/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.runtime.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.atf.adapter.IWebResourceLocator;
import org.eclipse.atf.core.CorePlugin;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.handler.IRuntimeHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SimpleRuntimeHandler
implements IRuntimeHandler {
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void install(IRuntimeInstance iRuntimeInstance, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IWebResourceLocator iWebResourceLocator;
        iProgressMonitor.beginTask("Handler installing runtime " + iRuntimeInstance.getType().getName() + " into project " + iProject.getName() + "...", 100);
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.atf.adapter.IWebResourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((iWebResourceLocator = (IWebResourceLocator)iProject.getAdapter((Class)clazz)) == null) return;
        IContainer iContainer = iWebResourceLocator.getWebResourceContainer();
        IPath iPath = iContainer.getFullPath().append(this.getProjectInstallPath(null).toString());
        try {
            try {
                URL uRL;
                IFolder iFolder = iProject.getWorkspace().getRoot().getFolder(iPath);
                if (!iFolder.exists()) {
                    iFolder.create(true, true, null);
                }
                if (!"file".equalsIgnoreCase((uRL = new URL(iRuntimeInstance.getLocation())).getProtocol())) {
                    uRL = FileLocator.toFileURL((URL)uRL);
                }
                iProgressMonitor.worked(10);
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 90);
                subProgressMonitor.setTaskName("Copying runtime assets...");
                this.copyTree(new File(uRL.getPath()), iPath, iProject.getWorkspace().getRoot(), (IProgressMonitor)subProgressMonitor);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 0, "Error installing runtime instance! Location <" + iRuntimeInstance.getLocation() + "> is not a valid URL.", (Throwable)malformedURLException));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 0, "Error installing runtime instance! Location <" + iRuntimeInstance.getLocation() + "> is not a valid platform URL.", (Throwable)iOException));
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall(IRuntimeInstance iRuntimeInstance, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IWebResourceLocator iWebResourceLocator;
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.atf.adapter.IWebResourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((iWebResourceLocator = (IWebResourceLocator)iProject.getAdapter((Class)clazz)) == null) return;
        iProgressMonitor.beginTask("Handler uninstalling runtime " + iRuntimeInstance.getType().getName() + " from project " + iProject.getName() + "...", 100);
        IContainer iContainer = iWebResourceLocator.getWebResourceContainer();
        IFolder iFolder = iContainer.getFolder(this.getProjectInstallPath(null));
        if (!iFolder.exists()) {
            iProgressMonitor.done();
            return;
        }
        iProgressMonitor.worked(10);
        try {
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 80);
            subProgressMonitor.setTaskName("Deleting runtime assets...");
            iFolder.delete(true, (IProgressMonitor)subProgressMonitor);
            subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
            subProgressMonitor.setTaskName("Refresing workspace...");
            iContainer.refreshLocal(0, (IProgressMonitor)subProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyTree(File file, IPath iPath, IWorkspaceRoot iWorkspaceRoot, IProgressMonitor iProgressMonitor) {
        if (file == null || iPath == null || iWorkspaceRoot == null) {
            iProgressMonitor.done();
            return;
        }
        try {
            try {
                if (file.exists()) {
                    File[] fileArray = file.isDirectory() ? file.listFiles() : new File[]{file};
                    iProgressMonitor.beginTask("Copying files from " + file.getName() + "...", fileArray.length);
                    int n = 0;
                    while (n < fileArray.length) {
                        Object object;
                        IFolder iFolder;
                        File file2 = fileArray[n];
                        if (file2.isFile()) {
                            iProgressMonitor.subTask("Copying file " + file2.getName() + "...");
                            iFolder = iWorkspaceRoot.getFile(iPath.append(file2.getName()));
                            object = new FileInputStream(file2);
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            subProgressMonitor.setTaskName("Creating file in project...");
                            if (!iFolder.exists()) {
                                iFolder.create((InputStream)object, true, (IProgressMonitor)subProgressMonitor);
                            } else {
                                iFolder.setContents((InputStream)object, true, false, (IProgressMonitor)subProgressMonitor);
                            }
                            ((FileInputStream)object).close();
                        } else if (file2.isDirectory()) {
                            iFolder = iWorkspaceRoot.getFolder(iPath.append(file2.getName()));
                            if (!iFolder.exists()) {
                                iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                            }
                            object = new SubProgressMonitor(iProgressMonitor, 1);
                            this.copyTree(file2, iPath.append(file2.getName()), iWorkspaceRoot, (IProgressMonitor)object);
                        }
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {
                CorePlugin.log(iOException);
            }
            catch (CoreException coreException) {
                CorePlugin.log(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        iProgressMonitor.done();
    }

    public IPath getProjectInstallPath(IRuntimeInstance iRuntimeInstance) {
        return new Path("ajaxRuntime");
    }

    public IStatus validate(IRuntimeInstance iRuntimeInstance) {
        return Status.OK_STATUS;
    }
}

