/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.runtime.validator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.atf.core.CorePlugin;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.validator.IRuntimeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FileCheckRuntimeValidator
implements IRuntimeValidator,
IExecutableExtension {
    protected IConfigurationElement config = null;

    public IStatus validate(IRuntimeInstance iRuntimeInstance) {
        URL uRL;
        try {
            uRL = new URL(iRuntimeInstance.getLocation());
        }
        catch (MalformedURLException malformedURLException) {
            Status status = new Status(4, "org.eclipse.atf.core", 4, "RuntimeInstance location <" + iRuntimeInstance.getLocation() + "> is not a valid URL.", (Throwable)malformedURLException);
            CorePlugin.getDefault().getLog().log((IStatus)status);
            return status;
        }
        if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
            try {
                uRL = FileLocator.toFileURL((URL)uRL);
            }
            catch (IOException iOException) {
                Status status = new Status(4, "org.eclipse.atf.core", 4, "Could not convert location URL <" + uRL + "> into a file:// URL.", (Throwable)iOException);
                CorePlugin.getDefault().getLog().log((IStatus)status);
                return status;
            }
        }
        IConfigurationElement[] iConfigurationElementArray = this.config.getChildren("file");
        File file = new File(uRL.getPath());
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("path");
            File file2 = new File(file, string);
            if (!file2.exists()) {
                Status status = new Status(4, "org.eclipse.atf.core", 4, "Missing runtime file <" + file2.toString() + ">.", null);
                return status;
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        this.config = iConfigurationElement.getChildren("validator")[0];
    }
}

