/**
  * Object DOMException()
  * @super Object
  * @type  constructor
  * @class DOMException
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
function DOMException(){};
DOMException.prototype = new Object();
/**
  * Constant DOMException.INDEX_SIZE_ERR=1
  * @type Number
  * @class DOMException
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link DOMException()  
  * @see     http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.INDEX_SIZE_ERR=1;
/**
  * Constant DOMException.DOMSTRING_SIZE_ERR=2
  * @type Number
  * @class DOMException
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.   
  * @link DOMException()  
  * @see     http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.DOMSTRING_SIZE_ERR=2;
/**
  * Constant DOMException.HIERARCHY_REQUEST_ERR=3
  * @type Mi,ber
  * @class DOMException
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition. 
  * @see DOMException() 
  * @link     http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.HIERARCHY_REQUEST_ERR=3;
/**
  * Constant DOMException.WRONG_DOCUMENT_ERR=4
  * @type Number
  * @see DOMException() 
  * @class DOMException
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
   
  * @link     http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.WRONG_DOCUMENT_ERR=4;
/**
  * Constant DOMException.INVALID_CHARACTER_ERR=5
  * @class DOMException
  * @type Number
  * @see DOMException()
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
  
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.INVALID_CHARACTER_ERR=5;
/**
  * Constant DOMException.NO_DATA_ALLOWED_ER=6
  * @type Number
  * @class DOMException
  * @see DOMException()  
  * @since Level 2 Document Object Model Core Definition. 
  * @since Standard ECMA-262 3rd. Edition

  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.NO_DATA_ALLOWED_ER=6;
/**
  * Constant DOMException.NO_MODIFICATION_ALLOWED_ERR=7
  * @type Number
  * @class DOMException
  * @see DOMException()  
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.

  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.NO_MODIFICATION_ALLOWED_ERR=7;
/**
  * Constant DOMException.NOT_FOUND_ERR=8
  * @type Number
  * @class DOMException
  * @see DOMException()  
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.

  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.NOT_FOUND_ERR=8;
/**
  * Constant DOMException.NOT_SUPPORTED_ERR=9
  * @type Number
  * @class DOMException
  * @see DOMException()  
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.

  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.NOT_SUPPORTED_ERR=9;
/**
  * Constant DOMException.INUSE_ATTRIBUTE_ERR=10
  * @type Number
  * @class DOMException
  * @see DOMException()
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
  
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.INUSE_ATTRIBUTE_ERR=10;
/**
  * Constant DOMException.INVALID_STATE_ERR=11
  * @type Number
  * @class DOMException
  * @see DOMException()
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
  
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.INVALID_STATE_ERR=11;
/**
  * Constant DOMException.SYNTAX_ERR=12
  * @type Number
  * @class DOMException
  * @see DOMException()  
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.

  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.SYNTAX_ERR=12;
/**
  * Constant DOMException.INVALID_MODIFICATION_ER=13
  * @type Number
  * @class DOMException
  * @see DOMException()  

  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.INVALID_MODIFICATION_ER=13;
/**
  * Constant DOMException.NAMESPACE_ERR=14
  * @type Number
  * @class DOMException
  * @see DOMException()  
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.

  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.NAMESPACE_ERR=14;
/**
  * Constant DOMException.NVALID_ACCESS_ERR=15
  * @type Number
  * @class DOMException
  * @see DOMException() 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.INVALID_ACCESS_ERR=15;
/**
  * Property code
  * @type Number
  * @class DOMException
  * @see DOMException() 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DOMException.prototype.code=new Number();


/**
  * Object DOMImplementation()
  * @super Object
  * @type  constructor
  * @class DOMImplementation
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
function DOMImplementation();
DOMImplementation.prototype = new Object();

/**
  * function hasFeature()
  * @type  method
  * @class DOMImplementation
  * @param feature String
  * @param version String
  * @return boolean
  * @see DOMImplementation
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.

  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
DOMImplementation.prototype.hasFeature = new function(feature, version);

/**
  * function createDocumentType()
  * @type  method
  * @class DOMImplementation
  * @param namespaceURI String
  * @param qualifiedName String
  * @param doctype DocumentType
  * @return Document
  * @throws DOMException
  * @see DOMImplementation
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.

  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
DOMImplementation.prototype.createDocument = function(namespaceURI, qualifiedName, doctype){};
/**
  * function createDocumentType()
  * @type  method
  * @class DOMImplementation

  * @param qualifiedName String
  * @param publicId String
  * @param systemId String
  
  * @return DocumentType
  * @throws DOMException
  * @see DOMImplementation
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.

  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
DOMImplementation.prototype.createDocumentType = function(qualifiedName, publicId, systemId){}; 
/**
  * Object Node()
  * @super Object
  * @type  constructor
  * @class Node
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
function Node(){};
Node.prototype=new Object(); 
/**
  * Constant Node.ELEMENT_NODE=1
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.ELEMENT_NODE=1; 
/**
  * Constant Node.ATTRIBUTE_NODE=2
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.ATTRIBUTE_NODE=2;
/**
  * Constant Node.TEXT_NODE=3
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.TEXT_NODE=3;
/**
  * Constant Node.CDATA_SECTION_NODE=4
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.CDATA_SECTION_NODE=4; 
/**
  * Constant Node.ENTITY_REFERENCE_NODE=5
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.ENTITY_REFERENCE_NODE=5; 
/**
  * Constant Node.ENTITY_NODE=6
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.ENTITY_NODE=6;
/**
  * Constant Node.PROCESSING_INSTRUCTION_NODE=7
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.PROCESSING_INSTRUCTION_NODE=7; 
/**
  * Constant Node.COMMENT_NODE=8
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.COMMENT_NODE=8;
/**
  * Constant Node.DOCUMENT_NODE=9
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.DOCUMENT_NODE=9;
/**
  * Constant Node.DOCUMENT_TYPE_NODE=10
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.DOCUMENT_TYPE_NODE=10; 
/**
  * Constant Node.DOCUMENT_FRAGMENT_NODE=11
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.DOCUMENT_FRAGMENT_NODE=11; 
/**
  * Constant Node.NOTATION_NODE=12
  * @type Number
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.NOTATION_NODE=12;

/**
  * Property nodeName
  * @type String
  * @class Node
  * @see Node 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.nodeName = new String(); 
/**
  * Property nodeName
  * @type String
  * @class Node
  * @see Node 
  * @throws DOMException when setting or getting the value.
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.nodeValue = new String(); 
/**
  * Property nodeType
  * @type Number
  * @class Node
  * @see Node 
 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Node.prototype.nodeType = new Number(); 
/**
  * Property parentNode 
  * @type Node
  * @class Node
  * @see Node 
 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Node.prototype.parentNode=new Node(); 
/**
  * Property childNodes  
  * @type NodeList
  * @class Node
  * @see Node
  * @see NodeList 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.childNodes=new NodeList(); 
/**
  * Property firstChild 
  * @type Node
  * @class Node
  * @see Node 
 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Node.prototype.firstChild=new Node(); 
/**
  * Property lastChild 
  * @type Node
  * @class Node
  * @see Node 
 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.lastChild=new Node();  
/**
  * Property previousSibling 
  * @type Node
  * @class Node
  * @see Node 
 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.previousSibling=new Node(); 
/**
  * Property nextSibling  
  * @type Node
  * @class Node
  * @see Node 
 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.nextSibling=new Node(); 
/**
  * Property attributes  
  * @type NamedNodeMap
  * @class Node
  * @see Node
  * @see NamedNodeMap 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.attributes=new NamedNodeMap();
/**
  * Property ownerDocument   
  * @type Document
  * @class Node
  * @see Node
  * @see Document
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.ownerDocument = new Document(); 
/**
  * Property namespaceURI   
  * @type String
  * @class Node
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.namespaceURI=new String(); 
/**
  * Property prefix   
  * @type String
  * @class Node
  * @see Node
  * @throws DOMException on setting.
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.prefix = new String(); 
/**
  * Property localName   
  * @type String
  * @class Node
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.localName= new String();
/**
  * function insertBefore(newChild, refChild)   
  * @type Method
  * @class Node
  * @param newChilds Node
  * @param refChild Node
  * @return Node
  * @throws DOMException
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Node.prototype.insertBefore = new function(newChild, refChild){}; 
/**
  * function replaceChild(newChild, oldChild) 
  * @type Method
  * @class Node
  * @param newChilds Node
  * @param oldChild Node
  * @return Node
  * @throws DOMException
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Node.prototype.replaceChild = function(newChild, oldChild){}; 
 /**
  * function removeChild(oldChild) 
  * @type Method
  * @class Node
  * @param oldChild Node
  * @return Node
  * @throws DOMException
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Node.prototype.removeChild = function(oldChild){}; 
 /**
  * function appendChild(newChild) 
  * @type Method
  * @class Node
  * @param newChild Node
  * @return Node
  * @throws DOMException
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Node.prototype.appendChild = function(newChild){}; 
 /**
  * function hasChildNodes() 
  * @type Method
  * @class Node
  * @return Boolean
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.prototype.hasChildNodes=function(){}; 
 /**
  * function hasChildNodes() 
  * @type Method
  * @class Node
  * @param deep Boolean
  * @return Node
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.prototype.cloneNode=function(deep){}; 
 /**
  * function normalize() 
  * @type Method
  * @class Node
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Node.prototype.normalize = function(){}; 
 /**
  * function isSupported(feature, version)  
  * @type Method
  * @class Node
  * @param feature String
  * @param version String
  * @return Boolean;
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.isSupported=function(feature, version){}; 
 /**
  * function hasAttributes()   
  * @type Method
  * @class Node
  * @return Boolean;
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Node.prototype.hasAttributes=function(){};
 /**
  * Object NodeList   
  * @type constructor
  * @class NodeList
  * @see NodeList
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
function NodeList(){};
NodeList.prototype = new Object();
 /**
  * property length   
  * @type Number
  * @class NodeList
  * @see NodeList
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 

NodeList.prototype.length=new Number(); 
 /**
  * function item(index) 
  *     Note: This object can also be dereferenced using square bracket notation (e.g. obj[1]). Dereferencing with an integer index is equivalent to invoking the item method with that index 
  * @type Method
  * @class NodeList
  * @param index Number
  * @return Node;
  * @see NodeList
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
NodeList.prototype.item = function(index){}; 
/**
  * Object DocumentFragment()
  * DocumentFragment inherits all of the methods and properties from Document and Node.
  * @super Document
  * @type  constructor
  * @see Document
  * @class  DocumentFragment
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
function DocumentFragment(){};
DocumentFragment.prototype=new Document(); 
/**
  * Object Document()
  * Document inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor
  * @see Node
  * @class  Document
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
function Document(){};
Document.prototype = new Node();
/**
  * property doctype
  * @type  DocumentType
  * @see Document
  * @see DocumentType
  * @class  Document
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Document.prototype.doctype = new DocumentType(); 
/**
  * property implementation
  * @type   DOMImplementation
  * @see Document
  * @see DOMImplementation
  * @class  Document
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Document.prototype.implementation = new DOMImplementation();
/**
  * property documentElement 
  * @type   Element
  * @see Document
  * @see Element
  * @class  Document
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Document.prototype.documentElement= new Element(); 
 /**
  * function createElement(tagName)  
  * @type Method
  * @class Document
  * @param tagName String
  * @return Element;
  * @throws DOMException
  * @see Document
  * @see Element
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  

Document.prototype.createElement=function(tagName){}; 
 /**
  * function createDocumentFragment()  
  * @type Method
  * @class Document
  * @return DocumentFragment;
  * @see Document
  * @see DocumentFragment
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Document.prototype.createDocumentFragment=function(){}; 
 /**
  * function createTextNode(data)  
  * @type Method
  * @class Document
  * @param data String
  * @return Text;
  * @see Document
  * @see Text
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Document.prototype.createTextNode=function(data){}; 
 /**
  * function createComment(data)  
  * @type Method
  * @class Document
  * @param data String
  * @return Comment;
  * @see Document
  * @see Comment
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Document.prototype.createComment=function(data){}; 
 /**
  * function createCDATASection(data)  
  * @type Method
  * @class Document
  * @param data String
  * @return CDATASection
  * @throws DOMException
  * @see Document
  * @see CDATASection
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.createCDATASection(data) 
 /**
  * function createProcessingInstruction(target, data) 
  * @type Method
  * @class Document
  * @param target String
  * @param data String;
  * @return  ProcessingInstruction
  * @throws DOMException
  * @see Document
  * @see ProcessingInstruction
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.createProcessingInstruction=function(target, data){}; 
 /**
  * function createAttribute(name)  
  * @type Method
  * @class Document
  * @param name String
  * @return  Attr
  * @throws DOMException
  * @see Document
  * @see Attr
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.createAttribute=function(name){}; 
 /**
  * function createEntityReference(name)  
  * @type Method
  * @class Document
  * @param name String
  * @return  EntityReference
  * @throws DOMException
  * @see Document
  * @see EntityReference
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.createEntityReference=function(name){}; 
 /**
  * function getElementsByTagName(tagname)  
  * @type Method
  * @class Document
  * @param tagname String
  * @return  NodeList
  * @see Document
  * @see NodeList
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.getElementsByTagName=function(tagname){}; 
 /**
  * function importNode(importedNode, deep)  
  * @type Method
  * @class Document
  * @param importedNode Node
  * @param deep Boolean
  * @return  Node
  * @throws DOMException
  * @see Document
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.importNode=function(importedNode, deep){}; 
 /**
  * function createElementNS(namespaceURI, qualifiedName) 
  * @type Method
  * @class Document
  * @param namespaceURI String
  * @param qualifiedName String
  * @return  Element
  * @throws DOMException
  * @see Document
  * @see Element
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.createElementNS=function(namespaceURI, qualifiedName){}; 
 /**
  * function createAttributeNS(namespaceURI, qualifiedName)
  * @type Method
  * @class Document
  * @param namespaceURI String
  * @param qualifiedName String
  * @return  Attr
  * @throws DOMException
  * @see Document
  * @see Attr
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.createAttributeNS=function(namespaceURI, qualifiedName){}; 
/**
  * function getElementsByTagNameNS(namespaceURI, localName)
  * @type Method
  * @class Document
  * @param namespaceURI String
  * @param qualifiedName String
  * @return  NodeList
  * @see Document
  * @see NodeList
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Document.prototype.getElementsByTagNameNS=function(namespaceURI, localName){}; 
/**
  * function getElementById(elementId)
  * @type Method
  * @class Document
  * @param elementId String
  * @return  Element
  * @see Document
  * @see Element
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Document.prototype.getElementById=function(elementId){}; 
/**
  * Object NamedNodeMap()
  * @super Object
  * @type  constructor
  * @class NamedNodeMap
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
function NamedNodeMap(){};
NamedNodeMap.prototype = new Object();
/**
  * property length 
  * @type   Number
  * @class  NamedNodeMap;
  * @see NamedNodeMap

  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
NamedNodeMap.prototype.length=new Number(); 
/**
  * function getNamedItem(name) 
  * @type Method
  * @class NamedNodeMap
  * @param Name String
  * @return  Node
  * @see NamedNodeMap
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
NamedNodeMap.prototype.getNamedItem=function(name){}; 
/**
  * function setNamedItem(arg) 
  * @type Method
  * @class NamedNodeMap
  * @param arg Node
  * @return  Node
  * @throws DOMException
  * @see NamedNodeMap
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
NamedNodeMap.prototype.setNamedItem=function(arg){}; 
/**
  * function removeNamedItem(name)  
  * @type Method
  * @class NamedNodeMap
  * @param name String
  * @return  Node
  * @throws DOMException
  * @see NamedNodeMap
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
NamedNodeMap.prototype.removeNamedItem=function(name){}; 
/**
  * function item(index)
  * Note: This object can also be dereferenced using square bracket notation (e.g. obj[1]). Dereferencing with an integer index is equivalent to invoking the item method with that index.
  * @type Method
  * @class NamedNodeMap
  * @param index Number
  * @return  Node
  * @see NamedNodeMap
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
NamedNodeMap.prototype.item=function(index){}; 
/**
  * function getNamedItemNS(namespaceURI, localName) 
  * @type Method
  * @class NamedNodeMap
  * @param namespaceURI String
  * @param localName String
  * @return  Node
  * @see NamedNodeMap
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
NamedNodeMap.prototype.getNamedItemNS=function(namespaceURI, localName){}; 
/**
  * function setNamedItemNS(arg) 
  * @type Method
  * @class NamedNodeMap
  * @param arg Node
  * @param localName String
  * @return  Node
  * @throws DOMException
  * @see NamedNodeMap
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
NamedNodeMap.prototype.setNamedItemNS=function(arg){}; 
/**
  * function removeNamedItemNS(namespaceURI, localName)  
  * @type Method
  * @class NamedNodeMap
  * @param namespaceURI String
  * @param localName String
  * @return  Node
  * @throws DOMException
  * @see NamedNodeMap
  * @see Node
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
NamedNodeMap.prototype.removeNamedItemNS=function(namespaceURI, localName){}; 
/**
  * Object CharacterData()
  * CharacterData inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor
  * @see Node
  * @class  CharacterData
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
function CharacterData(){};
CharacterData.prototype=new Node();
/**
  * property data
  * @type   String
  * @class  CharacterData
  * @throws DOMException on setting and can raise a DOMException object on retrieval.
  * @see CharacterData

  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
CharacterData.prototype.data=new String(); 
/**
  * property length
  * @type   Number
  * @class  CharacterData
  * @see CharacterData

  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
CharacterData.prototype.length=new Number(); 
/**
  * function substringData(offset, count)   
  * @type Method
  * @class CharacterData
  * @param parameter Number
  * @param count Number
  * @return String
  * @throws DOMException
  * @see CharacterData
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
CharacterData.prototype.substringData=function(offset, count){}; 
/**
  * function appendData(arg)    
  * @type Method
  * @class CharacterData
  * @param arg String
  * @return String
  * @throws DOMException
  * @see CharacterData
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
CharacterData.prototype.appendData=function(arg){}; 
/**
  * function insertData(offset, arg)  
  * @type Method
  * @class CharacterData
  * @param offset Number
  * @param arg String
  * @throws DOMException
  * @see CharacterData
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
CharacterData.prototype.insertData=function(offset, arg){};  
/**
  * function deleteData(offset, count)  
  * @type Method
  * @class CharacterData
  * @param offset Number
  * @param count Number
  * @throws DOMException
  * @see CharacterData
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
CharacterData.prototype.deleteData=function(offset, count){}; 
/**
  * function replaceData(offset, count, arg)
  * @type Method
  * @class CharacterData
  * @param offset Number
  * @param count Number
  * @param arg String
  * @throws DOMException
  * @see CharacterData
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
CharacterData.prototype.replaceData=function(offset, count, arg){}; 
/**
  * Object Attr()
  * Attr inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor
  * @see Node
  * @class Attr
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
function Attr(){};
Attr.prototype=new Node();
/**
  * property name
  * @type   String
  * @class  Attr
 
  * @see Attr

  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Attr.prototype.name=new String(); 
/**
  * property specified
  * @type   Boolean
  * @class  Attr
  
  * @see Attr

  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Attr.prototype.specified=new Boolean(); 
/**
  * property value 
  * @type   Boolean
  * @class  Attr
  * @throws DOMException on setting and can raise a DOMException object on retrieval.
  * @see Attr

  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Attr.prototype.value=new String();
/**
  * property ownerElement 
  * @type   Element
  * @class  Attr
  * @throws DOMException on setting and can raise a DOMException object on retrieval.
  * @see Attr
  * @see Element

  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Attr.prototype.ownerElement=new Element(); 
/**
  * Object Element()
  * Element inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor
  * @see Node
  * @class Attr
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
function Element(){};
Element.prototype=new Node(); 
/**
  * property tagName  
  * @type   String
  * @class  Element
  * @throws DOMException on setting and can raise a DOMException object on retrieval.
  * @see Attr
  * @see Element

  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Element.prototype.tagName=new String();
/**
  * function getAttribute(name) 
  * @type Method
  * @class Element
  * @param name String
  * @return String
  * @see Element
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Element.prototype.getAttribute=function(name){}; 
/**
  * function setAttribute(name, value) 
  * @type Method
  * @class Element
  * @param name String
  * @param value String
  * @throws DOMException
  * @see Element
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Element.prototype.setAttribute=function(name, value){}; 
/**
  * function removeAttribute(name)
  * @type Method
  * @class Element
  * @param name String
  * @throws DOMException
  * @see Element
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Element.prototype.removeAttribute=function(name){}; 
/**
  * function getAttributeNode(name)
  * @type Method
  * @class Element
  * @param name String
  * @return Attr
  * @see Element
  * @see Attr
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.getAttributeNode=function(name){}; 
/**
  * function setAttributeNode(newAttr)
  * @type Method
  * @class Element
  * @param newAttr Attr
  * @return Attr

  * @throws DOMException
  * @see Element
  * @see Attr
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.setAttributeNode=function(newAttr){}; 
/**
  * function removeAttributeNode(oldAttr) 
  * @type Method
  * @class Element
  * @param oldAttr Attr
  * @return Attr
  * @throws DOMException
  * @see Element
  * @see Attr;
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Element.prototype.removeAttributeNode=function(oldAttr){}; 
/**
  * function getElementsByTagName(name)
  * @type Method
  * @class Element
  * @param name String
  * @return NodeList
  * @see NodeList
  * @see Element;
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Element.prototype.getElementsByTagName=function(name){}; 
/**
  * function getAttributeNS(namespaceURI, localName) 
  * @type Method
  * @class Element
  * @param namespaceURI String
  * @param localName String
  * @return String
  * @see Element
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.getAttributeNS=function(namespaceURI, localName){}; 
 /**
  * function setAttributeNS(namespaceURI, qualifiedName, value)  
  * @type Method
  * @class Element
  * @param namespaceURI String
  * @param qualifiedName String
  * @param value String
  * @throws DOMException
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.setAttributeNS=function(namespaceURI, qualifiedName, value){}; 
 /**
  * function removeAttributeNS(namespaceURI, localName)  
  * @type Method
  * @class Element
  * @param namespaceURI String
  * @param localName String
  * @throws DOMException
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.removeAttributeNS=function(namespaceURI, localName){}; 
 /**
  * function getAttributeNodeNS(namespaceURI, localName)   
  * @type Method
  * @class Element
  * @param namespaceURI String
  * @param localName String
  * @return Attr
  * @throws DOMException
  * @see Attr
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.getAttributeNodeNS=function(namespaceURI, localName){}; 
 /**
  * function setAttributeNodeNS(newAttr)    
  * @type Method
  * @class Element
  * @param newAttr Attr

  * @return Attr
  * @throws DOMException
  * @see Attr
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.setAttributeNodeNS=function(newAttr){}; 
 /**
  * function getElementsByTagNameNS(namespaceURI, localName)   
  * @type Method
  * @class Element
  * @param namespaceURI String
  * @param localName String

  * @return NodeList
 
  * @see NodeList
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.getElementsByTagNameNS=function(namespaceURI, localName){}; 
 /**
  * function hasAttribute(name)   
  * @type Method
  * @class Element
  
  * @param name String

  * @return Boolean
 
  
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Element.prototype.hasAttribute=function(name){}; 
 /**
  * function hasAttributeNS(namespaceURI, localName)    
  * @type Method
  * @class Element
  * @param namespaceURI String
  * @param localName String

  * @return Boolean
 
  
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Element.prototype.hasAttributeNS=function(namespaceURI, localName){}; 
/**
  * Object Text()
  * Text inherits all of the methods and properties from CharacterData.
  * @super CharacterData
  * @type  constructor

  * @class Text
  * @see CharacterData
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
function Text(){};
Text.prototype = new ChracterData();
 /**
  * function splitText(offset)     
  * @type Method
  * @class Text
  * @param offset Number
 

  * @return Text
  * @throws DOMException
  * @see Text
  
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Text.prototype.splitText=function(offset){}; 
/**
  * Object Comment()
  * Comment inherits all of the methods and properties from CharacterData.
  * @super CharacterData
  * @type  constructor

  * @class Comment
  * @see CharacterData
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
function Comment(){};
Comment.prototype = new ChracterData();
/**
  * Object CDATASection()
  * Comment inherits all of the methods and properties from Text.
  * @super Text
  * @type  constructor

  * @class CDATASection
  * @see Text
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
function CDATASection(){};
CDATASection.prototype = new Text();
/**
  * Object DocumentType()
  * DocumentType inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor

  * @class DocumenType
  * @see Node
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
function DocumentType(){};
DocumentType.prototype = new Node(); 
/**
  * read-only Property name
  * @type String
  * @class DocumentType
  * @see DocumentType(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DocumentType.prototype.name=new String(); 
/**
  * read-only Property entities
  * @type NamedNodeMap
  * @class DocumentType
  * @see DocumentType(); 
  * @see NamedNodeMap
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DocumentType.prototype.entities = new NamedNodeMap();
/**
  * Read-Only Property notations 
  * @type NamedNodeMap
  * @class DocumentType
  * @see DocumentType(); 
  * @see NamedNodeMap
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DocumentType.prototype.notations=new NamedNodeMap(); 
/**
  * Read-Only Property publicId 
  * @type String
  * @class DocumentType
  * @see DocumentType(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
DocumentType.prototype.publicId=new String(); 
/**
  * Read-Only Property systemId  
  * @type String
  * @class DocumentType
  * @see DocumentType(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
DocumentType.prototype.systemId=new String(); 
/**
  * Read-Only Property internalSubset 
  * @type String
  * @class DocumentType
  * @see DocumentType(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
DocumentType.prototype.internalSubset=new String();
/**
  * Object Notation()
  * Notation inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor

  * @class Notation
  * @see Node
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
function Notation(){};
Notation.prototype=new Node(); 
/**
  * Read-Only Property publicId 
  * @type String
  * @class Notation
  * @see Notation(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
Notation.prototype.publicId=new String(); 
/**
  * Read-Only Property systemId 
  * @type String
  * @class Notation
  * @see Notation(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Notation.prototype.systemId=new String();
/**
  * Object Entity()
  * Entity inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor

  * @class Entity
  * @see Node
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */  
function Entity(){}; 
Entity.prototype=new Node();
/**
  * Read-Only Property publicId 
  * @type String
  * @class Entity
  * @see Entity(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Entity.prototype.publicId=new String();
 /**
  * Read-Only Property systemId 
  * @type String
  * @class Entity
  * @see Entity(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
Entity.prototype.systemId=new String(); 
 /**
  * Read-Only Property notationName 
  * @type String
  * @class Entity
  * @see Entity(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
Entity.prototype.notationName=new String(); 
/**
  * Object EntityReference()
  * EntityReference inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor

  * @class EntityReference
  * @see Node
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */ 
function EntityReference(){};
EntityReference.prototype=new Node();
 /**
  * Object ProcessingInstruction()
  * ProcessingInstruction inherits all of the methods and properties from Node.
  * @super Node
  * @type  constructor

  * @class ProcessingInstruction
  * @see Node
  * @since Standard ECMA-262 3rd. Edition
  * @since Level 2 Document Object Model Core Definition.
  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
 
function ProcessingInstruction(){}; 
ProcessingInstruction.prototype=new Node();
 /**
  * Read-Only Property target  
  * @type String
  * @class ProcessingInstruction
  * @see ProcessingInstruction(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
ProcessingInstruction.prototype.target=new String();
 /**
  * Read-Only Property target  
  * @type String
  * @class ProcessingInstruction
  * @throws DOMException on setting.
  * @see ProcessingInstruction(); 
  * @since Standard ECMA-262 3rd. Edition 
  * @since Level 2 Document Object Model Core Definition.
 
  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html     
 */
ProcessingInstruction.prototype.data=new String(); 




