/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.palette.editparts.TriangleFigure;

class RolloverArrow
extends Clickable {
    RolloverArrow() {
        super((IFigure)new TriangleFigure());
        this.setRolloverEnabled(true);
        this.setBorder((Border)new ButtonBorder(ButtonBorder.SCHEMES.TOOLBAR));
        this.setOpaque(false);
        this.setStyle(Clickable.STYLE_BUTTON);
    }

    protected void fillCheckeredRectangle(Graphics graphics) {
        graphics.setBackgroundColor(ColorConstants.button);
        graphics.setForegroundColor(ColorConstants.buttonLightest);
        Rectangle rect = this.getClientArea(Rectangle.SINGLETON).crop(new Insets(1, 1, 0, 0));
        graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
        graphics.clipRect(rect);
        graphics.translate(rect.x, rect.y);
        int n = rect.width + rect.height;
        int i = 1;
        while (i < n) {
            graphics.drawLine(0, i, i, 0);
            i += 2;
        }
        graphics.restoreState();
    }

    public boolean hasFocus() {
        return false;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isSelected() && this.isOpaque()) {
            this.fillCheckeredRectangle(graphics);
        } else {
            super.paintFigure(graphics);
        }
    }
}

