/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CalleeMethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallerMethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.Implementors;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;

public class CallHierarchy {
    private static final String PREF_USE_IMPLEMENTORS = "PREF_USE_IMPLEMENTORS";
    private static final String PREF_USE_FILTERS = "PREF_USE_FILTERS";
    private static final String PREF_FILTERS_LIST = "PREF_FILTERS_LIST";
    private static final String DEFAULT_IGNORE_FILTERS = "java.*,javax.*";
    private static CallHierarchy fgInstance;
    private IJavaSearchScope fSearchScope;
    private StringMatcher[] fFilters;

    public static CallHierarchy getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchy();
        }
        return fgInstance;
    }

    public boolean isSearchUsingImplementorsEnabled() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(PREF_USE_IMPLEMENTORS);
    }

    public void setSearchUsingImplementorsEnabled(boolean bl) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(PREF_USE_IMPLEMENTORS, bl);
    }

    public Collection getImplementingMethods(IMethod iMethod) {
        IJavaElement[] iJavaElementArray;
        if (this.isSearchUsingImplementorsEnabled() && (iJavaElementArray = Implementors.getInstance().searchForImplementors(new IJavaElement[]{iMethod}, (IProgressMonitor)new NullProgressMonitor())) != null && iJavaElementArray.length > 0) {
            return Arrays.asList(iJavaElementArray);
        }
        return new ArrayList(0);
    }

    public Collection getInterfaceMethods(IMethod iMethod) {
        IJavaElement[] iJavaElementArray;
        if (this.isSearchUsingImplementorsEnabled() && (iJavaElementArray = Implementors.getInstance().searchForInterfaces(new IJavaElement[]{iMethod}, (IProgressMonitor)new NullProgressMonitor())) != null && iJavaElementArray.length > 0) {
            return Arrays.asList(iJavaElementArray);
        }
        return new ArrayList(0);
    }

    public MethodWrapper getCallerRoot(IMethod iMethod) {
        return new CallerMethodWrapper(null, new MethodCall((IMember)iMethod));
    }

    public MethodWrapper getCalleeRoot(IMethod iMethod) {
        return new CalleeMethodWrapper(null, new MethodCall((IMember)iMethod));
    }

    public static CallLocation getCallLocation(Object object) {
        CallLocation callLocation = null;
        if (object instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)object);
            MethodCall methodCall = methodWrapper.getMethodCall();
            if (methodCall != null) {
                callLocation = methodCall.getFirstCallLocation();
            }
        } else if (object instanceof CallLocation) {
            callLocation = (CallLocation)object;
        }
        return callLocation;
    }

    public IJavaSearchScope getSearchScope() {
        if (this.fSearchScope == null) {
            this.fSearchScope = SearchEngine.createWorkspaceScope();
        }
        return this.fSearchScope;
    }

    public void setSearchScope(IJavaSearchScope iJavaSearchScope) {
        this.fSearchScope = iJavaSearchScope;
    }

    public boolean isIgnored(String string) {
        if (this.getIgnoreFilters() != null && this.getIgnoreFilters().length > 0) {
            int n = 0;
            while (n < this.getIgnoreFilters().length) {
                String string2 = string;
                if (this.getIgnoreFilters()[n].match(string2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isFilterEnabled() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(PREF_USE_FILTERS);
    }

    public void setFilterEnabled(boolean bl) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(PREF_USE_FILTERS, bl);
    }

    public String getFilters() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getString(PREF_FILTERS_LIST);
    }

    public void setFilters(String string) {
        this.fFilters = null;
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(PREF_FILTERS_LIST, string);
    }

    private StringMatcher[] getIgnoreFilters() {
        if (this.fFilters == null) {
            String string = null;
            if (this.isFilterEnabled() && (string = this.getFilters()) == null) {
                string = DEFAULT_IGNORE_FILTERS;
            }
            this.fFilters = string != null ? CallHierarchy.parseList(string) : null;
        }
        return this.fFilters;
    }

    private static StringMatcher[] parseList(String string) {
        ArrayList<StringMatcher> arrayList = new ArrayList<StringMatcher>(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            arrayList.add(new StringMatcher(string2, false, false));
        }
        return arrayList.toArray(new StringMatcher[arrayList.size()]);
    }

    static CompilationUnit getCompilationUnitNode(IMember iMember, boolean bl) {
        ITypeRoot iTypeRoot = iMember.getTypeRoot();
        try {
            if (iTypeRoot.exists() && iTypeRoot.getBuffer() != null) {
                ASTParser aSTParser = ASTParser.newParser((int)3);
                aSTParser.setSource(iTypeRoot);
                aSTParser.setResolveBindings(bl);
                return (CompilationUnit)aSTParser.createAST(null);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return null;
    }
}

