/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertForLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertIterableLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.ILinkedFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class ConvertLoopFix
extends LinkedFix {
    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2, boolean bl3) {
        if (!JavaModelUtil.is50OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        if (!bl && !bl2) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ControlStatementFinder controlStatementFinder = new ControlStatementFinder(bl, bl2, bl3, arrayList);
        compilationUnit.accept((ASTVisitor)controlStatementFinder);
        if (arrayList.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] iFixRewriteOperationArray = arrayList.toArray(new IFixRewriteOperation[arrayList.size()]);
        return new ConvertLoopFix(FixMessages.ControlStatementsFix_change_name, compilationUnit, iFixRewriteOperationArray);
    }

    public static IFix createConvertForLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement forStatement) {
        ConvertForLoopOperation convertForLoopOperation = new ConvertForLoopOperation(forStatement);
        if (!((ConvertLoopOperation)convertForLoopOperation).satisfiesPreconditions().isOK()) {
            return null;
        }
        return new ConvertLoopFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new ILinkedFixRewriteOperation[]{convertForLoopOperation});
    }

    public static IFix createConvertIterableLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement forStatement) {
        ConvertIterableLoopOperation convertIterableLoopOperation = new ConvertIterableLoopOperation(forStatement);
        IStatus iStatus = convertIterableLoopOperation.satisfiesPreconditions();
        if (iStatus.getSeverity() == 4) {
            return null;
        }
        ConvertLoopFix convertLoopFix = new ConvertLoopFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new ILinkedFixRewriteOperation[]{convertIterableLoopOperation});
        convertLoopFix.setStatus(iStatus);
        return convertLoopFix;
    }

    protected ConvertLoopFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        super(string, compilationUnit, iFixRewriteOperationArray);
    }

    private static final class ControlStatementFinder
    extends GenericVisitor {
        private final List fResult;
        private final Hashtable fUsedNames;
        private final boolean fFindForLoopsToConvert;
        private final boolean fConvertIterableForLoops;
        private final boolean fMakeFinal;

        public ControlStatementFinder(boolean bl, boolean bl2, boolean bl3, List list) {
            this.fFindForLoopsToConvert = bl;
            this.fConvertIterableForLoops = bl2;
            this.fMakeFinal = bl3;
            this.fResult = list;
            this.fUsedNames = new Hashtable();
        }

        public boolean visit(ForStatement forStatement) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                ForStatement forStatement2 = forStatement;
                ConvertLoopOperation convertLoopOperation = this.getConvertOperation(forStatement2);
                ConvertLoopOperation convertLoopOperation2 = null;
                while (convertLoopOperation != null) {
                    if (convertLoopOperation2 == null) {
                        this.fResult.add(convertLoopOperation);
                    } else {
                        convertLoopOperation2.setBodyConverter(convertLoopOperation);
                    }
                    if (forStatement2.getBody() instanceof ForStatement) {
                        forStatement2 = (ForStatement)forStatement2.getBody();
                        convertLoopOperation2 = convertLoopOperation;
                        convertLoopOperation = this.getConvertOperation(forStatement2);
                        continue;
                    }
                    convertLoopOperation = null;
                }
                forStatement2.getBody().accept((ASTVisitor)this);
                return false;
            }
            return super.visit(forStatement);
        }

        private ConvertLoopOperation getConvertOperation(ForStatement forStatement) {
            ConvertIterableLoopOperation convertIterableLoopOperation;
            Collection collection = this.fUsedNames.values();
            String[] stringArray = collection.toArray(new String[collection.size()]);
            ConvertForLoopOperation convertForLoopOperation = new ConvertForLoopOperation(forStatement, stringArray, this.fMakeFinal);
            if (((ConvertLoopOperation)convertForLoopOperation).satisfiesPreconditions().isOK()) {
                if (this.fFindForLoopsToConvert) {
                    this.fUsedNames.put(forStatement, ((ConvertLoopOperation)convertForLoopOperation).getIntroducedVariableName());
                    return convertForLoopOperation;
                }
            } else if (this.fConvertIterableForLoops && ((ConvertLoopOperation)(convertIterableLoopOperation = new ConvertIterableLoopOperation(forStatement, stringArray, this.fMakeFinal))).satisfiesPreconditions().isOK()) {
                this.fUsedNames.put(forStatement, ((ConvertLoopOperation)convertIterableLoopOperation).getIntroducedVariableName());
                return convertIterableLoopOperation;
            }
            return null;
        }

        public void endVisit(ForStatement forStatement) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                this.fUsedNames.remove(forStatement);
            }
            super.endVisit(forStatement);
        }
    }
}

