/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class LinkedProposalPositionGroup {
    private final String fGroupId;
    private final List fPositions;
    private final List fProposals;

    public static PositionInformation createPositionInformation(ITrackedNodePosition iTrackedNodePosition, boolean bl) {
        return new TrackedNodePosition(iTrackedNodePosition, bl);
    }

    public LinkedProposalPositionGroup(String string) {
        this.fGroupId = string;
        this.fPositions = new ArrayList();
        this.fProposals = new ArrayList();
    }

    public void addPosition(PositionInformation positionInformation) {
        this.fPositions.add(positionInformation);
    }

    public void addProposal(Proposal proposal) {
        this.fProposals.add(proposal);
    }

    public void addPosition(ITrackedNodePosition iTrackedNodePosition, boolean bl) {
        this.addPosition(LinkedProposalPositionGroup.createPositionInformation(iTrackedNodePosition, bl));
    }

    public void addProposal(String string, Image image, int n) {
        this.addProposal(new Proposal(string, image, n));
    }

    public void addProposal(ITypeBinding iTypeBinding, ICompilationUnit iCompilationUnit, int n) {
        this.addProposal(new JavaLinkedModeProposal(iCompilationUnit, iTypeBinding, n));
    }

    public String getGroupId() {
        return this.fGroupId;
    }

    public PositionInformation[] getPositions() {
        return this.fPositions.toArray(new PositionInformation[this.fPositions.size()]);
    }

    public Proposal[] getProposals() {
        return this.fProposals.toArray(new Proposal[this.fProposals.size()]);
    }

    private static final class JavaLinkedModeProposal
    extends Proposal {
        private final ITypeBinding fTypeProposal;
        private final ICompilationUnit fCompilationUnit;

        public JavaLinkedModeProposal(ICompilationUnit iCompilationUnit, ITypeBinding iTypeBinding, int n) {
            super(BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_POST_QUALIFIED), null, n);
            this.fTypeProposal = iTypeBinding;
            this.fCompilationUnit = iCompilationUnit;
            ImageDescriptor imageDescriptor = BindingLabelProvider.getBindingImageDescriptor((IBinding)this.fTypeProposal, 1);
            if (imageDescriptor != null) {
                this.setImage(JavaPlugin.getImageDescriptorRegistry().get(imageDescriptor));
            }
        }

        public TextEdit computeEdits(int n, LinkedPosition linkedPosition, char c, int n2, LinkedModeModel linkedModeModel) throws CoreException {
            ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
            String string = importRewrite.addImport(this.fTypeProposal);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            multiTextEdit.addChild((TextEdit)new ReplaceEdit(linkedPosition.getOffset(), linkedPosition.getLength(), string));
            multiTextEdit.addChild(importRewrite.rewriteImports(null));
            return multiTextEdit;
        }
    }

    public static abstract class PositionInformation {
        public abstract int getOffset();

        public abstract int getLength();

        public abstract int getSequenceRank();
    }

    public static class Proposal {
        private String fDisplayString;
        private Image fImage;
        private int fRelevance;

        public Proposal(String string, Image image, int n) {
            this.fDisplayString = string;
            this.fImage = image;
            this.fRelevance = n;
        }

        public String getDisplayString() {
            return this.fDisplayString;
        }

        public Image getImage() {
            return this.fImage;
        }

        public int getRelevance() {
            return this.fRelevance;
        }

        public void setImage(Image image) {
            this.fImage = image;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public TextEdit computeEdits(int n, LinkedPosition linkedPosition, char c, int n2, LinkedModeModel linkedModeModel) throws CoreException {
            return new ReplaceEdit(linkedPosition.getOffset(), linkedPosition.getLength(), this.fDisplayString);
        }
    }

    private static class TrackedNodePosition
    extends PositionInformation {
        private final ITrackedNodePosition fPos;
        private final boolean fIsFirst;

        public TrackedNodePosition(ITrackedNodePosition iTrackedNodePosition, boolean bl) {
            this.fPos = iTrackedNodePosition;
            this.fIsFirst = bl;
        }

        public int getOffset() {
            return this.fPos.getStartPosition();
        }

        public int getLength() {
            return this.fPos.getLength();
        }

        public int getSequenceRank() {
            return this.fIsFirst ? 0 : 1;
        }
    }
}

