/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTFlattener;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ReturnTypeInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class TypeContextChecker {
    private static Type parseType(String string, IJavaProject iJavaProject, List list) {
        String string2;
        if ("".equals(string.trim())) {
            return null;
        }
        if (!string.trim().equals(string)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("interface A{");
        int n = stringBuffer.length();
        stringBuffer.append(string).append(" m();}");
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(stringBuffer.toString().toCharArray());
        aSTParser.setProject(iJavaProject);
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        Selection selection = Selection.createFromStartLength(n, string.length());
        SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(selection, false);
        compilationUnit.accept((ASTVisitor)selectionAnalyzer);
        ASTNode aSTNode = selectionAnalyzer.getFirstSelectedNode();
        if (!(aSTNode instanceof Type)) {
            return null;
        }
        Type type = (Type)aSTNode;
        if (MethodTypesSyntaxChecker.isVoidArrayType(type)) {
            return null;
        }
        IProblem[] iProblemArray = ASTNodes.getProblems((ASTNode)type, 0, 3);
        if (iProblemArray.length > 0) {
            int n2 = 0;
            while (n2 < iProblemArray.length) {
                list.add(iProblemArray[n2].getMessage());
                ++n2;
            }
        }
        if (string.equals(string2 = stringBuffer.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)type)))) {
            return type;
        }
        return null;
    }

    private static ITypeBinding handleBug84585(ITypeBinding iTypeBinding) {
        if (iTypeBinding == null) {
            return null;
        }
        if (iTypeBinding.isGenericType() && !iTypeBinding.isRawType() && !iTypeBinding.isParameterizedType()) {
            return null;
        }
        return iTypeBinding;
    }

    public static RefactoringStatus[] checkAndResolveMethodTypes(IMethod iMethod, StubTypeContext stubTypeContext, List list, ReturnTypeInfo returnTypeInfo, IProblemVerifier iProblemVerifier) throws CoreException {
        MethodTypesChecker methodTypesChecker = new MethodTypesChecker(iMethod, stubTypeContext, list, returnTypeInfo, iProblemVerifier);
        return methodTypesChecker.checkAndResolveMethodTypes();
    }

    public static RefactoringStatus[] checkMethodTypesSyntax(IMethod iMethod, List list, ReturnTypeInfo returnTypeInfo) {
        MethodTypesSyntaxChecker methodTypesSyntaxChecker = new MethodTypesSyntaxChecker(iMethod, list, returnTypeInfo);
        return methodTypesSyntaxChecker.checkSyntax();
    }

    public static RefactoringStatus checkParameterTypeSyntax(String string, IJavaProject iJavaProject) {
        boolean bl;
        String string2 = ParameterInfo.stripEllipsis(string.trim()).trim();
        if ("".equals(string2.trim())) {
            String string3 = Messages.format(RefactoringCoreMessages.TypeContextChecker_parameter_type, new String[]{string});
            return RefactoringStatus.createFatalErrorStatus((String)string3);
        }
        if (ParameterInfo.isVarargs(string) && !JavaModelUtil.is50OrHigher(iJavaProject)) {
            String string4 = Messages.format(RefactoringCoreMessages.TypeContextChecker_no_vararg_below_50, new String[]{string});
            return RefactoringStatus.createFatalErrorStatus((String)string4);
        }
        ArrayList arrayList = new ArrayList(0);
        Type type = TypeContextChecker.parseType(string2, iJavaProject, arrayList);
        boolean bl2 = bl = type != null;
        if (bl && type instanceof PrimitiveType) {
            boolean bl3 = bl = !PrimitiveType.VOID.equals(((PrimitiveType)type).getPrimitiveTypeCode());
        }
        if (!bl) {
            String string5 = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_type_name, new String[]{string2});
            return RefactoringStatus.createFatalErrorStatus((String)string5);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string6 = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_type_syntax, new String[]{string2, (String)iterator.next()});
            refactoringStatus.addError(string6);
        }
        return refactoringStatus;
    }

    public static StubTypeContext createStubTypeContext(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, int n) throws CoreException {
        StubTypeContext stubTypeContext;
        IDocument iDocument = RefactoringFileBuffers.acquire(iCompilationUnit).getDocument();
        try {
            List list;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = 0;
            PackageDeclaration packageDeclaration = compilationUnit.getPackage();
            if (packageDeclaration != null) {
                n2 = packageDeclaration.getStartPosition() + packageDeclaration.getLength();
            }
            if ((list = compilationUnit.imports()).size() > 0) {
                ImportDeclaration importDeclaration = (ImportDeclaration)list.get(list.size() - 1);
                n2 = importDeclaration.getStartPosition() + importDeclaration.getLength();
            }
            try {
                stringBuffer.append(iDocument.get(0, n2));
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
            TypeContextChecker.fillWithTypeStubs(stringBuffer, stringBuffer2, n, compilationUnit.types());
            stringBuffer.append(' ');
            stringBuffer2.insert(0, ' ');
            stubTypeContext = new StubTypeContext(iCompilationUnit, stringBuffer.toString(), stringBuffer2.toString());
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            RefactoringFileBuffers.release(iCompilationUnit);
            throw throwable;
        }
        RefactoringFileBuffers.release(iCompilationUnit);
        return stubTypeContext;
    }

    private static void fillWithTypeStubs(final StringBuffer stringBuffer, final StringBuffer stringBuffer2, final int n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer3;
            Object object;
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
            if (!(bodyDeclaration instanceof AbstractTypeDeclaration)) {
                if (!(bodyDeclaration instanceof MethodDeclaration)) continue;
                int n2 = bodyDeclaration.getStartPosition();
                int n3 = bodyDeclaration.getStartPosition() + bodyDeclaration.getLength();
                if (n2 >= n || n >= n3) continue;
                object = (MethodDeclaration)bodyDeclaration;
                stringBuffer3 = stringBuffer;
                TypeContextChecker.appendModifiers(stringBuffer3, object.modifiers());
                TypeContextChecker.appendTypeParameters(stringBuffer3, object.typeParameters());
                stringBuffer3.append(" void ");
                stringBuffer3.append(object.getName().getIdentifier());
                stringBuffer3.append("(){\n");
                Block block = object.getBody();
                block.accept((ASTVisitor)new HierarchicalASTVisitor(){

                    public boolean visit(AbstractTypeDeclaration abstractTypeDeclaration) {
                        TypeContextChecker.fillWithTypeStubs(stringBuffer, stringBuffer2, n, Collections.singletonList(abstractTypeDeclaration));
                        return false;
                    }

                    public boolean visit(ClassInstanceCreation classInstanceCreation) {
                        AnonymousClassDeclaration anonymousClassDeclaration = classInstanceCreation.getAnonymousClassDeclaration();
                        if (anonymousClassDeclaration == null) {
                            return false;
                        }
                        int n3 = anonymousClassDeclaration.getStartPosition();
                        int n2 = anonymousClassDeclaration.getStartPosition() + anonymousClassDeclaration.getLength();
                        if (n3 >= n || n >= n2) {
                            return false;
                        }
                        stringBuffer.append(" new ");
                        stringBuffer.append(classInstanceCreation.getType().toString());
                        stringBuffer.append("(){\n");
                        TypeContextChecker.fillWithTypeStubs(stringBuffer, stringBuffer2, n, anonymousClassDeclaration.bodyDeclarations());
                        stringBuffer2.insert(0, "};\n");
                        return false;
                    }
                });
                stringBuffer3 = stringBuffer2;
                stringBuffer3.append("}\n");
                continue;
            }
            AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)bodyDeclaration;
            stringBuffer3 = abstractTypeDeclaration.getStartPosition() < n ? stringBuffer : stringBuffer2;
            TypeContextChecker.appendModifiers(stringBuffer3, abstractTypeDeclaration.modifiers());
            if (abstractTypeDeclaration instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)abstractTypeDeclaration;
                stringBuffer3.append(typeDeclaration.isInterface() ? "interface " : "class ");
                stringBuffer3.append(typeDeclaration.getName().getIdentifier());
                TypeContextChecker.appendTypeParameters(stringBuffer3, typeDeclaration.typeParameters());
                if (typeDeclaration.getSuperclassType() != null) {
                    stringBuffer3.append(" extends ");
                    stringBuffer3.append(ASTNodes.asString((ASTNode)typeDeclaration.getSuperclassType()));
                }
                object = typeDeclaration.superInterfaceTypes();
                TypeContextChecker.appendSuperInterfaces(stringBuffer3, (List)object);
            } else if (abstractTypeDeclaration instanceof AnnotationTypeDeclaration) {
                AnnotationTypeDeclaration annotationTypeDeclaration = (AnnotationTypeDeclaration)abstractTypeDeclaration;
                stringBuffer3.append("@interface ");
                stringBuffer3.append(annotationTypeDeclaration.getName().getIdentifier());
            } else if (abstractTypeDeclaration instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)abstractTypeDeclaration;
                stringBuffer3.append("enum ");
                stringBuffer3.append(enumDeclaration.getName().getIdentifier());
                object = enumDeclaration.superInterfaceTypes();
                TypeContextChecker.appendSuperInterfaces(stringBuffer3, (List)object);
            }
            stringBuffer3.append("{\n");
            if (abstractTypeDeclaration instanceof EnumDeclaration) {
                stringBuffer3.append(";\n");
            }
            TypeContextChecker.fillWithTypeStubs(stringBuffer, stringBuffer2, n, abstractTypeDeclaration.bodyDeclarations());
            stringBuffer3 = abstractTypeDeclaration.getStartPosition() + abstractTypeDeclaration.getLength() < n ? stringBuffer : stringBuffer2;
            stringBuffer3.append("}\n");
        }
    }

    private static void appendTypeParameters(StringBuffer stringBuffer, List list) {
        int n = list.size();
        if (n > 0) {
            stringBuffer.append('<');
            int n2 = 0;
            while (n2 < n) {
                TypeParameter typeParameter = (TypeParameter)list.get(n2);
                stringBuffer.append(ASTNodes.asString((ASTNode)typeParameter));
                if (n2 < n - 1) {
                    stringBuffer.append(',');
                }
                ++n2;
            }
        }
    }

    private static void appendModifiers(StringBuffer stringBuffer, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IExtendedModifier iExtendedModifier = (IExtendedModifier)iterator.next();
            if (!iExtendedModifier.isModifier()) continue;
            Modifier modifier = (Modifier)iExtendedModifier;
            stringBuffer.append(modifier.getKeyword().toString()).append(' ');
        }
    }

    private static void appendSuperInterfaces(StringBuffer stringBuffer, List list) {
        int n = list.size();
        if (n > 0) {
            stringBuffer.append(" implements ");
            int n2 = 0;
            while (n2 < n) {
                Type type = (Type)list.get(n2);
                stringBuffer.append(ASTNodes.asString((ASTNode)type));
                if (n2 < n - 1) {
                    stringBuffer.append(',');
                }
                ++n2;
            }
        }
    }

    public static StubTypeContext createSuperInterfaceStubTypeContext(String string, IType iType, IPackageFragment iPackageFragment) {
        return TypeContextChecker.createSupertypeStubTypeContext(string, true, iType, iPackageFragment);
    }

    public static StubTypeContext createSuperClassStubTypeContext(String string, IType iType, IPackageFragment iPackageFragment) {
        return TypeContextChecker.createSupertypeStubTypeContext(string, false, iType, iPackageFragment);
    }

    private static StubTypeContext createSupertypeStubTypeContext(String string, boolean bl, IType iType, IPackageFragment iPackageFragment) {
        StubTypeContext stubTypeContext;
        String string2 = "class " + string + (bl ? " implements " : " extends ");
        String string3 = " {} ";
        if (iType != null) {
            try {
                ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
                ISourceRange iSourceRange = iType.getSourceRange();
                int n = iSourceRange.getOffset() + iSourceRange.getLength() - 1;
                ASTParser aSTParser = ASTParser.newParser((int)3);
                aSTParser.setSource(iCompilationUnit);
                aSTParser.setFocalPosition(n);
                CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
                stubTypeContext = TypeContextChecker.createStubTypeContext(iCompilationUnit, compilationUnit, n);
                stubTypeContext = new StubTypeContext(stubTypeContext.getCuHandle(), String.valueOf(stubTypeContext.getBeforeString()) + string2, String.valueOf(string3) + stubTypeContext.getAfterString());
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
                stubTypeContext = new StubTypeContext(null, null, null);
            }
        } else if (iPackageFragment != null) {
            ICompilationUnit iCompilationUnit = iPackageFragment.getCompilationUnit("$$__$$.js");
            stubTypeContext = new StubTypeContext(iCompilationUnit, "package " + iPackageFragment.getElementName() + ";" + string2, string3);
        } else {
            stubTypeContext = new StubTypeContext(null, null, null);
        }
        return stubTypeContext;
    }

    public static Type parseSuperClass(String string) {
        return TypeContextChecker.parseSuperType(string, false);
    }

    public static Type parseSuperInterface(String string) {
        return TypeContextChecker.parseSuperType(string, true);
    }

    private static Type parseSuperType(String string, boolean bl) {
        if (!string.trim().equals(string)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("class __X__ implements ");
        } else {
            stringBuffer.append("class __X__ extends ");
        }
        int n = stringBuffer.length();
        stringBuffer.append(string).append(" {}");
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(stringBuffer.toString().toCharArray());
        HashMap hashMap = new HashMap();
        JavaModelUtil.set50CompilanceOptions(hashMap);
        aSTParser.setCompilerOptions(hashMap);
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, n, string.length());
        if (aSTNode instanceof Name) {
            aSTNode = aSTNode.getParent();
        }
        if (aSTNode.getStartPosition() != n || aSTNode.getLength() != string.length() || !(aSTNode instanceof Type) || aSTNode instanceof PrimitiveType) {
            return null;
        }
        Type type = (Type)aSTNode;
        String string2 = stringBuffer.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)type));
        if (!string.equals(string2)) {
            return null;
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITypeBinding resolveSuperClass(String string, IType iType, StubTypeContext stubTypeContext) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stubTypeContext.getBeforeString());
        stringBuffer.append(string);
        stringBuffer.append(stubTypeContext.getAfterString());
        try {
            ITypeBinding iTypeBinding;
            ICompilationUnit iCompilationUnit;
            block7: {
                ITypeBinding iTypeBinding2;
                block6: {
                    iCompilationUnit = iType.getCompilationUnit().getWorkingCopy(new WorkingCopyOwner(){}, (IProgressMonitor)new NullProgressMonitor());
                    try {
                        ASTNode aSTNode;
                        iCompilationUnit.getBuffer().setContents(stringBuffer.toString());
                        CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, true);
                        ASTNode aSTNode2 = NodeFinder.perform((ASTNode)compilationUnit, stubTypeContext.getBeforeString().length(), string.length());
                        if (aSTNode2 instanceof Type) {
                            iTypeBinding2 = TypeContextChecker.handleBug84585(((Type)aSTNode2).resolveBinding());
                            Object var8_9 = null;
                            break block6;
                        }
                        if (aSTNode2 instanceof Name && (aSTNode = aSTNode2.getParent()) instanceof Type) {
                            iTypeBinding = TypeContextChecker.handleBug84585(((Type)aSTNode).resolveBinding());
                            break block7;
                        }
                        throw new IllegalStateException();
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        iCompilationUnit.discardWorkingCopy();
                        throw throwable;
                    }
                }
                iCompilationUnit.discardWorkingCopy();
                return iTypeBinding2;
            }
            Object var8_10 = null;
            iCompilationUnit.discardWorkingCopy();
            return iTypeBinding;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITypeBinding[] resolveSuperInterfaces(String[] stringArray, IType iType, StubTypeContext stubTypeContext) {
        ITypeBinding[] iTypeBindingArray = new ITypeBinding[stringArray.length];
        int[] nArray = new int[stringArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stubTypeContext.getBeforeString());
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            nArray[n2] = stringBuffer.length();
            stringBuffer.append(stringArray[n2]);
            if (n2 != n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(stubTypeContext.getAfterString());
        try {
            ICompilationUnit iCompilationUnit = iType.getCompilationUnit().getWorkingCopy(new WorkingCopyOwner(){}, (IProgressMonitor)new NullProgressMonitor());
            try {
                iCompilationUnit.getBuffer().setContents(stringBuffer.toString());
                CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, true);
                int n3 = 0;
                while (n3 <= n) {
                    ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, nArray[n3], stringArray[n3].length());
                    if (aSTNode instanceof Type) {
                        iTypeBindingArray[n3] = TypeContextChecker.handleBug84585(((Type)aSTNode).resolveBinding());
                    } else {
                        if (!(aSTNode instanceof Name)) throw new IllegalStateException();
                        ASTNode aSTNode2 = aSTNode.getParent();
                        if (!(aSTNode2 instanceof Type)) throw new IllegalStateException();
                        iTypeBindingArray[n3] = TypeContextChecker.handleBug84585(((Type)aSTNode2).resolveBinding());
                    }
                    ++n3;
                }
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                iCompilationUnit.discardWorkingCopy();
                throw throwable;
            }
            iCompilationUnit.discardWorkingCopy();
            return iTypeBindingArray;
        }
        catch (JavaModelException javaModelException) {}
        return iTypeBindingArray;
    }

    public static interface IProblemVerifier {
        public boolean isError(IProblem var1, ASTNode var2);
    }

    private static class MethodTypesChecker {
        private static final String METHOD_NAME = "__$$__";
        private final IMethod fMethod;
        private final StubTypeContext fStubTypeContext;
        private final List fParameterInfos;
        private final ReturnTypeInfo fReturnTypeInfo;
        private final IProblemVerifier fProblemVerifier;

        public MethodTypesChecker(IMethod iMethod, StubTypeContext stubTypeContext, List list, ReturnTypeInfo returnTypeInfo, IProblemVerifier iProblemVerifier) {
            this.fMethod = iMethod;
            this.fStubTypeContext = stubTypeContext;
            this.fParameterInfos = list;
            this.fReturnTypeInfo = returnTypeInfo;
            this.fProblemVerifier = iProblemVerifier;
        }

        public RefactoringStatus[] checkAndResolveMethodTypes() throws CoreException {
            RefactoringStatus[] refactoringStatusArray = new MethodTypesSyntaxChecker(this.fMethod, this.fParameterInfos, this.fReturnTypeInfo).checkSyntax();
            int n = 0;
            while (n < refactoringStatusArray.length) {
                if (refactoringStatusArray[n] != null && refactoringStatusArray[n].hasFatalError()) {
                    return refactoringStatusArray;
                }
                ++n;
            }
            n = this.fParameterInfos.size();
            String[] stringArray = new String[n + 1];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = ParameterInfo.stripEllipsis(((ParameterInfo)this.fParameterInfos.get(n2)).getNewTypeName());
                ++n2;
            }
            stringArray[n] = this.fReturnTypeInfo.getNewTypeName();
            RefactoringStatus[] refactoringStatusArray2 = new RefactoringStatus[n + 1];
            ITypeBinding[] iTypeBindingArray = this.resolveBindings(stringArray, refactoringStatusArray2, true);
            boolean bl = false;
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (iTypeBindingArray[n3] == null || !refactoringStatusArray2[n3].isOK()) {
                    bl = true;
                }
                ++n3;
            }
            RefactoringStatus[] refactoringStatusArray3 = new RefactoringStatus[n + 1];
            if (bl) {
                iTypeBindingArray = this.resolveBindings(stringArray, refactoringStatusArray3, false);
            }
            int n4 = 0;
            while (n4 < this.fParameterInfos.size()) {
                ParameterInfo parameterInfo = (ParameterInfo)this.fParameterInfos.get(n4);
                if (parameterInfo.getOldTypeBinding() != null && !parameterInfo.isTypeNameChanged()) {
                    parameterInfo.setNewTypeBinding(parameterInfo.getOldTypeBinding());
                } else {
                    parameterInfo.setNewTypeBinding(iTypeBindingArray[n4]);
                    if (iTypeBindingArray[n4] == null || bl && !refactoringStatusArray3[n4].isOK()) {
                        if (refactoringStatusArray[n4] == null) {
                            refactoringStatusArray[n4] = refactoringStatusArray3[n4];
                        } else {
                            refactoringStatusArray[n4].merge(refactoringStatusArray3[n4]);
                        }
                    }
                }
                ++n4;
            }
            this.fReturnTypeInfo.setNewTypeBinding(iTypeBindingArray[this.fParameterInfos.size()]);
            if (iTypeBindingArray[n] == null || bl && !refactoringStatusArray3[n].isOK()) {
                if (refactoringStatusArray[n] == null) {
                    refactoringStatusArray[n] = refactoringStatusArray3[n];
                } else {
                    refactoringStatusArray[n].merge(refactoringStatusArray3[n]);
                }
            }
            return refactoringStatusArray;
        }

        private ITypeBinding[] resolveBindings(String[] stringArray, RefactoringStatus[] refactoringStatusArray, boolean bl) throws CoreException {
            ITypeBinding[] iTypeBindingArray;
            int n = stringArray.length - 1;
            ITypeBinding[] iTypeBindingArray2 = new ITypeBinding[stringArray.length];
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.fStubTypeContext.getBeforeString());
            int n2 = this.appendMethodDeclaration(stringBuffer, stringArray, n);
            stringBuffer.append(this.fStubTypeContext.getAfterString());
            ICompilationUnit iCompilationUnit = this.fMethod.getCompilationUnit().getWorkingCopy(new WorkingCopyOwner(this){
                final /* synthetic */ MethodTypesChecker this$1;
                {
                    this.this$1 = methodTypesChecker;
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            try {
                List list;
                iCompilationUnit.getBuffer().setContents(stringBuffer.toString());
                CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, true);
                ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, n2, METHOD_NAME.length()).getParent();
                Type[] typeArray = new Type[stringArray.length];
                if (aSTNode instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
                    typeArray[n] = methodDeclaration.getReturnType2();
                    list = methodDeclaration.parameters();
                    int n3 = 0;
                    while (n3 < n) {
                        typeArray[n3] = ((SingleVariableDeclaration)list.get(n3)).getType();
                        ++n3;
                    }
                } else if (aSTNode instanceof AnnotationTypeMemberDeclaration) {
                    typeArray[0] = ((AnnotationTypeMemberDeclaration)aSTNode).getType();
                }
                int n4 = 0;
                while (n4 < stringArray.length) {
                    IProblem[] iProblemArray;
                    list = typeArray[n4];
                    if (list == null) {
                        iProblemArray = Messages.format(RefactoringCoreMessages.TypeContextChecker_couldNotResolveType, stringArray[n4]);
                        refactoringStatusArray[n4] = RefactoringStatus.createErrorStatus((String)iProblemArray);
                    } else {
                        refactoringStatusArray[n4] = new RefactoringStatus();
                        iProblemArray = ASTNodes.getProblems((ASTNode)list, 0, 3);
                        if (iProblemArray.length > 0) {
                            int n5 = 0;
                            while (n5 < iProblemArray.length) {
                                if (this.isError(iProblemArray[n5], (Type)list)) {
                                    refactoringStatusArray[n4].addError(iProblemArray[n5].getMessage());
                                }
                                ++n5;
                            }
                        }
                        iTypeBindingArray2[n4] = list.resolveBinding();
                        iTypeBindingArray2[n4] = TypeContextChecker.handleBug84585(iTypeBindingArray2[n4]);
                        if (bl && iTypeBindingArray2[n4] == null) {
                            stringArray[n4] = this.qualifyTypes((Type)list, refactoringStatusArray[n4]);
                        }
                    }
                    ++n4;
                }
                iTypeBindingArray = iTypeBindingArray2;
                Object var16_19 = null;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                iCompilationUnit.discardWorkingCopy();
                throw throwable;
            }
            iCompilationUnit.discardWorkingCopy();
            return iTypeBindingArray;
        }

        private boolean isError(IProblem iProblem, Type type) {
            if (this.fProblemVerifier != null) {
                return this.fProblemVerifier.isError(iProblem, (ASTNode)type);
            }
            return true;
        }

        private int appendMethodDeclaration(StringBuffer stringBuffer, String[] stringArray, int n) throws JavaModelException {
            int n2;
            ITypeParameter[] iTypeParameterArray;
            if (Flags.isStatic((int)this.fMethod.getFlags())) {
                stringBuffer.append("static ");
            }
            if ((iTypeParameterArray = this.fMethod.getTypeParameters()).length != 0) {
                stringBuffer.append('<');
                n2 = 0;
                while (n2 < iTypeParameterArray.length) {
                    ITypeParameter iTypeParameter = iTypeParameterArray[n2];
                    if (n2 > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(iTypeParameter.getElementName());
                    ++n2;
                }
                stringBuffer.append("> ");
            }
            stringBuffer.append(stringArray[n]).append(' ');
            n2 = stringBuffer.length();
            stringBuffer.append(METHOD_NAME).append('(');
            int n3 = 0;
            while (n3 < n) {
                if (n3 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[n3]).append(" p").append(n3);
                ++n3;
            }
            stringBuffer.append(");");
            return n2;
        }

        private String qualifyTypes(Type type, RefactoringStatus refactoringStatus) throws CoreException {
            class NestedException
            extends RuntimeException {
                private static final long serialVersionUID = 1L;
                final /* synthetic */ MethodTypesChecker this$1;

                NestedException(MethodTypesChecker methodTypesChecker, CoreException coreException) {
                    super(coreException);
                    this.this$1 = methodTypesChecker;
                }
            }
            ASTFlattener aSTFlattener = new ASTFlattener(this, refactoringStatus){
                final /* synthetic */ MethodTypesChecker this$1;
                private final /* synthetic */ RefactoringStatus val$result;
                {
                    this.this$1 = methodTypesChecker;
                    this.val$result = refactoringStatus;
                }

                public boolean visit(SimpleName simpleName) {
                    this.appendResolved(simpleName.getIdentifier());
                    return false;
                }

                public boolean visit(QualifiedName qualifiedName) {
                    this.appendResolved(qualifiedName.getFullyQualifiedName());
                    return false;
                }

                public boolean visit(QualifiedType qualifiedType) {
                    this.appendResolved(ASTNodes.asString((ASTNode)qualifiedType));
                    return false;
                }

                private void appendResolved(String string) {
                    String string2;
                    try {
                        string2 = MethodTypesChecker.access$1(string, this.val$result, MethodTypesChecker.access$0(this.this$1).getDeclaringType(), null);
                    }
                    catch (CoreException coreException) {
                        throw new NestedException(this.this$1, coreException);
                    }
                    this.fBuffer.append(string2);
                }
            };
            try {
                type.accept((ASTVisitor)aSTFlattener);
            }
            catch (NestedException nestedException) {
                throw (CoreException)nestedException.getCause();
            }
            return aSTFlattener.getResult();
        }

        private static String resolveType(String string, RefactoringStatus refactoringStatus, IType iType, IProgressMonitor iProgressMonitor) throws CoreException {
            List list;
            String[][] stringArray = iType.resolveType(string);
            if (stringArray != null) {
                if (stringArray.length == 1) {
                    return JavaModelUtil.concatenateName(stringArray[0][0], stringArray[0][1]);
                }
                if (stringArray.length > 1) {
                    Object[] objectArray = new String[]{string, String.valueOf(stringArray.length)};
                    String string2 = Messages.format(RefactoringCoreMessages.TypeContextChecker_ambiguous, objectArray);
                    refactoringStatus.addError(string2);
                    return string;
                }
            }
            if ((list = MethodTypesChecker.findTypeInfos(string, iType, iProgressMonitor)).size() == 0) {
                Object[] objectArray = new String[]{string};
                String string3 = Messages.format(RefactoringCoreMessages.TypeContextChecker_not_unique, objectArray);
                refactoringStatus.addError(string3);
                return string;
            }
            if (list.size() == 1) {
                TypeNameMatch typeNameMatch = (TypeNameMatch)list.get(0);
                return typeNameMatch.getFullyQualifiedName();
            }
            Assert.isTrue((list.size() > 1 ? 1 : 0) != 0);
            Object[] objectArray = new String[]{string, String.valueOf(list.size())};
            String string4 = Messages.format(RefactoringCoreMessages.TypeContextChecker_ambiguous, objectArray);
            refactoringStatus.addError(string4);
            return string;
        }

        private static List findTypeInfos(String string, IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
            IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{iType.getJavaProject()}, (boolean)true);
            IPackageFragment iPackageFragment = iType.getPackageFragment();
            ArrayList arrayList = new ArrayList();
            TypeNameMatchCollector typeNameMatchCollector = new TypeNameMatchCollector(arrayList);
            int n = 8;
            new SearchEngine().searchAllTypeNames(null, n, string.toCharArray(), n, 0, iJavaSearchScope, (TypeNameMatchRequestor)typeNameMatchCollector, 3, iProgressMonitor);
            ArrayList<TypeNameMatch> arrayList2 = new ArrayList<TypeNameMatch>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                TypeNameMatch typeNameMatch = (TypeNameMatch)iterator.next();
                IType iType2 = typeNameMatch.getType();
                if (iType2 == null) continue;
                boolean bl = true;
                try {
                    bl = JavaModelUtil.isVisible((IMember)iType2, iPackageFragment);
                }
                catch (JavaModelException javaModelException) {}
                if (!bl) continue;
                arrayList2.add(typeNameMatch);
            }
            return arrayList2;
        }

        static /* synthetic */ IMethod access$0(MethodTypesChecker methodTypesChecker) {
            return methodTypesChecker.fMethod;
        }

        static /* synthetic */ String access$1(String string, RefactoringStatus refactoringStatus, IType iType, IProgressMonitor iProgressMonitor) throws CoreException {
            return MethodTypesChecker.resolveType(string, refactoringStatus, iType, iProgressMonitor);
        }
    }

    private static class MethodTypesSyntaxChecker {
        private final IMethod fMethod;
        private final List fParameterInfos;
        private final ReturnTypeInfo fReturnTypeInfo;

        public MethodTypesSyntaxChecker(IMethod iMethod, List list, ReturnTypeInfo returnTypeInfo) {
            this.fMethod = iMethod;
            this.fParameterInfos = list;
            this.fReturnTypeInfo = returnTypeInfo;
        }

        public RefactoringStatus[] checkSyntax() {
            int n = this.fParameterInfos.size();
            RefactoringStatus[] refactoringStatusArray = new RefactoringStatus[n + 1];
            refactoringStatusArray[n] = this.checkReturnTypeSyntax();
            int n2 = 0;
            while (n2 < n) {
                ParameterInfo parameterInfo = (ParameterInfo)this.fParameterInfos.get(n2);
                refactoringStatusArray[n2] = this.checkParameterTypeSyntax(parameterInfo);
                ++n2;
            }
            return refactoringStatusArray;
        }

        private RefactoringStatus checkParameterTypeSyntax(ParameterInfo parameterInfo) {
            if (!parameterInfo.isAdded() && !parameterInfo.isTypeNameChanged()) {
                return null;
            }
            return TypeContextChecker.checkParameterTypeSyntax(parameterInfo.getNewTypeName(), this.fMethod.getJavaProject());
        }

        private RefactoringStatus checkReturnTypeSyntax() {
            String string = this.fReturnTypeInfo.getNewTypeName();
            if ("".equals(string.trim())) {
                String string2 = RefactoringCoreMessages.TypeContextChecker_return_type_not_empty;
                return RefactoringStatus.createFatalErrorStatus((String)string2);
            }
            ArrayList arrayList = new ArrayList(0);
            Type type = TypeContextChecker.parseType(string, this.fMethod.getJavaProject(), arrayList);
            if (type == null) {
                String string3 = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_return_type, new String[]{string});
                return RefactoringStatus.createFatalErrorStatus((String)string3);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string4 = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_return_type_syntax, new String[]{string, (String)iterator.next()});
                refactoringStatus.addError(string4);
            }
            return refactoringStatus;
        }

        private static boolean isVoidArrayType(Type type) {
            if (!type.isArrayType()) {
                return false;
            }
            ArrayType arrayType = (ArrayType)type;
            if (!arrayType.getComponentType().isPrimitiveType()) {
                return false;
            }
            PrimitiveType primitiveType = (PrimitiveType)arrayType.getComponentType();
            return primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID;
        }
    }
}

