/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class DeleteFileChange
extends AbstractDeleteChange {
    private final IPath fPath;
    private final boolean fIsExecuteChange;

    public DeleteFileChange(IFile iFile, boolean bl) {
        Assert.isNotNull((Object)iFile, (String)"file");
        this.fPath = Utils.getResourcePath((IResource)iFile);
        this.fIsExecuteChange = bl;
    }

    private IFile getFile() {
        return Utils.getFile(this.fPath);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteFileChange_1, this.fPath.lastSegment());
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(iProgressMonitor, 0);
        }
        return super.isValid(iProgressMonitor, 3);
    }

    public Object getModifiedElement() {
        return this.getFile();
    }

    protected Change doDelete(IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile = this.getFile();
        Assert.isNotNull((Object)iFile);
        Assert.isTrue((boolean)iFile.exists());
        iProgressMonitor.beginTask("", 3);
        DeleteFileChange.saveFileIfNeeded(iFile, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        ResourceDescription resourceDescription = ResourceDescription.fromResource((IResource)iFile);
        iFile.delete(false, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        resourceDescription.recordStateFromHistory((IResource)iFile, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        iProgressMonitor.done();
        return new UndoDeleteResourceChange(resourceDescription);
    }
}

