/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;

abstract class PackageFragmentRootReorgChange
extends JDTChange {
    private final String fRootHandle;
    private final IPath fDestinationPath;
    private final INewNameQuery fNewNameQuery;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;
    static /* synthetic */ Class class$0;

    PackageFragmentRootReorgChange(IPackageFragmentRoot iPackageFragmentRoot, IProject iProject, INewNameQuery iNewNameQuery, IPackageFragmentRootManipulationQuery iPackageFragmentRootManipulationQuery) {
        Assert.isTrue((!iPackageFragmentRoot.isExternal() ? 1 : 0) != 0);
        this.fRootHandle = iPackageFragmentRoot.getHandleIdentifier();
        this.fDestinationPath = Utils.getResourcePath((IResource)iProject);
        this.fNewNameQuery = iNewNameQuery;
        this.fUpdateClasspathQuery = iPackageFragmentRootManipulationQuery;
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        return this.isValid(iProgressMonitor, 0);
    }

    public final Change perform(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        Change change;
        iProgressMonitor.beginTask(this.getName(), 2);
        try {
            String string = this.getNewResourceName();
            IPackageFragmentRoot iPackageFragmentRoot = this.getRoot();
            ResourceMapping resourceMapping = JavaElementResourceMapping.create(iPackageFragmentRoot);
            Change change2 = this.doPerformReorg(this.getDestinationProjectPath().append(string), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            this.markAsExecuted(iPackageFragmentRoot, resourceMapping);
            change = change2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return change;
    }

    protected abstract Change doPerformReorg(IPath var1, IProgressMonitor var2) throws JavaModelException;

    public Object getModifiedElement() {
        return this.getRoot();
    }

    protected IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fRootHandle);
    }

    protected IPath getDestinationProjectPath() {
        return this.fDestinationPath;
    }

    protected IProject getDestinationProject() {
        return Utils.getProject(this.getDestinationProjectPath());
    }

    private String getNewResourceName() throws OperationCanceledException {
        if (this.fNewNameQuery == null) {
            return this.getRoot().getElementName();
        }
        String string = this.fNewNameQuery.getNewName();
        if (string == null) {
            return this.getRoot().getElementName();
        }
        return string;
    }

    protected int getUpdateModelFlags(boolean bl) throws JavaModelException {
        int n;
        int n2;
        if (bl) {
            n2 = 0;
            n = 0;
        } else {
            n2 = 2;
            n = 4;
        }
        if (!JavaCore.create((IProject)this.getDestinationProject()).exists()) {
            return 0x10 | n2;
        }
        if (this.fUpdateClasspathQuery == null) {
            return 0x10 | n2 | 8;
        }
        IJavaProject[] iJavaProjectArray = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (iJavaProjectArray.length <= 1) {
            return 0x10 | n2 | 8;
        }
        boolean bl2 = this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), iJavaProjectArray);
        if (bl2) {
            return 0x10 | n2 | 8 | n;
        }
        return 0x10 | n2 | 8;
    }

    protected int getResourceUpdateFlags() {
        return 34;
    }

    private void markAsExecuted(IPackageFragmentRoot iPackageFragmentRoot, ResourceMapping resourceMapping) {
        ReorgExecutionLog reorgExecutionLog;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reorgExecutionLog = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            reorgExecutionLog.markAsProcessed((Object)iPackageFragmentRoot);
            reorgExecutionLog.markAsProcessed((Object)resourceMapping);
        }
    }
}

