/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenameJavaProjectChange
extends AbstractJavaElementRenameChange {
    private boolean fUpdateReferences;

    public RenameJavaProjectChange(IJavaProject iJavaProject, String string, boolean bl) {
        this(iJavaProject.getPath(), iJavaProject.getElementName(), string, -1L, bl);
        Assert.isTrue((!iJavaProject.isReadOnly() ? 1 : 0) != 0, (String)"should not be read only");
    }

    private RenameJavaProjectChange(IPath iPath, String string, String string2, long l, boolean bl) {
        super(iPath, string, string2);
        this.fUpdateReferences = bl;
    }

    private IClasspathEntry createModifiedEntry(IClasspathEntry iClasspathEntry) {
        return JavaCore.newProjectEntry((IPath)this.createNewPath(), (IAccessRule[])iClasspathEntry.getAccessRules(), (boolean)iClasspathEntry.combineAccessRules(), (IClasspathAttribute[])iClasspathEntry.getExtraAttributes(), (boolean)iClasspathEntry.isExported());
    }

    protected IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    protected Change createUndoChange(long l) throws JavaModelException {
        return new RenameJavaProjectChange(this.createNewPath(), this.getNewName(), this.getOldName(), l, this.fUpdateReferences);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRename(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            IProject iProject;
            iProgressMonitor.beginTask(this.getName(), 2);
            if (this.fUpdateReferences) {
                this.modifyClassPaths((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            if ((iProject = this.getProject()) != null) {
                IProjectDescription iProjectDescription = iProject.getDescription();
                iProjectDescription.setName(this.getNewName());
                iProject.move(iProjectDescription, 33, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        iProgressMonitor.done();
    }

    private IJavaProject getJavaProject() {
        return (IJavaProject)this.getModifiedElement();
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameJavaProjectChange_rename, new String[]{this.getOldName(), this.getNewName()});
    }

    private IProject getProject() {
        IJavaProject iJavaProject = this.getJavaProject();
        if (iJavaProject == null) {
            return null;
        }
        return iJavaProject.getProject();
    }

    private boolean isOurEntry(IClasspathEntry iClasspathEntry) {
        if (iClasspathEntry.getEntryKind() != 2) {
            return false;
        }
        return iClasspathEntry.getPath().equals((Object)this.getResourcePath());
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        return this.isValid(iProgressMonitor, 2);
    }

    private void modifyClassPath(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        iProgressMonitor.beginTask("", 1);
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length];
        int n = 0;
        while (n < iClasspathEntryArray2.length) {
            iClasspathEntryArray2[n] = this.isOurEntry(iClasspathEntryArray[n]) ? this.createModifiedEntry(iClasspathEntryArray[n]) : iClasspathEntryArray[n];
            ++n;
        }
        iJavaProject.setRawClasspath(iClasspathEntryArray2, iProgressMonitor);
        iProgressMonitor.done();
    }

    private void modifyClassPaths(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IProject[] iProjectArray = this.getProject().getReferencingProjects();
        iProgressMonitor.beginTask(RefactoringCoreMessages.RenameJavaProjectChange_update, iProjectArray.length);
        int n = 0;
        while (n < iProjectArray.length) {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProjectArray[n]);
            if (iJavaProject != null && iJavaProject.exists()) {
                this.modifyClassPath(iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            } else {
                iProgressMonitor.worked(1);
            }
            ++n;
        }
        iProgressMonitor.done();
    }
}

