/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ConstantChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class ExtractConstantRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_QUALIFY = "qualify";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String MODIFIER = "static final";
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private CompilationUnitRewrite fCuRewrite;
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private IExpressionFragment fSelectedExpression;
    private Type fConstantTypeCache;
    private boolean fReplaceAllOccurrences = true;
    private boolean fQualifyReferencesWithDeclaringClassName = false;
    private String fVisibility = "private";
    private boolean fTargetIsInterface = false;
    private String fConstantName;
    private String[] fExcludedVariableNames;
    private boolean fSelectionAllStaticFinal;
    private boolean fAllStaticFinalCheckPerformed = false;
    private List fBodyDeclarations;
    private BodyDeclaration fToInsertAfter;
    private boolean fInsertFirst;
    private CompilationUnitChange fChange;
    private String[] fGuessedConstNames;
    private LinkedProposalModel fLinkedProposalModel;
    static /* synthetic */ Class class$0;

    public ExtractConstantRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fCu = iCompilationUnit;
        this.fCuRewrite = null;
        this.fLinkedProposalModel = null;
        this.fConstantName = "";
    }

    public ExtractConstantRefactoring(CompilationUnit compilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(compilationUnit.getTypeRoot() instanceof ICompilationUnit));
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fCu = (ICompilationUnit)compilationUnit.getTypeRoot();
        this.fCuRewrite = new CompilationUnitRewrite(this.fCu, compilationUnit);
        this.fLinkedProposalModel = null;
        this.fConstantName = "";
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractConstantRefactoring_name;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    public void setReplaceAllOccurrences(boolean bl) {
        this.fReplaceAllOccurrences = bl;
    }

    public void setVisibility(String string) {
        Assert.isTrue((string == "private" || string == "protected" || string == "" || string == "public" ? 1 : 0) != 0);
        this.fVisibility = string;
    }

    public String getVisibility() {
        return this.fVisibility;
    }

    public boolean getTargetIsInterface() {
        return this.fTargetIsInterface;
    }

    public boolean qualifyReferencesWithDeclaringClassName() {
        return this.fQualifyReferencesWithDeclaringClassName;
    }

    public void setQualifyReferencesWithDeclaringClassName(boolean bl) {
        this.fQualifyReferencesWithDeclaringClassName = bl;
    }

    public String guessConstantName() throws JavaModelException {
        String[] stringArray = this.guessConstantNames();
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return this.fConstantName;
    }

    public String[] guessConstantNames() {
        if (this.fGuessedConstNames == null) {
            try {
                Expression expression = this.getSelectedExpression().getAssociatedExpression();
                if (expression != null) {
                    ITypeBinding iTypeBinding = expression.resolveTypeBinding();
                    this.fGuessedConstNames = StubUtility.getVariableNameSuggestions(3, this.fCu.getJavaProject(), iTypeBinding, expression, Arrays.asList(this.getExcludedVariableNames()));
                }
            }
            catch (JavaModelException javaModelException) {}
            if (this.fGuessedConstNames == null) {
                this.fGuessedConstNames = new String[0];
            }
        }
        return this.fGuessedConstNames;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IExpressionFragment iExpressionFragment = this.getSelectedExpression();
                Collection collection = new ScopeAnalyzer(this.fCuRewrite.getRoot()).getUsedVariableNames(iExpressionFragment.getStartPosition(), iExpressionFragment.getLength());
                this.fExcludedVariableNames = collection.toArray(new String[collection.size()]);
            }
            catch (JavaModelException javaModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnit compilationUnit;
        RefactoringStatus refactoringStatus;
        block9: {
            block8: {
                RefactoringStatus refactoringStatus2;
                try {
                    iProgressMonitor.beginTask("", 7);
                    refactoringStatus = Checks.validateEdit(this.fCu, this.getValidationContext());
                    if (!refactoringStatus.hasFatalError()) break block8;
                    refactoringStatus2 = refactoringStatus;
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                iProgressMonitor.done();
                return refactoringStatus2;
            }
            iProgressMonitor.worked(1);
            if (this.fCuRewrite == null) {
                compilationUnit = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
                this.fCuRewrite = new CompilationUnitRewrite(this.fCu, compilationUnit);
            } else {
                iProgressMonitor.worked(3);
            }
            refactoringStatus.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3)));
            if (!refactoringStatus.hasFatalError()) break block9;
            RefactoringStatus refactoringStatus3 = refactoringStatus;
            Object var4_7 = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        if (this.isLiteralNodeSelected()) {
            this.fReplaceAllOccurrences = false;
        }
        if ((compilationUnit = this.getContainingTypeBinding()).isAnnotation() || compilationUnit.isInterface()) {
            this.fTargetIsInterface = true;
            this.fVisibility = "public";
        }
        RefactoringStatus refactoringStatus4 = refactoringStatus;
        Object var4_8 = null;
        iProgressMonitor.done();
        return refactoringStatus4;
    }

    public boolean selectionAllStaticFinal() {
        Assert.isTrue((boolean)this.fAllStaticFinalCheckPerformed);
        return this.fSelectionAllStaticFinal;
    }

    private void checkAllStaticFinal() throws JavaModelException {
        this.fSelectionAllStaticFinal = ConstantChecks.isStaticFinalConstant(this.getSelectedExpression());
        this.fAllStaticFinalCheckPerformed = true;
    }

    private RefactoringStatus checkSelection(IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block5: {
            block4: {
                RefactoringStatus refactoringStatus2;
                try {
                    iProgressMonitor.beginTask("", 2);
                    IExpressionFragment iExpressionFragment = this.getSelectedExpression();
                    if (iExpressionFragment != null) break block4;
                    String string = RefactoringCoreMessages.ExtractConstantRefactoring_select_expression;
                    refactoringStatus2 = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCuRewrite.getRoot(), string);
                    Object var4_8 = null;
                }
                catch (Throwable throwable) {
                    Object var4_11 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                iProgressMonitor.done();
                return refactoringStatus2;
            }
            iProgressMonitor.worked(1);
            refactoringStatus = new RefactoringStatus();
            refactoringStatus.merge(this.checkExpression());
            if (!refactoringStatus.hasFatalError()) break block5;
            RefactoringStatus refactoringStatus3 = refactoringStatus;
            Object var4_9 = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        iProgressMonitor.worked(1);
        RefactoringStatus refactoringStatus4 = refactoringStatus;
        Object var4_10 = null;
        iProgressMonitor.done();
        return refactoringStatus4;
    }

    private RefactoringStatus checkExpressionBinding() throws JavaModelException {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractConstantRefactoring_select_expression, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractConstantRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment iExpressionFragment = this.getSelectedExpression();
        if (iExpressionFragment == null) {
            return false;
        }
        Expression expression = iExpressionFragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: 
            case 87: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(this.checkExpressionBinding());
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.checkAllStaticFinal();
        IExpressionFragment iExpressionFragment = this.getSelectedExpression();
        Expression expression = iExpressionFragment.getAssociatedExpression();
        if (expression instanceof NullLiteral) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_null_literals));
        } else if (!ConstantChecks.isLoadTimeConstant(iExpressionFragment)) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_not_load_time_constant));
        } else if (expression instanceof SimpleName && (expression.getParent() instanceof QualifiedName && expression.getLocationInParent() == QualifiedName.NAME_PROPERTY || expression.getParent() instanceof FieldAccess && expression.getLocationInParent() == FieldAccess.NAME_PROPERTY)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_select_expression);
        }
        return refactoringStatus;
    }

    public void setConstantName(String string) {
        Assert.isNotNull((Object)string);
        this.fConstantName = string;
    }

    public String getConstantName() {
        return this.fConstantName;
    }

    public RefactoringStatus checkConstantNameOnChange() throws JavaModelException {
        if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fConstantName)) {
            return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_another_variable, this.getConstantName()));
        }
        return Checks.checkConstantName(this.getConstantName());
    }

    public String getConstantSignaturePreview() throws JavaModelException {
        String string = " ";
        return String.valueOf(this.getVisibility()) + string + MODIFIER + string + this.getConstantTypeName() + string + this.fConstantName;
    }

    public CompilationUnitChange createTextChange(IProgressMonitor iProgressMonitor) throws CoreException {
        this.createConstantDeclaration();
        this.replaceExpressionsWithConstant();
        return this.fCuRewrite.createChange(RefactoringCoreMessages.ExtractConstantRefactoring_change_name, true, iProgressMonitor);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        iProgressMonitor.beginTask(RefactoringCoreMessages.ExtractConstantRefactoring_checking_preconditions, 4);
        try {
            RefactoringStatus refactoringStatus2 = new RefactoringStatus();
            this.fChange = this.createTextChange((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            String string = this.fChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
            CompilationUnit compilationUnit = new RefactoringASTParser(3).parse(string, this.fCu, true, true, null);
            IProblem[] iProblemArray = RefactoringAnalyzeUtil.getIntroducedCompileProblems(compilationUnit, this.fCuRewrite.getRoot());
            int n = 0;
            while (n < iProblemArray.length) {
                IProblem iProblem = iProblemArray[n];
                if (iProblem.isError()) {
                    refactoringStatus2.addEntry(new RefactoringStatusEntry(iProblem.isError() ? 3 : 2, iProblem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(string, new SourceRange(iProblem))));
                }
                ++n;
            }
            this.fConstantTypeCache = null;
            this.fCuRewrite.clearASTAndImportRewrites();
            refactoringStatus = refactoringStatus2;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private void createConstantDeclaration() throws CoreException {
        ListRewrite listRewrite;
        Object object;
        Type type = this.getConstantType();
        IExpressionFragment iExpressionFragment = this.getSelectedExpression();
        String string = this.fCu.getBuffer().getText(iExpressionFragment.getStartPosition(), iExpressionFragment.getLength());
        AST aST = this.fCuRewrite.getAST();
        VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(aST.newSimpleName(this.fConstantName));
        variableDeclarationFragment.setInitializer((Expression)this.fCuRewrite.getASTRewrite().createStringPlaceholder(string, 42));
        FieldDeclaration fieldDeclaration = aST.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.setType(type);
        Modifier.ModifierKeyword modifierKeyword = Modifier.ModifierKeyword.toKeyword((String)this.fVisibility);
        if (modifierKeyword != null) {
            fieldDeclaration.modifiers().add(aST.newModifier(modifierKeyword));
        }
        fieldDeclaration.modifiers().add(aST.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        fieldDeclaration.modifiers().add(aST.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        boolean bl = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.fCu.getJavaProject()).createComments;
        if (bl && (object = CodeGeneration.getFieldComment(this.fCu, this.getConstantTypeName(), this.fConstantName, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu))) != null && ((String)object).length() > 0) {
            listRewrite = (Javadoc)this.fCuRewrite.getASTRewrite().createStringPlaceholder((String)object, 29);
            fieldDeclaration.setJavadoc((Javadoc)listRewrite);
        }
        object = this.getContainingTypeDeclarationNode();
        listRewrite = this.fCuRewrite.getASTRewrite().getListRewrite((ASTNode)object, object.getBodyDeclarationsProperty());
        TextEditGroup textEditGroup = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.ExtractConstantRefactoring_declare_constant);
        if (this.insertFirst()) {
            listRewrite.insertFirst((ASTNode)fieldDeclaration, textEditGroup);
        } else {
            listRewrite.insertAfter((ASTNode)fieldDeclaration, (ASTNode)this.getNodeToInsertConstantDeclarationAfter(), textEditGroup);
        }
        if (this.fLinkedProposalModel != null) {
            ASTRewrite aSTRewrite = this.fCuRewrite.getASTRewrite();
            LinkedProposalPositionGroup linkedProposalPositionGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
            linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getName()), true);
            String[] stringArray = this.guessConstantNames();
            if (stringArray.length > 0 && !stringArray[0].equals(this.fConstantName)) {
                linkedProposalPositionGroup.addProposal(this.fConstantName, null, stringArray.length + 1);
            }
            int n = 0;
            while (n < stringArray.length) {
                linkedProposalPositionGroup.addProposal(stringArray[n], null, stringArray.length - n);
                ++n;
            }
            LinkedProposalPositionGroup linkedProposalPositionGroup2 = this.fLinkedProposalModel.getPositionGroup(KEY_TYPE, true);
            linkedProposalPositionGroup2.addPosition(aSTRewrite.track((ASTNode)type), true);
            ITypeBinding iTypeBinding = iExpressionFragment.getAssociatedExpression().resolveTypeBinding();
            if (iTypeBinding != null) {
                ITypeBinding[] iTypeBindingArray = ASTResolving.getNarrowingTypes(aST, iTypeBinding);
                int n2 = 0;
                while (n2 < iTypeBindingArray.length) {
                    linkedProposalPositionGroup2.addProposal(iTypeBindingArray[n2], this.fCuRewrite.getCu(), iTypeBindingArray.length - n2);
                    ++n2;
                }
            }
            boolean bl2 = object.resolveBinding() != null && object.resolveBinding().isInterface();
            ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.fLinkedProposalModel, aSTRewrite, fieldDeclaration.modifiers(), bl2);
        }
    }

    private Type getConstantType() throws JavaModelException {
        if (this.fConstantTypeCache == null) {
            IExpressionFragment iExpressionFragment = this.getSelectedExpression();
            ITypeBinding iTypeBinding = iExpressionFragment.getAssociatedExpression().resolveTypeBinding();
            AST aST = this.fCuRewrite.getAST();
            iTypeBinding = Bindings.normalizeForDeclarationUse(iTypeBinding, aST);
            this.fConstantTypeCache = this.fCuRewrite.getImportRewrite().addImport(iTypeBinding, aST);
        }
        return this.fConstantTypeCache;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        IJavaProject iJavaProject = this.fCu.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        int n = 786432;
        if (JdtFlags.getVisibilityCode(this.fVisibility) != 2) {
            n |= 2;
        }
        String string2 = "";
        try {
            string2 = String.valueOf(BindingLabelProvider.getBindingLabel((IBinding)this.getContainingTypeBinding(), JavaElementLabels.ALL_FULLY_QUALIFIED)) + ".";
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        String string3 = ASTNodes.asString((ASTNode)this.fSelectedExpression.getAssociatedExpression());
        String string4 = Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_descriptor_description_short, this.fConstantName);
        String string5 = Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_descriptor_description, new String[]{String.valueOf(string2) + this.fConstantName, string3});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string5);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_constant_name_pattern, this.fConstantName));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_constant_expression_pattern, string3));
        String string6 = this.fVisibility;
        if ("".equals(string6)) {
            string6 = RefactoringCoreMessages.ExtractConstantRefactoring_default_visibility;
        }
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_visibility_pattern, string6));
        if (this.fReplaceAllOccurrences) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ExtractConstantRefactoring_replace_occurrences);
        }
        if (this.fQualifyReferencesWithDeclaringClassName) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ExtractConstantRefactoring_qualify_references);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.extract.constant", string, string4, jDTRefactoringDescriptorComment.asString(), hashMap, n);
        hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCu));
        hashMap.put(KEY_NAME, this.fConstantName);
        hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        hashMap.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllOccurrences).toString());
        hashMap.put(ATTRIBUTE_QUALIFY, Boolean.valueOf(this.fQualifyReferencesWithDeclaringClassName).toString());
        hashMap.put(ATTRIBUTE_VISIBILITY, new Integer(JdtFlags.getVisibilityCode(this.fVisibility)).toString());
        return new RefactoringDescriptorChange((RefactoringDescriptor)jDTRefactoringDescriptor, RefactoringCoreMessages.ExtractConstantRefactoring_name, new Change[]{this.fChange});
    }

    private void replaceExpressionsWithConstant() throws JavaModelException {
        ASTRewrite aSTRewrite = this.fCuRewrite.getASTRewrite();
        AST aST = aSTRewrite.getAST();
        IASTFragment[] iASTFragmentArray = this.getFragmentsToReplace();
        int n = 0;
        while (n < iASTFragmentArray.length) {
            SimpleName simpleName;
            IASTFragment iASTFragment = iASTFragmentArray[n];
            SimpleName simpleName2 = simpleName = aST.newSimpleName(this.fConstantName);
            if (this.qualifyReferencesWithDeclaringClassName()) {
                simpleName2 = aST.newQualifiedName((Name)aST.newSimpleName(this.getContainingTypeBinding().getName()), simpleName);
            }
            TextEditGroup textEditGroup = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.ExtractConstantRefactoring_replace);
            iASTFragment.replace(aSTRewrite, (ASTNode)simpleName2, textEditGroup);
            if (this.fLinkedProposalModel != null) {
                this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(aSTRewrite.track((ASTNode)simpleName), false);
            }
            ++n;
        }
    }

    private void computeConstantDeclarationLocation() throws JavaModelException {
        if (this.isDeclarationLocationComputed()) {
            return;
        }
        BodyDeclaration bodyDeclaration = null;
        Iterator iterator = this.getBodyDeclarations();
        Assert.isTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            int n;
            BodyDeclaration bodyDeclaration2 = (BodyDeclaration)iterator.next();
            if (bodyDeclaration2 instanceof FieldDeclaration) {
                n = ((FieldDeclaration)bodyDeclaration2).getModifiers();
            } else {
                if (!(bodyDeclaration2 instanceof Initializer)) continue;
                n = ((Initializer)bodyDeclaration2).getModifiers();
            }
            if (!Modifier.isStatic((int)n) || !ExtractConstantRefactoring.depends(this.getSelectedExpression(), bodyDeclaration2)) continue;
            bodyDeclaration = bodyDeclaration2;
        }
        if (bodyDeclaration == null) {
            this.fInsertFirst = true;
        } else {
            this.fToInsertAfter = bodyDeclaration;
        }
    }

    private static boolean depends(IExpressionFragment iExpressionFragment, BodyDeclaration bodyDeclaration) {
        if (bodyDeclaration instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
            Iterator iterator = fieldDeclaration.fragments().iterator();
            while (iterator.hasNext()) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
                SimpleName simpleName = variableDeclarationFragment.getName();
                if (iExpressionFragment.getSubFragmentsMatching(ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)simpleName)).length == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDeclarationLocationComputed() {
        return this.fInsertFirst || this.fToInsertAfter != null;
    }

    private boolean insertFirst() throws JavaModelException {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.fInsertFirst;
    }

    private BodyDeclaration getNodeToInsertConstantDeclarationAfter() throws JavaModelException {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.fToInsertAfter;
    }

    private Iterator getBodyDeclarations() throws JavaModelException {
        if (this.fBodyDeclarations == null) {
            this.fBodyDeclarations = this.getContainingTypeDeclarationNode().bodyDeclarations();
        }
        return this.fBodyDeclarations.iterator();
    }

    private String getConstantTypeName() throws JavaModelException {
        return ASTNodes.asString((ASTNode)this.getConstantType());
    }

    private static boolean isStaticFieldOrStaticInitializer(BodyDeclaration bodyDeclaration) {
        int n;
        if (bodyDeclaration instanceof MethodDeclaration || bodyDeclaration instanceof AbstractTypeDeclaration) {
            return false;
        }
        if (bodyDeclaration instanceof FieldDeclaration) {
            n = ((FieldDeclaration)bodyDeclaration).getModifiers();
        } else if (bodyDeclaration instanceof Initializer) {
            n = ((Initializer)bodyDeclaration).getModifiers();
        } else {
            Assert.isTrue((boolean)false);
            return false;
        }
        return Modifier.isStatic((int)n);
    }

    private Iterator getReplacementScope() throws JavaModelException {
        boolean bl = false;
        ArrayList<BodyDeclaration> arrayList = new ArrayList<BodyDeclaration>();
        Iterator iterator = this.getBodyDeclarations();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
            if (bodyDeclaration == this.getNodeToInsertConstantDeclarationAfter()) {
                bl = true;
            }
            if (!this.insertFirst() && !bl && ExtractConstantRefactoring.isStaticFieldOrStaticInitializer(bodyDeclaration)) continue;
            arrayList.add(bodyDeclaration);
        }
        return arrayList.iterator();
    }

    private IASTFragment[] getFragmentsToReplace() throws JavaModelException {
        ArrayList<IASTFragment> arrayList = new ArrayList<IASTFragment>();
        if (this.fReplaceAllOccurrences) {
            Iterator iterator = this.getReplacementScope();
            while (iterator.hasNext()) {
                BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
                IASTFragment[] iASTFragmentArray = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)bodyDeclaration).getSubFragmentsMatching(this.getSelectedExpression());
                IASTFragment[] iASTFragmentArray2 = ExtractConstantRefactoring.retainOnlyReplacableMatches(iASTFragmentArray);
                int n = 0;
                while (n < iASTFragmentArray2.length) {
                    arrayList.add(iASTFragmentArray2[n]);
                    ++n;
                }
            }
        } else if (ExtractConstantRefactoring.canReplace(this.getSelectedExpression())) {
            arrayList.add(this.getSelectedExpression());
        }
        return arrayList.toArray(new IASTFragment[arrayList.size()]);
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] iASTFragmentArray) {
        ArrayList<IASTFragment> arrayList = new ArrayList<IASTFragment>(iASTFragmentArray.length);
        int n = 0;
        while (n < iASTFragmentArray.length) {
            if (ExtractConstantRefactoring.canReplace(iASTFragmentArray[n])) {
                arrayList.add(iASTFragmentArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IASTFragment[arrayList.size()]);
    }

    private static boolean canReplace(IASTFragment iASTFragment) {
        VariableDeclarationFragment variableDeclarationFragment;
        ASTNode aSTNode = iASTFragment.getAssociatedNode();
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2 instanceof VariableDeclarationFragment && aSTNode.equals((Object)(variableDeclarationFragment = (VariableDeclarationFragment)aSTNode2).getName())) {
            return false;
        }
        if (aSTNode2 instanceof ExpressionStatement) {
            return false;
        }
        return !(aSTNode2 instanceof SwitchCase);
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment iASTFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCuRewrite.getRoot(), this.fCu);
        if (iASTFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(iASTFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)iASTFragment;
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private AbstractTypeDeclaration getContainingTypeDeclarationNode() throws JavaModelException {
        ASTNode aSTNode = this.getSelectedExpression().getAssociatedNode();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
        Assert.isNotNull((Object)abstractTypeDeclaration);
        return abstractTypeDeclaration;
    }

    private ITypeBinding getContainingTypeBinding() throws JavaModelException {
        ITypeBinding iTypeBinding = this.getContainingTypeDeclarationNode().resolveBinding();
        Assert.isNotNull((Object)iTypeBinding);
        return iTypeBinding;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object;
            Object object2;
            int n;
            int n2;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute("selection");
            if (string2 != null) {
                n2 = -1;
                n = -1;
                object2 = new StringTokenizer(string2);
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    n2 = Integer.valueOf(((StringTokenizer)object2).nextToken());
                }
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    n = Integer.valueOf(((StringTokenizer)object2).nextToken());
                }
                if (n2 < 0 || n < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string2, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = n2;
            this.fSelectionLength = n;
            String string3 = javaRefactoringArguments.getAttribute("input");
            if (string3 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string3, false);
                if (object == null || !object.exists() || object.getElementType() != 5) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.extract.constant");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (ICompilationUnit)object;
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_VISIBILITY);
            if (object != null && !"".equals(object)) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = JdtFlags.getVisibilityString(n3);
            }
            if ((object2 = javaRefactoringArguments.getAttribute(KEY_NAME)) == null || "".equals(object2)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, KEY_NAME));
            }
            this.fConstantName = object2;
            String string4 = javaRefactoringArguments.getAttribute(ATTRIBUTE_REPLACE);
            if (string4 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
            }
            this.fReplaceAllOccurrences = Boolean.valueOf(string4);
            string = javaRefactoringArguments.getAttribute(ATTRIBUTE_QUALIFY);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFY));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fQualifyReferencesWithDeclaringClassName = Boolean.valueOf(string);
        return new RefactoringStatus();
    }
}

