/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ConstantChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class InlineConstantRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_REMOVE = "remove";
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fSelectionCu;
    private CompilationUnitRewrite fSelectionCuRewrite;
    private Name fSelectedConstantName;
    private IField fField;
    private CompilationUnitRewrite fDeclarationCuRewrite;
    private VariableDeclarationFragment fDeclaration;
    private boolean fDeclarationSelected;
    private boolean fDeclarationSelectedChecked = false;
    private boolean fInitializerAllStaticFinal;
    private boolean fInitializerChecked = false;
    private boolean fRemoveDeclaration = false;
    private boolean fReplaceAllReferences = true;
    private CompilationUnitChange[] fChanges;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static SimpleName getLeftmost(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        return InlineConstantRefactoring.getLeftmost(((QualifiedName)name).getQualifier());
    }

    public InlineConstantRefactoring(IField iField) {
        Assert.isNotNull((Object)iField);
        Assert.isTrue((!iField.isBinary() ? 1 : 0) != 0);
        this.fField = iField;
    }

    public InlineConstantRefactoring(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fSelectionCu = iCompilationUnit;
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        if (iCompilationUnit != null) {
            this.initialize(iCompilationUnit, compilationUnit);
        }
    }

    private void initialize(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit) {
        this.fSelectionCuRewrite = new CompilationUnitRewrite(iCompilationUnit, compilationUnit);
        this.fSelectedConstantName = this.findConstantNameNode();
    }

    private Name findConstantNameNode() {
        ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fSelectionCuRewrite.getRoot(), this.fSelectionStart, this.fSelectionLength);
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode instanceof FieldAccess) {
            aSTNode = ((FieldAccess)aSTNode).getName();
        }
        if (aSTNode.getParent() instanceof EnumConstantDeclaration) {
            return null;
        }
        if (!(aSTNode instanceof Name)) {
            return null;
        }
        Name name = (Name)aSTNode;
        IBinding iBinding = name.resolveBinding();
        if (!(iBinding instanceof IVariableBinding)) {
            return null;
        }
        IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
        if (!iVariableBinding.isField() || iVariableBinding.isEnumConstant()) {
            return null;
        }
        int n = iBinding.getModifiers();
        if (!Modifier.isStatic((int)n) || !Modifier.isFinal((int)n)) {
            return null;
        }
        return name;
    }

    public RefactoringStatus checkStaticFinalConstantNameSelected() {
        if (this.fSelectedConstantName == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_static_final_field, null, (String)Corext.getPluginId(), (int)128, null);
        }
        return new RefactoringStatus();
    }

    public String getName() {
        return RefactoringCoreMessages.InlineConstantRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            RefactoringStatus refactoringStatus2;
                            try {
                                iProgressMonitor.beginTask("", 3);
                                if (this.fSelectionCu.isStructureKnown()) break block7;
                                refactoringStatus2 = RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_syntax_errors, null, (String)Corext.getPluginId(), (int)129, null);
                                Object var3_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var3_14 = null;
                                iProgressMonitor.done();
                                throw throwable;
                            }
                            iProgressMonitor.done();
                            return refactoringStatus2;
                        }
                        refactoringStatus = this.checkStaticFinalConstantNameSelected();
                        if (!refactoringStatus.hasFatalError()) break block8;
                        RefactoringStatus refactoringStatus3 = refactoringStatus;
                        Object var3_9 = null;
                        iProgressMonitor.done();
                        return refactoringStatus3;
                    }
                    refactoringStatus.merge(this.findField());
                    if (!refactoringStatus.hasFatalError()) break block9;
                    RefactoringStatus refactoringStatus4 = refactoringStatus;
                    Object var3_10 = null;
                    iProgressMonitor.done();
                    return refactoringStatus4;
                }
                iProgressMonitor.worked(1);
                refactoringStatus.merge(this.findDeclaration());
                if (!refactoringStatus.hasFatalError()) break block10;
                RefactoringStatus refactoringStatus5 = refactoringStatus;
                Object var3_11 = null;
                iProgressMonitor.done();
                return refactoringStatus5;
            }
            iProgressMonitor.worked(1);
            refactoringStatus.merge(this.checkInitializer());
            if (!refactoringStatus.hasFatalError()) break block11;
            RefactoringStatus refactoringStatus6 = refactoringStatus;
            Object var3_12 = null;
            iProgressMonitor.done();
            return refactoringStatus6;
        }
        iProgressMonitor.worked(1);
        RefactoringStatus refactoringStatus7 = refactoringStatus;
        Object var3_13 = null;
        iProgressMonitor.done();
        return refactoringStatus7;
    }

    private RefactoringStatus findField() throws JavaModelException {
        this.fField = (IField)((IVariableBinding)this.fSelectedConstantName.resolveBinding()).getJavaElement();
        if (this.fField != null && !this.fField.exists()) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_local_anonymous_unsupported, null, (String)Corext.getPluginId(), (int)132, null);
        }
        return null;
    }

    private RefactoringStatus findDeclaration() throws JavaModelException {
        VariableDeclarationFragment variableDeclarationFragment;
        this.fDeclarationSelectedChecked = true;
        this.fDeclarationSelected = false;
        ASTNode aSTNode = this.fSelectedConstantName.getParent();
        if (aSTNode instanceof VariableDeclarationFragment && (variableDeclarationFragment = (VariableDeclarationFragment)aSTNode).getName() == this.fSelectedConstantName) {
            this.fDeclarationSelected = true;
            this.fDeclarationCuRewrite = this.fSelectionCuRewrite;
            this.fDeclaration = (VariableDeclarationFragment)this.fSelectedConstantName.getParent();
            return null;
        }
        variableDeclarationFragment = (VariableDeclarationFragment)this.fSelectionCuRewrite.getRoot().findDeclaringNode(this.fSelectedConstantName.resolveBinding());
        if (variableDeclarationFragment != null) {
            this.fDeclarationCuRewrite = this.fSelectionCuRewrite;
            this.fDeclaration = variableDeclarationFragment;
            return null;
        }
        if (this.fField.getCompilationUnit() == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_binary_file, null, (String)Corext.getPluginId(), (int)130, null);
        }
        this.fDeclarationCuRewrite = new CompilationUnitRewrite(this.fField.getCompilationUnit());
        this.fDeclaration = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(this.fField, this.fDeclarationCuRewrite.getRoot());
        return null;
    }

    private RefactoringStatus checkInitializer() {
        Expression expression = this.getInitializer();
        if (expression == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_blank_finals, null, (String)Corext.getPluginId(), (int)131, null);
        }
        this.fInitializerAllStaticFinal = ConstantChecks.isStaticFinalConstant((IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression));
        this.fInitializerChecked = true;
        return new RefactoringStatus();
    }

    private VariableDeclarationFragment getDeclaration() throws JavaModelException {
        return this.fDeclaration;
    }

    private Expression getInitializer() {
        return this.fDeclaration.getInitializer();
    }

    private ICompilationUnit getDeclaringCompilationUnit() throws JavaModelException {
        return this.fField.getCompilationUnit();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        Object object;
        HashSet hashSet;
        ArrayList<Object> arrayList;
        RefactoringStatus refactoringStatus2;
        block11: {
            Object object2;
            refactoringStatus2 = new RefactoringStatus();
            iProgressMonitor.beginTask("", 3);
            arrayList = new ArrayList<Object>();
            hashSet = new HashSet();
            ImportReferencesCollector importReferencesCollector = new ImportReferencesCollector(this.fField.getJavaProject(), null, new ArrayList(), hashSet);
            this.getInitializer().accept((ASTVisitor)importReferencesCollector);
            if (this.getReplaceAllReferences()) {
                object2 = this.findReferences(iProgressMonitor, refactoringStatus2);
                int n = 0;
                while (n < ((SearchResultGroup[])object2).length) {
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    object = object2[n];
                    ICompilationUnit iCompilationUnit = object.getCompilationUnit();
                    CompilationUnitRewrite compilationUnitRewrite = this.getCuRewrite(iCompilationUnit);
                    Name[] nameArray = this.extractReferenceNodes(object.getSearchResults(), compilationUnitRewrite.getRoot());
                    InlineTargetCompilationUnit inlineTargetCompilationUnit = new InlineTargetCompilationUnit(compilationUnitRewrite, nameArray, this, hashSet);
                    arrayList.add((Object)inlineTargetCompilationUnit.getChange());
                    ++n;
                }
            } else {
                Assert.isTrue((!this.isDeclarationSelected() ? 1 : 0) != 0);
                object2 = new InlineTargetCompilationUnit(this.fSelectionCuRewrite, new Name[]{this.fSelectedConstantName}, this, hashSet);
                arrayList.add((Object)((InlineTargetCompilationUnit)object2).getChange());
            }
            if (!refactoringStatus2.hasFatalError()) break block11;
            RefactoringStatus refactoringStatus3 = refactoringStatus2;
            Object var13_19 = null;
            this.fSelectionCuRewrite = null;
            this.fSelectedConstantName = null;
            this.fDeclarationCuRewrite = null;
            this.fDeclaration = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        try {
            if (this.getRemoveDeclaration() && this.getReplaceAllReferences()) {
                boolean bl = false;
                Object object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object = (CompilationUnitChange)((Object)object3.next());
                    if (!((CompilationUnitChange)((Object)object)).getCompilationUnit().equals(this.fDeclarationCuRewrite.getCu())) continue;
                    bl = true;
                    break;
                }
                if (!bl && (object = ((InlineTargetCompilationUnit)(object3 = new InlineTargetCompilationUnit(this.fDeclarationCuRewrite, new Name[0], this, hashSet))).getChange()) != null) {
                    arrayList.add(object);
                }
            }
            ICompilationUnit[] iCompilationUnitArray = new ICompilationUnit[arrayList.size()];
            int n = 0;
            while (n < arrayList.size()) {
                object = (CompilationUnitChange)((Object)arrayList.get(n));
                iCompilationUnitArray[n] = ((CompilationUnitChange)((Object)object)).getCompilationUnit();
                ++n;
            }
            refactoringStatus2.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(iCompilationUnitArray), this.getValidationContext()));
            iProgressMonitor.worked(1);
            this.fChanges = arrayList.toArray(new CompilationUnitChange[arrayList.size()]);
            refactoringStatus = refactoringStatus2;
            Object var13_20 = null;
            this.fSelectionCuRewrite = null;
            this.fSelectedConstantName = null;
            this.fDeclarationCuRewrite = null;
            this.fDeclaration = null;
        }
        catch (Throwable throwable) {
            Object var13_21 = null;
            this.fSelectionCuRewrite = null;
            this.fSelectedConstantName = null;
            this.fDeclarationCuRewrite = null;
            this.fDeclaration = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private Name[] extractReferenceNodes(SearchMatch[] searchMatchArray, CompilationUnit compilationUnit) {
        Name[] nameArray = new Name[searchMatchArray.length];
        int n = 0;
        while (n < searchMatchArray.length) {
            nameArray[n] = (Name)NodeFinder.perform((ASTNode)compilationUnit, searchMatchArray[n].getOffset(), searchMatchArray[n].getLength());
            ++n;
        }
        return nameArray;
    }

    private CompilationUnitRewrite getCuRewrite(ICompilationUnit iCompilationUnit) {
        CompilationUnitRewrite compilationUnitRewrite = iCompilationUnit.equals(this.fSelectionCu) ? this.fSelectionCuRewrite : (iCompilationUnit.equals(this.fField.getCompilationUnit()) ? this.fDeclarationCuRewrite : new CompilationUnitRewrite(iCompilationUnit));
        return compilationUnitRewrite;
    }

    private SearchResultGroup[] findReferences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fField, (int)2));
        refactoringSearchEngine2.setFiltering(true, true);
        refactoringSearchEngine2.setScope(RefactoringScopeFactory.create((IJavaElement)this.fField));
        refactoringSearchEngine2.setStatus(refactoringStatus);
        refactoringSearchEngine2.setRequestor(new IRefactoringSearchRequestor(){

            public SearchMatch acceptSearchMatch(SearchMatch searchMatch) {
                return searchMatch.isInsideDocComment() ? null : searchMatch;
            }
        });
        refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        return (SearchResultGroup[])refactoringSearchEngine2.getResults();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.InlineConstantRefactoring_preview, 2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = null;
            IJavaProject iJavaProject = this.fSelectionCu.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            int n = 786434;
            try {
                if (!Flags.isPrivate((int)this.fField.getFlags())) {
                    n |= 4;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            String string2 = Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_descriptor_description_short, this.fField.getElementName());
            String string3 = Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel(this.fField.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_original_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            if (this.fRemoveDeclaration) {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.InlineConstantRefactoring_remove_declaration);
            }
            if (this.fReplaceAllReferences) {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.InlineConstantRefactoring_replace_references);
            }
            JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.inline.constant", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, n);
            hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fSelectionCu));
            hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
            hashMap.put(ATTRIBUTE_REMOVE, Boolean.valueOf(this.fRemoveDeclaration).toString());
            hashMap.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllReferences).toString());
            dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.InlineConstantRefactoring_inline, (Change[])this.fChanges);
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            iProgressMonitor.done();
            this.fChanges = null;
            throw throwable;
        }
        iProgressMonitor.done();
        this.fChanges = null;
        return dynamicValidationRefactoringChange;
    }

    private void checkInvariant() {
        if (this.isDeclarationSelected()) {
            Assert.isTrue((boolean)this.fReplaceAllReferences);
        }
    }

    public boolean getRemoveDeclaration() {
        return this.fRemoveDeclaration;
    }

    public boolean getReplaceAllReferences() {
        this.checkInvariant();
        return this.fReplaceAllReferences;
    }

    public boolean isDeclarationSelected() {
        Assert.isTrue((boolean)this.fDeclarationSelectedChecked);
        return this.fDeclarationSelected;
    }

    public boolean isInitializerAllStaticFinal() {
        Assert.isTrue((boolean)this.fInitializerChecked);
        return this.fInitializerAllStaticFinal;
    }

    public void setRemoveDeclaration(boolean bl) {
        this.fRemoveDeclaration = bl;
    }

    public void setReplaceAllReferences(boolean bl) {
        this.fReplaceAllReferences = bl;
        this.checkInvariant();
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        Object object;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object2;
            String string;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute("selection");
            if (string2 != null) {
                int n = -1;
                int n2 = -1;
                object = new StringTokenizer(string2);
                if (((StringTokenizer)object).hasMoreTokens()) {
                    n = Integer.valueOf(((StringTokenizer)object).nextToken());
                }
                if (((StringTokenizer)object).hasMoreTokens()) {
                    n2 = Integer.valueOf(((StringTokenizer)object).nextToken());
                }
                if (n >= 0 && n2 >= 0) {
                    this.fSelectionStart = n;
                    this.fSelectionLength = n2;
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string2, "selection"}));
                }
            }
            if ((string = javaRefactoringArguments.getAttribute("input")) != null) {
                ISourceRange iSourceRange;
                object2 = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                if (object2 == null || !object2.exists()) {
                    return this.createInputFatalStatus(object2, "org.eclipse.wst.jsdt.ui.inline.constant");
                }
                if (object2 instanceof ICompilationUnit) {
                    this.fSelectionCu = (ICompilationUnit)object2;
                    if (string2 == null) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
                    }
                } else if (object2 instanceof IField) {
                    object = (IField)object2;
                    try {
                        iSourceRange = object.getNameRange();
                        if (iSourceRange == null) {
                            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "org.eclipse.wst.jsdt.ui.inline.constant"));
                        }
                        this.fSelectionStart = iSourceRange.getOffset();
                        this.fSelectionLength = iSourceRange.getLength();
                    }
                    catch (JavaModelException javaModelException) {
                        return this.createInputFatalStatus(object2, "org.eclipse.wst.jsdt.ui.inline.constant");
                    }
                    this.fSelectionCu = object.getCompilationUnit();
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string, "input"}));
                }
                object = ASTParser.newParser((int)3);
                object.setResolveBindings(true);
                object.setSource(this.fSelectionCu);
                iSourceRange = (CompilationUnit)object.createAST(null);
                this.initialize(this.fSelectionCu, (CompilationUnit)iSourceRange);
                if (this.checkStaticFinalConstantNameSelected().hasFatalError()) {
                    return this.createInputFatalStatus(object2, "org.eclipse.wst.jsdt.ui.inline.constant");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            object2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_REPLACE);
            if (object2 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
            }
            this.fReplaceAllReferences = Boolean.valueOf((String)object2);
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_REMOVE);
            if (object == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REMOVE));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fRemoveDeclaration = Boolean.valueOf((String)object);
        return new RefactoringStatus();
    }

    private static class InlineTargetCompilationUnit {
        private final Expression fInitializer;
        private final ICompilationUnit fInitializerUnit;
        private final VariableDeclarationFragment fOriginalDeclaration;
        private final Expression[] fReferences;
        private final VariableDeclarationFragment fDeclarationToRemove;
        private final CompilationUnitRewrite fCuRewrite;
        private final TightSourceRangeComputer fSourceRangeComputer;
        private final HashSet fStaticImportsInInitializer;
        private final boolean fIs15;

        private InlineTargetCompilationUnit(CompilationUnitRewrite compilationUnitRewrite, Name[] nameArray, InlineConstantRefactoring inlineConstantRefactoring, HashSet hashSet) throws JavaModelException {
            this.fInitializer = inlineConstantRefactoring.getInitializer();
            this.fInitializerUnit = inlineConstantRefactoring.getDeclaringCompilationUnit();
            this.fCuRewrite = compilationUnitRewrite;
            this.fSourceRangeComputer = new TightSourceRangeComputer();
            this.fCuRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)this.fSourceRangeComputer);
            this.fDeclarationToRemove = inlineConstantRefactoring.getRemoveDeclaration() && inlineConstantRefactoring.getReplaceAllReferences() && compilationUnitRewrite.getCu().equals(this.fInitializerUnit) ? inlineConstantRefactoring.getDeclaration() : null;
            this.fOriginalDeclaration = inlineConstantRefactoring.getDeclaration();
            this.fReferences = new Expression[nameArray.length];
            int n = 0;
            while (n < nameArray.length) {
                this.fReferences[n] = InlineTargetCompilationUnit.getQualifiedReference(nameArray[n]);
                ++n;
            }
            this.fIs15 = JavaModelUtil.is50OrHigher(compilationUnitRewrite.getCu().getJavaProject());
            this.fStaticImportsInInitializer = this.fIs15 ? hashSet : new HashSet(0);
        }

        private static Expression getQualifiedReference(Name name) {
            if (InlineTargetCompilationUnit.doesParentQualify(name)) {
                return (Expression)name.getParent();
            }
            return name;
        }

        private static boolean doesParentQualify(Name name) {
            ASTNode aSTNode = name.getParent();
            Assert.isNotNull((Object)aSTNode);
            if (aSTNode instanceof FieldAccess && ((FieldAccess)aSTNode).getName() == name) {
                return true;
            }
            if (aSTNode instanceof QualifiedName && ((QualifiedName)aSTNode).getName() == name) {
                return true;
            }
            return aSTNode instanceof MethodInvocation && ((MethodInvocation)aSTNode).getName() == name;
        }

        public CompilationUnitChange getChange() throws CoreException {
            int n = 0;
            while (n < this.fReferences.length) {
                this.inlineReference(this.fReferences[n]);
                ++n;
            }
            this.removeConstantDeclarationIfNecessary();
            return this.fCuRewrite.createChange();
        }

        private void inlineReference(Expression expression) throws CoreException {
            ArrayCreation arrayCreation;
            ASTNode aSTNode;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.ImportDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((aSTNode = ASTNodes.getParent((ASTNode)expression, clazz)) != null) {
                return;
            }
            String string = this.prepareInitializerForLocation(expression);
            if (string == null) {
                return;
            }
            TextEditGroup textEditGroup = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.InlineConstantRefactoring_Inline);
            Expression expression2 = (Expression)this.fCuRewrite.getASTRewrite().createStringPlaceholder(string, expression.getNodeType());
            if (this.fInitializer instanceof ArrayInitializer) {
                arrayCreation = this.fCuRewrite.getAST().newArrayCreation();
                ArrayType arrayType = (ArrayType)ASTNodeFactory.newType(this.fCuRewrite.getAST(), (VariableDeclaration)this.fOriginalDeclaration);
                arrayCreation.setType(arrayType);
                ArrayInitializer arrayInitializer = (ArrayInitializer)this.fCuRewrite.getASTRewrite().createStringPlaceholder(string, 4);
                arrayCreation.setInitializer(arrayInitializer);
                expression2 = arrayCreation;
                ITypeBinding iTypeBinding = ASTNodes.getType((VariableDeclaration)this.fOriginalDeclaration).resolveBinding();
                this.fCuRewrite.getImportRewrite().addImport(iTypeBinding);
                this.fCuRewrite.getImportRemover().registerAddedImport(iTypeBinding.getName());
            }
            if (InlineTargetCompilationUnit.shouldParenthesizeSubstitute(this.fInitializer, expression)) {
                arrayCreation = this.fCuRewrite.getAST().newParenthesizedExpression();
                arrayCreation.setExpression(expression2);
                expression2 = arrayCreation;
            }
            this.fCuRewrite.getASTRewrite().replace((ASTNode)expression, (ASTNode)expression2, textEditGroup);
            this.fSourceRangeComputer.addTightSourceNode((ASTNode)expression);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }

        private String prepareInitializerForLocation(Expression expression) throws CoreException {
            HashSet hashSet = new HashSet();
            IJavaProject iJavaProject = this.fCuRewrite.getCu().getJavaProject();
            if (this.fIs15) {
                expression.accept((ASTVisitor)new ImportReferencesCollector(iJavaProject, null, new ArrayList(), hashSet));
            }
            InitializerTraversal initializerTraversal = new InitializerTraversal(this.fInitializer, this.fStaticImportsInInitializer, expression, hashSet, this.fCuRewrite);
            ASTRewrite aSTRewrite = initializerTraversal.getInitializerRewrite();
            Document document = new Document(this.fInitializerUnit.getBuffer().getContents());
            RangeMarker rangeMarker = new RangeMarker(this.fInitializer.getStartPosition(), this.fInitializer.getLength());
            TextEdit[] textEditArray = aSTRewrite.rewriteAST((IDocument)document, this.fInitializerUnit.getJavaProject().getOptions(true)).removeChildren();
            rangeMarker.addChildren(textEditArray);
            try {
                rangeMarker.apply((IDocument)document, 2);
                String string = document.get(rangeMarker.getOffset(), rangeMarker.getLength());
                IRegion iRegion = document.getLineInformation(document.getLineOfOffset(rangeMarker.getOffset()));
                int n = Strings.computeIndentUnits(document.get(iRegion.getOffset(), iRegion.getLength()), iJavaProject);
                return Strings.changeIndent(string, n, iJavaProject, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
            }
            catch (MalformedTreeException malformedTreeException) {
                JavaPlugin.log(malformedTreeException);
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
            return this.fInitializerUnit.getBuffer().getText(this.fInitializer.getStartPosition(), this.fInitializer.getLength());
        }

        private static boolean shouldParenthesizeSubstitute(Expression expression, Expression expression2) {
            if (expression instanceof Assignment) {
                return true;
            }
            return ASTNodes.substituteMustBeParenthesized(expression, expression2);
        }

        private void removeConstantDeclarationIfNecessary() throws CoreException {
            if (this.fDeclarationToRemove == null) {
                return;
            }
            FieldDeclaration fieldDeclaration = (FieldDeclaration)this.fDeclarationToRemove.getParent();
            Object object = fieldDeclaration.fragments().size() == 1 ? fieldDeclaration : this.fDeclarationToRemove;
            TextEditGroup textEditGroup = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.InlineConstantRefactoring_remove_declaration);
            this.fCuRewrite.getASTRewrite().remove((ASTNode)object, textEditGroup);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)object);
        }

        private static class InitializerTraversal
        extends HierarchicalASTVisitor {
            private final Expression fInitializer;
            private ASTRewrite fInitializerRewrite;
            private final HashSet fStaticImportsInInitializer2;
            private Set fNamesDeclaredLocallyAtNewLocation;
            private final Expression fNewLocation;
            private final HashSet fStaticImportsInReference;
            private final CompilationUnitRewrite fNewLocationCuRewrite;

            private static boolean areInSameType(ASTNode aSTNode, ASTNode aSTNode2) {
                ASTNode aSTNode3 = InitializerTraversal.getContainingTypeDeclaration(aSTNode);
                ASTNode aSTNode4 = InitializerTraversal.getContainingTypeDeclaration(aSTNode2);
                if (aSTNode3 == null || aSTNode4 == null) {
                    return false;
                }
                ITypeBinding iTypeBinding = InitializerTraversal.getTypeBindingForTypeDeclaration(aSTNode3);
                ITypeBinding iTypeBinding2 = InitializerTraversal.getTypeBindingForTypeDeclaration(aSTNode4);
                Assert.isNotNull((Object)iTypeBinding);
                Assert.isNotNull((Object)iTypeBinding2);
                String string = iTypeBinding.getKey();
                String string2 = iTypeBinding2.getKey();
                if (string == null || string2 == null) {
                    return false;
                }
                return string.equals(string2);
            }

            private static boolean isStaticAccess(SimpleName simpleName) {
                IBinding iBinding = simpleName.resolveBinding();
                Assert.isTrue((iBinding instanceof IVariableBinding || iBinding instanceof IMethodBinding || iBinding instanceof ITypeBinding ? 1 : 0) != 0);
                if (iBinding instanceof ITypeBinding) {
                    return true;
                }
                if (iBinding instanceof IVariableBinding) {
                    return ((IVariableBinding)iBinding).isField();
                }
                int n = iBinding.getModifiers();
                return Modifier.isStatic((int)n);
            }

            private static ASTNode getContainingTypeDeclaration(ASTNode aSTNode) {
                while (aSTNode != null && !(aSTNode instanceof AbstractTypeDeclaration) && !(aSTNode instanceof AnonymousClassDeclaration)) {
                    aSTNode = aSTNode.getParent();
                }
                return aSTNode;
            }

            private static ITypeBinding getTypeBindingForTypeDeclaration(ASTNode aSTNode) {
                if (aSTNode instanceof AnonymousClassDeclaration) {
                    return ((AnonymousClassDeclaration)aSTNode).resolveBinding();
                }
                if (aSTNode instanceof AbstractTypeDeclaration) {
                    return ((AbstractTypeDeclaration)aSTNode).resolveBinding();
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            public InitializerTraversal(Expression expression, HashSet hashSet, Expression expression2, HashSet hashSet2, CompilationUnitRewrite compilationUnitRewrite) {
                this.fInitializer = expression;
                this.fInitializerRewrite = ASTRewrite.create((AST)expression.getAST());
                this.fStaticImportsInInitializer2 = hashSet;
                this.fNewLocation = expression2;
                this.fStaticImportsInReference = hashSet2;
                this.fNewLocationCuRewrite = compilationUnitRewrite;
                this.perform(expression);
            }

            private Set getLocallyDeclaredNames(BodyDeclaration bodyDeclaration) {
                Assert.isTrue((!(bodyDeclaration instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
                HashSet hashSet = new HashSet();
                if (bodyDeclaration instanceof FieldDeclaration) {
                    return hashSet;
                }
                bodyDeclaration.accept((ASTVisitor)new HierarchicalASTVisitor(this, hashSet){
                    final /* synthetic */ InitializerTraversal this$2;
                    private final /* synthetic */ Set val$result;
                    {
                        this.this$2 = initializerTraversal;
                        this.val$result = set;
                    }

                    public boolean visit(AbstractTypeDeclaration abstractTypeDeclaration) {
                        Assert.isTrue((boolean)(abstractTypeDeclaration.getParent() instanceof TypeDeclarationStatement));
                        this.val$result.add(abstractTypeDeclaration.getName().getIdentifier());
                        return false;
                    }

                    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                        return false;
                    }

                    public boolean visit(VariableDeclaration variableDeclaration) {
                        this.val$result.add(variableDeclaration.getName().getIdentifier());
                        return false;
                    }
                });
                return hashSet;
            }

            public ASTRewrite getInitializerRewrite() {
                return this.fInitializerRewrite;
            }

            private void perform(Expression expression) {
                expression.accept((ASTVisitor)this);
                if (expression instanceof MethodInvocation || expression instanceof SuperMethodInvocation) {
                    this.addExplicitTypeArgumentsIfNecessary(expression);
                }
            }

            private void addExplicitTypeArgumentsIfNecessary(Expression expression) {
                ASTNode aSTNode;
                if (Invocations.isResolvedTypeInferredFromExpectedType(expression) && !((aSTNode = this.fNewLocation.getParent()) instanceof VariableDeclarationFragment) && !(aSTNode instanceof SingleVariableDeclaration) && !(aSTNode instanceof Assignment)) {
                    IMethodBinding iMethodBinding = Invocations.resolveBinding((ASTNode)expression);
                    ITypeBinding[] iTypeBindingArray = iMethodBinding.getTypeArguments();
                    ListRewrite listRewrite = this.fInitializerRewrite.getListRewrite((ASTNode)expression, Invocations.getTypeArgumentsProperty(expression));
                    int n = 0;
                    while (n < iTypeBindingArray.length) {
                        Type type = this.fNewLocationCuRewrite.getImportRewrite().addImport(iTypeBindingArray[n], this.fNewLocationCuRewrite.getAST());
                        this.fNewLocationCuRewrite.getImportRemover().registerAddedImports(type);
                        listRewrite.insertLast((ASTNode)type, null);
                        ++n;
                    }
                }
            }

            public boolean visit(FieldAccess fieldAccess) {
                fieldAccess.getExpression().accept((ASTVisitor)this);
                return false;
            }

            public boolean visit(MethodInvocation methodInvocation) {
                if (methodInvocation.getExpression() == null) {
                    this.qualifyUnqualifiedMemberNameIfNecessary(methodInvocation.getName());
                } else {
                    methodInvocation.getExpression().accept((ASTVisitor)this);
                }
                Iterator iterator = methodInvocation.arguments().iterator();
                while (iterator.hasNext()) {
                    ((Expression)iterator.next()).accept((ASTVisitor)this);
                }
                return false;
            }

            public boolean visit(Name name) {
                SimpleName simpleName = InlineConstantRefactoring.getLeftmost(name);
                IBinding iBinding = simpleName.resolveBinding();
                if (iBinding instanceof IVariableBinding || iBinding instanceof IMethodBinding || iBinding instanceof ITypeBinding) {
                    if (this.shouldUnqualify(simpleName)) {
                        this.unqualifyMemberName(simpleName);
                    } else {
                        this.qualifyUnqualifiedMemberNameIfNecessary(simpleName);
                    }
                }
                if (iBinding instanceof ITypeBinding) {
                    String string = this.fNewLocationCuRewrite.getImportRewrite().addImport((ITypeBinding)iBinding);
                    this.fNewLocationCuRewrite.getImportRemover().registerAddedImport(string);
                }
                return false;
            }

            private void qualifyUnqualifiedMemberNameIfNecessary(SimpleName simpleName) {
                if (this.shouldQualify(simpleName)) {
                    this.qualifyMemberName(simpleName);
                }
            }

            private boolean shouldUnqualify(SimpleName simpleName) {
                if (InitializerTraversal.areInSameType((ASTNode)simpleName, (ASTNode)this.fNewLocation)) {
                    return !this.mayBeShadowedByLocalDeclaration(simpleName);
                }
                return false;
            }

            private void unqualifyMemberName(SimpleName simpleName) {
                if (InlineTargetCompilationUnit.doesParentQualify((Name)simpleName)) {
                    this.fInitializerRewrite.replace(simpleName.getParent(), (ASTNode)simpleName, null);
                }
            }

            private boolean shouldQualify(SimpleName simpleName) {
                if (!InitializerTraversal.areInSameType((ASTNode)this.fInitializer, (ASTNode)this.fNewLocation)) {
                    return true;
                }
                return this.mayBeShadowedByLocalDeclaration(simpleName);
            }

            private boolean mayBeShadowedByLocalDeclaration(SimpleName simpleName) {
                return this.getNamesDeclaredLocallyAtNewLocation().contains(simpleName.getIdentifier());
            }

            private Set getNamesDeclaredLocallyAtNewLocation() {
                BodyDeclaration bodyDeclaration;
                if (this.fNamesDeclaredLocallyAtNewLocation != null) {
                    return this.fNamesDeclaredLocallyAtNewLocation;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Assert.isTrue((!((bodyDeclaration = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.fNewLocation, clazz)) instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
                this.fNamesDeclaredLocallyAtNewLocation = this.getLocallyDeclaredNames(bodyDeclaration);
                return this.fNamesDeclaredLocallyAtNewLocation;
            }

            private void qualifyMemberName(SimpleName simpleName) {
                if (InitializerTraversal.isStaticAccess(simpleName)) {
                    IBinding iBinding = simpleName.resolveBinding();
                    if (iBinding instanceof IVariableBinding || iBinding instanceof IMethodBinding) {
                        if (this.fStaticImportsInReference.contains(this.fNewLocation)) {
                            this.importStatically(simpleName, iBinding);
                            return;
                        }
                        if (this.fStaticImportsInInitializer2.contains(simpleName)) {
                            this.importStatically(simpleName, iBinding);
                            return;
                        }
                    }
                    this.qualifyToTopLevelClass(simpleName);
                }
            }

            private void importStatically(SimpleName simpleName, IBinding iBinding) {
                String string = this.fNewLocationCuRewrite.getImportRewrite().addStaticImport(iBinding);
                this.fNewLocationCuRewrite.getImportRemover().registerAddedStaticImport(iBinding);
                Name name = ASTNodeFactory.newName(this.fInitializerRewrite.getAST(), string);
                this.fInitializerRewrite.replace((ASTNode)simpleName, (ASTNode)name, null);
            }

            private void qualifyToTopLevelClass(SimpleName simpleName) {
                ITypeBinding iTypeBinding = InitializerTraversal.getDeclaringClassBinding(simpleName);
                if (iTypeBinding == null) {
                    return;
                }
                Type type = this.fNewLocationCuRewrite.getImportRewrite().addImport(iTypeBinding, this.fInitializerRewrite.getAST());
                this.fNewLocationCuRewrite.getImportRemover().registerAddedImports(type);
                SimpleName simpleName2 = (SimpleName)this.fInitializerRewrite.createMoveTarget((ASTNode)simpleName);
                QualifiedType qualifiedType = this.fInitializerRewrite.getAST().newQualifiedType(type, simpleName2);
                this.fInitializerRewrite.replace((ASTNode)simpleName, (ASTNode)qualifiedType, null);
            }

            private static ITypeBinding getDeclaringClassBinding(SimpleName simpleName) {
                IBinding iBinding = simpleName.resolveBinding();
                if (iBinding instanceof IMethodBinding) {
                    return ((IMethodBinding)iBinding).getDeclaringClass();
                }
                if (iBinding instanceof IVariableBinding) {
                    return ((IVariableBinding)iBinding).getDeclaringClass();
                }
                if (iBinding instanceof ITypeBinding) {
                    return ((ITypeBinding)iBinding).getDeclaringClass();
                }
                Assert.isTrue((boolean)false);
                return null;
            }
        }
    }
}

