/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class IntroduceParameterRefactoring
extends ScriptableRefactoring
implements IDelegateUpdating {
    private static final String ATTRIBUTE_ARGUMENT = "argument";
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private ICompilationUnit fSourceCU;
    private int fSelectionStart;
    private int fSelectionLength;
    private IMethod fMethod;
    private ChangeSignatureRefactoring fChangeSignatureRefactoring;
    private ParameterInfo fParameter;
    private String fParameterName;
    private RefactoringArguments fArguments;
    private Expression fSelectedExpression;
    private String[] fExcludedParameterNames;
    static /* synthetic */ Class class$0;

    public IntroduceParameterRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fSourceCU = iCompilationUnit;
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
    }

    public boolean canEnableDelegateUpdating() {
        return true;
    }

    public boolean getDelegateUpdating() {
        return this.fChangeSignatureRefactoring != null ? this.fChangeSignatureRefactoring.getDelegateUpdating() : false;
    }

    public void setDelegateUpdating(boolean bl) {
        if (this.fChangeSignatureRefactoring != null) {
            this.fChangeSignatureRefactoring.setDelegateUpdating(bl);
        }
    }

    public void setDeprecateDelegates(boolean bl) {
        if (this.fChangeSignatureRefactoring != null) {
            this.fChangeSignatureRefactoring.setDeprecateDelegates(bl);
        }
    }

    public boolean getDeprecateDelegates() {
        return this.fChangeSignatureRefactoring != null ? this.fChangeSignatureRefactoring.getDeprecateDelegates() : false;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceParameterRefactoring_name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block23: {
            RefactoringStatus refactoringStatus2;
            block22: {
                RefactoringStatus refactoringStatus3;
                block21: {
                    RefactoringStatus refactoringStatus4;
                    block20: {
                        RefactoringStatus refactoringStatus5;
                        block19: {
                            RefactoringStatus refactoringStatus6;
                            block18: {
                                RefactoringStatus refactoringStatus7;
                                block17: {
                                    RefactoringStatus refactoringStatus8;
                                    block16: {
                                        RefactoringStatus refactoringStatus9;
                                        block15: {
                                            RefactoringStatus refactoringStatus10;
                                            block14: {
                                                try {
                                                    Object object;
                                                    RefactoringStatus refactoringStatus11;
                                                    block25: {
                                                        block26: {
                                                            block24: {
                                                                iProgressMonitor.beginTask("", 7);
                                                                if (!this.fSourceCU.isStructureKnown()) {
                                                                    refactoringStatus10 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_syntax_error);
                                                                    Object var7_12 = null;
                                                                    break block14;
                                                                }
                                                                IJavaElement iJavaElement = SelectionConverter.resolveEnclosingElement((IJavaElement)this.fSourceCU, (ITextSelection)new TextSelection(this.fSelectionStart, this.fSelectionLength));
                                                                if (!(iJavaElement instanceof IMethod)) {
                                                                    refactoringStatus9 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                                                                    break block15;
                                                                }
                                                                this.fMethod = (IMethod)iJavaElement;
                                                                iProgressMonitor.worked(1);
                                                                refactoringStatus11 = new RefactoringStatus();
                                                                if (this.fArguments == null) break block24;
                                                                this.fChangeSignatureRefactoring = new ChangeSignatureRefactoring(null);
                                                                refactoringStatus11 = this.fChangeSignatureRefactoring.initialize(this.fArguments);
                                                                if (!refactoringStatus11.hasFatalError()) {
                                                                    this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                                                                    refactoringStatus11.merge(this.fChangeSignatureRefactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2)));
                                                                    if (refactoringStatus11.hasFatalError()) {
                                                                        refactoringStatus8 = refactoringStatus11;
                                                                        break block16;
                                                                    }
                                                                    break block25;
                                                                } else {
                                                                    iProgressMonitor.worked(2);
                                                                    refactoringStatus7 = refactoringStatus11;
                                                                    break block17;
                                                                }
                                                            }
                                                            ChangeSignatureRefactoring changeSignatureRefactoring = this.fChangeSignatureRefactoring = RefactoringAvailabilityTester.isChangeSignatureAvailable(this.fMethod) ? new ChangeSignatureRefactoring(this.fMethod) : null;
                                                            if (this.fChangeSignatureRefactoring == null) {
                                                                refactoringStatus6 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                                                                break block18;
                                                            }
                                                            this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                                                            refactoringStatus11.merge(this.fChangeSignatureRefactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                                                            if (!refactoringStatus11.hasFatalError()) break block26;
                                                            object = refactoringStatus11.getEntryMatchingSeverity(4);
                                                            if (object.getCode() == 1 || object.getCode() == 2) {
                                                                IMethod iMethod = (IMethod)object.getData();
                                                                ChangeSignatureRefactoring changeSignatureRefactoring2 = this.fChangeSignatureRefactoring = RefactoringAvailabilityTester.isChangeSignatureAvailable(iMethod) ? new ChangeSignatureRefactoring(iMethod) : null;
                                                                if (this.fChangeSignatureRefactoring == null) {
                                                                    String string = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_cannot_introduce, object.getMessage());
                                                                    refactoringStatus5 = RefactoringStatus.createFatalErrorStatus((String)string);
                                                                    break block19;
                                                                }
                                                                refactoringStatus11 = this.fChangeSignatureRefactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                                                if (refactoringStatus11.hasFatalError()) {
                                                                    refactoringStatus4 = refactoringStatus11;
                                                                    break block20;
                                                                }
                                                                break block25;
                                                            } else {
                                                                refactoringStatus3 = refactoringStatus11;
                                                                break block21;
                                                            }
                                                        }
                                                        iProgressMonitor.worked(1);
                                                    }
                                                    if (!((CompilationUnitRewrite)(object = this.fChangeSignatureRefactoring.getBaseCuRewrite())).getCu().equals(this.fSourceCU)) {
                                                        object = new CompilationUnitRewrite(this.fSourceCU);
                                                    }
                                                    this.initializeSelectedExpression((CompilationUnitRewrite)object);
                                                    iProgressMonitor.worked(1);
                                                    refactoringStatus11.merge(this.checkSelection((CompilationUnitRewrite)object, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3)));
                                                    if (refactoringStatus11.hasFatalError()) {
                                                        refactoringStatus2 = refactoringStatus11;
                                                        break block22;
                                                    }
                                                    this.initializeExcludedParameterNames((CompilationUnitRewrite)object);
                                                    this.addParameterInfo((CompilationUnitRewrite)object);
                                                    this.fChangeSignatureRefactoring.setBodyUpdater(new BodyUpdater(){

                                                        public void updateBody(MethodDeclaration methodDeclaration, CompilationUnitRewrite compilationUnitRewrite, RefactoringStatus refactoringStatus) {
                                                            IntroduceParameterRefactoring.this.replaceSelectedExpression(compilationUnitRewrite);
                                                        }
                                                    });
                                                    refactoringStatus = refactoringStatus11;
                                                    break block23;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var7_22 = null;
                                                    iProgressMonitor.done();
                                                    if (this.fChangeSignatureRefactoring == null) throw throwable;
                                                    this.fChangeSignatureRefactoring.setValidationContext(null);
                                                    throw throwable;
                                                }
                                            }
                                            iProgressMonitor.done();
                                            if (this.fChangeSignatureRefactoring == null) return refactoringStatus10;
                                            this.fChangeSignatureRefactoring.setValidationContext(null);
                                            return refactoringStatus10;
                                        }
                                        Object var7_13 = null;
                                        iProgressMonitor.done();
                                        if (this.fChangeSignatureRefactoring == null) return refactoringStatus9;
                                        this.fChangeSignatureRefactoring.setValidationContext(null);
                                        return refactoringStatus9;
                                    }
                                    Object var7_14 = null;
                                    iProgressMonitor.done();
                                    if (this.fChangeSignatureRefactoring == null) return refactoringStatus8;
                                    this.fChangeSignatureRefactoring.setValidationContext(null);
                                    return refactoringStatus8;
                                }
                                Object var7_15 = null;
                                iProgressMonitor.done();
                                if (this.fChangeSignatureRefactoring == null) return refactoringStatus7;
                                this.fChangeSignatureRefactoring.setValidationContext(null);
                                return refactoringStatus7;
                            }
                            Object var7_16 = null;
                            iProgressMonitor.done();
                            if (this.fChangeSignatureRefactoring == null) return refactoringStatus6;
                            this.fChangeSignatureRefactoring.setValidationContext(null);
                            return refactoringStatus6;
                        }
                        Object var7_17 = null;
                        iProgressMonitor.done();
                        if (this.fChangeSignatureRefactoring == null) return refactoringStatus5;
                        this.fChangeSignatureRefactoring.setValidationContext(null);
                        return refactoringStatus5;
                    }
                    Object var7_18 = null;
                    iProgressMonitor.done();
                    if (this.fChangeSignatureRefactoring == null) return refactoringStatus4;
                    this.fChangeSignatureRefactoring.setValidationContext(null);
                    return refactoringStatus4;
                }
                Object var7_19 = null;
                iProgressMonitor.done();
                if (this.fChangeSignatureRefactoring == null) return refactoringStatus3;
                this.fChangeSignatureRefactoring.setValidationContext(null);
                return refactoringStatus3;
            }
            Object var7_20 = null;
            iProgressMonitor.done();
            if (this.fChangeSignatureRefactoring == null) return refactoringStatus2;
            this.fChangeSignatureRefactoring.setValidationContext(null);
            return refactoringStatus2;
        }
        Object var7_21 = null;
        iProgressMonitor.done();
        if (this.fChangeSignatureRefactoring == null) return refactoringStatus;
        this.fChangeSignatureRefactoring.setValidationContext(null);
        return refactoringStatus;
    }

    private void addParameterInfo(CompilationUnitRewrite compilationUnitRewrite) throws JavaModelException {
        ITypeBinding iTypeBinding = Bindings.normalizeForDeclarationUse(this.fSelectedExpression.resolveTypeBinding(), this.fSelectedExpression.getAST());
        String string = compilationUnitRewrite.getImportRewrite().addImport(iTypeBinding);
        String string2 = this.fParameterName != null ? this.fParameterName : this.guessedParameterName();
        String string3 = this.fSourceCU.getBuffer().getText(this.fSelectedExpression.getStartPosition(), this.fSelectedExpression.getLength());
        this.fParameter = ParameterInfo.createInfoForAddedParameter(iTypeBinding, string, string2, string3);
        if (this.fArguments == null) {
            List list = this.fChangeSignatureRefactoring.getParameterInfos();
            int n = list.size();
            if (n > 0 && ((ParameterInfo)list.get(n - 1)).isOldVarargs()) {
                list.add(n - 1, this.fParameter);
            } else {
                list.add(this.fParameter);
            }
        }
    }

    private void replaceSelectedExpression(CompilationUnitRewrite compilationUnitRewrite) {
        if (!this.fSourceCU.equals(compilationUnitRewrite.getCu())) {
            return;
        }
        Expression expression = (Expression)NodeFinder.perform((ASTNode)compilationUnitRewrite.getRoot(), this.fSelectedExpression.getStartPosition(), this.fSelectedExpression.getLength());
        SimpleName simpleName = compilationUnitRewrite.getRoot().getAST().newSimpleName(this.fParameter.getNewName());
        String string = RefactoringCoreMessages.IntroduceParameterRefactoring_replace;
        compilationUnitRewrite.getASTRewrite().replace((ASTNode)expression, (ASTNode)simpleName, compilationUnitRewrite.createGroupDescription(string));
    }

    private void initializeSelectedExpression(CompilationUnitRewrite compilationUnitRewrite) throws JavaModelException {
        IASTFragment iASTFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)compilationUnitRewrite.getRoot(), compilationUnitRewrite.getCu());
        if (!(iASTFragment instanceof IExpressionFragment)) {
            return;
        }
        Expression expression = ((IExpressionFragment)iASTFragment).getAssociatedExpression();
        if (iASTFragment.getStartPosition() != expression.getStartPosition() || iASTFragment.getLength() != expression.getLength()) {
            return;
        }
        if (Checks.isInsideJavadoc((ASTNode)expression)) {
            return;
        }
        if (Checks.isEnumCase(expression.getParent())) {
            return;
        }
        this.fSelectedExpression = expression;
    }

    private RefactoringStatus checkSelection(CompilationUnitRewrite compilationUnitRewrite, IProgressMonitor iProgressMonitor) {
        MethodDeclaration methodDeclaration;
        if (this.fSelectedExpression == null) {
            String string = RefactoringCoreMessages.IntroduceParameterRefactoring_select;
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, compilationUnitRewrite.getRoot(), string);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((methodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression, clazz)) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
        }
        if (methodDeclaration.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_binding);
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(this.checkExpression());
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(this.checkExpressionBinding());
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkExpression() {
        Expression expression = this.fSelectedExpression;
        if (expression instanceof Name && expression.getParent() instanceof ClassInstanceCreation) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
        }
        if (expression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
        }
        if (expression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
        }
        if (expression instanceof Assignment) {
            if (expression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
            }
            return null;
        }
        if (expression instanceof SimpleName) {
            if (((SimpleName)expression).isDeclaration()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
            }
            if (expression.getParent() instanceof QualifiedName && expression.getLocationInParent() == QualifiedName.NAME_PROPERTY || expression.getParent() instanceof FieldAccess && expression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionBinding() {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() {
        switch (Checks.checkExpressionIsRValue(this.fSelectedExpression)) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_select, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public List getParameterInfos() {
        return this.fChangeSignatureRefactoring.getParameterInfos();
    }

    public ParameterInfo getAddedParameterInfo() {
        return this.fParameter;
    }

    public String getMethodSignaturePreview() throws JavaModelException {
        return this.fChangeSignatureRefactoring.getNewMethodSignature();
    }

    public void setParameterName(String string) {
        Assert.isNotNull((Object)string);
        this.fParameter.setNewName(string);
    }

    public String guessedParameterName() {
        String[] stringArray = this.guessParameterNames();
        if (stringArray.length == 0) {
            return "";
        }
        return stringArray[0];
    }

    public String[] guessParameterNames() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (this.fSelectedExpression instanceof MethodInvocation) {
            linkedHashSet.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)this.fSelectedExpression, this.fExcludedParameterNames));
        }
        linkedHashSet.addAll(this.guessTempNamesFromExpression(this.fSelectedExpression, this.fExcludedParameterNames));
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private List guessTempNamesFromMethodInvocation(MethodInvocation methodInvocation, String[] stringArray) {
        String string;
        SimpleName simpleName = methodInvocation.getName();
        if (simpleName != null) {
            string = simpleName.getIdentifier();
            int n = 0;
            while (n < KNOWN_METHOD_NAME_PREFIXES.length) {
                String string2 = KNOWN_METHOD_NAME_PREFIXES[n];
                if (string.startsWith(string2)) {
                    if (string.length() == string2.length()) {
                        return Collections.EMPTY_LIST;
                    }
                    char c = string.charAt(string2.length());
                    if (Character.isUpperCase(c)) {
                        String string3;
                        string = string3 = String.valueOf(Character.toLowerCase(c)) + string.substring(string2.length() + 1);
                        break;
                    }
                }
                ++n;
            }
        } else {
            string = "indirectFunctionCall";
        }
        String[] stringArray2 = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaProject(), string, 0, stringArray);
        return Arrays.asList(stringArray2);
    }

    private List guessTempNamesFromExpression(Expression expression, String[] stringArray) {
        ITypeBinding iTypeBinding = Bindings.normalizeForDeclarationUse(expression.resolveTypeBinding(), expression.getAST());
        String string = IntroduceParameterRefactoring.getQualifiedName(iTypeBinding);
        if (string.length() == 0) {
            string = iTypeBinding.getName();
        }
        if (string.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        int n = string.indexOf("<");
        if (n != -1) {
            string = string.substring(0, n);
        }
        String[] stringArray2 = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaProject(), string, iTypeBinding.getDimensions(), stringArray);
        return Arrays.asList(stringArray2);
    }

    private static String getQualifiedName(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isAnonymous()) {
            return IntroduceParameterRefactoring.getQualifiedName(iTypeBinding.getSuperclass());
        }
        if (!iTypeBinding.isArray()) {
            return iTypeBinding.getQualifiedName();
        }
        return iTypeBinding.getElementType().getQualifiedName();
    }

    private void initializeExcludedParameterNames(CompilationUnitRewrite compilationUnitRewrite) {
        IBinding[] iBindingArray = new ScopeAnalyzer(compilationUnitRewrite.getRoot()).getDeclarationsInScope(this.fSelectedExpression.getStartPosition(), 2);
        this.fExcludedParameterNames = new String[iBindingArray.length];
        int n = 0;
        while (n < this.fExcludedParameterNames.length) {
            this.fExcludedParameterNames[n] = iBindingArray[n].getName();
            ++n;
        }
    }

    public RefactoringStatus validateInput() {
        return this.fChangeSignatureRefactoring.checkSignature();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            refactoringStatus = this.fChangeSignatureRefactoring.checkFinalConditions(iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fChangeSignatureRefactoring.setValidationContext(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fChangeSignatureRefactoring.setValidationContext(null);
        return refactoringStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        ChangeDescriptor changeDescriptor;
        Object object;
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            object = this.fChangeSignatureRefactoring.createChange(iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.fChangeSignatureRefactoring.setValidationContext(null);
            throw throwable;
        }
        {
            changeDescriptor = null;
        }
        this.fChangeSignatureRefactoring.setValidationContext(null);
        if (object == null) return object;
        changeDescriptor = object.getDescriptor();
        if (!(changeDescriptor instanceof RefactoringChangeDescriptor)) return object;
        RefactoringDescriptor refactoringDescriptor = ((RefactoringChangeDescriptor)changeDescriptor).getRefactoringDescriptor();
        if (!(refactoringDescriptor instanceof JDTRefactoringDescriptor)) return object;
        JDTRefactoringDescriptor jDTRefactoringDescriptor = (JDTRefactoringDescriptor)refactoringDescriptor;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ATTRIBUTE_ARGUMENT, this.fParameter.getNewName());
        hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        hashMap.putAll(jDTRefactoringDescriptor.getArguments());
        String string = this.fChangeSignatureRefactoring.getMethodName();
        try {
            string = this.fChangeSignatureRefactoring.getOldMethodSignature();
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        String string2 = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description_short, this.fChangeSignatureRefactoring.getMethod().getElementName());
        String string3 = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description, new String[]{this.fParameter.getNewName(), string, ASTNodes.asString((ASTNode)this.fSelectedExpression)});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(jDTRefactoringDescriptor.getProject(), this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_original_pattern, JavaElementLabels.getTextLabel(this.fChangeSignatureRefactoring.getMethod(), JavaElementLabels.ALL_FULLY_QUALIFIED)));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_expression_pattern, ASTNodes.asString((ASTNode)this.fSelectedExpression)));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_parameter_pattern, this.getAddedParameterInfo().getNewName()));
        return new RefactoringDescriptorChange((RefactoringDescriptor)new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.introduce.parameter", jDTRefactoringDescriptor.getProject(), string2, jDTRefactoringDescriptorComment.asString(), hashMap, jDTRefactoringDescriptor.getFlags()), RefactoringCoreMessages.IntroduceParameterRefactoring_name, new Change[]{object});
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        Object object;
        this.fArguments = refactoringArguments;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            int n;
            int n2;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute("selection");
            if (string != null) {
                n2 = -1;
                n = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (n2 < 0 || n < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = n2;
            this.fSelectionLength = n;
            String string2 = javaRefactoringArguments.getAttribute("input");
            if (string2 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (object == null || !object.exists() || object.getElementType() != 5) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.introduce.parameter");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fSourceCU = ((IMethod)object).getCompilationUnit();
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_ARGUMENT);
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ARGUMENT));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fParameterName = object;
        return new RefactoringStatus();
    }

    public String getDelegateUpdatingTitle(boolean bl) {
        if (bl) {
            return RefactoringCoreMessages.DelegateCreator_keep_original_changed_plural;
        }
        return RefactoringCoreMessages.DelegateCreator_keep_original_changed_singular;
    }
}

