/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;

public class LocalTypeAnalyzer
extends ASTVisitor {
    private Selection fSelection;
    private List fTypeDeclarationsBefore = new ArrayList(2);
    private List fTypeDeclarationsSelected = new ArrayList(2);
    private String fBeforeTypeReferenced;
    private String fSelectedTypeReferenced;

    public static RefactoringStatus perform(BodyDeclaration bodyDeclaration, Selection selection) {
        LocalTypeAnalyzer localTypeAnalyzer = new LocalTypeAnalyzer(selection);
        bodyDeclaration.accept((ASTVisitor)localTypeAnalyzer);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        localTypeAnalyzer.check(refactoringStatus);
        return refactoringStatus;
    }

    private LocalTypeAnalyzer(Selection selection) {
        this.fSelection = selection;
    }

    public boolean visit(SimpleName simpleName) {
        if (simpleName.isDeclaration()) {
            return true;
        }
        IBinding iBinding = simpleName.resolveBinding();
        if (iBinding instanceof ITypeBinding) {
            this.processLocalTypeBinding((ITypeBinding)iBinding, this.fSelection.getVisitSelectionMode((ASTNode)simpleName));
        }
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        return this.visitType((AbstractTypeDeclaration)typeDeclaration);
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return this.visitType((AbstractTypeDeclaration)annotationTypeDeclaration);
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        return this.visitType((AbstractTypeDeclaration)enumDeclaration);
    }

    private boolean visitType(AbstractTypeDeclaration abstractTypeDeclaration) {
        int n = this.fSelection.getVisitSelectionMode((ASTNode)abstractTypeDeclaration);
        switch (n) {
            case 1: {
                this.fTypeDeclarationsBefore.add(abstractTypeDeclaration);
                break;
            }
            case 2: {
                this.fTypeDeclarationsSelected.add(abstractTypeDeclaration);
            }
        }
        return true;
    }

    private void processLocalTypeBinding(ITypeBinding iTypeBinding, int n) {
        switch (n) {
            case 2: {
                if (this.fBeforeTypeReferenced != null || !this.checkBinding(this.fTypeDeclarationsBefore, iTypeBinding)) break;
                this.fBeforeTypeReferenced = RefactoringCoreMessages.LocalTypeAnalyzer_local_type_from_outside;
                break;
            }
            case 3: {
                if (this.fSelectedTypeReferenced != null || !this.checkBinding(this.fTypeDeclarationsSelected, iTypeBinding)) break;
                this.fSelectedTypeReferenced = RefactoringCoreMessages.LocalTypeAnalyzer_local_type_referenced_outside;
            }
        }
    }

    private boolean checkBinding(List list, ITypeBinding iTypeBinding) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)iterator.next();
            if (abstractTypeDeclaration.resolveBinding() != iTypeBinding) continue;
            return true;
        }
        return false;
    }

    private void check(RefactoringStatus refactoringStatus) {
        if (this.fBeforeTypeReferenced != null) {
            refactoringStatus.addFatalError(this.fBeforeTypeReferenced);
        }
        if (this.fSelectedTypeReferenced != null) {
            refactoringStatus.addFatalError(this.fSelectedTypeReferenced);
        }
    }
}

