/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;

public class NLSLine {
    private int fLineNumber;
    private List fElements;

    public NLSLine(int n) {
        this.fLineNumber = n;
        Assert.isTrue((this.fLineNumber >= 0 ? 1 : 0) != 0);
        this.fElements = new ArrayList();
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public void add(NLSElement nLSElement) {
        Assert.isNotNull((Object)nLSElement);
        this.fElements.add(nLSElement);
    }

    public NLSElement[] getElements() {
        return this.fElements.toArray(new NLSElement[this.fElements.size()]);
    }

    public NLSElement get(int n) {
        return (NLSElement)this.fElements.get(n);
    }

    public boolean exists(int n) {
        return n >= 0 && n < this.fElements.size();
    }

    public int size() {
        return this.fElements.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Line: " + this.fLineNumber + "\n");
        Iterator iterator = this.fElements.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t");
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

