/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;

public class RefactoringHandleTransplanter {
    private final IType fOldType;
    private final IType fNewType;
    private final Map fRefactoredSimilarElements;

    public RefactoringHandleTransplanter(IType iType, IType iType2, Map map) {
        this.fOldType = iType;
        this.fNewType = iType2;
        this.fRefactoredSimilarElements = map == null ? Collections.EMPTY_MAP : map;
    }

    public IMember transplantHandle(IMember iMember) {
        LinkedList linkedList = new LinkedList();
        this.addElements(iMember, linkedList);
        IMember[] iMemberArray = this.convertElements(linkedList.toArray(new IMember[0]));
        return iMemberArray[iMemberArray.length - 1];
    }

    private void addElements(IMember iMember, LinkedList linkedList) {
        linkedList.addFirst(iMember);
        IJavaElement iJavaElement = iMember.getParent();
        if (iJavaElement instanceof IMember) {
            this.addElements((IMember)iJavaElement, linkedList);
        }
    }

    private IMember[] convertElements(IMember[] iMemberArray) {
        IMember[] iMemberArray2 = new IMember[iMemberArray.length];
        IMember iMember = iMemberArray[0];
        Assert.isTrue((boolean)(iMember instanceof IType));
        iMemberArray2[0] = iMember.equals(this.fOldType) ? this.fNewType : iMember;
        int n = 1;
        while (n < iMemberArray.length) {
            IMember iMember2 = iMemberArray2[n - 1];
            IMember iMember3 = iMemberArray[n];
            switch (iMember2.getElementType()) {
                case 7: {
                    switch (iMember3.getElementType()) {
                        case 7: {
                            Object object = this.resolveTypeName((IType)iMember3);
                            iMemberArray2[n] = ((IType)iMember2).getType((String)object);
                            break;
                        }
                        case 9: {
                            Object object = this.resolveElementName((IJavaElement)iMember3);
                            String[] stringArray = this.resolveParameterTypes((IMethod)iMember3);
                            iMemberArray2[n] = ((IType)iMember2).getMethod((String)object, stringArray);
                            break;
                        }
                        case 10: {
                            Object object = (IInitializer)iMember3;
                            iMemberArray2[n] = ((IType)iMember2).getInitializer(object.getOccurrenceCount());
                            break;
                        }
                        case 8: {
                            Object object = this.resolveElementName((IJavaElement)iMember3);
                            iMemberArray2[n] = ((IType)iMember2).getField((String)object);
                        }
                    }
                    break;
                }
                case 9: {
                    switch (iMember3.getElementType()) {
                        case 7: {
                            iMemberArray2[n] = this.resolveTypeInMember((IMember)((IMethod)iMember2), (IType)iMember3);
                        }
                    }
                    break;
                }
                case 10: {
                    switch (iMember3.getElementType()) {
                        case 7: {
                            iMemberArray2[n] = this.resolveTypeInMember((IMember)((IInitializer)iMember2), (IType)iMember3);
                        }
                    }
                    break;
                }
                case 8: {
                    switch (iMember3.getElementType()) {
                        case 7: {
                            iMemberArray2[n] = this.resolveTypeInMember((IMember)((IField)iMember2), (IType)iMember3);
                        }
                    }
                }
            }
            ++n;
        }
        return iMemberArray2;
    }

    private String[] resolveParameterTypes(IMethod iMethod) {
        String[] stringArray = iMethod.getParameterTypes();
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[]{Signature.createTypeSignature((String)this.fOldType.getElementName(), (boolean)false), Signature.createTypeSignature((String)this.fOldType.getElementName(), (boolean)true), Signature.createTypeSignature((String)this.fOldType.getFullyQualifiedName(), (boolean)false), Signature.createTypeSignature((String)this.fOldType.getFullyQualifiedName(), (boolean)true)};
        String[] stringArray4 = new String[]{Signature.createTypeSignature((String)this.fNewType.getElementName(), (boolean)false), Signature.createTypeSignature((String)this.fNewType.getElementName(), (boolean)true), Signature.createTypeSignature((String)this.fNewType.getFullyQualifiedName(), (boolean)false), Signature.createTypeSignature((String)this.fNewType.getFullyQualifiedName(), (boolean)true)};
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n];
            int n2 = 0;
            while (n2 < stringArray3.length) {
                stringArray2[n] = RefactoringHandleTransplanter.replaceAll(stringArray2[n], stringArray3[n2], stringArray4[n2]);
                ++n2;
            }
            ++n;
        }
        return stringArray2;
    }

    private String resolveElementName(IJavaElement iJavaElement) {
        String string = (String)this.fRefactoredSimilarElements.get(iJavaElement);
        if (string != null) {
            return string;
        }
        return iJavaElement.getElementName();
    }

    private IMember resolveTypeInMember(IMember iMember, IType iType) {
        String string = "";
        if (iType.getElementName().length() != 0) {
            string = this.resolveTypeName(iType);
        }
        return iMember.getType(string, iType.getOccurrenceCount());
    }

    private String resolveTypeName(IType iType) {
        return iType.equals(this.fOldType) ? this.fNewType.getElementName() : iType.getElementName();
    }

    private static String replaceAll(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }
}

