/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateFieldCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class RenameFieldProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IDelegateUpdating {
    protected static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_RENAME_GETTER = "getter";
    private static final String ATTRIBUTE_RENAME_SETTER = "setter";
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    protected IField fField;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    protected boolean fUpdateReferences;
    protected boolean fUpdateTextualMatches;
    private boolean fRenameGetter;
    private boolean fRenameSetter;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameFieldProcessor";

    public RenameFieldProcessor(IField iField) {
        this(iField, new TextChangeManager(true), null);
        this.fIsComposite = false;
    }

    RenameFieldProcessor(IField iField, TextChangeManager textChangeManager, GroupCategorySet groupCategorySet) {
        this.initialize(iField);
        this.fChangeManager = textChangeManager;
        this.fCategorySet = groupCategorySet;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        this.fIsComposite = true;
    }

    private void initialize(IField iField) {
        this.fField = iField;
        if (this.fField != null) {
            this.setNewElementName(this.fField.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fRenameGetter = false;
        this.fRenameSetter = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameFieldAvailable(this.fField);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameFieldRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fField);
    }

    public IField getField() {
        return this.fField;
    }

    public Object[] getElements() {
        return new Object[]{this.fField};
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        IMethod iMethod;
        RenameModifications renameModifications = new RenameModifications();
        renameModifications.rename(this.fField, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (this.fRenameGetter && (iMethod = this.getGetter()) != null) {
            renameModifications.rename(iMethod, new RenameArguments(this.getNewGetterName(), this.getUpdateReferences()));
        }
        if (this.fRenameSetter && (iMethod = this.getSetter()) != null) {
            renameModifications.rename(iMethod, new RenameArguments(this.getNewSetterName(), this.getUpdateReferences()));
        }
        return renameModifications;
    }

    protected IFile[] getChangedFiles() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    public final String getCurrentElementName() {
        return this.fField.getElementName();
    }

    public final String getCurrentElementQualifier() {
        return JavaModelUtil.getFullyQualifiedName(this.fField.getDeclaringType());
    }

    public RefactoringStatus checkNewElementName(String string) throws CoreException {
        boolean bl;
        Assert.isNotNull((Object)string, (String)"new name");
        RefactoringStatus refactoringStatus = Checks.checkFieldName(string);
        if (RenameFieldProcessor.isInstanceField(this.fField) && !Checks.startsWithLowerCase(string)) {
            refactoringStatus.addWarning(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_should_start_lowercase2, new String[]{string, this.fField.getDeclaringType().getElementName()}) : RefactoringCoreMessages.RenameFieldRefactoring_should_start_lowercase);
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fField, string)) {
            refactoringStatus.addError(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_another_name2, new String[]{string, this.fField.getDeclaringType().getElementName()}) : RefactoringCoreMessages.RenameFieldRefactoring_another_name, JavaStatusContext.create((IMember)this.fField));
        }
        boolean bl2 = bl = this.fField.getDeclaringType() != null ? this.fField.getDeclaringType().getField(string).exists() : this.fField.getCompilationUnit().getField(string).exists();
        if (bl) {
            refactoringStatus.addError(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_field_already_defined2, new String[]{string, this.fField.getDeclaringType().getElementName()}) : RefactoringCoreMessages.RenameFieldRefactoring_field_already_defined, JavaStatusContext.create((IMember)this.fField.getDeclaringType().getField(string)));
        }
        return refactoringStatus;
    }

    public Object getNewElement() {
        return this.fField.getDeclaringType() != null ? this.fField.getDeclaringType().getField(this.getNewElementName()) : this.fField.getCompilationUnit().getField(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean bl) {
        this.fUpdateTextualMatches = bl;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String canEnableGetterRenaming() throws CoreException {
        ITypeHierarchy iTypeHierarchy;
        if (this.fField.getDeclaringType() != null && this.fField.getDeclaringType().isInterface()) {
            return this.getGetter() == null ? "" : null;
        }
        IMethod iMethod = this.getGetter();
        if (iMethod == null) {
            return "";
        }
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        if (MethodChecks.isVirtual(iMethod) && (MethodChecks.isDeclaredInInterface(iMethod, iTypeHierarchy = iMethod.getDeclaringType().newTypeHierarchy((IProgressMonitor)nullProgressMonitor), (IProgressMonitor)nullProgressMonitor) != null || MethodChecks.overridesAnotherMethod(iMethod, iTypeHierarchy) != null)) {
            return RefactoringCoreMessages.RenameFieldRefactoring_declared_in_supertype;
        }
        return null;
    }

    public String canEnableSetterRenaming() throws CoreException {
        ITypeHierarchy iTypeHierarchy;
        if (this.fField.getDeclaringType() != null && this.fField.getDeclaringType().isInterface()) {
            return this.getSetter() == null ? "" : null;
        }
        IMethod iMethod = this.getSetter();
        if (iMethod == null) {
            return "";
        }
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        if (MethodChecks.isVirtual(iMethod) && (MethodChecks.isDeclaredInInterface(iMethod, iTypeHierarchy = iMethod.getDeclaringType().newTypeHierarchy((IProgressMonitor)nullProgressMonitor), (IProgressMonitor)nullProgressMonitor) != null || MethodChecks.overridesAnotherMethod(iMethod, iTypeHierarchy) != null)) {
            return RefactoringCoreMessages.RenameFieldRefactoring_declared_in_supertype;
        }
        return null;
    }

    public boolean getRenameGetter() {
        return this.fRenameGetter;
    }

    public void setRenameGetter(boolean bl) {
        this.fRenameGetter = bl;
    }

    public boolean getRenameSetter() {
        return this.fRenameSetter;
    }

    public void setRenameSetter(boolean bl) {
        this.fRenameSetter = bl;
    }

    public IMethod getGetter() throws CoreException {
        return GetterSetterUtil.getGetter(this.fField);
    }

    public IMethod getSetter() throws CoreException {
        return GetterSetterUtil.getSetter(this.fField);
    }

    public String getNewGetterName() throws CoreException {
        IMethod iMethod = JavaModelUtil.findMethod(GetterSetterUtil.getGetterName(this.fField, new String[0]), new String[0], false, this.fField.getDeclaringType());
        if (!JavaModelUtil.isBoolean(this.fField) || iMethod != null && iMethod.exists()) {
            return GetterSetterUtil.getGetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), JavaModelUtil.isBoolean(this.fField), null);
        }
        return GetterSetterUtil.getGetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), false, null);
    }

    public String getNewSetterName() throws CoreException {
        return GetterSetterUtil.getSetterName(this.fField.getJavaProject(), this.getNewElementName(), this.fField.getFlags(), JavaModelUtil.isBoolean(this.fField), null);
    }

    public boolean canEnableDelegateUpdating() {
        return this.getDelegateCount() > 0;
    }

    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    public void setDelegateUpdating(boolean bl) {
        this.fDelegateUpdating = bl;
    }

    public void setDeprecateDelegates(boolean bl) {
        this.fDelegateDeprecation = bl;
    }

    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public int getDelegateCount() {
        int n = 0;
        try {
            if (RefactoringAvailabilityTester.isDelegateCreationAvailable(this.getField())) {
                ++n;
            }
            if (this.fRenameGetter && this.getGetter() != null) {
                ++n;
            }
            if (this.fRenameSetter && this.getSetter() != null) {
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return n;
    }

    public int getSaveMode() {
        return 3;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        IField iField = (IField)this.fField.getPrimaryElement();
        if (iField == null || !iField.exists()) {
            String string = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_deleted, this.fField.getCompilationUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        this.fField = iField;
        return Checks.checkIfCuBroken((IMember)this.fField);
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        block13: {
            block12: {
                RefactoringStatus refactoringStatus2;
                try {
                    iProgressMonitor.beginTask("", 18);
                    iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
                    refactoringStatus = new RefactoringStatus();
                    refactoringStatus.merge(Checks.checkIfCuBroken((IMember)this.fField));
                    if (!refactoringStatus.hasFatalError()) break block12;
                    refactoringStatus2 = refactoringStatus;
                    Object var4_7 = null;
                }
                catch (Throwable throwable) {
                    Object var4_10 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                iProgressMonitor.done();
                return refactoringStatus2;
            }
            refactoringStatus.merge(this.checkNewElementName(this.getNewElementName()));
            iProgressMonitor.worked(1);
            refactoringStatus.merge(this.checkEnclosingHierarchy());
            iProgressMonitor.worked(1);
            refactoringStatus.merge(this.checkNestedHierarchy(this.fField.getDeclaringType()));
            iProgressMonitor.worked(1);
            if (this.fUpdateReferences) {
                iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_searching);
                this.fReferences = this.getReferences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3), refactoringStatus);
                iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            } else {
                this.fReferences = new SearchResultGroup[0];
                iProgressMonitor.worked(3);
            }
            if (this.fUpdateReferences) {
                refactoringStatus.merge(this.analyzeAffectedCompilationUnits());
            } else {
                Checks.checkCompileErrorsInAffectedFile(refactoringStatus, this.fField.getResource());
            }
            if (this.getGetter() != null && this.fRenameGetter) {
                refactoringStatus.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), this.getGetter(), this.getNewGetterName()));
                refactoringStatus.merge(Checks.checkIfConstructorName(this.getGetter(), this.getNewGetterName(), this.fField.getDeclaringType().getElementName()));
            } else {
                iProgressMonitor.worked(1);
            }
            if (this.getSetter() != null && this.fRenameSetter) {
                refactoringStatus.merge(this.checkAccessor((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), this.getSetter(), this.getNewSetterName()));
                refactoringStatus.merge(Checks.checkIfConstructorName(this.getSetter(), this.getNewSetterName(), this.fField.getDeclaringType().getElementName()));
            } else {
                iProgressMonitor.worked(1);
            }
            refactoringStatus.merge(this.createChanges((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10)));
            if (!refactoringStatus.hasFatalError()) break block13;
            RefactoringStatus refactoringStatus3 = refactoringStatus;
            Object var4_8 = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        RefactoringStatus refactoringStatus4 = refactoringStatus;
        Object var4_9 = null;
        iProgressMonitor.done();
        return refactoringStatus4;
    }

    private RefactoringStatus checkAccessor(IProgressMonitor iProgressMonitor, IMethod iMethod, String string) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(this.checkAccessorDeclarations(iProgressMonitor, iMethod));
        refactoringStatus.merge(this.checkNewAccessor(iMethod, string));
        return refactoringStatus;
    }

    private RefactoringStatus checkNewAccessor(IMethod iMethod, String string) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IMethod iMethod2 = JavaModelUtil.findMethod(string, iMethod.getParameterTypes(), false, this.fField.getDeclaringType());
        if (iMethod2 == null || !iMethod2.exists()) {
            return null;
        }
        String string2 = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_already_exists, new String[]{JavaElementUtil.createMethodSignature(iMethod2), JavaModelUtil.getFullyQualifiedName(this.fField.getDeclaringType())});
        refactoringStatus.addError(string2, JavaStatusContext.create((IMember)iMethod2));
        return refactoringStatus;
    }

    private RefactoringStatus checkAccessorDeclarations(IProgressMonitor iProgressMonitor, IMethod iMethod) throws CoreException {
        IJavaSearchScope iJavaSearchScope;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)iMethod, (int)0, (int)24);
        SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(searchPattern, iJavaSearchScope = SearchEngine.createHierarchyScope((IType)this.fField.getDeclaringType()), iProgressMonitor, refactoringStatus);
        Assert.isTrue((searchResultGroupArray.length > 0 ? 1 : 0) != 0);
        if (searchResultGroupArray.length != 1) {
            String string = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_overridden, JavaElementUtil.createMethodSignature(iMethod));
            refactoringStatus.addError(string);
        } else {
            SearchResultGroup searchResultGroup = searchResultGroupArray[0];
            Assert.isTrue((searchResultGroup.getSearchResults().length > 0 ? 1 : 0) != 0);
            if (searchResultGroup.getSearchResults().length != 1) {
                String string = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_overridden_or_overrides, JavaElementUtil.createMethodSignature(iMethod));
                refactoringStatus.addError(string);
            }
        }
        return refactoringStatus;
    }

    private static boolean isInstanceField(IField iField) throws CoreException {
        if (JavaModelUtil.isInterfaceOrAnnotation(iField.getDeclaringType())) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)iField);
    }

    private RefactoringStatus checkNestedHierarchy(IType iType) throws CoreException {
        if (iType == null) {
            return null;
        }
        IType[] iTypeArray = iType.getTypes();
        if (iTypeArray == null) {
            return null;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < iTypeArray.length) {
            IField iField = iTypeArray[n].getField(this.getNewElementName());
            if (iField.exists()) {
                String string = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_hiding, new String[]{this.fField.getElementName(), this.getNewElementName(), JavaModelUtil.getFullyQualifiedName(iTypeArray[n])});
                refactoringStatus.addWarning(string, JavaStatusContext.create((IMember)iField));
            }
            refactoringStatus.merge(this.checkNestedHierarchy(iTypeArray[n]));
            ++n;
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkEnclosingHierarchy() {
        IType iType = this.fField.getDeclaringType();
        if (iType == null || Checks.isTopLevel(iType)) {
            return null;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        while (iType != null) {
            IField iField = iType.getField(this.getNewElementName());
            if (iField.exists()) {
                String string = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_hiding2, new String[]{this.getNewElementName(), JavaModelUtil.getFullyQualifiedName(iType), iField.getElementName()});
                refactoringStatus.addWarning(string, JavaStatusContext.create((IMember)iField));
            }
            iType = iType.getDeclaringType();
        }
        return refactoringStatus;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fReferences = Checks.excludeCompilationUnits(this.fReferences, refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        return refactoringStatus;
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.createPattern((IJavaElement)this.fField, (int)2);
    }

    private IJavaSearchScope createRefactoringScope() throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)this.fField);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        return RefactoringSearchEngine.search(this.createSearchPattern(), this.createRefactoringScope(), iProgressMonitor, refactoringStatus);
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 1);
            TextChange[] textChangeArray = this.fChangeManager.getAllChanges();
            ArrayList<TextChange> arrayList = new ArrayList<TextChange>(textChangeArray.length);
            arrayList.addAll(Arrays.asList(textChangeArray));
            String string = null;
            IJavaProject iJavaProject = this.fField.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            int n = 589826;
            try {
                if (!Flags.isPrivate((int)this.fField.getFlags())) {
                    n |= 4;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            IType iType = this.fField.getDeclaringType();
            try {
                if (iType != null && (iType.isAnonymous() || iType.isLocal())) {
                    n |= 0x40000;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            String string2 = Messages.format(RefactoringCoreMessages.RenameFieldRefactoring_descriptor_description_short, this.fField.getElementName());
            String string3 = Messages.format(RefactoringCoreMessages.RenameFieldProcessor_descriptor_description, new String[]{this.fField.getElementName(), JavaElementLabels.getElementLabel(this.fField.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
            if (this.fRenameGetter) {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.RenameFieldRefactoring_setting_rename_getter);
            }
            if (this.fRenameSetter) {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.RenameFieldRefactoring_setting_rename_settter);
            }
            RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.field");
            renameJavaElementDescriptor.setProject(string);
            renameJavaElementDescriptor.setDescription(string2);
            renameJavaElementDescriptor.setComment(jDTRefactoringDescriptorComment.asString());
            renameJavaElementDescriptor.setFlags(n);
            renameJavaElementDescriptor.setJavaElement((IJavaElement)this.fField);
            renameJavaElementDescriptor.setNewName(this.getNewElementName());
            renameJavaElementDescriptor.setUpdateReferences(this.fUpdateReferences);
            renameJavaElementDescriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
            renameJavaElementDescriptor.setRenameGetters(this.fRenameGetter);
            renameJavaElementDescriptor.setRenameSetters(this.fRenameSetter);
            renameJavaElementDescriptor.setKeepOriginal(this.fDelegateUpdating);
            renameJavaElementDescriptor.setDeprecateDelegate(this.fDelegateDeprecation);
            dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenameFieldRefactoring_change_name, arrayList.toArray(new Change[arrayList.size()]));
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    private RefactoringStatus createChanges(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 10);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (!this.fIsComposite) {
            this.fChangeManager.clear();
        }
        if (this.fDelegateUpdating) {
            refactoringStatus.merge(this.addDelegates());
        }
        this.addDeclarationUpdate();
        if (this.fUpdateReferences) {
            this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            refactoringStatus.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2)));
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
        } else {
            iProgressMonitor.worked(3);
        }
        if (this.getGetter() != null && this.fRenameGetter) {
            this.addGetterOccurrences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
        } else {
            iProgressMonitor.worked(1);
        }
        if (this.getSetter() != null && this.fRenameSetter) {
            this.addSetterOccurrences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
        } else {
            iProgressMonitor.worked(1);
        }
        if (this.fUpdateTextualMatches) {
            this.addTextMatches((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 5));
        } else {
            iProgressMonitor.worked(5);
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private void addDeclarationUpdate() throws CoreException {
        ISourceRange iSourceRange = this.fField.getNameRange();
        ReplaceEdit replaceEdit = new ReplaceEdit(iSourceRange.getOffset(), iSourceRange.getLength(), this.getNewElementName());
        ICompilationUnit iCompilationUnit = this.fField.getCompilationUnit();
        String string = RefactoringCoreMessages.RenameFieldRefactoring_Update_field_declaration;
        this.addTextEdit(this.fChangeManager.get(iCompilationUnit), string, (TextEdit)replaceEdit);
    }

    private RefactoringStatus addDelegates() throws JavaModelException, CoreException {
        Object object;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(this.fField.getCompilationUnit());
        compilationUnitRewrite.setResolveBindings(true);
        if (RefactoringAvailabilityTester.isDelegateCreationAvailable(this.fField)) {
            object = ASTNodeSearchUtil.getFieldDeclarationNode(this.fField, compilationUnitRewrite.getRoot());
            if (object.fragments().size() > 1) {
                refactoringStatus.addWarning(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_more_than_one_fragment, this.fField.getElementName()), JavaStatusContext.create((IMember)this.fField));
            } else if (((VariableDeclarationFragment)object.fragments().get(0)).getInitializer() == null) {
                refactoringStatus.addWarning(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_no_initializer, this.fField.getElementName()), JavaStatusContext.create((IMember)this.fField));
            } else {
                DelegateFieldCreator delegateFieldCreator = new DelegateFieldCreator();
                delegateFieldCreator.setDeclareDeprecated(this.fDelegateDeprecation);
                delegateFieldCreator.setDeclaration((BodyDeclaration)object);
                delegateFieldCreator.setNewElementName(this.getNewElementName());
                delegateFieldCreator.setSourceRewrite(compilationUnitRewrite);
                delegateFieldCreator.prepareDelegate();
                delegateFieldCreator.createEdit();
            }
        }
        if (this.getGetter() != null && this.fRenameGetter) {
            this.addMethodDelegate(this.getGetter(), this.getNewGetterName(), compilationUnitRewrite);
        }
        if (this.getSetter() != null && this.fRenameSetter) {
            this.addMethodDelegate(this.getSetter(), this.getNewSetterName(), compilationUnitRewrite);
        }
        if ((object = compilationUnitRewrite.createChange()) != null) {
            object.setKeepPreviewEdits(true);
            this.fChangeManager.manage(this.fField.getCompilationUnit(), (TextChange)object);
        }
        return refactoringStatus;
    }

    private void addMethodDelegate(IMethod iMethod, String string, CompilationUnitRewrite compilationUnitRewrite) throws JavaModelException {
        MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, compilationUnitRewrite.getRoot());
        DelegateMethodCreator delegateMethodCreator = new DelegateMethodCreator();
        delegateMethodCreator.setDeclareDeprecated(this.fDelegateDeprecation);
        delegateMethodCreator.setDeclaration((BodyDeclaration)methodDeclaration);
        delegateMethodCreator.setNewElementName(string);
        delegateMethodCreator.setSourceRewrite(compilationUnitRewrite);
        delegateMethodCreator.prepareDelegate();
        delegateMethodCreator.createEdit();
    }

    private void addTextEdit(TextChange textChange, String string, TextEdit textEdit) {
        if (this.fIsComposite) {
            TextChangeCompatibility.addTextEdit(textChange, string, textEdit, this.fCategorySet);
        } else {
            TextChangeCompatibility.addTextEdit(textChange, string, textEdit);
        }
    }

    private void addReferenceUpdates(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("", this.fReferences.length);
        String string = RefactoringCoreMessages.RenameFieldRefactoring_Update_field_reference;
        int n = 0;
        while (n < this.fReferences.length) {
            ICompilationUnit iCompilationUnit = this.fReferences[n].getCompilationUnit();
            if (iCompilationUnit != null) {
                SearchMatch[] searchMatchArray = this.fReferences[n].getSearchResults();
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    this.addTextEdit(this.fChangeManager.get(iCompilationUnit), string, this.createTextChange(searchMatchArray[n2]));
                    ++n2;
                }
                iProgressMonitor.worked(1);
            }
            ++n;
        }
    }

    private TextEdit createTextChange(SearchMatch searchMatch) {
        return new ReplaceEdit(searchMatch.getOffset(), searchMatch.getLength(), this.getNewElementName());
    }

    private void addGetterOccurrences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        this.addAccessorOccurrences(iProgressMonitor, this.getGetter(), RefactoringCoreMessages.RenameFieldRefactoring_Update_getter_occurrence, this.getNewGetterName(), refactoringStatus);
    }

    private void addSetterOccurrences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        this.addAccessorOccurrences(iProgressMonitor, this.getSetter(), RefactoringCoreMessages.RenameFieldRefactoring_Update_setter_occurrence, this.getNewSetterName(), refactoringStatus);
    }

    private void addAccessorOccurrences(IProgressMonitor iProgressMonitor, IMethod iMethod, String string, String string2, RefactoringStatus refactoringStatus) throws CoreException {
        Assert.isTrue((boolean)iMethod.exists());
        IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)iMethod);
        SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)iMethod, (int)3, (int)24);
        SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(searchPattern, iJavaSearchScope, new MethodOccurenceCollector(iMethod.getElementName()), iProgressMonitor, refactoringStatus);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            ICompilationUnit iCompilationUnit = searchResultGroupArray[n].getCompilationUnit();
            if (iCompilationUnit != null) {
                SearchMatch[] searchMatchArray = searchResultGroupArray[n].getSearchResults();
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    SearchMatch searchMatch = searchMatchArray[n2];
                    ReplaceEdit replaceEdit = new ReplaceEdit(searchMatch.getOffset(), searchMatch.getLength(), string2);
                    this.addTextEdit(this.fChangeManager.get(iCompilationUnit), string, (TextEdit)replaceEdit);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void addTextMatches(IProgressMonitor iProgressMonitor) throws CoreException {
        TextMatchUpdater.perform(iProgressMonitor, this.createRefactoringScope(), this, this.fChangeManager, this.fReferences);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor iProgressMonitor) throws CoreException {
        int n;
        Throwable throwable2;
        ICompilationUnit[] iCompilationUnitArray;
        block10: {
            RefactoringStatus refactoringStatus;
            iCompilationUnitArray = null;
            WorkingCopyOwner workingCopyOwner = new WorkingCopyOwner(){};
            try {
                ArrayList<ICompilationUnit> arrayList;
                SearchResultGroup[] searchResultGroupArray;
                RefactoringStatus refactoringStatus2;
                block9: {
                    iProgressMonitor.beginTask("", 2);
                    refactoringStatus2 = new RefactoringStatus();
                    searchResultGroupArray = this.fReferences;
                    arrayList = new ArrayList<ICompilationUnit>();
                    if (this.fIsComposite) {
                        int n2 = 0;
                        while (true) {
                            if (n2 >= searchResultGroupArray.length) {
                                arrayList.add(this.fField.getCompilationUnit());
                                break block9;
                            }
                            arrayList.add(searchResultGroupArray[n2].getCompilationUnit());
                            ++n2;
                        }
                    }
                    arrayList.addAll(Arrays.asList(this.fChangeManager.getAllCompilationUnits()));
                }
                iCompilationUnitArray = RenameAnalyzeUtil.createNewWorkingCopies(arrayList.toArray(new ICompilationUnit[arrayList.size()]), this.fChangeManager, workingCopyOwner, new SubProgressMonitor(iProgressMonitor, 1));
                SearchResultGroup[] searchResultGroupArray2 = this.getNewReferences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus2, workingCopyOwner, iCompilationUnitArray);
                refactoringStatus2.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, searchResultGroupArray, searchResultGroupArray2, this.getNewElementName()));
                refactoringStatus = refactoringStatus2;
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                iProgressMonitor.done();
                if (iCompilationUnitArray == null) throw throwable2;
                n = 0;
                break block10;
            }
            iProgressMonitor.done();
            if (iCompilationUnitArray == null) return refactoringStatus;
            int n3 = 0;
            while (true) {
                if (n3 >= iCompilationUnitArray.length) {
                    return refactoringStatus;
                }
                iCompilationUnitArray[n3].discardWorkingCopy();
                ++n3;
            }
        }
        while (true) {
            if (n >= iCompilationUnitArray.length) {
                throw throwable2;
            }
            iCompilationUnitArray[n].discardWorkingCopy();
            ++n;
        }
    }

    private SearchResultGroup[] getNewReferences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus, WorkingCopyOwner workingCopyOwner, ICompilationUnit[] iCompilationUnitArray) throws CoreException {
        SearchPattern searchPattern;
        iProgressMonitor.beginTask("", 2);
        ICompilationUnit iCompilationUnit = RenameAnalyzeUtil.findWorkingCopyForCu(iCompilationUnitArray, this.fField.getCompilationUnit());
        if (iCompilationUnit == null) {
            return new SearchResultGroup[0];
        }
        IField iField = this.getFieldInWorkingCopy(iCompilationUnit, this.getNewElementName());
        if (iField == null || !iField.exists()) {
            return new SearchResultGroup[0];
        }
        CollectingSearchRequestor collectingSearchRequestor = null;
        if (this.fDelegateUpdating && RefactoringAvailabilityTester.isDelegateCreationAvailable(this.getField())) {
            searchPattern = this.getFieldInWorkingCopy(iCompilationUnit, this.getCurrentElementName());
            collectingSearchRequestor = new CollectingSearchRequestor((IField)searchPattern){
                private final /* synthetic */ IField val$oldField;
                {
                    this.val$oldField = iField;
                }

                public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                    if (!this.val$oldField.equals(searchMatch.getElement())) {
                        super.acceptSearchMatch(searchMatch);
                    }
                }
            };
        } else {
            collectingSearchRequestor = new CollectingSearchRequestor();
        }
        searchPattern = SearchPattern.createPattern((IJavaElement)iField, (int)2);
        return RefactoringSearchEngine.search(searchPattern, workingCopyOwner, this.createRefactoringScope(), collectingSearchRequestor, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
    }

    private IField getFieldInWorkingCopy(ICompilationUnit iCompilationUnit, String string) throws CoreException {
        IType iType = this.fField.getDeclaringType();
        IType iType2 = (IType)JavaModelUtil.findInCompilationUnit(iCompilationUnit, (IJavaElement)iType);
        if (iType2 == null) {
            return null;
        }
        return iType2.getField(string);
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute("input");
            if (string != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                if (object == null || !object.exists() || object.getElementType() != 8) {
                    return ScriptableRefactoring.createInputFatalStatus(object, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.field");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fField = (IField)object;
            object = javaRefactoringArguments.getAttribute("name");
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName((String)object);
            String string2 = javaRefactoringArguments.getAttribute("references");
            if (string2 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.fUpdateReferences = Boolean.valueOf(string2);
            String string3 = javaRefactoringArguments.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
            if (string3 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
            }
            this.fUpdateTextualMatches = Boolean.valueOf(string3);
            String string4 = javaRefactoringArguments.getAttribute(ATTRIBUTE_RENAME_GETTER);
            this.fRenameGetter = string4 != null ? Boolean.valueOf(string4) : false;
            String string5 = javaRefactoringArguments.getAttribute(ATTRIBUTE_RENAME_SETTER);
            this.fRenameSetter = string5 != null ? Boolean.valueOf(string5) : false;
            String string6 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DELEGATE);
            this.fDelegateUpdating = string6 != null ? Boolean.valueOf(string6) : false;
            String string7 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DEPRECATE);
            this.fDelegateDeprecation = string7 != null ? Boolean.valueOf(string7) : false;
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public String getDelegateUpdatingTitle(boolean bl) {
        if (bl) {
            return RefactoringCoreMessages.DelegateFieldCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateFieldCreator_keep_original_renamed_singular;
    }
}

