/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameLocalVariableDescriptor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class RenameLocalVariableProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private ILocalVariable fLocalVariable;
    private ICompilationUnit fCu;
    private boolean fUpdateReferences;
    private String fCurrentName;
    private String fNewName;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private TextChange fChange;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private TextChangeManager fChangeManager;
    private RenameAnalyzeUtil.LocalAnalyzePackage fLocalAnalyzePackage;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameLocalVariableProcessor";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RenameLocalVariableProcessor(ILocalVariable iLocalVariable) {
        this.fLocalVariable = iLocalVariable;
        this.fUpdateReferences = true;
        if (iLocalVariable != null) {
            this.fCu = (ICompilationUnit)iLocalVariable.getAncestor(5);
        }
        this.fNewName = "";
        this.fIsComposite = false;
    }

    RenameLocalVariableProcessor(ILocalVariable iLocalVariable, TextChangeManager textChangeManager, CompilationUnit compilationUnit, GroupCategorySet groupCategorySet) {
        this(iLocalVariable);
        this.fChangeManager = textChangeManager;
        this.fCategorySet = groupCategorySet;
        this.fCompilationUnitNode = compilationUnit;
        this.fIsComposite = true;
    }

    protected final String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fLocalVariable);
    }

    public Object[] getElements() {
        return new Object[]{this.fLocalVariable};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTempRefactoring_rename;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fLocalVariable);
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public String getCurrentElementName() {
        return this.fCurrentName;
    }

    public String getNewElementName() {
        return this.fNewName;
    }

    public void setNewElementName(String string) {
        Assert.isNotNull((Object)string);
        this.fNewName = string;
    }

    public Object getNewElement() {
        return null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        this.initAST();
        if (this.fTempDeclarationNode == null || this.fTempDeclarationNode.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_must_select_local);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.Initializer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz2)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_only_in_methods_and_initializers);
            }
        }
        this.initNames();
        return new RefactoringStatus();
    }

    private void initAST() throws JavaModelException {
        ISourceRange iSourceRange;
        ASTNode aSTNode;
        if (!this.fIsComposite) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, null);
        }
        if ((aSTNode = NodeFinder.perform((ASTNode)this.fCompilationUnitNode, iSourceRange = this.fLocalVariable.getNameRange())) == null) {
            return;
        }
        if (aSTNode.getParent() instanceof VariableDeclaration) {
            this.fTempDeclarationNode = (VariableDeclaration)aSTNode.getParent();
        }
    }

    private void initNames() {
        this.fCurrentName = this.fTempDeclarationNode.getName().getIdentifier();
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications renameModifications = new RenameModifications();
        renameModifications.rename(this.fLocalVariable, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return renameModifications;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[]{ResourceUtil.getFile(this.fCu)};
    }

    public int getSaveMode() {
        return 5;
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            try {
                iProgressMonitor.beginTask("", 1);
                refactoringStatus = this.checkNewElementName(this.fNewName);
                if (!refactoringStatus.hasFatalError()) break block6;
                refactoringStatus2 = refactoringStatus;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var5_8 = null;
                    iProgressMonitor.done();
                    if (!this.fIsComposite) break block7;
                    this.fChange = null;
                    this.fCompilationUnitNode = null;
                    this.fTempDeclarationNode = null;
                }
                throw throwable;
            }
            iProgressMonitor.done();
            if (this.fIsComposite) {
                this.fChange = null;
                this.fCompilationUnitNode = null;
                this.fTempDeclarationNode = null;
            }
            return refactoringStatus2;
        }
        this.createEdits();
        if (!this.fIsComposite) {
            RenameAnalyzeUtil.LocalAnalyzePackage[] localAnalyzePackageArray = new RenameAnalyzeUtil.LocalAnalyzePackage[]{this.fLocalAnalyzePackage};
            refactoringStatus.merge(RenameAnalyzeUtil.analyzeLocalRenames(localAnalyzePackageArray, this.fChange, this.fCompilationUnitNode, true));
        }
        RefactoringStatus refactoringStatus3 = refactoringStatus;
        Object var5_7 = null;
        iProgressMonitor.done();
        if (this.fIsComposite) {
            this.fChange = null;
            this.fCompilationUnitNode = null;
            this.fTempDeclarationNode = null;
        }
        return refactoringStatus3;
    }

    public RefactoringStatus checkNewElementName(String string) throws JavaModelException {
        RefactoringStatus refactoringStatus = Checks.checkFieldName(string);
        if (!Checks.startsWithLowerCase(string)) {
            if (this.fIsComposite) {
                String string2 = this.fLocalVariable.getParent() instanceof IMethod ? this.fLocalVariable.getParent().getElementName() : RefactoringCoreMessages.JavaElementUtil_initializer;
                String string3 = this.fLocalVariable.getAncestor(7).getElementName();
                refactoringStatus.addWarning(Messages.format(RefactoringCoreMessages.RenameTempRefactoring_lowercase2, new String[]{string, string2, string3}));
            } else {
                refactoringStatus.addWarning(RefactoringCoreMessages.RenameTempRefactoring_lowercase);
            }
        }
        return refactoringStatus;
    }

    private void createEdits() {
        TextEdit textEdit = this.createRenameEdit(this.fTempDeclarationNode.getName().getStartPosition());
        TextEdit[] textEditArray = this.getAllRenameEdits(textEdit);
        TextEdit[] textEditArray2 = new TextEdit[textEditArray.length];
        TextEdit textEdit2 = null;
        this.fChange = new CompilationUnitChange(RefactoringCoreMessages.RenameTempRefactoring_rename, this.fCu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        this.fChange.setEdit((TextEdit)multiTextEdit);
        this.fChange.setKeepPreviewEdits(true);
        int n = 0;
        while (n < textEditArray.length) {
            if (this.fIsComposite) {
                TextChangeCompatibility.addTextEdit(this.fChangeManager.get(this.fCu), RefactoringCoreMessages.RenameTempRefactoring_changeName, textEditArray[n].copy(), this.fCategorySet);
                textEditArray2[n] = textEditArray[n].copy();
                if (textEditArray[n].equals((Object)textEdit)) {
                    textEdit2 = textEditArray2[n];
                }
            }
            multiTextEdit.addChild(textEditArray[n]);
            this.fChange.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.RenameTempRefactoring_changeName, textEditArray[n]));
            ++n;
        }
        this.fLocalAnalyzePackage = this.fIsComposite ? new RenameAnalyzeUtil.LocalAnalyzePackage(textEdit2, textEditArray2) : new RenameAnalyzeUtil.LocalAnalyzePackage(textEdit, textEditArray);
    }

    private TextEdit[] getAllRenameEdits(TextEdit textEdit) {
        if (!this.fUpdateReferences) {
            return new TextEdit[]{textEdit};
        }
        TempOccurrenceAnalyzer tempOccurrenceAnalyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, true);
        tempOccurrenceAnalyzer.perform();
        int[] nArray = tempOccurrenceAnalyzer.getReferenceAndJavadocOffsets();
        TextEdit[] textEditArray = new TextEdit[nArray.length + 1];
        int n = 0;
        while (n < nArray.length) {
            textEditArray[n] = this.createRenameEdit(nArray[n]);
            ++n;
        }
        textEditArray[nArray.length] = textEdit;
        return textEditArray;
    }

    private TextEdit createRenameEdit(int n) {
        return new ReplaceEdit(n, this.fCurrentName.length(), this.fNewName);
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        TextChange textChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.RenameTypeProcessor_creating_changes, 1);
            Object object = this.fChange;
            if (object != null) {
                ISourceRange iSourceRange = this.fLocalVariable.getNameRange();
                String string = null;
                IJavaProject iJavaProject = this.fCu.getJavaProject();
                if (iJavaProject != null) {
                    string = iJavaProject.getElementName();
                }
                String string2 = Messages.format(RefactoringCoreMessages.RenameLocalVariableProcessor_descriptor_description, new String[]{this.fCurrentName, JavaElementLabels.getElementLabel(this.fLocalVariable.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.fNewName});
                String string3 = Messages.format(RefactoringCoreMessages.RenameLocalVariableProcessor_descriptor_description_short, this.fCurrentName);
                String string4 = new JDTRefactoringDescriptorComment(string, this, string2).asString();
                RenameLocalVariableDescriptor renameLocalVariableDescriptor = new RenameLocalVariableDescriptor();
                renameLocalVariableDescriptor.setProject(string);
                renameLocalVariableDescriptor.setDescription(string3);
                renameLocalVariableDescriptor.setComment(string4);
                renameLocalVariableDescriptor.setFlags(0);
                renameLocalVariableDescriptor.setCompilationUnit(this.fCu);
                renameLocalVariableDescriptor.setNewName(this.getNewElementName());
                renameLocalVariableDescriptor.setSelection(iSourceRange);
                renameLocalVariableDescriptor.setUpdateReferences(this.fUpdateReferences);
                RefactoringDescriptorChange refactoringDescriptorChange = new RefactoringDescriptorChange((RefactoringDescriptor)renameLocalVariableDescriptor, RefactoringCoreMessages.RenameTempRefactoring_rename, new Change[]{object});
                refactoringDescriptorChange.markAsSynthetic();
                object = refactoringDescriptorChange;
            }
            textChange = object;
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return textChange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (!(refactoringArguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
        String string2 = javaRefactoringArguments.getAttribute("input");
        if (string2 == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
        if (iJavaElement == null || !iJavaElement.exists()) return ScriptableRefactoring.createInputFatalStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.local.variable");
        if (iJavaElement.getElementType() == 5) {
            this.fCu = (ICompilationUnit)iJavaElement;
        } else {
            if (iJavaElement.getElementType() != 14) return ScriptableRefactoring.createInputFatalStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.local.variable");
            this.fLocalVariable = (ILocalVariable)iJavaElement;
            this.fCu = (ICompilationUnit)this.fLocalVariable.getAncestor(5);
            if (this.fCu == null) {
                return ScriptableRefactoring.createInputFatalStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.local.variable");
            }
        }
        String string3 = javaRefactoringArguments.getAttribute("name");
        if (string3 == null || "".equals(string3)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(string3);
        if (this.fCu != null && this.fLocalVariable == null) {
            string = javaRefactoringArguments.getAttribute("selection");
            if (string == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            int n = -1;
            int n2 = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreTokens()) {
                n = Integer.valueOf(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.valueOf(stringTokenizer.nextToken());
            }
            if (n < 0 || n2 < 0) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string, "selection"}));
            try {
                IJavaElement[] iJavaElementArray = this.fCu.codeSelect(n, n2);
                if (iJavaElementArray != null) {
                    int n3 = 0;
                    while (n3 < iJavaElementArray.length) {
                        IJavaElement iJavaElement2 = iJavaElementArray[n3];
                        if (iJavaElement2 instanceof ILocalVariable) {
                            this.fLocalVariable = (ILocalVariable)iJavaElement2;
                        }
                        ++n3;
                    }
                }
                if (this.fLocalVariable == null) {
                    return ScriptableRefactoring.createInputFatalStatus(null, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.local.variable");
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        if ((string = javaRefactoringArguments.getAttribute("references")) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    public RenameAnalyzeUtil.LocalAnalyzePackage getLocalAnalyzePackage() {
        return this.fLocalAnalyzePackage;
    }
}

