/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameResourceDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public class RenameResourceProcessor
extends RenameProcessor
implements IScriptableRefactoring,
ICommentProvider,
INameUpdating {
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameResourceProcessor";
    private String fComment;
    private String fNewElementName;
    private RenameModifications fRenameModifications;
    private IResource fResource;
    static /* synthetic */ Class class$0;

    public RenameResourceProcessor(IResource iResource) {
        this.fResource = iResource;
        if (iResource != null) {
            this.setNewElementName(iResource.getName());
        }
    }

    public boolean canEnableComment() {
        return true;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        iProgressMonitor.beginTask("", 1);
        try {
            this.fRenameModifications = new RenameModifications();
            this.fRenameModifications.rename(this.fResource, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker resourceChangeChecker = (ResourceChangeChecker)checkConditionsContext.getChecker((Class)clazz);
            IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = resourceChangeChecker.getDeltaFactory();
            this.fRenameModifications.buildDelta(iResourceChangeDescriptionFactory);
            refactoringStatus = new RefactoringStatus();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        return RefactoringStatus.create((IStatus)Resources.checkInSync(this.fResource));
    }

    public RefactoringStatus checkNewElementName(String string) throws JavaModelException {
        Assert.isNotNull((Object)string, (String)"new name");
        IContainer iContainer = this.fResource.getParent();
        if (iContainer == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_Internal_Error);
        }
        if (iContainer.findMember(string) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_alread_exists);
        }
        if (!iContainer.getFullPath().isValidSegment(string)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_invalidName);
        }
        RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)iContainer.getWorkspace().validateName(string, this.fResource.getType()));
        if (!refactoringStatus.hasFatalError()) {
            refactoringStatus.merge(RefactoringStatus.create((IStatus)iContainer.getWorkspace().validatePath(this.createNewPath(string), this.fResource.getType())));
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws JavaModelException {
        DynamicValidationStateChange dynamicValidationStateChange;
        iProgressMonitor.beginTask("", 1);
        try {
            String string = null;
            if (this.fResource.getType() != 4) {
                string = this.fResource.getProject().getName();
            }
            String string2 = Messages.format(RefactoringCoreMessages.RenameResourceChange_descriptor_description, new String[]{this.fResource.getFullPath().toString(), this.getNewElementName()});
            String string3 = Messages.format(RefactoringCoreMessages.RenameResourceChange_descriptor_description_short, this.fResource.getName());
            String string4 = new JDTRefactoringDescriptorComment(string, this, string2).asString();
            RenameResourceDescriptor renameResourceDescriptor = new RenameResourceDescriptor();
            renameResourceDescriptor.setProject(string);
            renameResourceDescriptor.setDescription(string3);
            renameResourceDescriptor.setComment(string4);
            renameResourceDescriptor.setFlags(7);
            renameResourceDescriptor.setResource(this.fResource);
            renameResourceDescriptor.setNewName(this.getNewElementName());
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameResourceChange((RefactoringDescriptor)renameResourceDescriptor, this.fResource, this.getNewElementName(), string4));
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationStateChange;
    }

    private String createNewPath(String string) {
        return this.fResource.getFullPath().removeLastSegments(1).append(string).toString();
    }

    public String[] getAffectedProjectNatures() throws CoreException {
        return ResourceProcessors.computeAffectedNatures(this.fResource);
    }

    public String getComment() {
        return this.fComment;
    }

    public String getCurrentElementName() {
        return this.fResource.getName();
    }

    public Object[] getElements() {
        return new Object[]{this.fResource};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public Object getNewElement() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.createNewPath(this.getNewElementName()));
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameResourceProcessor_name;
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute("input");
            if (string2 != null) {
                this.fResource = JDTRefactoringDescriptor.handleToResource(javaRefactoringArguments.getProject(), string2);
                if (this.fResource == null || !this.fResource.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(this.fResource, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.resource");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            string = javaRefactoringArguments.getAttribute("name");
            if (string == null || "".equals(string)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName(string);
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws JavaModelException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fResource);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, SharableParticipants sharableParticipants) throws CoreException {
        return this.fRenameModifications.loadParticipants(refactoringStatus, (RefactoringProcessor)this, this.getAffectedProjectNatures(), sharableParticipants);
    }

    public void setComment(String string) {
        this.fComment = string;
    }

    public void setNewElementName(String string) {
        Assert.isNotNull((Object)string);
        this.fNewElementName = string;
    }
}

