/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class RenameTypeParameterProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameTypeParameterProcessor";
    private Change fChange = null;
    private ITypeParameter fTypeParameter;
    private boolean fUpdateReferences = true;

    public RenameTypeParameterProcessor(ITypeParameter iTypeParameter) {
        this.fTypeParameter = iTypeParameter;
        if (iTypeParameter != null) {
            this.setNewElementName(iTypeParameter.getElementName());
        }
    }

    public final boolean canEnableUpdateReferences() {
        return true;
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications renameModifications = new RenameModifications();
        renameModifications.rename(this.fTypeParameter, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return renameModifications;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[]{ResourceUtil.getFile(this.fTypeParameter.getDeclaringMember().getCompilationUnit())};
    }

    public int getSaveMode() {
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        block4: {
            RefactoringStatus refactoringStatus2;
            block5: {
                Assert.isNotNull((Object)iProgressMonitor);
                Assert.isNotNull((Object)checkConditionsContext);
                refactoringStatus = new RefactoringStatus();
                try {
                    iProgressMonitor.beginTask("", 5);
                    iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_checking);
                    refactoringStatus.merge(Checks.checkIfCuBroken(this.fTypeParameter.getDeclaringMember()));
                    iProgressMonitor.worked(1);
                    if (refactoringStatus.hasFatalError()) break block4;
                    refactoringStatus.merge(this.checkNewElementName(this.getNewElementName()));
                    iProgressMonitor.worked(1);
                    iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_searching);
                    refactoringStatus.merge(this.createRenameChanges((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2)));
                    iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_checking);
                    if (refactoringStatus.hasFatalError()) {
                        refactoringStatus2 = refactoringStatus;
                        Object var4_5 = null;
                        break block5;
                    }
                    iProgressMonitor.worked(1);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        Object var4_7 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public final RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)iProgressMonitor);
        if (!this.fTypeParameter.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_deleted, this.fTypeParameter.getDeclaringMember().getCompilationUnit().getElementName()));
        }
        return Checks.checkIfCuBroken(this.fTypeParameter.getDeclaringMember());
    }

    public final RefactoringStatus checkNewElementName(String string) throws CoreException {
        IMember iMember;
        Assert.isNotNull((Object)string);
        RefactoringStatus refactoringStatus = Checks.checkTypeParameterName(string);
        if (Checks.startsWithLowerCase(string)) {
            refactoringStatus.addWarning(RefactoringCoreMessages.RenameTypeParameterRefactoring_should_start_lowercase);
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fTypeParameter, string)) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_another_name);
        }
        if ((iMember = this.fTypeParameter.getDeclaringMember()) instanceof IType) {
            IType iType = (IType)iMember;
            if (iType.getTypeParameter(string).exists()) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_class_type_parameter_already_defined);
            }
        } else if (iMember instanceof IMethod) {
            IMethod iMethod = (IMethod)iMember;
            if (iMethod.getTypeParameter(string).exists()) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_method_type_parameter_already_defined);
            }
        } else {
            JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + iMember.getClass().getName());
            Assert.isTrue((boolean)false);
        }
        return refactoringStatus;
    }

    public final Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        Change change;
        Assert.isNotNull((Object)iProgressMonitor);
        try {
            Object object = this.fChange;
            if (object != null) {
                String string = null;
                IJavaProject iJavaProject = this.fTypeParameter.getJavaProject();
                if (iJavaProject != null) {
                    string = iJavaProject.getElementName();
                }
                String string2 = Messages.format(RefactoringCoreMessages.RenameTypeParameterProcessor_descriptor_description_short, this.fTypeParameter.getElementName());
                String string3 = Messages.format(RefactoringCoreMessages.RenameTypeParameterProcessor_descriptor_description, new String[]{this.fTypeParameter.getElementName(), JavaElementLabels.getElementLabel((IJavaElement)this.fTypeParameter.getDeclaringMember(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
                String string4 = new JDTRefactoringDescriptorComment(string, this, string3).asString();
                RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.type.parameter");
                renameJavaElementDescriptor.setProject(string);
                renameJavaElementDescriptor.setDescription(string2);
                renameJavaElementDescriptor.setComment(string4);
                renameJavaElementDescriptor.setFlags(0);
                renameJavaElementDescriptor.setJavaElement((IJavaElement)this.fTypeParameter);
                renameJavaElementDescriptor.setNewName(this.getNewElementName());
                renameJavaElementDescriptor.setUpdateReferences(this.fUpdateReferences);
                object = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenameTypeParameterProcessor_change_name, new Change[]{object});
            }
            change = object;
            Object var9_10 = null;
            this.fChange = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.fChange = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return change;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus createRenameChanges(IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iProgressMonitor);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.RenameTypeParameterRefactoring_searching, 2);
            ICompilationUnit iCompilationUnit = this.fTypeParameter.getDeclaringMember().getCompilationUnit();
            CompilationUnit compilationUnit = RefactoringASTParser.parseWithASTProvider((ITypeRoot)iCompilationUnit, true, null);
            CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(iCompilationUnit, compilationUnit);
            IMember iMember = this.fTypeParameter.getDeclaringMember();
            MethodDeclaration methodDeclaration = null;
            if (iMember instanceof IMethod) {
                methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)iMember, compilationUnit);
            } else if (iMember instanceof IType) {
                methodDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)iMember, compilationUnit);
            } else {
                JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + iMember.getClass().getName());
                Assert.isTrue((boolean)false);
            }
            iProgressMonitor.worked(1);
            RenameTypeParameterVisitor renameTypeParameterVisitor = new RenameTypeParameterVisitor(compilationUnitRewrite, this.fTypeParameter.getNameRange(), refactoringStatus);
            if (methodDeclaration != null) {
                methodDeclaration.accept((ASTVisitor)renameTypeParameterVisitor);
            }
            this.fChange = renameTypeParameterVisitor.getResult();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    protected final String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fTypeParameter);
    }

    public final String getCurrentElementName() {
        return this.fTypeParameter.getElementName();
    }

    public final Object[] getElements() {
        return new Object[]{this.fTypeParameter};
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final Object getNewElement() throws CoreException {
        IMember iMember = this.fTypeParameter.getDeclaringMember();
        if (iMember instanceof IType) {
            IType iType = (IType)iMember;
            return iType.getTypeParameter(this.getNewElementName());
        }
        if (iMember instanceof IMethod) {
            IMethod iMethod = (IMethod)iMember;
            return iMethod.getTypeParameter(this.getNewElementName());
        }
        JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + iMember.getClass().getName());
        Assert.isTrue((boolean)false);
        return null;
    }

    public final String getProcessorName() {
        return RefactoringCoreMessages.RenameTypeParameterProcessor_name;
    }

    public final boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public final RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_PARAMETER);
            if (string2 == null || "".equals(string2)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PARAMETER));
            }
            String string3 = javaRefactoringArguments.getAttribute("input");
            if (string3 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string3, false);
                if (object == null || !object.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(object, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.type.parameter");
                }
                if (object instanceof IMethod) {
                    this.fTypeParameter = ((IMethod)object).getTypeParameter(string2);
                } else if (object instanceof IType) {
                    this.fTypeParameter = ((IType)object).getTypeParameter(string2);
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string3, "input"}));
                }
                if (this.fTypeParameter == null || !this.fTypeParameter.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(this.fTypeParameter, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.type.parameter");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            object = javaRefactoringArguments.getAttribute("name");
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName((String)object);
            string = javaRefactoringArguments.getAttribute("references");
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fUpdateReferences = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    public final boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fTypeParameter);
    }

    public final void setUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public final class RenameTypeParameterVisitor
    extends ASTVisitor {
        private final IBinding fBinding;
        private final SimpleName fName;
        private final CompilationUnitRewrite fRewrite;
        private final RefactoringStatus fStatus;

        public RenameTypeParameterVisitor(CompilationUnitRewrite compilationUnitRewrite, ISourceRange iSourceRange, RefactoringStatus refactoringStatus) {
            super(true);
            Assert.isNotNull((Object)compilationUnitRewrite);
            Assert.isNotNull((Object)iSourceRange);
            Assert.isNotNull((Object)refactoringStatus);
            this.fRewrite = compilationUnitRewrite;
            this.fName = (SimpleName)NodeFinder.perform((ASTNode)compilationUnitRewrite.getRoot(), iSourceRange);
            this.fBinding = this.fName.resolveBinding();
            this.fStatus = refactoringStatus;
        }

        public final Change getResult() throws CoreException {
            return this.fRewrite.createChange();
        }

        public final boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            String string = annotationTypeDeclaration.getName().getIdentifier();
            if (string.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{string}), JavaStatusContext.create((ITypeRoot)RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), new SourceRange((ASTNode)annotationTypeDeclaration)));
                return false;
            }
            return true;
        }

        public final boolean visit(EnumDeclaration enumDeclaration) {
            String string = enumDeclaration.getName().getIdentifier();
            if (string.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{string}), JavaStatusContext.create((ITypeRoot)RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), new SourceRange((ASTNode)enumDeclaration)));
                return false;
            }
            return true;
        }

        public final boolean visit(SimpleName simpleName) {
            ITypeBinding iTypeBinding = simpleName.resolveTypeBinding();
            if (iTypeBinding != null && iTypeBinding.isTypeVariable() && Bindings.equals((IBinding)iTypeBinding, this.fBinding) && simpleName.getIdentifier().equals(this.fName.getIdentifier())) {
                if (simpleName != this.fName) {
                    if (RenameTypeParameterProcessor.this.fUpdateReferences) {
                        this.fRewrite.getASTRewrite().set((ASTNode)simpleName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)RenameTypeParameterProcessor.this.getNewElementName(), this.fRewrite.createGroupDescription(RefactoringCoreMessages.RenameTypeParameterRefactoring_update_type_parameter_reference));
                    }
                } else {
                    this.fRewrite.getASTRewrite().set((ASTNode)simpleName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)RenameTypeParameterProcessor.this.getNewElementName(), this.fRewrite.createGroupDescription(RefactoringCoreMessages.RenameTypeParameterRefactoring_update_type_parameter_declaration));
                }
            }
            return true;
        }

        public final boolean visit(TypeDeclaration typeDeclaration) {
            String string = typeDeclaration.getName().getIdentifier();
            if (string.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{string}), JavaStatusContext.create((ITypeRoot)RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), new SourceRange((ASTNode)typeDeclaration)));
                return false;
            }
            return true;
        }
    }
}

