/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.refactoring.IJavaElementMapper;
import org.eclipse.wst.jsdt.core.refactoring.RenameTypeArguments;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.TypeReferenceMatch;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringHandleTransplanter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenamingNameSuggestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TypeOccurrenceCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.Changes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class RenameTypeProcessor
extends JavaRenameProcessor
implements ITextUpdating,
IReferenceUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper,
IJavaElementMapper {
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_MATCHING_STRATEGY = "matchStrategy";
    private static final GroupCategorySet CATEGORY_TYPE_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.renameType.type", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_type, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_type_description));
    private static final GroupCategorySet CATEGORY_METHOD_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.renameType.method", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_method, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_method_description));
    private static final GroupCategorySet CATEGORY_FIELD_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.renameType.field", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_fields, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_fields_description));
    private static final GroupCategorySet CATEGORY_LOCAL_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.renameType.local", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables_description));
    private IType fType;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameTypeProcessor";
    private boolean fUpdateSimilarElements;
    private Map fFinalSimilarElementToName = null;
    private int fRenamingStrategy;
    private LinkedHashMap fPreloadedElementToName = null;
    private Map fPreloadedElementToSelection = null;
    private LinkedHashMap fPreloadedElementToNameDefault = null;
    private String fCachedNewName = null;
    private boolean fCachedRenameSimilarElements = false;
    private int fCachedRenamingStrategy = -1;
    private RefactoringStatus fCachedRefactoringStatus = null;
    static /* synthetic */ Class class$0;

    public RenameTypeProcessor(IType iType) {
        this.fType = iType;
        if (iType != null) {
            this.setNewElementName(iType.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fUpdateSimilarElements = false;
        this.fRenamingStrategy = 1;
    }

    public IType getType() {
        return this.fType;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fType);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTypeRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fType);
    }

    public Object[] getElements() {
        return new Object[]{this.fType};
    }

    protected RenameModifications computeRenameModifications() {
        RenameModifications renameModifications = new RenameModifications();
        renameModifications.rename(this.fType, new RenameTypeArguments(this.getNewElementName(), this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements()), this.createParticipantDescriptorFilter());
        if (this.isPrimaryType()) {
            ICompilationUnit iCompilationUnit = this.fType.getCompilationUnit();
            String string = this.getNewCompilationUnit().getElementName();
            renameModifications.rename(iCompilationUnit, new RenameArguments(string, this.getUpdateReferences()));
        }
        return renameModifications;
    }

    private boolean isPrimaryType() {
        String string = this.fType.getCompilationUnit().getElementName();
        String string2 = this.fType.getElementName();
        return Checks.isTopLevel(this.fType) && JavaCore.removeJavaLikeExtension((String)string).equals(string2);
    }

    public String getCurrentElementName() {
        return this.fType.getElementName();
    }

    public String getCurrentElementQualifier() {
        return JavaModelUtil.getTypeContainerName(this.fType);
    }

    public RefactoringStatus checkNewElementName(String string) {
        Assert.isNotNull((Object)string, (String)"new name");
        RefactoringStatus refactoringStatus = Checks.checkTypeName(string);
        if (Checks.isAlreadyNamed((IJavaElement)this.fType, string)) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.RenameTypeRefactoring_choose_another_name);
        }
        return refactoringStatus;
    }

    public Object getNewElement() {
        if (Checks.isTopLevel(this.fType)) {
            return this.getNewCompilationUnit().getType(this.getNewElementName());
        }
        return this.fType.getDeclaringType().getType(this.getNewElementName());
    }

    private ICompilationUnit getNewCompilationUnit() {
        ICompilationUnit iCompilationUnit = this.fType.getCompilationUnit();
        if (this.isPrimaryType()) {
            IPackageFragment iPackageFragment = this.fType.getPackageFragment();
            String string = JavaModelUtil.getRenamedCUName(iCompilationUnit, this.getNewElementName());
            return iPackageFragment.getCompilationUnit(string);
        }
        return iCompilationUnit;
    }

    protected RenameArguments createRenameArguments() {
        return new RenameTypeArguments(this.getNewElementName(), this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
    }

    protected IParticipantDescriptorFilter createParticipantDescriptorFilter() {
        if (!this.getUpdateSimilarDeclarations()) {
            return null;
        }
        return new ParticipantDescriptorFilter();
    }

    protected IFile[] getChangedFiles() throws CoreException {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        arrayList.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.fQualifiedNameSearchResult != null) {
            arrayList.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        if (this.willRenameCU()) {
            arrayList.add(ResourceUtil.getFile(this.fType.getCompilationUnit()));
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    public int getSaveMode() {
        return 3;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean bl) {
        this.fUpdateTextualMatches = bl;
    }

    public void setUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fType.getPackageFragment().isDefaultPackage() && !(this.fType.getParent() instanceof IType);
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean bl) {
        this.fUpdateQualifiedNames = bl;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String string) {
        Assert.isNotNull((Object)string);
        this.fFilePatterns = string;
    }

    public boolean canEnableSimilarDeclarationUpdating() {
        String string;
        IProduct iProduct = Platform.getProduct();
        return iProduct == null || !"false".equalsIgnoreCase(string = iProduct.getProperty("org.eclipse.wst.jsdt.ui.refactoring.handlesSimilarDeclarations"));
    }

    public void setUpdateSimilarDeclarations(boolean bl) {
        this.fUpdateSimilarElements = bl;
    }

    public boolean getUpdateSimilarDeclarations() {
        return this.fUpdateSimilarElements;
    }

    public int getMatchStrategy() {
        return this.fRenamingStrategy;
    }

    public void setMatchStrategy(int n) {
        this.fRenamingStrategy = n;
    }

    public IJavaElement[] getSimilarElements() {
        if (this.fFinalSimilarElementToName == null) {
            return null;
        }
        Set set = this.fFinalSimilarElementToName.keySet();
        return set.toArray(new IJavaElement[set.size()]);
    }

    public IResource getRefactoredResource(IResource iResource) {
        if (iResource instanceof IFile && Checks.isTopLevel(this.fType) && iResource.equals((Object)this.fType.getResource())) {
            return this.getNewCompilationUnit().getResource();
        }
        return iResource;
    }

    public IJavaElement getRefactoredJavaElement(IJavaElement iJavaElement) {
        if (iJavaElement instanceof ICompilationUnit) {
            if (Checks.isTopLevel(this.fType) && iJavaElement.equals(this.fType.getCompilationUnit())) {
                return this.getNewCompilationUnit();
            }
        } else if (iJavaElement instanceof IMember) {
            IType iType = (IType)this.getNewElement();
            RefactoringHandleTransplanter refactoringHandleTransplanter = new RefactoringHandleTransplanter(this.fType, iType, this.fFinalSimilarElementToName);
            return refactoringHandleTransplanter.transplantHandle((IMember)iJavaElement);
        }
        return iJavaElement;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        IType iType = (IType)this.fType.getPrimaryElement();
        if (iType == null || !iType.exists()) {
            String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_does_not_exist, new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.fType.getCompilationUnit().getElementName()});
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        this.fType = iType;
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        int n;
        int n2;
        RefactoringStatus refactoringStatus;
        block21: {
            int n3;
            block20: {
                int n4;
                int n5;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                RefactoringStatus refactoringStatus2;
                                Assert.isNotNull((Object)this.fType, (String)"type");
                                Assert.isNotNull((Object)this.getNewElementName(), (String)"newName");
                                refactoringStatus = new RefactoringStatus();
                                n5 = this.fUpdateReferences || this.fUpdateSimilarElements ? 15 : 0;
                                n4 = this.fUpdateReferences || this.fUpdateSimilarElements ? 10 : 1;
                                n3 = this.fUpdateSimilarElements ? 85 : 0;
                                n2 = 5;
                                n = this.fUpdateQualifiedNames ? 50 : 0;
                                try {
                                    iProgressMonitor.beginTask("", 12 + n5 + n4 + n3 + n2 + n);
                                    iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_checking);
                                    this.fChangeManager = new TextChangeManager(true);
                                    refactoringStatus.merge(this.checkNewElementName(this.getNewElementName()));
                                    if (!refactoringStatus.hasFatalError()) break block16;
                                    refactoringStatus2 = refactoringStatus;
                                    Object var9_16 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_23 = null;
                                    iProgressMonitor.done();
                                    throw throwable;
                                }
                                iProgressMonitor.done();
                                return refactoringStatus2;
                            }
                            refactoringStatus.merge(Checks.checkIfCuBroken((IMember)this.fType));
                            if (!refactoringStatus.hasFatalError()) break block17;
                            RefactoringStatus refactoringStatus3 = refactoringStatus;
                            Object var9_17 = null;
                            iProgressMonitor.done();
                            return refactoringStatus3;
                        }
                        iProgressMonitor.worked(1);
                        refactoringStatus.merge(this.checkTypesInCompilationUnit());
                        iProgressMonitor.worked(1);
                        refactoringStatus.merge(this.checkForMethodsWithConstructorNames());
                        iProgressMonitor.worked(1);
                        refactoringStatus.merge(this.checkImportedTypes());
                        iProgressMonitor.worked(1);
                        if (Checks.isTopLevel(this.fType) && JdtFlags.isPublic((IMember)this.fType)) {
                            refactoringStatus.merge(Checks.checkCompilationUnitNewName(this.fType.getCompilationUnit(), this.getNewElementName()));
                        }
                        iProgressMonitor.worked(1);
                        if (this.isPrimaryType()) {
                            refactoringStatus.merge(this.checkNewPathValidity());
                        }
                        iProgressMonitor.worked(1);
                        refactoringStatus.merge(this.checkEnclosingTypes());
                        iProgressMonitor.worked(1);
                        refactoringStatus.merge(this.checkEnclosedTypes());
                        iProgressMonitor.worked(1);
                        refactoringStatus.merge(this.checkTypesInPackage());
                        iProgressMonitor.worked(1);
                        refactoringStatus.merge(this.checkTypesImportedInCu());
                        iProgressMonitor.worked(1);
                        refactoringStatus.merge(Checks.checkForMainAndNativeMethods(this.fType));
                        iProgressMonitor.worked(1);
                        if (!refactoringStatus.hasFatalError()) break block18;
                        RefactoringStatus refactoringStatus4 = refactoringStatus;
                        Object var9_18 = null;
                        iProgressMonitor.done();
                        return refactoringStatus4;
                    }
                    refactoringStatus.merge(this.analyseEnclosedTypes());
                    iProgressMonitor.worked(1);
                    if (!refactoringStatus.hasFatalError()) break block19;
                    RefactoringStatus refactoringStatus5 = refactoringStatus;
                    Object var9_19 = null;
                    iProgressMonitor.done();
                    return refactoringStatus5;
                }
                if (this.fUpdateReferences || this.fUpdateSimilarElements) {
                    iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_searching);
                    refactoringStatus.merge(this.initializeReferences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n5)));
                } else {
                    this.fReferences = new SearchResultGroup[0];
                }
                iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_checking);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.fUpdateReferences || this.fUpdateSimilarElements) {
                    refactoringStatus.merge(this.analyzeAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n4)));
                } else {
                    Checks.checkCompileErrorsInAffectedFile(refactoringStatus, this.fType.getResource());
                    iProgressMonitor.worked(n4);
                }
                if (!refactoringStatus.hasFatalError()) break block20;
                RefactoringStatus refactoringStatus6 = refactoringStatus;
                Object var9_20 = null;
                iProgressMonitor.done();
                return refactoringStatus6;
            }
            if (!this.fUpdateSimilarElements) break block21;
            refactoringStatus.merge(this.initializeSimilarElementsRenameProcessors((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3), checkConditionsContext));
            if (!refactoringStatus.hasFatalError()) break block21;
            RefactoringStatus refactoringStatus7 = refactoringStatus;
            Object var9_21 = null;
            iProgressMonitor.done();
            return refactoringStatus7;
        }
        this.createChanges((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
        if (this.fUpdateQualifiedNames) {
            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n));
        }
        RefactoringStatus refactoringStatus8 = refactoringStatus;
        Object var9_22 = null;
        iProgressMonitor.done();
        return refactoringStatus8;
    }

    public RefactoringStatus initializeReferences(IProgressMonitor iProgressMonitor) throws JavaModelException, OperationCanceledException {
        Assert.isNotNull((Object)this.fType);
        Assert.isNotNull((Object)this.getNewElementName());
        if (this.fReferences != null && this.getNewElementName().equals(this.fCachedNewName) && this.fCachedRenameSimilarElements == this.getUpdateSimilarDeclarations() && this.fCachedRenamingStrategy == this.fRenamingStrategy) {
            return this.fCachedRefactoringStatus;
        }
        this.fCachedNewName = this.getNewElementName();
        this.fCachedRenameSimilarElements = this.fUpdateSimilarElements;
        this.fCachedRenamingStrategy = this.fRenamingStrategy;
        this.fCachedRefactoringStatus = new RefactoringStatus();
        try {
            Object object;
            SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)this.fType, (int)2, (int)24);
            this.fReferences = RefactoringSearchEngine.search(searchPattern, RefactoringScopeFactory.create((IJavaElement)this.fType), new TypeOccurrenceCollector(this.fType), iProgressMonitor, this.fCachedRefactoringStatus);
            this.fReferences = Checks.excludeCompilationUnits(this.fReferences, this.fCachedRefactoringStatus);
            this.fPreloadedElementToName = new LinkedHashMap();
            this.fPreloadedElementToSelection = new HashMap();
            String string = this.fType.getElementName();
            iProgressMonitor.beginTask("", this.fReferences.length);
            if (this.getUpdateSimilarDeclarations()) {
                object = new RenamingNameSuggestor(this.fRenamingStrategy);
                int n = 0;
                while (n < this.fReferences.length) {
                    ICompilationUnit iCompilationUnit = this.fReferences[n].getCompilationUnit();
                    if (iCompilationUnit != null) {
                        SearchMatch[] searchMatchArray = this.fReferences[n].getSearchResults();
                        int n2 = 0;
                        while (n2 < searchMatchArray.length) {
                            if (searchMatchArray[n2] instanceof TypeReferenceMatch) {
                                TypeReferenceMatch typeReferenceMatch = (TypeReferenceMatch)searchMatchArray[n2];
                                ArrayList<Object> arrayList = new ArrayList<Object>();
                                if (typeReferenceMatch.getLocalElement() != null) {
                                    arrayList.add(typeReferenceMatch.getLocalElement());
                                } else {
                                    arrayList.add(typeReferenceMatch.getElement());
                                }
                                IJavaElement[] iJavaElementArray = typeReferenceMatch.getOtherElements();
                                if (iJavaElementArray != null) {
                                    arrayList.addAll(Arrays.asList(iJavaElementArray));
                                }
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    boolean bl;
                                    IField iField;
                                    String string2;
                                    IJavaElement iJavaElement = (IJavaElement)iterator.next();
                                    if (!(iJavaElement instanceof IMethod) && !(iJavaElement instanceof IField) && !(iJavaElement instanceof ILocalVariable) || !this.isInDeclaredType(typeReferenceMatch.getOffset(), iJavaElement)) continue;
                                    if (iJavaElement instanceof IField && (string2 = ((RenamingNameSuggestor)object).suggestNewFieldName((iField = (IField)iJavaElement).getJavaProject(), iField.getElementName(), Flags.isStatic((int)iField.getFlags()), string, this.getNewElementName())) != null) {
                                        this.fPreloadedElementToName.put(iField, string2);
                                    }
                                    if (iJavaElement instanceof IMethod) {
                                        iField = (IMethod)iJavaElement;
                                        this.addMethodRename(string, (RenamingNameSuggestor)object, (IMethod)iField);
                                    }
                                    if (!(iJavaElement instanceof ILocalVariable)) continue;
                                    iField = (ILocalVariable)iJavaElement;
                                    if (JavaModelUtil.isParameter((ILocalVariable)iField)) {
                                        this.addMethodRename(string, (RenamingNameSuggestor)object, (IMethod)iField.getParent());
                                        bl = true;
                                    } else {
                                        bl = false;
                                    }
                                    String string3 = ((RenamingNameSuggestor)object).suggestNewLocalName(iField.getJavaProject(), iField.getElementName(), bl, string, this.getNewElementName());
                                    if (string3 == null) continue;
                                    this.fPreloadedElementToName.put(iField, string3);
                                }
                            }
                            ++n2;
                        }
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                    ++n;
                }
            }
            object = this.fPreloadedElementToName.keySet().iterator();
            while (object.hasNext()) {
                IJavaElement iJavaElement = (IJavaElement)object.next();
                this.fPreloadedElementToSelection.put(iJavaElement, Boolean.TRUE);
            }
            this.fPreloadedElementToNameDefault = (LinkedHashMap)this.fPreloadedElementToName.clone();
        }
        catch (OperationCanceledException operationCanceledException) {
            this.fReferences = null;
            this.fPreloadedElementToName = null;
            throw new OperationCanceledException();
        }
        return this.fCachedRefactoringStatus;
    }

    private boolean isInDeclaredType(int n, IJavaElement iJavaElement) throws JavaModelException {
        if (iJavaElement != null) {
            int n2 = 0;
            if (iJavaElement instanceof IMethod || iJavaElement instanceof IField) {
                n2 = ((IMember)iJavaElement).getNameRange().getOffset();
            } else if (iJavaElement instanceof ILocalVariable) {
                n2 = ((ILocalVariable)iJavaElement).getNameRange().getOffset();
            }
            return n < n2;
        }
        return false;
    }

    private void addMethodRename(String string, RenamingNameSuggestor renamingNameSuggestor, IMethod iMethod) throws JavaModelException {
        String string2;
        if (!iMethod.isConstructor() && (string2 = renamingNameSuggestor.suggestNewMethodName(iMethod.getElementName(), string, this.getNewElementName())) != null) {
            this.fPreloadedElementToName.put(iMethod, string2);
        }
    }

    private RefactoringStatus checkNewPathValidity() {
        IContainer iContainer = this.fType.getCompilationUnit().getResource().getParent();
        String string = RefactoringCoreMessages.RenameTypeRefactoring_will_not_rename;
        IStatus iStatus = iContainer.getWorkspace().validateName(this.getNewElementName(), 1);
        if (iStatus.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(iStatus.getMessage()) + ". " + string));
        }
        iStatus = iContainer.getWorkspace().validatePath(this.createNewPath(this.getNewElementName()), 1);
        if (iStatus.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(iStatus.getMessage()) + ". " + string));
        }
        return new RefactoringStatus();
    }

    private String createNewPath(String string) {
        return this.fType.getCompilationUnit().getResource().getFullPath().removeLastSegments(1).append(string).toString();
    }

    private RefactoringStatus checkTypesImportedInCu() throws CoreException {
        IImportDeclaration iImportDeclaration = RenameTypeProcessor.getImportedType(this.fType.getCompilationUnit(), this.getNewElementName());
        if (iImportDeclaration == null) {
            return null;
        }
        String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_imported, new Object[]{this.getNewElementName(), this.fType.getCompilationUnit().getResource().getFullPath()});
        IJavaElement iJavaElement = iImportDeclaration.getParent().getParent();
        if (iJavaElement instanceof ICompilationUnit) {
            return RefactoringStatus.createErrorStatus((String)string, (RefactoringStatusContext)JavaStatusContext.create(iImportDeclaration));
        }
        return null;
    }

    private RefactoringStatus checkTypesInPackage() throws CoreException {
        IType iType = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.getNewElementName());
        if (iType == null || !iType.exists()) {
            return null;
        }
        String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_exists, new String[]{this.getNewElementName(), this.fType.getPackageFragment().getElementName()});
        return RefactoringStatus.createErrorStatus((String)string, (RefactoringStatusContext)JavaStatusContext.create((IMember)iType));
    }

    private RefactoringStatus checkEnclosedTypes() throws CoreException {
        IType iType = RenameTypeProcessor.findEnclosedType(this.fType, this.getNewElementName());
        if (iType == null) {
            return null;
        }
        String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_encloses, new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.getNewElementName()});
        return RefactoringStatus.createErrorStatus((String)string, (RefactoringStatusContext)JavaStatusContext.create((IMember)iType));
    }

    private RefactoringStatus checkEnclosingTypes() {
        IType iType = RenameTypeProcessor.findEnclosingType(this.fType, this.getNewElementName());
        if (iType == null) {
            return null;
        }
        String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_enclosed, new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.getNewElementName()});
        return RefactoringStatus.createErrorStatus((String)string, (RefactoringStatusContext)JavaStatusContext.create((IMember)iType));
    }

    private static IType findEnclosedType(IType iType, String string) throws CoreException {
        IType[] iTypeArray = iType.getTypes();
        int n = 0;
        while (n < iTypeArray.length) {
            if (string.equals(iTypeArray[n].getElementName()) || RenameTypeProcessor.findEnclosedType(iTypeArray[n], string) != null) {
                return iTypeArray[n];
            }
            ++n;
        }
        return null;
    }

    private static IType findEnclosingType(IType iType, String string) {
        IType iType2 = iType.getDeclaringType();
        while (iType2 != null) {
            if (string.equals(iType2.getElementName())) {
                return iType2;
            }
            iType2 = iType2.getDeclaringType();
        }
        return null;
    }

    private static IImportDeclaration getImportedType(ICompilationUnit iCompilationUnit, String string) throws CoreException {
        IImportDeclaration[] iImportDeclarationArray = iCompilationUnit.getImports();
        String string2 = "." + string;
        int n = 0;
        while (n < iImportDeclarationArray.length) {
            if (iImportDeclarationArray[n].getElementName().endsWith(string2)) {
                return iImportDeclarationArray[n];
            }
            ++n;
        }
        return null;
    }

    private RefactoringStatus checkForMethodsWithConstructorNames() throws CoreException {
        IMethod[] iMethodArray = this.fType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            RefactoringStatus refactoringStatus;
            if (!iMethodArray[n].isConstructor() && (refactoringStatus = Checks.checkIfConstructorName(iMethodArray[n], iMethodArray[n].getElementName(), this.getNewElementName())) != null) {
                return refactoringStatus;
            }
            ++n;
        }
        return null;
    }

    private RefactoringStatus checkImportedTypes() throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IImportDeclaration[] iImportDeclarationArray = this.fType.getCompilationUnit().getImports();
        int n = 0;
        while (n < iImportDeclarationArray.length) {
            this.analyzeImportDeclaration(iImportDeclarationArray[n], refactoringStatus);
            ++n;
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkTypesInCompilationUnit() {
        IType iType;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (!Checks.isTopLevel(this.fType) && (iType = this.fType.getDeclaringType().getType(this.getNewElementName())).exists()) {
            String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_member_type_exists, new String[]{this.getNewElementName(), JavaModelUtil.getFullyQualifiedName(this.fType.getDeclaringType())});
            refactoringStatus.addError(string, JavaStatusContext.create((IMember)iType));
        }
        return refactoringStatus;
    }

    private RefactoringStatus analyseEnclosedTypes() throws CoreException {
        final ISourceRange iSourceRange = this.fType.getSourceRange();
        final RefactoringStatus refactoringStatus = new RefactoringStatus();
        CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)this.fType.getCompilationUnit(), false);
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration typeDeclaration) {
                RefactoringStatusContext refactoringStatusContext;
                if (typeDeclaration.getStartPosition() <= iSourceRange.getOffset()) {
                    return true;
                }
                if (typeDeclaration.getStartPosition() > iSourceRange.getOffset() + iSourceRange.getLength()) {
                    return true;
                }
                if (RenameTypeProcessor.this.getNewElementName().equals(typeDeclaration.getName().getIdentifier())) {
                    refactoringStatusContext = JavaStatusContext.create((ITypeRoot)RenameTypeProcessor.this.fType.getCompilationUnit(), (ASTNode)typeDeclaration);
                    String string = null;
                    if (typeDeclaration.isLocalTypeDeclaration()) {
                        string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_local_type, new String[]{JavaElementUtil.createSignature((IMember)RenameTypeProcessor.this.fType), RenameTypeProcessor.this.getNewElementName()});
                    } else if (typeDeclaration.isMemberTypeDeclaration()) {
                        string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_member_type, new String[]{JavaElementUtil.createSignature((IMember)RenameTypeProcessor.this.fType), RenameTypeProcessor.this.getNewElementName()});
                    }
                    if (string != null) {
                        refactoringStatus.addError(string, refactoringStatusContext);
                    }
                }
                refactoringStatusContext = typeDeclaration.getMethods();
                int n = 0;
                while (n < ((RefactoringStatusContext)refactoringStatusContext).length) {
                    if (Modifier.isNative((int)refactoringStatusContext[n].getModifiers())) {
                        RefactoringStatusContext refactoringStatusContext2 = JavaStatusContext.create((ITypeRoot)RenameTypeProcessor.this.fType.getCompilationUnit(), (ASTNode)refactoringStatusContext[n]);
                        String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_enclosed_type_native, typeDeclaration.getName().getIdentifier());
                        refactoringStatus.addWarning(string, refactoringStatusContext2);
                    }
                    ++n;
                }
                return true;
            }
        });
        return refactoringStatus;
    }

    private static ICompilationUnit getCompilationUnit(IImportDeclaration iImportDeclaration) {
        return (ICompilationUnit)iImportDeclaration.getParent().getParent();
    }

    private void analyzeImportedTypes(IType[] iTypeArray, RefactoringStatus refactoringStatus, IImportDeclaration iImportDeclaration) throws CoreException {
        int n = 0;
        while (n < iTypeArray.length) {
            if (JdtFlags.isPublic((IMember)iTypeArray[n]) && iTypeArray[n].getElementName().equals(this.getNewElementName())) {
                String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_name_conflict1, new Object[]{JavaModelUtil.getFullyQualifiedName(iTypeArray[n]), RenameTypeProcessor.getFullPath(RenameTypeProcessor.getCompilationUnit(iImportDeclaration))});
                refactoringStatus.addError(string, JavaStatusContext.create(iImportDeclaration));
            }
            ++n;
        }
    }

    private static IJavaElement convertFromImportDeclaration(IImportDeclaration iImportDeclaration) throws CoreException {
        if (iImportDeclaration.isOnDemand()) {
            String string = iImportDeclaration.getElementName().substring(0, iImportDeclaration.getElementName().length() - 2);
            return JavaModelUtil.findTypeContainer(iImportDeclaration.getJavaProject(), string);
        }
        return JavaModelUtil.findTypeContainer(iImportDeclaration.getJavaProject(), iImportDeclaration.getElementName());
    }

    private void analyzeImportDeclaration(IImportDeclaration iImportDeclaration, RefactoringStatus refactoringStatus) throws CoreException {
        if (!iImportDeclaration.isOnDemand()) {
            return;
        }
        IJavaElement iJavaElement = RenameTypeProcessor.convertFromImportDeclaration(iImportDeclaration);
        if (iJavaElement == null) {
            return;
        }
        if (iJavaElement instanceof IPackageFragment) {
            ICompilationUnit[] iCompilationUnitArray = ((IPackageFragment)iJavaElement).getCompilationUnits();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                this.analyzeImportedTypes(iCompilationUnitArray[n].getTypes(), refactoringStatus, iImportDeclaration);
                ++n;
            }
        } else {
            this.analyzeImportedTypes(((IType)iJavaElement).getTypes(), refactoringStatus, iImportDeclaration);
        }
    }

    private RefactoringStatus analyzeAffectedCompilationUnits(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences, this.fType.getResource()));
        iProgressMonitor.beginTask("", this.fReferences.length);
        refactoringStatus.merge(this.checkConflictingTypes(iProgressMonitor));
        return refactoringStatus;
    }

    private RefactoringStatus checkConflictingTypes(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        SearchPattern searchPattern = SearchPattern.createPattern((String)this.getNewElementName(), (int)0, (int)3, (int)24);
        ICompilationUnit[] iCompilationUnitArray = RefactoringSearchEngine.findAffectedCompilationUnits(searchPattern, iJavaSearchScope, iProgressMonitor, refactoringStatus);
        if (iCompilationUnitArray.length == 0) {
            return refactoringStatus;
        }
        ICompilationUnit[] iCompilationUnitArray2 = RenameTypeProcessor.getCus(this.fReferences);
        ICompilationUnit[] iCompilationUnitArray3 = RenameTypeProcessor.isIntersectionEmpty(iCompilationUnitArray2, iCompilationUnitArray);
        if (iCompilationUnitArray3.length == 0) {
            return refactoringStatus;
        }
        int n = 0;
        while (n < iCompilationUnitArray3.length) {
            RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iCompilationUnitArray3[n]);
            String string = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_another_type, new String[]{this.getNewElementName(), iCompilationUnitArray3[n].getElementName()});
            refactoringStatus.addError(string, refactoringStatusContext);
            ++n;
        }
        return refactoringStatus;
    }

    private static ICompilationUnit[] isIntersectionEmpty(ICompilationUnit[] iCompilationUnitArray, ICompilationUnit[] iCompilationUnitArray2) {
        HashSet<ICompilationUnit> hashSet = new HashSet<ICompilationUnit>(Arrays.asList(iCompilationUnitArray));
        HashSet<ICompilationUnit> hashSet2 = new HashSet<ICompilationUnit>(Arrays.asList(iCompilationUnitArray2));
        hashSet.retainAll(hashSet2);
        return hashSet.toArray(new ICompilationUnit[hashSet.size()]);
    }

    private static ICompilationUnit[] getCus(SearchResultGroup[] searchResultGroupArray) {
        ArrayList<ICompilationUnit> arrayList = new ArrayList<ICompilationUnit>(searchResultGroupArray.length);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            ICompilationUnit iCompilationUnit = searchResultGroupArray[n].getCompilationUnit();
            if (iCompilationUnit != null) {
                arrayList.add(iCompilationUnit);
            }
            ++n;
        }
        return arrayList.toArray(new ICompilationUnit[arrayList.size()]);
    }

    private static String getFullPath(ICompilationUnit iCompilationUnit) {
        Assert.isTrue((boolean)iCompilationUnit.exists());
        return iCompilationUnit.getResource().getFullPath().toString();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            TextChange textChange;
            iProgressMonitor.beginTask(RefactoringCoreMessages.RenameTypeRefactoring_creating_change, 4);
            String string = null;
            IJavaProject iJavaProject = this.fType.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            int n = 589826;
            try {
                if (!Flags.isPrivate((int)this.fType.getFlags())) {
                    n |= 4;
                }
                if (this.fType.isAnonymous() || this.fType.isLocal()) {
                    n |= 0x40000;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            String string2 = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_descriptor_description_short, this.fType.getElementName());
            String string3 = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fType, JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
            String string4 = new JDTRefactoringDescriptorComment(string, this, string3).asString();
            RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.type");
            renameJavaElementDescriptor.setProject(string);
            renameJavaElementDescriptor.setDescription(string2);
            renameJavaElementDescriptor.setComment(string4);
            renameJavaElementDescriptor.setFlags(n);
            renameJavaElementDescriptor.setJavaElement((IJavaElement)this.fType);
            renameJavaElementDescriptor.setNewName(this.getNewElementName());
            renameJavaElementDescriptor.setUpdateQualifiedNames(this.fUpdateQualifiedNames);
            renameJavaElementDescriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
            renameJavaElementDescriptor.setUpdateReferences(this.fUpdateReferences);
            if (this.fUpdateQualifiedNames && this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                renameJavaElementDescriptor.setFileNamePatterns(this.fFilePatterns);
            }
            renameJavaElementDescriptor.setUpdateSimilarDeclarations(this.fUpdateSimilarElements);
            renameJavaElementDescriptor.setMatchStrategy(this.fRenamingStrategy);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenameTypeProcessor_change_name);
            if (this.fChangeManager.containsChangesIn(this.fType.getCompilationUnit()) && (textChange = this.fChangeManager.get(this.fType.getCompilationUnit())) instanceof TextFileChange) {
                ((TextFileChange)textChange).setSaveMode(2);
            }
            dynamicValidationRefactoringChange.addAll((Change[])this.fChangeManager.getAllChanges());
            if (this.willRenameCU()) {
                textChange = this.fType.getCompilationUnit().getResource();
                if (textChange != null && textChange.isLinked()) {
                    String string5 = textChange.getFileExtension();
                    String string6 = string5 == null ? this.getNewElementName() : String.valueOf(this.getNewElementName()) + '.' + string5;
                    dynamicValidationRefactoringChange.add(new RenameResourceChange(null, this.fType.getCompilationUnit().getResource(), string6, string4));
                } else {
                    String string7 = JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.getNewElementName());
                    dynamicValidationRefactoringChange.add(new RenameCompilationUnitChange(this.fType.getCompilationUnit(), string7));
                }
            }
            iProgressMonitor.worked(1);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange2 = dynamicValidationRefactoringChange;
            Object var13_16 = null;
            this.fChangeManager = null;
            return dynamicValidationRefactoringChange2;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            this.fChangeManager = null;
            throw throwable;
        }
    }

    public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fQualifiedNameSearchResult != null) {
            try {
                Change change = this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(changeArray));
                Object var3_4 = null;
                this.fQualifiedNameSearchResult = null;
                return change;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.fQualifiedNameSearchResult = null;
                throw throwable;
            }
        }
        return null;
    }

    private boolean willRenameCU() throws CoreException {
        String string = JavaCore.removeJavaLikeExtension((String)this.fType.getCompilationUnit().getElementName());
        if (!Checks.isTopLevel(this.fType) || !string.equals(this.fType.getElementName())) {
            return false;
        }
        if (!this.checkNewPathValidity().isOK()) {
            return false;
        }
        return Checks.checkCompilationUnitNewName(this.fType.getCompilationUnit(), this.getNewElementName()).isOK();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createChanges(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor.beginTask("", 12);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeProcessor_creating_changes);
            if (this.fUpdateReferences) {
                this.addReferenceUpdates(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            }
            iProgressMonitor.worked(1);
            IResource iResource = this.fType.getCompilationUnit().getResource();
            if (iResource != null && iResource.isLinked() || !this.willRenameCU()) {
                this.addTypeDeclarationUpdate(this.fChangeManager);
                iProgressMonitor.worked(1);
                this.addConstructorRenames(this.fChangeManager);
                iProgressMonitor.worked(1);
            } else {
                iProgressMonitor.worked(2);
            }
            if (this.fUpdateTextualMatches) {
                iProgressMonitor.subTask(RefactoringCoreMessages.RenameTypeRefactoring_searching_text);
                TextMatchUpdater.perform((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), RefactoringScopeFactory.create((IJavaElement)this.fType), this, this.fChangeManager, this.fReferences);
                if (this.fUpdateSimilarElements) {
                    this.addSimilarElementsTextualUpdates(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        iProgressMonitor.done();
    }

    private void addTypeDeclarationUpdate(TextChangeManager textChangeManager) throws CoreException {
        String string = RefactoringCoreMessages.RenameTypeRefactoring_update;
        int n = this.fType.getElementName().length();
        ICompilationUnit iCompilationUnit = this.fType.getCompilationUnit();
        TextChangeCompatibility.addTextEdit(textChangeManager.get(iCompilationUnit), string, (TextEdit)new ReplaceEdit(this.fType.getNameRange().getOffset(), n, this.getNewElementName()));
    }

    private void addConstructorRenames(TextChangeManager textChangeManager) throws CoreException {
        ICompilationUnit iCompilationUnit = this.fType.getCompilationUnit();
        IMethod[] iMethodArray = this.fType.getMethods();
        int n = this.fType.getElementName().length();
        int n2 = 0;
        while (n2 < iMethodArray.length) {
            if (iMethodArray[n2].isConstructor()) {
                String string = RefactoringCoreMessages.RenameTypeRefactoring_rename_constructor;
                TextChangeCompatibility.addTextEdit(textChangeManager.get(iCompilationUnit), string, (TextEdit)new ReplaceEdit(iMethodArray[n2].getNameRange().getOffset(), n, this.getNewElementName()));
            }
            ++n2;
        }
    }

    private void addReferenceUpdates(TextChangeManager textChangeManager, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("", this.fReferences.length);
        int n = 0;
        while (n < this.fReferences.length) {
            ICompilationUnit iCompilationUnit = this.fReferences[n].getCompilationUnit();
            if (iCompilationUnit != null) {
                String string = RefactoringCoreMessages.RenameTypeRefactoring_update_reference;
                SearchMatch[] searchMatchArray = this.fReferences[n].getSearchResults();
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    SearchMatch searchMatch = searchMatchArray[n2];
                    ReplaceEdit replaceEdit = new ReplaceEdit(searchMatch.getOffset(), searchMatch.getLength(), this.getNewElementName());
                    TextChangeCompatibility.addTextEdit(textChangeManager.get(iCompilationUnit), string, (TextEdit)replaceEdit, CATEGORY_TYPE_RENAME);
                    ++n2;
                }
                iProgressMonitor.worked(1);
            }
            ++n;
        }
    }

    private void computeQualifiedNameMatches(IProgressMonitor iProgressMonitor) throws CoreException {
        IPackageFragment iPackageFragment = this.fType.getPackageFragment();
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fType.getFullyQualifiedName(), String.valueOf(iPackageFragment.getElementName()) + "." + this.getNewElementName(), this.fFilePatterns, this.fType.getJavaProject().getProject(), iProgressMonitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (!(refactoringArguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
        String string2 = javaRefactoringArguments.getAttribute("input");
        if (string2 == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
        if (iJavaElement == null || !iJavaElement.exists() || iJavaElement.getElementType() != 7) {
            return ScriptableRefactoring.createInputFatalStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.type");
        }
        this.fType = (IType)iJavaElement;
        String string3 = javaRefactoringArguments.getAttribute("name");
        if (string3 == null || "".equals(string3)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(string3);
        String string4 = javaRefactoringArguments.getAttribute(ATTRIBUTE_PATTERNS);
        if (string4 != null && !"".equals(string4)) {
            this.fFilePatterns = string4;
        }
        if ((string = javaRefactoringArguments.getAttribute("references")) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(string);
        String string5 = javaRefactoringArguments.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
        if (string5 == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
        }
        this.fUpdateTextualMatches = Boolean.valueOf(string5);
        String string6 = javaRefactoringArguments.getAttribute(ATTRIBUTE_QUALIFIED);
        if (string6 == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFIED));
        }
        this.fUpdateQualifiedNames = Boolean.valueOf(string6);
        String string7 = javaRefactoringArguments.getAttribute(ATTRIBUTE_SIMILAR_DECLARATIONS);
        if (string7 == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SIMILAR_DECLARATIONS));
        }
        this.fUpdateSimilarElements = Boolean.valueOf(string7);
        String string8 = javaRefactoringArguments.getAttribute(ATTRIBUTE_MATCHING_STRATEGY);
        if (string8 == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MATCHING_STRATEGY));
        try {
            this.fRenamingStrategy = Integer.valueOf(string8);
            return new RefactoringStatus();
        }
        catch (NumberFormatException numberFormatException) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{string8, ATTRIBUTE_QUALIFIED}));
        }
    }

    private RefactoringStatus initializeSimilarElementsRenameProcessors(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        Assert.isNotNull((Object)this.fPreloadedElementToName);
        Assert.isNotNull((Object)this.fPreloadedElementToSelection);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        HashSet<ILocalVariable> hashSet = new HashSet<ILocalVariable>();
        HashSet hashSet2 = new HashSet();
        ArrayList<RenameLocalVariableProcessor> arrayList = new ArrayList<RenameLocalVariableProcessor>();
        this.fFinalSimilarElementToName = new HashMap();
        CompilationUnit compilationUnit = null;
        ICompilationUnit iCompilationUnit = null;
        int n = 0;
        int n2 = this.fPreloadedElementToName.size();
        iProgressMonitor.beginTask("", n2 * 3);
        iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeProcessor_checking_similarly_named_declarations_refactoring_conditions);
        Iterator iterator = this.fPreloadedElementToName.keySet().iterator();
        while (iterator.hasNext()) {
            ILocalVariable iLocalVariable;
            IJavaElement iJavaElement = (IJavaElement)iterator.next();
            ++n;
            iProgressMonitor.worked(3);
            if (!((Boolean)this.fPreloadedElementToSelection.get(iJavaElement)).booleanValue() || this.fFinalSimilarElementToName.containsKey(iJavaElement)) continue;
            ICompilationUnit iCompilationUnit2 = (ICompilationUnit)iJavaElement.getAncestor(5);
            if (!iCompilationUnit2.equals(iCompilationUnit)) {
                this.checkCUCompleteConditions(refactoringStatus, compilationUnit, iCompilationUnit, arrayList);
                if (refactoringStatus.hasFatalError()) {
                    return refactoringStatus;
                }
                compilationUnit = null;
                iCompilationUnit = iCompilationUnit2;
                arrayList.clear();
            }
            String string = (String)this.fPreloadedElementToName.get(iJavaElement);
            JavaRenameProcessor javaRenameProcessor = null;
            if (iJavaElement instanceof ILocalVariable) {
                iLocalVariable = (ILocalVariable)iJavaElement;
                if (compilationUnit == null) {
                    compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, true);
                }
                javaRenameProcessor = this.createLocalRenameProcessor(iLocalVariable, string, compilationUnit);
                if (refactoringStatus.hasFatalError()) {
                    return refactoringStatus;
                }
                this.fFinalSimilarElementToName.put(iLocalVariable, string);
            }
            if (iJavaElement instanceof IField) {
                iLocalVariable = (IField)iJavaElement;
                javaRenameProcessor = this.createFieldRenameProcessor((IField)iLocalVariable, string);
                refactoringStatus.merge(this.checkForConflictingRename((IField)iLocalVariable, string));
                if (refactoringStatus.hasFatalError()) {
                    return refactoringStatus;
                }
                this.fFinalSimilarElementToName.put(iLocalVariable, string);
            }
            if (iJavaElement instanceof IMethod) {
                iLocalVariable = (IMethod)iJavaElement;
                if (MethodChecks.isVirtual((IMethod)iLocalVariable)) {
                    IMethod iMethod;
                    IType iType = iLocalVariable.getDeclaringType();
                    ITypeHierarchy iTypeHierarchy = null;
                    if (!iType.isInterface()) {
                        iTypeHierarchy = iType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    }
                    if ((iMethod = MethodChecks.getTopmostMethod((IMethod)iLocalVariable, iTypeHierarchy, (IProgressMonitor)new NullProgressMonitor())) != null) {
                        iLocalVariable = iMethod;
                    }
                    if (hashSet.contains(iLocalVariable)) continue;
                    hashSet.add(iLocalVariable);
                    IMethod[] iMethodArray = MethodChecks.getOverriddenMethods((IMethod)iLocalVariable, (IProgressMonitor)new NullProgressMonitor());
                    if (this.checkForWarnings(hashSet2, string, iMethodArray)) continue;
                    refactoringStatus.merge(this.checkForConflictingRename(iMethodArray, string));
                    if (refactoringStatus.hasFatalError()) {
                        return refactoringStatus;
                    }
                    javaRenameProcessor = this.createVirtualMethodRenameProcessor((IMethod)iLocalVariable, string, iMethodArray, iTypeHierarchy);
                    this.fFinalSimilarElementToName.put(iLocalVariable, string);
                    int n3 = 0;
                    while (n3 < iMethodArray.length) {
                        this.fFinalSimilarElementToName.put(iMethodArray[n3], string);
                        ++n3;
                    }
                } else {
                    refactoringStatus.merge(this.checkForConflictingRename(new IMethod[]{iLocalVariable}, string));
                    if (refactoringStatus.hasFatalError()) break;
                    this.fFinalSimilarElementToName.put(iLocalVariable, string);
                    javaRenameProcessor = this.createNonVirtualMethodRenameProcessor((IMethod)iLocalVariable, string);
                }
            }
            iProgressMonitor.subTask(Messages.format(RefactoringCoreMessages.RenameTypeProcessor_progress_current_total, new Object[]{String.valueOf(n), String.valueOf(n2)}));
            refactoringStatus.merge(javaRenameProcessor.checkInitialConditions((IProgressMonitor)new NoOverrideProgressMonitor(iProgressMonitor, 1)));
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            refactoringStatus.merge(javaRenameProcessor.checkFinalConditions((IProgressMonitor)new NoOverrideProgressMonitor(iProgressMonitor, 1), checkConditionsContext));
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            arrayList.add((RenameLocalVariableProcessor)javaRenameProcessor);
            iProgressMonitor.worked(1);
            if (!iProgressMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        this.checkCUCompleteConditions(refactoringStatus, compilationUnit, iCompilationUnit, arrayList);
        refactoringStatus.merge(this.addWarnings(hashSet2));
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private void checkCUCompleteConditions(RefactoringStatus refactoringStatus, CompilationUnit compilationUnit, ICompilationUnit iCompilationUnit, List list) throws CoreException {
        List list2;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(list2 = this.getProcessorsOfType(list, clazz)).isEmpty()) {
            RenameAnalyzeUtil.LocalAnalyzePackage[] localAnalyzePackageArray = new RenameAnalyzeUtil.LocalAnalyzePackage[list2.size()];
            TextChangeManager textChangeManager = new TextChangeManager();
            int n = 0;
            TextChange textChange = textChangeManager.get(iCompilationUnit);
            textChange.setKeepPreviewEdits(true);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                RenameAnalyzeUtil.LocalAnalyzePackage localAnalyzePackage;
                RenameLocalVariableProcessor renameLocalVariableProcessor = (RenameLocalVariableProcessor)iterator.next();
                localAnalyzePackageArray[n] = localAnalyzePackage = renameLocalVariableProcessor.getLocalAnalyzePackage();
                int n2 = 0;
                while (n2 < localAnalyzePackage.fOccurenceEdits.length) {
                    TextChangeCompatibility.addTextEdit(textChange, "", localAnalyzePackage.fOccurenceEdits[n2], GroupCategorySet.NONE);
                    ++n2;
                }
                ++n;
            }
            refactoringStatus.merge(RenameAnalyzeUtil.analyzeLocalRenames(localAnalyzePackageArray, textChange, compilationUnit, false));
        }
    }

    private List getProcessorsOfType(List list, Class clazz) {
        ArrayList<RefactoringProcessor> arrayList = new ArrayList<RefactoringProcessor>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RefactoringProcessor refactoringProcessor = (RefactoringProcessor)iterator.next();
            if (!refactoringProcessor.getClass().equals(clazz)) continue;
            arrayList.add(refactoringProcessor);
        }
        return arrayList;
    }

    private RefactoringStatus checkForConflictingRename(IMethod[] iMethodArray, String string) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Iterator iterator = this.fFinalSimilarElementToName.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement iJavaElement = (IJavaElement)iterator.next();
            if (!(iJavaElement instanceof IMethod)) continue;
            IMethod iMethod = (IMethod)iJavaElement;
            String string2 = (String)this.fFinalSimilarElementToName.get(iJavaElement);
            int n = 0;
            while (n < iMethodArray.length) {
                IMethod iMethod2 = iMethodArray[n];
                if (string2.equals(string) && iMethod2.getDeclaringType().equals(iMethod.getDeclaringType()) && RenameTypeProcessor.sameParams(iMethod, iMethod2)) {
                    String string3 = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_cannot_rename_methods_same_new_name, new String[]{iMethod.getElementName(), iMethod2.getElementName(), iMethod.getDeclaringType().getFullyQualifiedName(), string});
                    refactoringStatus.addFatalError(string3);
                    return refactoringStatus;
                }
                ++n;
            }
        }
        return refactoringStatus;
    }

    private static boolean sameParams(IMethod iMethod, IMethod iMethod2) {
        if (iMethod.getNumberOfParameters() != iMethod2.getNumberOfParameters()) {
            return false;
        }
        String[] stringArray = iMethod.getParameterTypes();
        String[] stringArray2 = iMethod2.getParameterTypes();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            String string2 = Signature.getSimpleName((String)Signature.toString((String)stringArray[n]));
            if (!string2.equals(string = Signature.getSimpleName((String)Signature.toString((String)stringArray2[n])))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private RefactoringStatus checkForConflictingRename(IField iField, String string) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Iterator iterator = this.fFinalSimilarElementToName.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement iJavaElement = (IJavaElement)iterator.next();
            if (!(iJavaElement instanceof IField)) continue;
            IField iField2 = (IField)iJavaElement;
            String string2 = (String)this.fFinalSimilarElementToName.get(iJavaElement);
            if (!string2.equals(string) || !iField2.getDeclaringType().equals(iField.getDeclaringType())) continue;
            String string3 = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_cannot_rename_fields_same_new_name, new String[]{iField2.getElementName(), iField.getElementName(), iField2.getDeclaringType().getFullyQualifiedName(), string});
            refactoringStatus.addFatalError(string3);
            return refactoringStatus;
        }
        return refactoringStatus;
    }

    private RefactoringStatus addWarnings(Set set) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            Warning warning = (Warning)iterator.next();
            IMethod[] iMethodArray = warning.getRipple();
            if (warning.isSelectionWarning()) {
                string = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_deselected_method_is_overridden, new String[]{JavaElementLabels.getElementLabel((IJavaElement)iMethodArray[0], JavaElementLabels.ALL_DEFAULT), JavaElementLabels.getElementLabel((IJavaElement)iMethodArray[0].getDeclaringType(), JavaElementLabels.ALL_DEFAULT)});
                refactoringStatus.addWarning(string);
            }
            if (warning.isNameWarning()) {
                string = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_renamed_method_is_overridden, new String[]{JavaElementLabels.getElementLabel((IJavaElement)iMethodArray[0], JavaElementLabels.ALL_DEFAULT), JavaElementLabels.getElementLabel((IJavaElement)iMethodArray[0].getDeclaringType(), JavaElementLabels.ALL_DEFAULT)});
                refactoringStatus.addWarning(string);
            }
            int n = 0;
            while (n < iMethodArray.length) {
                this.fPreloadedElementToSelection.put(iMethodArray[n], Boolean.FALSE);
                ++n;
            }
        }
        return refactoringStatus;
    }

    private boolean checkForWarnings(Set set, String string, IMethod[] iMethodArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < iMethodArray.length) {
            String string2 = (String)this.fPreloadedElementToName.get(iMethodArray[n]);
            Boolean bl3 = (Boolean)this.fPreloadedElementToSelection.get(iMethodArray[n]);
            if (bl3 != null) {
                if (!bl3.booleanValue()) {
                    bl = true;
                }
                if (!string.equals(string2)) {
                    bl2 = true;
                }
            }
            ++n;
        }
        if (bl || bl2) {
            set.add(new Warning(iMethodArray, bl, bl2));
        }
        return bl || bl2;
    }

    private RenameMethodProcessor createVirtualMethodRenameProcessor(IMethod iMethod, String string, IMethod[] iMethodArray, ITypeHierarchy iTypeHierarchy) throws JavaModelException {
        RenameVirtualMethodProcessor renameVirtualMethodProcessor = new RenameVirtualMethodProcessor(iMethod, iMethodArray, this.fChangeManager, iTypeHierarchy, CATEGORY_METHOD_RENAME);
        this.initMethodProcessor(renameVirtualMethodProcessor, string);
        return renameVirtualMethodProcessor;
    }

    private RenameMethodProcessor createNonVirtualMethodRenameProcessor(IMethod iMethod, String string) {
        RenameNonVirtualMethodProcessor renameNonVirtualMethodProcessor = new RenameNonVirtualMethodProcessor(iMethod, this.fChangeManager, CATEGORY_METHOD_RENAME);
        this.initMethodProcessor(renameNonVirtualMethodProcessor, string);
        return renameNonVirtualMethodProcessor;
    }

    private void initMethodProcessor(RenameMethodProcessor renameMethodProcessor, String string) {
        renameMethodProcessor.setNewElementName(string);
        renameMethodProcessor.setUpdateReferences(this.getUpdateReferences());
    }

    private RenameFieldProcessor createFieldRenameProcessor(IField iField, String string) {
        RenameFieldProcessor renameFieldProcessor = new RenameFieldProcessor(iField, this.fChangeManager, CATEGORY_FIELD_RENAME);
        renameFieldProcessor.setNewElementName(string);
        renameFieldProcessor.setRenameGetter(false);
        renameFieldProcessor.setRenameSetter(false);
        renameFieldProcessor.setUpdateReferences(this.getUpdateReferences());
        renameFieldProcessor.setUpdateTextualMatches(false);
        return renameFieldProcessor;
    }

    private RenameLocalVariableProcessor createLocalRenameProcessor(ILocalVariable iLocalVariable, String string, CompilationUnit compilationUnit) {
        RenameLocalVariableProcessor renameLocalVariableProcessor = new RenameLocalVariableProcessor(iLocalVariable, this.fChangeManager, compilationUnit, CATEGORY_LOCAL_RENAME);
        renameLocalVariableProcessor.setNewElementName(string);
        renameLocalVariableProcessor.setUpdateReferences(this.getUpdateReferences());
        return renameLocalVariableProcessor;
    }

    private void addSimilarElementsTextualUpdates(TextChangeManager textChangeManager, IProgressMonitor iProgressMonitor) throws CoreException {
        String string;
        String string2;
        IJavaElement iJavaElement;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.fFinalSimilarElementToName.keySet().iterator();
        while (iterator.hasNext()) {
            iJavaElement = (IJavaElement)iterator.next();
            if (!(iJavaElement instanceof IField) || arrayList.contains(iJavaElement.getElementName())) continue;
            string2 = (String)hashMap.get(iJavaElement.getElementName());
            string = (String)this.fFinalSimilarElementToName.get(iJavaElement);
            if (string2 == null) {
                hashMap.put(iJavaElement.getElementName(), string);
                continue;
            }
            if (string2.equals(string)) continue;
            arrayList.add(iJavaElement.getElementName());
        }
        iterator = this.fFinalSimilarElementToName.keySet().iterator();
        while (iterator.hasNext()) {
            iJavaElement = (IJavaElement)iterator.next();
            if (!(iJavaElement instanceof IField)) continue;
            string2 = (IField)iJavaElement;
            string = (String)this.fFinalSimilarElementToName.get(string2);
            TextMatchUpdater.perform(iProgressMonitor, RefactoringScopeFactory.create((IJavaElement)string2), string2.getElementName(), string2.getDeclaringType().getFullyQualifiedName(), string, textChangeManager, new SearchResultGroup[0], arrayList.contains(string2.getElementName()));
        }
    }

    public Map getSimilarElementsToNewNames() {
        return this.fPreloadedElementToName;
    }

    public Map getSimilarElementsToSelection() {
        return this.fPreloadedElementToSelection;
    }

    public void resetSelectedSimilarElements() {
        Assert.isNotNull((Object)this.fPreloadedElementToName);
        Iterator iterator = this.fPreloadedElementToNameDefault.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement iJavaElement = (IJavaElement)iterator.next();
            this.fPreloadedElementToName.put(iJavaElement, this.fPreloadedElementToNameDefault.get(iJavaElement));
            this.fPreloadedElementToSelection.put(iJavaElement, Boolean.TRUE);
        }
    }

    public boolean hasSimilarElementsToRename() {
        if (!this.fUpdateSimilarElements) {
            return false;
        }
        if (this.fPreloadedElementToName == null) {
            return false;
        }
        return this.fPreloadedElementToName.size() != 0;
    }

    private class NoOverrideProgressMonitor
    extends SubProgressMonitor {
        public NoOverrideProgressMonitor(IProgressMonitor iProgressMonitor, int n) {
            super(iProgressMonitor, n, 2);
        }

        public void setTaskName(String string) {
        }
    }

    public static final class ParticipantDescriptorFilter
    implements IParticipantDescriptorFilter {
        public boolean select(IConfigurationElement iConfigurationElement, RefactoringStatus refactoringStatus) {
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("param");
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
                if ("handlesSimilarDeclarations".equals(iConfigurationElement2.getAttribute("name")) && "false".equals(iConfigurationElement2.getAttribute("value"))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    private class Warning {
        private IMethod[] fRipple;
        private boolean fSelectionWarning;
        private boolean fNameWarning;

        public Warning(IMethod[] iMethodArray, boolean bl, boolean bl2) {
            this.fRipple = iMethodArray;
            this.fSelectionWarning = bl;
            this.fNameWarning = bl2;
        }

        public boolean isNameWarning() {
            return this.fNameWarning;
        }

        public IMethod[] getRipple() {
            return this.fRipple;
        }

        public boolean isSelectionWarning() {
            return this.fSelectionWarning;
        }
    }
}

