/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.LoggedNewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.MonitoringNewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public final class JavaCopyProcessor
extends CopyProcessor
implements IReorgDestinationValidator,
IScriptableRefactoring,
ICommentProvider {
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.CopyProcessor";
    private String fComment;
    private IReorgPolicy.ICopyPolicy fCopyPolicy;
    private ReorgExecutionLog fExecutionLog;
    private INewNameQueries fNewNameQueries;
    private IReorgQueries fReorgQueries;
    static /* synthetic */ Class class$0;

    public JavaCopyProcessor(IReorgPolicy.ICopyPolicy iCopyPolicy) {
        this.fCopyPolicy = iCopyPolicy;
    }

    public boolean canChildrenBeDestinations(IJavaElement iJavaElement) {
        return this.fCopyPolicy.canChildrenBeDestinations(iJavaElement);
    }

    public boolean canChildrenBeDestinations(IResource iResource) {
        return this.fCopyPolicy.canChildrenBeDestinations(iResource);
    }

    public boolean canElementBeDestination(IJavaElement iJavaElement) {
        return this.fCopyPolicy.canElementBeDestination(iJavaElement);
    }

    public boolean canElementBeDestination(IResource iResource) {
        return this.fCopyPolicy.canElementBeDestination(iResource);
    }

    public boolean canEnableComment() {
        return true;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        Assert.isNotNull((Object)this.fNewNameQueries, (String)"Missing new name queries");
        Assert.isNotNull((Object)this.fReorgQueries, (String)"Missing reorg queries");
        iProgressMonitor.beginTask("", 2);
        RefactoringStatus refactoringStatus = this.fCopyPolicy.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), checkConditionsContext, this.fReorgQueries);
        refactoringStatus.merge(checkConditionsContext.check((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fCopyPolicy.getResources()))));
        IResource[] iResourceArray = ReorgUtils.getResources(this.fCopyPolicy.getJavaElements());
        refactoringStatus.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(iResourceArray))));
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        Assert.isNotNull((Object)this.fNewNameQueries);
        Assert.isTrue((this.fCopyPolicy.getJavaElementDestination() == null || this.fCopyPolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fCopyPolicy.getJavaElementDestination() != null || this.fCopyPolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            DynamicValidationStateChange dynamicValidationStateChange2 = new DynamicValidationStateChange(this.getChangeName()){

                public Object getAdapter(Class clazz) {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2.equals(clazz)) {
                        return JavaCopyProcessor.this.fExecutionLog;
                    }
                    return super.getAdapter(clazz);
                }

                public ChangeDescriptor getDescriptor() {
                    return JavaCopyProcessor.this.fCopyPolicy.getDescriptor();
                }

                public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
                    try {
                        super.perform(iProgressMonitor);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        JavaCopyProcessor.this.fExecutionLog.markAsCanceled();
                        throw operationCanceledException;
                    }
                    return null;
                }
            };
            Change change = this.fCopyPolicy.createChange(iProgressMonitor, new MonitoringNewNameQueries(this.fNewNameQueries, this.fExecutionLog));
            if (change instanceof CompositeChange) {
                CompositeChange compositeChange = (CompositeChange)change;
                dynamicValidationStateChange2.merge(compositeChange);
            } else {
                dynamicValidationStateChange2.add(change);
            }
            dynamicValidationStateChange = dynamicValidationStateChange2;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationStateChange;
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] stringArray = JavaProcessors.computeAffectedNaturs(this.fCopyPolicy.getJavaElements());
        String[] stringArray2 = ResourceProcessors.computeAffectedNatures(this.fCopyPolicy.getResources());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        hashSet.addAll(Arrays.asList(stringArray2));
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private String getChangeName() {
        return RefactoringCoreMessages.JavaCopyProcessor_changeName;
    }

    public String getComment() {
        return this.fComment;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fCopyPolicy.getResources(), this.fCopyPolicy.getJavaElements()).getCommonParent();
    }

    public Object[] getElements() {
        IJavaElement[] iJavaElementArray = this.fCopyPolicy.getJavaElements();
        IResource[] iResourceArray = this.fCopyPolicy.getResources();
        ArrayList<Object> arrayList = new ArrayList<Object>(iJavaElementArray.length + iResourceArray.length);
        arrayList.addAll(Arrays.asList(iJavaElementArray));
        arrayList.addAll(Arrays.asList(iResourceArray));
        return arrayList.toArray();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public IJavaElement[] getJavaElements() {
        return this.fCopyPolicy.getJavaElements();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.JavaCopyProcessor_processorName;
    }

    public IResource[] getResources() {
        return this.fCopyPolicy.getResources();
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        this.setReorgQueries(new NullReorgQueries());
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            this.fCopyPolicy = ReorgPolicyFactory.createCopyPolicy(refactoringStatus, javaRefactoringArguments);
            if (this.fCopyPolicy != null && !refactoringStatus.hasFatalError()) {
                ReorgExecutionLog reorgExecutionLog;
                refactoringStatus.merge(this.fCopyPolicy.initialize(refactoringArguments));
                if (!refactoringStatus.hasFatalError() && (reorgExecutionLog = ReorgPolicyFactory.loadReorgExecutionLog(refactoringStatus, javaRefactoringArguments)) != null && !refactoringStatus.hasFatalError()) {
                    this.setNewNameQueries(new LoggedNewNameQueries(reorgExecutionLog));
                }
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return refactoringStatus;
    }

    public boolean isApplicable() throws CoreException {
        return this.fCopyPolicy.canEnable();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, SharableParticipants sharableParticipants) throws CoreException {
        RefactoringParticipant[] refactoringParticipantArray = this.fCopyPolicy.loadParticipants(refactoringStatus, (RefactoringProcessor)this, this.getAffectedProjectNatures(), sharableParticipants);
        this.fExecutionLog = this.fCopyPolicy.getReorgExecutionLog();
        return refactoringParticipantArray;
    }

    public void setComment(String string) {
        this.fComment = string;
    }

    public RefactoringStatus setDestination(IJavaElement iJavaElement) throws JavaModelException {
        return this.fCopyPolicy.setDestination(iJavaElement);
    }

    public RefactoringStatus setDestination(IResource iResource) throws JavaModelException {
        return this.fCopyPolicy.setDestination(iResource);
    }

    public void setNewNameQueries(INewNameQueries iNewNameQueries) {
        Assert.isNotNull((Object)iNewNameQueries);
        this.fNewNameQueries = iNewNameQueries;
    }

    public void setReorgQueries(IReorgQueries iReorgQueries) {
        Assert.isNotNull((Object)iReorgQueries);
        this.fReorgQueries = iReorgQueries;
    }
}

