/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveStaticMemberAnalyzer;

class ReferenceAnalyzer
extends MoveStaticMemberAnalyzer {
    public ReferenceAnalyzer(CompilationUnitRewrite compilationUnitRewrite, IBinding[] iBindingArray, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        super(compilationUnitRewrite, iBindingArray, iTypeBinding2, iTypeBinding);
    }

    public boolean needsTargetImport() {
        return this.fNeedsImport;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        ITypeBinding iTypeBinding = typeDeclaration.resolveBinding();
        if (iTypeBinding != null && this.isMovedMember((IBinding)(iTypeBinding = iTypeBinding.getTypeDeclaration()))) {
            return false;
        }
        return super.visit(typeDeclaration);
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        if (this.isMovedMember((IBinding)variableDeclarationFragment.resolveBinding())) {
            return false;
        }
        return super.visit(variableDeclarationFragment);
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        if (this.isMovedMember((IBinding)variableDeclarationFragment.resolveBinding())) {
            return false;
        }
        return super.visit(fieldDeclaration);
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        if (this.isMovedMember((IBinding)methodDeclaration.resolveBinding())) {
            return false;
        }
        return super.visit(methodDeclaration);
    }

    public boolean visit(SimpleName simpleName) {
        if (!simpleName.isDeclaration() && this.isMovedMember(simpleName.resolveBinding()) && !this.isProcessed((ASTNode)simpleName)) {
            this.rewrite(simpleName, this.fTarget);
        }
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        if (this.isMovedMember(qualifiedName.resolveBinding())) {
            if (qualifiedName.getParent() instanceof ImportDeclaration) {
                ITypeBinding iTypeBinding = qualifiedName.resolveTypeBinding();
                if (iTypeBinding != null) {
                    this.fCuRewrite.getImportRewrite().removeImport(iTypeBinding.getQualifiedName());
                }
                String string = this.fCuRewrite.getImportRewrite().addImport(String.valueOf(this.fTarget.getQualifiedName()) + '.' + qualifiedName.getName().getIdentifier());
                this.fCuRewrite.getImportRemover().registerAddedImport(string);
            } else {
                this.rewrite(qualifiedName, this.fTarget);
            }
            return false;
        }
        return super.visit(qualifiedName);
    }

    public boolean visit(FieldAccess fieldAccess) {
        if (this.isMovedMember((IBinding)fieldAccess.resolveFieldBinding())) {
            this.rewrite(fieldAccess, this.fTarget);
        }
        return super.visit(fieldAccess);
    }

    public boolean visit(MethodInvocation methodInvocation) {
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (iMethodBinding != null && this.isMovedMember((IBinding)(iMethodBinding = iMethodBinding.getMethodDeclaration()))) {
            this.rewrite(methodInvocation, this.fTarget);
        }
        return super.visit(methodInvocation);
    }

    public boolean visit(MemberRef memberRef) {
        if (this.isMovedMember(memberRef.resolveBinding())) {
            this.rewrite(memberRef, this.fTarget);
        }
        return false;
    }

    public boolean visit(MethodRef methodRef) {
        if (this.isMovedMember(methodRef.resolveBinding())) {
            this.rewrite(methodRef, this.fTarget);
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        if (this.isMovedMember((IBinding)annotationTypeDeclaration.resolveBinding())) {
            return false;
        }
        return super.visit(annotationTypeDeclaration);
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        if (this.isMovedMember((IBinding)enumDeclaration.resolveBinding())) {
            return false;
        }
        return super.visit(enumDeclaration);
    }
}

