/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;

public class CompositeOrTypeConstraint
implements ITypeConstraint {
    private final ITypeConstraint[] fConstraints;

    CompositeOrTypeConstraint(ITypeConstraint[] iTypeConstraintArray) {
        Assert.isNotNull((Object)iTypeConstraintArray);
        this.fConstraints = CompositeOrTypeConstraint.sort(CompositeOrTypeConstraint.getCopy(iTypeConstraintArray));
    }

    private static ITypeConstraint[] getCopy(ITypeConstraint[] iTypeConstraintArray) {
        List<ITypeConstraint> list = Arrays.asList(iTypeConstraintArray);
        return list.toArray(new ITypeConstraint[list.size()]);
    }

    private static ITypeConstraint[] sort(ITypeConstraint[] iTypeConstraintArray) {
        Arrays.sort(iTypeConstraintArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return object2.toString().compareTo(object.toString());
            }
        });
        return iTypeConstraintArray;
    }

    public String toResolvedString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fConstraints.length) {
            ITypeConstraint iTypeConstraint = this.fConstraints[n];
            if (n > 0) {
                stringBuffer.append(" or ");
            }
            stringBuffer.append(iTypeConstraint.toResolvedString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isSimpleTypeConstraint() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fConstraints.length) {
            ITypeConstraint iTypeConstraint = this.fConstraints[n];
            if (n > 0) {
                stringBuffer.append(" or ");
            }
            stringBuffer.append(iTypeConstraint.toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public ITypeConstraint[] getConstraints() {
        return this.fConstraints;
    }
}

