/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EmptyTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeUniverseSet;

public class TypeSetEnvironment {
    private final TypeEnvironment fTypeEnvironment;
    private final TypeUniverseSet fUniverse;
    private final EmptyTypeSet fEmptyTypeSet;
    private final Map fSubtypesOfSingletons = new LinkedHashMap();
    private final Map fSubTypesSets = new LinkedHashMap();
    private final Map fSuperTypesOfSingletons = new LinkedHashMap();
    private final Map fSuperTypesSets = new LinkedHashMap();
    private int fgCommonExprHits = 0;
    private int fgCommonExprMisses = 0;

    public TypeSetEnvironment(TypeEnvironment typeEnvironment) {
        this.fTypeEnvironment = typeEnvironment;
        this.fUniverse = new TypeUniverseSet(this);
        this.fEmptyTypeSet = new EmptyTypeSet(this);
    }

    public TType getJavaLangObject() {
        return this.fTypeEnvironment.getJavaLangObject();
    }

    public TypeUniverseSet getUniverseTypeSet() {
        return this.fUniverse;
    }

    public EmptyTypeSet getEmptyTypeSet() {
        return this.fEmptyTypeSet;
    }

    public SubTypesOfSingleton createSubTypesOfSingleton(TType tType) {
        if (tType.isJavaLangObject()) {
            return this.getUniverseTypeSet();
        }
        if (this.fSubtypesOfSingletons.containsKey(tType)) {
            ++this.fgCommonExprHits;
            return (SubTypesOfSingleton)this.fSubtypesOfSingletons.get(tType);
        }
        SubTypesOfSingleton subTypesOfSingleton = new SubTypesOfSingleton(tType, this);
        ++this.fgCommonExprMisses;
        this.fSubtypesOfSingletons.put(tType, subTypesOfSingleton);
        return subTypesOfSingleton;
    }

    public SubTypesSet createSubTypesSet(TypeSet typeSet) {
        if (this.fSubTypesSets.containsKey(typeSet)) {
            ++this.fgCommonExprHits;
            return (SubTypesSet)this.fSubTypesSets.get(typeSet);
        }
        SubTypesSet subTypesSet = new SubTypesSet(typeSet);
        ++this.fgCommonExprMisses;
        this.fSubTypesSets.put(typeSet, subTypesSet);
        return subTypesSet;
    }

    public SuperTypesOfSingleton createSuperTypesOfSingleton(TType tType) {
        if (this.fSuperTypesOfSingletons.containsKey(tType)) {
            ++this.fgCommonExprHits;
            return (SuperTypesOfSingleton)this.fSuperTypesOfSingletons.get(tType);
        }
        SuperTypesOfSingleton superTypesOfSingleton = new SuperTypesOfSingleton(tType, this);
        ++this.fgCommonExprMisses;
        this.fSuperTypesOfSingletons.put(tType, superTypesOfSingleton);
        return superTypesOfSingleton;
    }

    public SuperTypesSet createSuperTypesSet(TType tType) {
        if (this.fSuperTypesSets.containsKey(tType)) {
            ++this.fgCommonExprHits;
            return (SuperTypesSet)this.fSuperTypesSets.get(tType);
        }
        SuperTypesSet superTypesSet = new SuperTypesSet(tType, this);
        ++this.fgCommonExprMisses;
        this.fSuperTypesSets.put(tType, superTypesSet);
        return superTypesSet;
    }

    public SuperTypesSet createSuperTypesSet(TypeSet typeSet) {
        if (this.fSuperTypesSets.containsKey(typeSet)) {
            return (SuperTypesSet)this.fSuperTypesSets.get(typeSet);
        }
        SuperTypesSet superTypesSet = new SuperTypesSet(typeSet, this);
        this.fSuperTypesSets.put(typeSet, superTypesSet);
        return superTypesSet;
    }

    public void dumpStats() {
        System.out.println("Common expression hits:   " + this.fgCommonExprHits);
        System.out.println("Common expression misses: " + this.fgCommonExprMisses);
    }
}

