/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;

public abstract class AbstractExceptionAnalyzer
extends ASTVisitor {
    private List fCurrentExceptions;
    private Stack fTryStack = new Stack();

    protected AbstractExceptionAnalyzer() {
        this.fCurrentExceptions = new ArrayList(1);
        this.fTryStack.push(this.fCurrentExceptions);
    }

    public abstract boolean visit(ThrowStatement var1);

    public abstract boolean visit(MethodInvocation var1);

    public abstract boolean visit(ClassInstanceCreation var1);

    public boolean visit(TypeDeclaration typeDeclaration) {
        return !typeDeclaration.isLocalTypeDeclaration();
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        return !enumDeclaration.isLocalTypeDeclaration();
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return !annotationTypeDeclaration.isLocalTypeDeclaration();
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        this.fCurrentExceptions = new ArrayList(1);
        this.fTryStack.push(this.fCurrentExceptions);
        tryStatement.getBody().accept((ASTVisitor)this);
        List list = tryStatement.catchClauses();
        if (!list.isEmpty()) {
            this.handleCatchArguments(list);
        }
        List list2 = (List)this.fTryStack.pop();
        this.fCurrentExceptions = (List)this.fTryStack.peek();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.addException((ITypeBinding)iterator.next());
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            ((CatchClause)iterator.next()).accept((ASTVisitor)this);
        }
        if (tryStatement.getFinally() != null) {
            tryStatement.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    protected void addExceptions(ITypeBinding[] iTypeBindingArray) {
        if (iTypeBindingArray == null) {
            return;
        }
        int n = 0;
        while (n < iTypeBindingArray.length) {
            this.addException(iTypeBindingArray[n]);
            ++n;
        }
    }

    protected void addException(ITypeBinding iTypeBinding) {
        if (!this.fCurrentExceptions.contains(iTypeBinding)) {
            this.fCurrentExceptions.add(iTypeBinding);
        }
    }

    protected List getCurrentExceptions() {
        return this.fCurrentExceptions;
    }

    private void handleCatchArguments(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CatchClause catchClause = (CatchClause)iterator.next();
            ITypeBinding iTypeBinding = catchClause.getException().getType().resolveBinding();
            if (iTypeBinding == null) continue;
            Iterator iterator2 = new ArrayList(this.fCurrentExceptions).iterator();
            while (iterator2.hasNext()) {
                ITypeBinding iTypeBinding2 = (ITypeBinding)iterator2.next();
                if (!this.catches(iTypeBinding, iTypeBinding2)) continue;
                this.fCurrentExceptions.remove(iTypeBinding2);
            }
        }
    }

    private boolean catches(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        while (iTypeBinding2 != null) {
            if (iTypeBinding2 == iTypeBinding) {
                return true;
            }
            iTypeBinding2 = iTypeBinding2.getSuperclass();
        }
        return false;
    }
}

