/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static String createMethodSignature(IMethod iMethod) {
        try {
            return Signature.toString((String)iMethod.getSignature(), (String)iMethod.getElementName(), (String[])iMethod.getParameterNames(), (boolean)false, (!iMethod.isConstructor() ? 1 : 0) != 0);
        }
        catch (JavaModelException javaModelException) {
            return iMethod.getElementName();
        }
    }

    public static String createFieldSignature(IField iField) {
        return String.valueOf(JavaModelUtil.getFullyQualifiedName(iField.getDeclaringType())) + "." + iField.getElementName();
    }

    public static String createSignature(IMember iMember) {
        switch (iMember.getElementType()) {
            case 8: {
                return JavaElementUtil.createFieldSignature((IField)iMember);
            }
            case 7: {
                return JavaModelUtil.getFullyQualifiedName((IType)iMember);
            }
            case 10: {
                return RefactoringCoreMessages.JavaElementUtil_initializer;
            }
            case 9: {
                return JavaElementUtil.createMethodSignature((IMethod)iMember);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IJavaElement[] getElementsOfType(IJavaElement[] iJavaElementArray, int n) {
        HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>(iJavaElementArray.length);
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            if (iJavaElement.getElementType() == n) {
                hashSet.add(iJavaElement);
            }
            ++n2;
        }
        return hashSet.toArray(new IJavaElement[hashSet.size()]);
    }

    public static IType getMainType(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IType[] iTypeArray = iCompilationUnit.getTypes();
        int n = 0;
        while (n < iTypeArray.length) {
            if (JavaElementUtil.isMainType(iTypeArray[n])) {
                return iTypeArray[n];
            }
            ++n;
        }
        return null;
    }

    public static boolean isMainType(IType iType) throws JavaModelException {
        if (!iType.exists()) {
            return false;
        }
        if (iType.isBinary()) {
            return false;
        }
        if (iType.getCompilationUnit() == null) {
            return false;
        }
        if (iType.getDeclaringType() != null) {
            return false;
        }
        return JavaElementUtil.isPrimaryType(iType) || JavaElementUtil.isCuOnlyType(iType);
    }

    private static boolean isPrimaryType(IType iType) {
        return iType.equals(iType.getCompilationUnit().findPrimaryType());
    }

    private static boolean isCuOnlyType(IType iType) throws JavaModelException {
        return iType.getCompilationUnit().getTypes().length == 1;
    }

    public static boolean isAncestorOf(IJavaElement iJavaElement, IJavaElement iJavaElement2) {
        IJavaElement iJavaElement3 = iJavaElement2.getParent();
        while (iJavaElement3 != null && !iJavaElement3.equals(iJavaElement)) {
            iJavaElement3 = iJavaElement3.getParent();
        }
        return iJavaElement3 != null;
    }

    public static IMethod[] getAllConstructors(IType iType) throws JavaModelException {
        if (JavaModelUtil.isInterfaceOrAnnotation(iType)) {
            return new IMethod[0];
        }
        ArrayList<IMethod> arrayList = new ArrayList<IMethod>();
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            IMethod iMethod = iMethodArray[n];
            if (iMethod.isConstructor()) {
                arrayList.add(iMethod);
            }
            ++n;
        }
        return arrayList.toArray(new IMethod[arrayList.size()]);
    }

    public static IJavaProject[] getReferencingProjects(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
        IJavaProject[] iJavaProjectArray = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>(iJavaProjectArray.length);
        int n = 0;
        while (n < iJavaProjectArray.length) {
            IJavaProject iJavaProject = iJavaProjectArray[n];
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.findPackageFragmentRoots(iClasspathEntry);
            if (iPackageFragmentRootArray.length > 0) {
                arrayList.add(iJavaProject);
            }
            ++n;
        }
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    public static IMember[] merge(IMember[] iMemberArray, IMember[] iMemberArray2) {
        IMember iMember;
        ArrayList<IMember> arrayList = new ArrayList<IMember>(iMemberArray.length + iMemberArray2.length);
        int n = 0;
        while (n < iMemberArray.length) {
            iMember = iMemberArray[n];
            if (!arrayList.contains(iMember)) {
                arrayList.add(iMember);
            }
            ++n;
        }
        n = 0;
        while (n < iMemberArray2.length) {
            iMember = iMemberArray2[n];
            if (!arrayList.contains(iMember)) {
                arrayList.add(iMember);
            }
            ++n;
        }
        return arrayList.toArray(new IMember[arrayList.size()]);
    }

    public static boolean isDefaultPackage(Object object) {
        return object instanceof IPackageFragment && ((IPackageFragment)object).isDefaultPackage();
    }

    public static IPackageFragment[] getPackageAndSubpackages(IPackageFragment iPackageFragment) throws JavaModelException {
        if (iPackageFragment.isDefaultPackage()) {
            return new IPackageFragment[]{iPackageFragment};
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
        IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
        arrayList.add(iPackageFragment);
        String string = String.valueOf(iPackageFragment.getElementName()) + '.';
        int n = 0;
        while (n < iJavaElementArray.length) {
            IPackageFragment iPackageFragment2 = (IPackageFragment)iJavaElementArray[n];
            if (iPackageFragment2.getElementName().startsWith(string)) {
                arrayList.add(iPackageFragment2);
            }
            ++n;
        }
        return arrayList.toArray(new IPackageFragment[arrayList.size()]);
    }

    public static IPackageFragment getParentSubpackage(IPackageFragment iPackageFragment) {
        String string;
        if (iPackageFragment.isDefaultPackage()) {
            return null;
        }
        int n = iPackageFragment.getElementName().lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
        IPackageFragment iPackageFragment2 = iPackageFragmentRoot.getPackageFragment(string = iPackageFragment.getElementName().substring(0, n));
        if (iPackageFragment2.exists()) {
            return iPackageFragment2;
        }
        return null;
    }

    public static IMember[] sortByOffset(IMember[] iMemberArray) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    return ((IMember)object).getNameRange().getOffset() - ((IMember)object2).getNameRange().getOffset();
                }
                catch (JavaModelException javaModelException) {
                    return 0;
                }
            }
        };
        Arrays.sort(iMemberArray, comparator);
        return iMemberArray;
    }

    public static boolean isSourceAvailable(ISourceReference iSourceReference) {
        try {
            return SourceRange.isAvailable(iSourceReference.getSourceRange());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

