/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.CorextMessages;
import org.eclipse.wst.jsdt.internal.corext.util.History;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.w3c.dom.Element;

public class OpenTypeHistory
extends History {
    private volatile boolean fNeedsConsistencyCheck = true;
    private Map fTimestampMapping = new HashMap();
    private final IElementChangedListener fDeltaListener;
    private final UpdateJob fUpdateJob;
    private static final String FILENAME = "OpenTypeHistory.xml";
    private static final String NODE_ROOT = "typeInfoHistroy";
    private static final String NODE_TYPE_INFO = "typeInfo";
    private static final String NODE_HANDLE = "handle";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final String NODE_TIMESTAMP = "timestamp";
    private static OpenTypeHistory fgInstance;
    static /* synthetic */ Class class$0;

    public static synchronized OpenTypeHistory getInstance() {
        if (fgInstance == null) {
            fgInstance = new OpenTypeHistory();
        }
        return fgInstance;
    }

    public static synchronized void shutdown() {
        if (fgInstance == null) {
            return;
        }
        fgInstance.doShutdown();
    }

    private OpenTypeHistory() {
        super(FILENAME, NODE_ROOT, NODE_TYPE_INFO);
        this.load();
        this.fDeltaListener = new TypeHistoryDeltaListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.fUpdateJob = new UpdateJob();
        this.fUpdateJob.setPriority(20);
    }

    public void markAsInconsistent() {
        this.fNeedsConsistencyCheck = true;
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    public boolean needConsistencyCheck() {
        return this.fNeedsConsistencyCheck;
    }

    public void checkConsistency(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        if (this.fUpdateJob.getState() == 4) {
            try {
                Job.getJobManager().join((Object)UpdateJob.FAMILY, iProgressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        this.internalCheckConsistency(iProgressMonitor);
    }

    public synchronized boolean contains(TypeNameMatch typeNameMatch) {
        return super.contains(typeNameMatch);
    }

    public synchronized void accessed(TypeNameMatch typeNameMatch) {
        if (!this.fTimestampMapping.containsKey(typeNameMatch)) {
            this.fTimestampMapping.put(typeNameMatch, new Long(this.getContainerTimestamp(typeNameMatch)));
        }
        super.accessed(typeNameMatch);
    }

    public synchronized TypeNameMatch remove(TypeNameMatch typeNameMatch) {
        this.fTimestampMapping.remove(typeNameMatch);
        return (TypeNameMatch)super.remove(typeNameMatch);
    }

    public synchronized void replace(TypeNameMatch typeNameMatch, TypeNameMatch typeNameMatch2) {
        this.fTimestampMapping.remove(typeNameMatch);
        this.fTimestampMapping.put(typeNameMatch2, new Long(this.getContainerTimestamp(typeNameMatch2)));
        super.remove(typeNameMatch);
        super.accessed(typeNameMatch2);
    }

    public synchronized TypeNameMatch[] getTypeInfos() {
        Collection collection = this.getValues();
        int n = collection.size();
        TypeNameMatch[] typeNameMatchArray = new TypeNameMatch[n];
        int n2 = n - 1;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            typeNameMatchArray[n2] = (TypeNameMatch)iterator.next();
            --n2;
        }
        return typeNameMatchArray;
    }

    public synchronized TypeNameMatch[] getFilteredTypeInfos(TypeInfoFilter typeInfoFilter) {
        Collection collection = this.getValues();
        ArrayList<TypeNameMatch> arrayList = new ArrayList<TypeNameMatch>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TypeNameMatch typeNameMatch = (TypeNameMatch)iterator.next();
            if (typeInfoFilter != null && !typeInfoFilter.matchesHistoryElement(typeNameMatch) || TypeFilter.isFiltered(typeNameMatch.getFullyQualifiedName())) continue;
            arrayList.add(typeNameMatch);
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new TypeNameMatch[arrayList.size()]);
    }

    protected Object getKey(Object object) {
        return object;
    }

    private synchronized void internalCheckConsistency(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        this.fNeedsConsistencyCheck = true;
        ArrayList arrayList = new ArrayList(this.getKeys());
        iProgressMonitor.beginTask(CorextMessages.TypeInfoHistory_consistency_check, arrayList.size());
        iProgressMonitor.setTaskName(CorextMessages.TypeInfoHistory_consistency_check);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TypeNameMatch typeNameMatch = (TypeNameMatch)iterator.next();
            long l = this.getContainerTimestamp(typeNameMatch);
            Long l2 = (Long)this.fTimestampMapping.get(typeNameMatch);
            if (l2 != null && l != -1L && l == l2 && !this.isContainerDirty(typeNameMatch)) continue;
            try {
                IType iType = typeNameMatch.getType();
                if (iType == null || !iType.exists()) {
                    this.remove(typeNameMatch);
                } else {
                    int n = iType.getFlags();
                    if (n != typeNameMatch.getModifiers()) {
                        this.replace(typeNameMatch, SearchEngine.createTypeNameMatch((IType)iType, (int)n));
                    } else {
                        this.fTimestampMapping.put(typeNameMatch, new Long(l));
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                this.remove(typeNameMatch);
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProgressMonitor.worked(1);
        }
        iProgressMonitor.done();
        this.fNeedsConsistencyCheck = false;
    }

    private long getContainerTimestamp(TypeNameMatch typeNameMatch) {
        try {
            IType iType = typeNameMatch.getType();
            IResource iResource = iType.getResource();
            if (iResource != null) {
                IJavaElement iJavaElement;
                IFileInfo iFileInfo;
                URI uRI = iResource.getLocationURI();
                if (uRI != null && (iFileInfo = EFS.getStore((URI)uRI).fetchInfo()).exists() && (iJavaElement = JavaCore.create((IResource)iResource)) != null && iJavaElement.exists()) {
                    return iFileInfo.getLastModified();
                }
            } else {
                IFileInfo iFileInfo;
                IPackageFragmentRoot iPackageFragmentRoot = typeNameMatch.getPackageFragmentRoot();
                if (iPackageFragmentRoot.exists() && (iFileInfo = EFS.getLocalFileSystem().getStore(iPackageFragmentRoot.getPath()).fetchInfo()).exists()) {
                    return iFileInfo.getLastModified();
                }
            }
        }
        catch (CoreException coreException) {}
        return -1L;
    }

    public boolean isContainerDirty(TypeNameMatch typeNameMatch) {
        ICompilationUnit iCompilationUnit = typeNameMatch.getType().getCompilationUnit();
        if (iCompilationUnit == null) {
            return false;
        }
        IResource iResource = iCompilationUnit.getResource();
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(iResource.getFullPath(), LocationKind.IFILE);
        if (iTextFileBuffer != null) {
            return iTextFileBuffer.isDirty();
        }
        return false;
    }

    private void doShutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.save();
    }

    protected Object createFromElement(Element element) {
        String string = element.getAttribute(NODE_HANDLE);
        if (string == null) {
            return null;
        }
        IJavaElement iJavaElement = JavaCore.create((String)string);
        if (!(iJavaElement instanceof IType)) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(element.getAttribute(NODE_MODIFIERS));
        }
        catch (NumberFormatException numberFormatException) {}
        TypeNameMatch typeNameMatch = SearchEngine.createTypeNameMatch((IType)((IType)iJavaElement), (int)n);
        long l = -1L;
        String string2 = element.getAttribute(NODE_TIMESTAMP);
        if (string2 != null && string2.length() > 0) {
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (l != -1L) {
            this.fTimestampMapping.put(typeNameMatch, new Long(l));
        }
        return typeNameMatch;
    }

    protected void setAttributes(Object object, Element element) {
        TypeNameMatch typeNameMatch = (TypeNameMatch)object;
        String string = typeNameMatch.getType().getHandleIdentifier();
        element.setAttribute(NODE_HANDLE, string);
        element.setAttribute(NODE_MODIFIERS, Integer.toString(typeNameMatch.getModifiers()));
        Long l = (Long)this.fTimestampMapping.get(typeNameMatch);
        if (l == null) {
            element.setAttribute(NODE_TIMESTAMP, Long.toString(-1L));
        } else {
            element.setAttribute(NODE_TIMESTAMP, l.toString());
        }
    }

    private static class TypeHistoryDeltaListener
    implements IElementChangedListener {
        private TypeHistoryDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            if (this.processDelta(elementChangedEvent.getDelta())) {
                OpenTypeHistory.getInstance().markAsInconsistent();
            }
        }

        private boolean processDelta(IJavaElementDelta iJavaElementDelta) {
            IJavaElement iJavaElement = iJavaElementDelta.getElement();
            boolean bl = iJavaElementDelta.getKind() == 4;
            boolean bl2 = iJavaElementDelta.getKind() == 2;
            switch (iJavaElement.getElementType()) {
                case 2: {
                    if (bl2 || bl && (iJavaElementDelta.getFlags() & 0x400) != 0) {
                        return true;
                    }
                    return this.processChildrenDelta(iJavaElementDelta);
                }
                case 3: {
                    if (bl2 || bl && ((iJavaElementDelta.getFlags() & 0x8000) != 0 || (iJavaElementDelta.getFlags() & 0x80) != 0)) {
                        return true;
                    }
                    return this.processChildrenDelta(iJavaElementDelta);
                }
                case 7: {
                    if (bl && (iJavaElementDelta.getFlags() & 2) != 0) {
                        return true;
                    }
                }
                case 1: 
                case 4: 
                case 6: {
                    if (bl2) {
                        return true;
                    }
                    return this.processChildrenDelta(iJavaElementDelta);
                }
                case 5: {
                    if (!JavaModelUtil.isPrimary((ICompilationUnit)iJavaElement)) {
                        return false;
                    }
                    if (bl2 || bl && this.isUnknownStructuralChange(iJavaElementDelta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(iJavaElementDelta);
                }
            }
            return false;
        }

        private boolean isUnknownStructuralChange(int n) {
            if ((n & 1) == 0) {
                return false;
            }
            return (n & 0x4000) == 0;
        }

        private boolean processChildrenDelta(IJavaElementDelta iJavaElementDelta) {
            IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
            int n = 0;
            while (n < iJavaElementDeltaArray.length) {
                if (this.processDelta(iJavaElementDeltaArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    private static class UpdateJob
    extends Job {
        public static final String FAMILY;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.util.OpenTypeHistory$UpdateJob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            FAMILY = clazz.getName();
        }

        public UpdateJob() {
            super(CorextMessages.TypeInfoHistory_consistency_check);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            OpenTypeHistory openTypeHistory = OpenTypeHistory.getInstance();
            openTypeHistory.internalCheckConsistency(iProgressMonitor);
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }

        public boolean belongsTo(Object object) {
            return FAMILY.equals(object);
        }
    }
}

