/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeHierarchyChangedListener;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.LRUMap;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;

public class SuperTypeHierarchyCache {
    private static final int CACHE_SIZE = 8;
    private static ArrayList fgHierarchyCache = new ArrayList(8);
    private static Map fgMethodOverrideTesterCache = new LRUMap(8);
    private static int fgCacheHits = 0;
    private static int fgCacheMisses = 0;

    public static ITypeHierarchy getTypeHierarchy(IType iType) throws JavaModelException {
        return SuperTypeHierarchyCache.getTypeHierarchy(iType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodOverrideTester getMethodOverrideTester(IType iType) throws JavaModelException {
        MethodOverrideTester methodOverrideTester = null;
        Map map = fgMethodOverrideTesterCache;
        synchronized (map) {
            methodOverrideTester = (MethodOverrideTester)fgMethodOverrideTesterCache.get(iType);
        }
        if (methodOverrideTester == null) {
            map = SuperTypeHierarchyCache.getTypeHierarchy(iType);
            Map map2 = fgMethodOverrideTesterCache;
            synchronized (map2) {
                methodOverrideTester = (MethodOverrideTester)fgMethodOverrideTesterCache.get(iType);
                if (methodOverrideTester == null) {
                    methodOverrideTester = new MethodOverrideTester(iType, (ITypeHierarchy)map);
                    fgMethodOverrideTesterCache.put(iType, methodOverrideTester);
                }
            }
        }
        return methodOverrideTester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeMethodOverrideTester(ITypeHierarchy iTypeHierarchy) {
        Map map = fgMethodOverrideTesterCache;
        synchronized (map) {
            Iterator iterator = fgMethodOverrideTesterCache.values().iterator();
            while (iterator.hasNext()) {
                MethodOverrideTester methodOverrideTester = (MethodOverrideTester)iterator.next();
                if (!methodOverrideTester.getTypeHierarchy().equals(iTypeHierarchy)) continue;
                iterator.remove();
            }
        }
    }

    public static ITypeHierarchy getTypeHierarchy(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ITypeHierarchy iTypeHierarchy = SuperTypeHierarchyCache.findTypeHierarchyInCache(iType);
        if (iTypeHierarchy == null) {
            ++fgCacheMisses;
            iTypeHierarchy = iType.newSupertypeHierarchy(iProgressMonitor);
            SuperTypeHierarchyCache.addTypeHierarchyToCache(iTypeHierarchy);
        } else {
            ++fgCacheHits;
        }
        return iTypeHierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTypeHierarchyToCache(ITypeHierarchy iTypeHierarchy) {
        ArrayList arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            HierarchyCacheEntry hierarchyCacheEntry;
            int n = fgHierarchyCache.size();
            if (n >= 8) {
                hierarchyCacheEntry = null;
                ArrayList<HierarchyCacheEntry> arrayList2 = new ArrayList<HierarchyCacheEntry>(8);
                int n2 = 0;
                while (n2 < n) {
                    HierarchyCacheEntry hierarchyCacheEntry2 = (HierarchyCacheEntry)fgHierarchyCache.get(n2);
                    ITypeHierarchy iTypeHierarchy2 = hierarchyCacheEntry2.getTypeHierarchy();
                    if (!iTypeHierarchy2.exists() || iTypeHierarchy.contains(iTypeHierarchy2.getType())) {
                        arrayList2.add(hierarchyCacheEntry2);
                    } else if (hierarchyCacheEntry == null || hierarchyCacheEntry2.getLastAccess() < hierarchyCacheEntry.getLastAccess()) {
                        hierarchyCacheEntry = hierarchyCacheEntry2;
                    }
                    ++n2;
                }
                if (!arrayList2.isEmpty()) {
                    n2 = 0;
                    while (n2 < arrayList2.size()) {
                        SuperTypeHierarchyCache.removeHierarchyEntryFromCache((HierarchyCacheEntry)arrayList2.get(n2));
                        ++n2;
                    }
                } else if (hierarchyCacheEntry != null) {
                    SuperTypeHierarchyCache.removeHierarchyEntryFromCache(hierarchyCacheEntry);
                }
            }
            hierarchyCacheEntry = new HierarchyCacheEntry(iTypeHierarchy);
            fgHierarchyCache.add(hierarchyCacheEntry);
        }
    }

    public static boolean hasInCache(IType iType) {
        return SuperTypeHierarchyCache.findTypeHierarchyInCache(iType) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ITypeHierarchy findTypeHierarchyInCache(IType iType) {
        ArrayList arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            int n = fgHierarchyCache.size() - 1;
            while (n >= 0) {
                HierarchyCacheEntry hierarchyCacheEntry = (HierarchyCacheEntry)fgHierarchyCache.get(n);
                ITypeHierarchy iTypeHierarchy = hierarchyCacheEntry.getTypeHierarchy();
                if (!iTypeHierarchy.exists()) {
                    SuperTypeHierarchyCache.removeHierarchyEntryFromCache(hierarchyCacheEntry);
                } else if (iTypeHierarchy.contains(iType)) {
                    hierarchyCacheEntry.markAsAccessed();
                    return iTypeHierarchy;
                }
                --n;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeHierarchyEntryFromCache(HierarchyCacheEntry hierarchyCacheEntry) {
        ArrayList arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            SuperTypeHierarchyCache.removeMethodOverrideTester(hierarchyCacheEntry.getTypeHierarchy());
            hierarchyCacheEntry.dispose();
            fgHierarchyCache.remove(hierarchyCacheEntry);
        }
    }

    public static int getCacheHits() {
        return fgCacheHits;
    }

    public static int getCacheMisses() {
        return fgCacheMisses;
    }

    private static class HierarchyCacheEntry
    implements ITypeHierarchyChangedListener {
        private ITypeHierarchy fTypeHierarchy;
        private long fLastAccess;

        public HierarchyCacheEntry(ITypeHierarchy iTypeHierarchy) {
            this.fTypeHierarchy = iTypeHierarchy;
            this.fTypeHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.markAsAccessed();
        }

        public void typeHierarchyChanged(ITypeHierarchy iTypeHierarchy) {
            SuperTypeHierarchyCache.removeHierarchyEntryFromCache(this);
        }

        public ITypeHierarchy getTypeHierarchy() {
            return this.fTypeHierarchy;
        }

        public void markAsAccessed() {
            this.fLastAccess = System.currentTimeMillis();
        }

        public long getLastAccess() {
            return this.fLastAccess;
        }

        public void dispose() {
            this.fTypeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.fTypeHierarchy = null;
        }

        public String toString() {
            return "Super hierarchy of: " + this.fTypeHierarchy.getType().getElementName();
        }
    }
}

