/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;

public class CategoryFilterActionGroup
extends ActionGroup {
    private static int COUNTER = 0;
    private static final String FILTER_CATEGORY_ACTION_ID = "FilterCategoryActionId";
    private final String CATEGORY_MENU_GROUP_NAME = "CategoryMenuGroup" + COUNTER++;
    private static final int MAX_NUMBER_OF_CATEGORIES_IN_MENU = 5;
    private final StructuredViewer fViewer;
    private final String fViewerId;
    private final CategoryFilter fFilter;
    private final HashSet fFilteredCategories;
    private IJavaElement[] fInputElement;
    private final CategoryFilterMenuAction fMenuAction;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;
    private final LinkedHashMap fLRUList;
    private boolean fFilterUncategorizedMembers;

    public CategoryFilterActionGroup(StructuredViewer structuredViewer, String string, IJavaElement[] iJavaElementArray) {
        Assert.isLegal((structuredViewer != null ? 1 : 0) != 0);
        Assert.isLegal((string != null ? 1 : 0) != 0);
        Assert.isLegal((iJavaElementArray != null ? 1 : 0) != 0);
        this.fLRUList = new LinkedHashMap(10, 0.75f, true){
            private static final long serialVersionUID = 1L;

            protected boolean removeEldestEntry(Map.Entry entry) {
                return this.size() > 5;
            }
        };
        this.fViewer = structuredViewer;
        this.fViewerId = string;
        this.fInputElement = iJavaElementArray;
        this.fFilter = new CategoryFilter();
        this.fFilteredCategories = new HashSet();
        this.loadSettings();
        this.fMenuAction = new CategoryFilterMenuAction();
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    public void setInput(IJavaElement[] iJavaElementArray) {
        Assert.isLegal((iJavaElementArray != null ? 1 : 0) != 0);
        this.fInputElement = iJavaElementArray;
    }

    private void loadSettings() {
        int n;
        String[] stringArray;
        this.fFilteredCategories.clear();
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString(this.getPreferenceKey());
        if (string != null && string.length() > 0) {
            stringArray = string.split(";");
            n = 0;
            while (n < stringArray.length) {
                this.fFilteredCategories.add(stringArray[n]);
                ++n;
            }
        }
        if ((string = iPreferenceStore.getString(String.valueOf(this.getPreferenceKey()) + ".LRU")) != null && string.length() > 0) {
            stringArray = string.split(";");
            n = stringArray.length - 1;
            while (n >= 0) {
                this.fLRUList.put(stringArray[n], stringArray[n]);
                --n;
            }
        }
        this.fFilterUncategorizedMembers = iPreferenceStore.getBoolean(String.valueOf(this.getPreferenceKey()) + ".FilterUncategorized");
    }

    private void storeSettings() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (this.fFilteredCategories.size() == 0) {
            iPreferenceStore.setValue(this.getPreferenceKey(), "");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator<Object> iterator = this.fFilteredCategories.iterator();
            String string = (String)iterator.next();
            stringBuffer.append(string);
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append(';');
                stringBuffer.append(string);
            }
            iPreferenceStore.setValue(this.getPreferenceKey(), stringBuffer.toString());
            stringBuffer = new StringBuffer();
            iterator = this.fLRUList.values().iterator();
            string = (String)iterator.next();
            stringBuffer.append(string);
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append(';');
                stringBuffer.append(string);
            }
            iPreferenceStore.setValue(String.valueOf(this.getPreferenceKey()) + ".LRU", stringBuffer.toString());
            iPreferenceStore.setValue(String.valueOf(this.getPreferenceKey()) + ".FilterUncategorized", this.fFilterUncategorizedMembers);
        }
    }

    public void contributeToViewMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator(this.CATEGORY_MENU_GROUP_NAME));
        iMenuManager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)this.fMenuAction);
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                if (!iMenuManager.isVisible()) {
                    return;
                }
                CategoryFilterActionGroup.this.updateMenu(iMenuManager);
            }
        };
        iMenuManager.addMenuListener(this.fMenuListener);
        this.fMenuManager = iMenuManager;
    }

    public void dispose() {
        super.dispose();
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
            this.fMenuManager = null;
            this.fMenuListener = null;
        }
    }

    private void updateMenu(IMenuManager iMenuManager) {
        IContributionItem[] iContributionItemArray = iMenuManager.getItems();
        if (iContributionItemArray != null) {
            int n = 0;
            while (n < iContributionItemArray.length) {
                IContributionItem iContributionItem;
                IContributionItem iContributionItem2 = iContributionItemArray[n];
                if (iContributionItem2 != null && iContributionItem2.getId() != null && iContributionItem2.getId().equals(FILTER_CATEGORY_ACTION_ID) && (iContributionItem = iMenuManager.remove(iContributionItem2)) != null) {
                    iContributionItem2.dispose();
                }
                ++n;
            }
        }
        ArrayList arrayList = new ArrayList();
        boolean bl = this.getMenuCategories(arrayList);
        Collections.sort(arrayList, Collator.getInstance());
        if (arrayList.size() > 0 && bl) {
            iMenuManager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)new FilterUncategorizedMembersAction());
        }
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            iMenuManager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)new CategoryFilterAction(string, n + 1));
            ++n;
        }
    }

    private boolean getMenuCategories(List list) {
        Object object;
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        final boolean[] blArray = new boolean[1];
        int n = 0;
        while (!(n >= this.fInputElement.length || blArray[0] && hashSet2.size() >= 5)) {
            this.collectCategories(this.fInputElement[n], new IResultCollector(){

                public boolean accept(String[] stringArray) {
                    if (stringArray.length > 0) {
                        int n = 0;
                        while (n < stringArray.length) {
                            String string = stringArray[n];
                            hashSet.add(string);
                            if (CategoryFilterActionGroup.this.fLRUList.containsKey(string)) {
                                hashSet2.add(string);
                            }
                            ++n;
                        }
                    } else {
                        blArray[0] = true;
                    }
                    return blArray[0] && hashSet2.size() >= 5;
                }
            });
            ++n;
        }
        n = 0;
        Object object2 = hashSet2.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            list.add(object);
            ++n;
        }
        if (n < 5) {
            object2 = new ArrayList(hashSet);
            Collections.sort(object2, Collator.getInstance());
            object = object2.iterator();
            while (object.hasNext() && n < 5) {
                String string = (String)object.next();
                if (hashSet2.contains(string)) continue;
                list.add(string);
                ++n;
            }
        }
        return blArray[0];
    }

    private boolean collectCategories(IJavaElement iJavaElement, IResultCollector iResultCollector) {
        try {
            if (iJavaElement instanceof IMember) {
                IMember iMember = (IMember)iJavaElement;
                iResultCollector.accept(iMember.getCategories());
                return this.processChildren(iMember.getChildren(), iResultCollector);
            }
            if (iJavaElement instanceof ICompilationUnit) {
                return this.processChildren(((ICompilationUnit)iJavaElement).getChildren(), iResultCollector);
            }
            if (iJavaElement instanceof IClassFile) {
                return this.processChildren(((IClassFile)iJavaElement).getChildren(), iResultCollector);
            }
            if (iJavaElement instanceof IJavaModel) {
                return this.processChildren(((IJavaModel)iJavaElement).getChildren(), iResultCollector);
            }
            if (iJavaElement instanceof IJavaProject) {
                return this.processChildren(((IJavaProject)iJavaElement).getChildren(), iResultCollector);
            }
            if (iJavaElement instanceof IPackageFragment) {
                return this.processChildren(((IPackageFragment)iJavaElement).getChildren(), iResultCollector);
            }
            if (iJavaElement instanceof IPackageFragmentRoot) {
                return this.processChildren(((IPackageFragmentRoot)iJavaElement).getChildren(), iResultCollector);
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return true;
        }
    }

    private boolean processChildren(IJavaElement[] iJavaElementArray, IResultCollector iResultCollector) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (this.collectCategories(iJavaElementArray[n], iResultCollector)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void fireSelectionChange() {
        this.fViewer.getControl().setRedraw(false);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                CategoryFilterActionGroup.this.fViewer.refresh();
            }
        });
        this.fViewer.getControl().setRedraw(true);
    }

    private String getPreferenceKey() {
        return "CategoryFilterActionGroup." + this.fViewerId;
    }

    private void showCategorySelectionDialog(IJavaElement[] iJavaElementArray) {
        final HashSet hashSet = new HashSet();
        int n = 0;
        while (n < iJavaElementArray.length) {
            this.collectCategories(iJavaElementArray[n], new IResultCollector(){

                public boolean accept(String[] stringArray) {
                    int n = 0;
                    while (n < stringArray.length) {
                        hashSet.add(stringArray[n]);
                        ++n;
                    }
                    return false;
                }
            });
            ++n;
        }
        CategoryFilterSelectionDialog categoryFilterSelectionDialog = new CategoryFilterSelectionDialog(this.fViewer.getControl().getShell(), new ArrayList(hashSet), new ArrayList(this.fFilteredCategories));
        if (categoryFilterSelectionDialog.open() == 0) {
            Object[] objectArray = categoryFilterSelectionDialog.getResult();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.contains(objectArray, string)) {
                    if (!this.fFilteredCategories.remove(string)) continue;
                    this.fLRUList.put(string, string);
                    continue;
                }
                if (!this.fFilteredCategories.add(string)) continue;
                this.fLRUList.put(string, string);
            }
            this.storeSettings();
            this.fireSelectionChange();
        }
    }

    private boolean contains(Object[] objectArray, String string) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private class CategoryFilter
    extends ViewerFilter {
        private CategoryFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object object, Object object2) {
            if (!(object2 instanceof IMember)) return true;
            IMember iMember = (IMember)object2;
            try {
                String[] stringArray = iMember.getCategories();
                if (stringArray.length == 0) {
                    if (!CategoryFilterActionGroup.this.fFilterUncategorizedMembers) return true;
                    return false;
                }
                int n = 0;
                while (true) {
                    if (n >= stringArray.length) {
                        return false;
                    }
                    if (!CategoryFilterActionGroup.this.fFilteredCategories.contains(stringArray[n])) {
                        return true;
                    }
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            return true;
        }
    }

    private class CategoryFilterAction
    extends Action {
        private final String fCategory;

        public CategoryFilterAction(String string, int n) {
            this.fCategory = string;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('&').append(n).append(' ').append(this.fCategory);
            this.setText(stringBuffer.toString());
            this.setChecked(!CategoryFilterActionGroup.this.fFilteredCategories.contains(this.fCategory));
            this.setId(CategoryFilterActionGroup.FILTER_CATEGORY_ACTION_ID);
        }

        public void run() {
            super.run();
            if (CategoryFilterActionGroup.this.fFilteredCategories.contains(this.fCategory)) {
                CategoryFilterActionGroup.this.fFilteredCategories.remove(this.fCategory);
            } else {
                CategoryFilterActionGroup.this.fFilteredCategories.add(this.fCategory);
            }
            CategoryFilterActionGroup.this.fLRUList.put(this.fCategory, this.fCategory);
            CategoryFilterActionGroup.this.storeSettings();
            CategoryFilterActionGroup.this.fireSelectionChange();
        }
    }

    private class CategoryFilterMenuAction
    extends Action {
        public CategoryFilterMenuAction() {
            this.setDescription(ActionMessages.CategoryFilterActionGroup_ShowCategoriesActionDescription);
            this.setToolTipText(ActionMessages.CategoryFilterActionGroup_ShowCategoriesToolTip);
            this.setText(ActionMessages.CategoryFilterActionGroup_ShowCategoriesLabel);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "category_menu.gif");
        }

        public void run() {
            CategoryFilterActionGroup.this.showCategorySelectionDialog(CategoryFilterActionGroup.this.fInputElement);
        }
    }

    private class CategoryFilterSelectionDialog
    extends SelectionStatusDialog
    implements IListAdapter {
        private static final int SELECT_ALL = 0;
        private static final int DESELECT_ALL = 1;
        private final CheckedListDialogField fCategoryList;

        public CategoryFilterSelectionDialog(Shell shell, List list, List list2) {
            super(shell);
            this.setTitle(ActionMessages.CategoryFilterActionGroup_JavaCategoryFilter_title);
            String[] stringArray = new String[]{ActionMessages.CategoryFilterActionGroup_SelectAllCategories, ActionMessages.CategoryFilterActionGroup_DeselectAllCategories};
            this.fCategoryList = new CheckedListDialogField(this, stringArray, new ILabelProvider(this){
                final /* synthetic */ CategoryFilterSelectionDialog this$1;
                {
                    this.this$1 = categoryFilterSelectionDialog;
                }

                public Image getImage(Object object) {
                    return null;
                }

                public String getText(Object object) {
                    return (String)object;
                }

                public void addListener(ILabelProviderListener iLabelProviderListener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object object, String string) {
                    return false;
                }

                public void removeListener(ILabelProviderListener iLabelProviderListener) {
                }
            });
            this.fCategoryList.addElements(list);
            this.fCategoryList.setViewerComparator(new ViewerComparator());
            this.fCategoryList.setLabelText(ActionMessages.CategoryFilterActionGroup_SelectCategoriesDescription);
            this.fCategoryList.checkAll(true);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.fCategoryList.setChecked(string, false);
            }
            if (list.size() == 0) {
                this.fCategoryList.setEnabled(false);
            }
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(4, 4, true, true));
            composite2.setLayout((Layout)new GridLayout(1, true));
            composite2.setFont(composite.getFont());
            Composite composite3 = new Composite(composite2, 0);
            composite3.setFont(composite2.getFont());
            LayoutUtil.doDefaultLayout(composite3, new DialogField[]{this.fCategoryList}, true);
            LayoutUtil.setHorizontalGrabbing(this.fCategoryList.getListControl(null));
            Dialog.applyDialogFont((Control)composite2);
            this.setHelpAvailable(false);
            return composite2;
        }

        protected void computeResult() {
            this.setResult(this.fCategoryList.getCheckedElements());
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            if (n == 0) {
                this.fCategoryList.checkAll(true);
                this.fCategoryList.refresh();
            } else if (n == 1) {
                this.fCategoryList.checkAll(false);
                this.fCategoryList.refresh();
            }
        }

        public void doubleClicked(ListDialogField listDialogField) {
            List list = listDialogField.getSelectedElements();
            if (list.size() == 1) {
                Object e;
                this.fCategoryList.setChecked(e, !this.fCategoryList.isChecked(e = list.get(0)));
            }
        }

        public void selectionChanged(ListDialogField listDialogField) {
        }
    }

    private class FilterUncategorizedMembersAction
    extends Action {
        public FilterUncategorizedMembersAction() {
            this.setText(ActionMessages.CategoryFilterActionGroup_ShowUncategorizedMembers);
            this.setChecked(!CategoryFilterActionGroup.this.fFilterUncategorizedMembers);
            this.setId(CategoryFilterActionGroup.FILTER_CATEGORY_ACTION_ID);
        }

        public void run() {
            CategoryFilterActionGroup.this.fFilterUncategorizedMembers = !CategoryFilterActionGroup.this.fFilterUncategorizedMembers;
            CategoryFilterActionGroup.this.storeSettings();
            CategoryFilterActionGroup.this.fireSelectionChange();
        }
    }

    private static interface IResultCollector {
        public boolean accept(String[] var1);
    }
}

