/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class CopyQualifiedNameAction
extends SelectionDispatchAction {
    private static final long LABEL_FLAGS = new Long(281477260838017L);
    public static final String ACTION_DEFINITION_ID = "org.eclipse.wst.jsdt.ui.edit.text.java.copy.qualified.name";
    public static final String ACTION_HANDLER_ID = "org.eclipse.wst.jsdt.ui.actions.CopyQualifiedName";
    private JavaEditor fEditor;

    public CopyQualifiedNameAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getSite());
        this.fEditor = javaEditor;
        this.setEnabled(true);
    }

    public CopyQualifiedNameAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.CopyQualifiedNameAction_ActionName);
        this.setToolTipText(ActionMessages.CopyQualifiedNameAction_ToolTipText);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_COPY_QUALIFIED_NAME);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_COPY_QUALIFIED_NAME);
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.canEnable(iStructuredSelection.toArray()));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    private boolean canEnable(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (this.isValideElement(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isValideElement(Object object) {
        if (object instanceof IMember) {
            return true;
        }
        if (object instanceof IClassFile) {
            return true;
        }
        if (object instanceof ICompilationUnit) {
            return true;
        }
        if (object instanceof IPackageDeclaration) {
            return true;
        }
        if (object instanceof IImportDeclaration) {
            return true;
        }
        return object instanceof IPackageFragment;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            IPath iPath;
            CharSequence charSequence;
            Transfer[] transferArray;
            Object[] objectArray;
            block16: {
                IJavaElement[] iJavaElementArray;
                block17: {
                    iJavaElementArray = this.getSelectedElements();
                    if (iJavaElementArray == null) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.CopyQualifiedNameAction_InfoDialogTitel, (String)ActionMessages.CopyQualifiedNameAction_NoElementToQualify);
                        return;
                    }
                    objectArray = null;
                    transferArray = null;
                    if (iJavaElementArray.length != 1) break block17;
                    charSequence = JavaElementLabels.getElementLabel(iJavaElementArray[0], LABEL_FLAGS);
                    IResource iResource = iJavaElementArray[0].getCorrespondingResource();
                    if (iResource != null) {
                        iPath = iResource.getLocation();
                        if (iPath != null) {
                            objectArray = new Object[]{charSequence, iResource, new String[]{iPath.toOSString()}};
                            transferArray = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
                            break block16;
                        } else {
                            objectArray = new Object[]{charSequence, iResource};
                            transferArray = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance()};
                        }
                        break block16;
                    } else {
                        objectArray = new Object[]{charSequence};
                        transferArray = new Transfer[]{TextTransfer.getInstance()};
                    }
                    break block16;
                }
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(JavaElementLabels.getElementLabel(iJavaElementArray[0], LABEL_FLAGS));
                int n = 1;
                while (true) {
                    if (n >= iJavaElementArray.length) {
                        objectArray = new Object[]{((StringBuffer)charSequence).toString()};
                        transferArray = new Transfer[]{TextTransfer.getInstance()};
                        break;
                    }
                    iPath = iJavaElementArray[n];
                    String string = JavaElementLabels.getElementLabel((IJavaElement)iPath, LABEL_FLAGS);
                    ((StringBuffer)charSequence).append('\r').append('\n').append(string);
                    ++n;
                }
            }
            charSequence = new Clipboard(this.getShell().getDisplay());
            try {
                try {
                    charSequence.setContents(objectArray, transferArray);
                }
                catch (SWTError sWTError) {
                    if (sWTError.code != 2002) {
                        throw sWTError;
                    }
                    if (MessageDialog.openQuestion((Shell)this.getShell(), (String)ActionMessages.CopyQualifiedNameAction_ErrorTitle, (String)ActionMessages.CopyQualifiedNameAction_ErrorDescription)) {
                        charSequence.setContents(objectArray, transferArray);
                    }
                }
            }
            catch (Throwable throwable) {
                iPath = null;
                charSequence.dispose();
                throw throwable;
            }
            {
                iPath = null;
                charSequence.dispose();
                return;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    private IJavaElement[] getSelectedElements() throws JavaModelException {
        if (this.fEditor != null) {
            IJavaElement iJavaElement = this.getSelectedElement(this.fEditor);
            if (iJavaElement == null) {
                return null;
            }
            return new IJavaElement[]{iJavaElement};
        }
        ISelection iSelection = this.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((IStructuredSelection)iSelection).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.isValideElement(e)) continue;
            arrayList.add(e);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    private IJavaElement getSelectedElement(JavaEditor javaEditor) {
        ISourceViewer iSourceViewer = javaEditor.getViewer();
        if (iSourceViewer == null) {
            return null;
        }
        Point point = iSourceViewer.getSelectedRange();
        int n = point.y;
        int n2 = point.x;
        IJavaElement iJavaElement = JavaUI.getEditorInputJavaElement(javaEditor.getEditorInput());
        CompilationUnit compilationUnit = ASTProvider.getASTProvider().getAST(iJavaElement, ASTProvider.WAIT_YES, null);
        if (compilationUnit == null) {
            return null;
        }
        NodeFinder nodeFinder = new NodeFinder(n2, n);
        compilationUnit.accept((ASTVisitor)nodeFinder);
        ASTNode aSTNode = nodeFinder.getCoveringNode();
        IBinding iBinding = null;
        if (aSTNode instanceof Name) {
            iBinding = ((Name)aSTNode).resolveBinding();
        } else if (aSTNode instanceof MethodInvocation) {
            iBinding = ((MethodInvocation)aSTNode).resolveMethodBinding();
        } else if (aSTNode instanceof MethodDeclaration) {
            iBinding = ((MethodDeclaration)aSTNode).resolveBinding();
        } else if (aSTNode instanceof Type) {
            iBinding = ((Type)aSTNode).resolveBinding();
        } else if (aSTNode instanceof AnonymousClassDeclaration) {
            iBinding = ((AnonymousClassDeclaration)aSTNode).resolveBinding();
        } else if (aSTNode instanceof TypeDeclaration) {
            iBinding = ((TypeDeclaration)aSTNode).resolveBinding();
        } else {
            if (aSTNode instanceof CompilationUnit) {
                return ((CompilationUnit)aSTNode).getJavaElement();
            }
            if (aSTNode instanceof Expression) {
                iBinding = ((Expression)aSTNode).resolveTypeBinding();
            } else if (aSTNode instanceof ImportDeclaration) {
                iBinding = ((ImportDeclaration)aSTNode).resolveBinding();
            } else if (aSTNode instanceof MemberRef) {
                iBinding = ((MemberRef)aSTNode).resolveBinding();
            } else if (aSTNode instanceof MemberValuePair) {
                iBinding = ((MemberValuePair)aSTNode).resolveMemberValuePairBinding();
            } else if (aSTNode instanceof PackageDeclaration) {
                iBinding = ((PackageDeclaration)aSTNode).resolveBinding();
            } else if (aSTNode instanceof TypeParameter) {
                iBinding = ((TypeParameter)aSTNode).resolveBinding();
            } else if (aSTNode instanceof VariableDeclaration) {
                iBinding = ((VariableDeclaration)aSTNode).resolveBinding();
            }
        }
        if (iBinding != null) {
            return iBinding.getJavaElement();
        }
        return null;
    }
}

