/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.GenerateConstructorUsingFieldsSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

public class GenerateConstructorUsingFieldsValidator
implements ISelectionStatusValidator {
    private GenerateConstructorUsingFieldsSelectionDialog fDialog;
    private final int fEntries;
    private List fSignatures;
    private ITypeBinding fType = null;

    public GenerateConstructorUsingFieldsValidator(GenerateConstructorUsingFieldsSelectionDialog generateConstructorUsingFieldsSelectionDialog, ITypeBinding iTypeBinding, int n) {
        this.fEntries = n;
        this.fDialog = generateConstructorUsingFieldsSelectionDialog;
        this.fType = iTypeBinding;
        this.fSignatures = this.getExistingConstructorSignatures();
    }

    public GenerateConstructorUsingFieldsValidator(int n) {
        this.fEntries = n;
        this.fType = null;
    }

    private int countSelectedFields(Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof IVariableBinding) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private void createSignature(IMethodBinding iMethodBinding, StringBuffer stringBuffer, Object[] objectArray) {
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            stringBuffer.append(iTypeBindingArray[n].getName());
            ++n;
        }
        if (objectArray != null) {
            n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof IVariableBinding) {
                    stringBuffer.append(((IVariableBinding)objectArray[n]).getType().getErasure().getName());
                }
                ++n;
            }
        }
    }

    private List getExistingConstructorSignatures() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IMethodBinding[] iMethodBindingArray = this.fType.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            if (iMethodBindingArray[n].isConstructor()) {
                StringBuffer stringBuffer = new StringBuffer();
                this.createSignature(iMethodBindingArray[n], stringBuffer, null);
                arrayList.add(stringBuffer.toString());
            }
            ++n;
        }
        return arrayList;
    }

    public IStatus validate(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        IMethodBinding iMethodBinding = this.fDialog.getSuperConstructorChoice();
        this.createSignature(iMethodBinding, stringBuffer, objectArray);
        if (this.fSignatures.contains(stringBuffer.toString())) {
            return new StatusInfo(2, ActionMessages.GenerateConstructorUsingFieldsAction_error_duplicate_constructor);
        }
        return new StatusInfo(1, Messages.format(ActionMessages.GenerateConstructorUsingFieldsAction_fields_selected, new Object[]{String.valueOf(this.countSelectedFields(objectArray)), String.valueOf(this.fEntries)}));
    }
}

