/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class CallHierarchyUI {
    private static final int DEFAULT_MAX_CALL_DEPTH = 10;
    private static final String PREF_MAX_CALL_DEPTH = "PREF_MAX_CALL_DEPTH";
    private static CallHierarchyUI fgInstance;

    private CallHierarchyUI() {
    }

    public static CallHierarchyUI getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchyUI();
        }
        return fgInstance;
    }

    public int getMaxCallDepth() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        int n = iPreferenceStore.getInt(PREF_MAX_CALL_DEPTH);
        if (n < 1 || n > 99) {
            n = 10;
        }
        return n;
    }

    public void setMaxCallDepth(int n) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(PREF_MAX_CALL_DEPTH, n);
    }

    public static void jumpToMember(IJavaElement iJavaElement) {
        if (iJavaElement != null) {
            try {
                JavaUI.openInEditor(iJavaElement, true, true);
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            catch (PartInitException partInitException) {
                JavaPlugin.log(partInitException);
            }
        }
    }

    public static void jumpToLocation(CallLocation callLocation) {
        try {
            IEditorPart iEditorPart = JavaUI.openInEditor((IJavaElement)callLocation.getMember(), false, false);
            if (iEditorPart instanceof ITextEditor) {
                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                iTextEditor.selectAndReveal(callLocation.getStart(), callLocation.getEnd() - callLocation.getStart());
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        catch (PartInitException partInitException) {
            JavaPlugin.log(partInitException);
        }
    }

    public static boolean openInEditor(Object object, Shell shell, String string) {
        int n;
        int n2;
        IMember iMember;
        CallLocation callLocation;
        block9: {
            block10: {
                ISourceRange iSourceRange;
                block11: {
                    callLocation = CallHierarchy.getCallLocation(object);
                    if (callLocation != null) {
                        iMember = callLocation.getMember();
                        n2 = callLocation.getStart();
                        n = callLocation.getEnd() - n2;
                        break block9;
                    }
                    if (!(object instanceof MethodWrapper)) break block10;
                    iMember = ((MethodWrapper)((Object)object)).getMember();
                    if (iMember.isVirtual()) {
                        n2 = 0;
                        n = 0;
                        break block9;
                    }
                    iSourceRange = iMember.getNameRange();
                    if (iSourceRange == null) {
                        iSourceRange = iMember.getSourceRange();
                    }
                    if (iSourceRange != null) break block11;
                    return true;
                }
                n2 = iSourceRange.getOffset();
                n = iSourceRange.getLength();
                break block9;
            }
            return true;
        }
        try {
            boolean bl = OpenStrategy.activateOnOpen();
            IEditorPart iEditorPart = JavaUI.openInEditor((IJavaElement)iMember, bl, false);
            if (iEditorPart instanceof ITextEditor) {
                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                iTextEditor.selectAndReveal(n2, n);
            }
            return true;
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (Throwable)javaModelException));
            ErrorDialog.openError((Shell)shell, (String)string, (String)CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (IStatus)javaModelException.getStatus());
            return false;
        }
        catch (PartInitException partInitException) {
            String string2 = callLocation != null ? callLocation.getCalledMember().getElementName() : (object instanceof MethodWrapper ? ((MethodWrapper)((Object)object)).getName() : "");
            MessageDialog.openError((Shell)shell, (String)string, (String)Messages.format(CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_messageArgs, new String[]{string2, partInitException.getMessage()}));
            return false;
        }
    }

    public static IEditorPart isOpenInEditor(Object object) {
        IMember iMember = null;
        if (object instanceof MethodWrapper) {
            iMember = ((MethodWrapper)((Object)object)).getMember();
        } else if (object instanceof CallLocation) {
            iMember = ((CallLocation)object).getCalledMember();
        }
        if (iMember != null) {
            return EditorUtility.isOpenInEditor(iMember);
        }
        return null;
    }

    public static IJavaElement[] getCandidates(Object object) {
        if (!(object instanceof IJavaElement)) {
            return null;
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        if (iJavaElement.getElementType() == 9) {
            return new IJavaElement[]{iJavaElement};
        }
        return null;
    }

    public static CallHierarchyViewPart open(IJavaElement[] iJavaElementArray, IWorkbenchWindow iWorkbenchWindow) {
        Assert.isTrue((iJavaElementArray != null && iJavaElementArray.length != 0 ? 1 : 0) != 0);
        IJavaElement iJavaElement = null;
        if (iJavaElementArray.length > 1) {
            String string = CallHierarchyMessages.CallHierarchyUI_selectionDialog_title;
            String string2 = CallHierarchyMessages.CallHierarchyUI_selectionDialog_message;
            iJavaElement = SelectionConverter.selectJavaElement(iJavaElementArray, iWorkbenchWindow.getShell(), string, string2);
        } else {
            iJavaElement = iJavaElementArray[0];
        }
        if (iJavaElement == null) {
            return null;
        }
        return CallHierarchyUI.openInViewPart(iWorkbenchWindow, iJavaElement);
    }

    private static CallHierarchyViewPart openInViewPart(IWorkbenchWindow iWorkbenchWindow, IJavaElement iJavaElement) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        try {
            CallHierarchyViewPart callHierarchyViewPart = (CallHierarchyViewPart)iWorkbenchPage.showView("org.eclipse.wst.jsdt.callhierarchy.view");
            callHierarchyViewPart.setMethod((IMethod)iJavaElement);
            return callHierarchyViewPart;
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, iWorkbenchWindow.getShell(), CallHierarchyMessages.CallHierarchyUI_error_open_view, coreException.getMessage());
            return null;
        }
    }

    static ISelection convertSelection(ISelection iSelection) {
        if (iSelection.isEmpty()) {
            return iSelection;
        }
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                IMember iMember;
                Object e = iterator.next();
                if (e instanceof MethodWrapper) {
                    iMember = ((MethodWrapper)((Object)e)).getMember();
                    if (iMember == null) continue;
                    arrayList.add(iMember);
                    continue;
                }
                if (e instanceof IMember) {
                    arrayList.add(e);
                    continue;
                }
                if (!(e instanceof CallLocation)) continue;
                iMember = ((CallLocation)e).getMember();
                arrayList.add(iMember);
            }
            return new StructuredSelection(arrayList);
        }
        return StructuredSelection.EMPTY;
    }
}

