/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;

class CopyCallHierarchyAction
extends Action {
    private static final char INDENTATION = '\t';
    private CallHierarchyViewPart fView;
    private CallHierarchyViewer fViewer;
    private final Clipboard fClipboard;

    public CopyCallHierarchyAction(CallHierarchyViewPart callHierarchyViewPart, Clipboard clipboard, CallHierarchyViewer callHierarchyViewer) {
        super(CallHierarchyMessages.CopyCallHierarchyAction_label);
        Assert.isNotNull((Object)clipboard);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_copy_action_context");
        this.fView = callHierarchyViewPart;
        this.fClipboard = clipboard;
        this.fViewer = callHierarchyViewer;
    }

    public boolean canActionBeAdded() {
        Object object = SelectionUtil.getSingleElement(this.getSelection());
        return object != null;
    }

    private ISelection getSelection() {
        ISelectionProvider iSelectionProvider = this.fView.getSite().getSelectionProvider();
        if (iSelectionProvider != null) {
            return iSelectionProvider.getSelection();
        }
        return null;
    }

    public void run() {
        block3: {
            StringBuffer stringBuffer = new StringBuffer();
            this.addCalls(this.fViewer.getTree().getSelection()[0], 0, stringBuffer);
            TextTransfer textTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{CopyCallHierarchyAction.convertLineTerminators(stringBuffer.toString())}, new Transfer[]{textTransfer});
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                if (!MessageDialog.openQuestion((Shell)this.fView.getViewSite().getShell(), (String)CallHierarchyMessages.CopyCallHierarchyAction_problem, (String)CallHierarchyMessages.CopyCallHierarchyAction_clipboard_busy)) break block3;
                this.run();
            }
        }
    }

    private void addCalls(TreeItem treeItem, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append('\t');
            ++n2;
        }
        stringBuffer.append(treeItem.getText());
        stringBuffer.append('\n');
        if (treeItem.getExpanded()) {
            TreeItem[] treeItemArray = treeItem.getItems();
            int n3 = 0;
            while (n3 < treeItemArray.length) {
                this.addCalls(treeItemArray[n3], n + 1, stringBuffer);
                ++n3;
            }
        }
    }

    static String convertLineTerminators(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                printWriter.print(string2);
                string2 = bufferedReader.readLine();
                if (string2 == null || string2.length() == 0) continue;
                printWriter.println();
            }
        }
        catch (IOException iOException) {
            return string;
        }
        return stringWriter.toString();
    }
}

