/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;

public class JavaNode
extends DocumentRangeNode
implements ITypedElement {
    public static final int CU = 0;
    public static final int PACKAGE = 1;
    public static final int IMPORT_CONTAINER = 2;
    public static final int IMPORT = 3;
    public static final int INTERFACE = 4;
    public static final int CLASS = 5;
    public static final int ENUM = 6;
    public static final int ANNOTATION = 7;
    public static final int FIELD = 8;
    public static final int INIT = 9;
    public static final int CONSTRUCTOR = 10;
    public static final int METHOD = 11;
    private int fInitializerCount = 1;

    public JavaNode(JavaNode javaNode, int n, String string, int n2, int n3) {
        super((DocumentRangeNode)javaNode, n, JavaCompareUtilities.buildID(n, string), javaNode.getDocument(), n2, n3);
        javaNode.addChild(this);
    }

    public JavaNode(IDocument iDocument) {
        super(0, JavaCompareUtilities.buildID(0, "root"), iDocument, 0, iDocument.getLength());
    }

    public String getInitializerCount() {
        return Integer.toString(this.fInitializerCount++);
    }

    public String extractMethodName() {
        String string = this.getId();
        int n = string.indexOf(40);
        if (n > 0) {
            return string.substring(1, n);
        }
        return string.substring(1);
    }

    public String extractArgumentList() {
        String string = this.getId();
        int n = string.indexOf(40);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string.substring(1);
    }

    public String getName() {
        switch (this.getTypeCode()) {
            case 9: {
                return CompareMessages.JavaNode_initializer;
            }
            case 2: {
                return CompareMessages.JavaNode_importDeclarations;
            }
            case 0: {
                return CompareMessages.JavaNode_compilationUnit;
            }
            case 1: {
                return CompareMessages.JavaNode_packageDeclaration;
            }
        }
        return this.getId().substring(1);
    }

    public String getType() {
        return "java2";
    }

    public Image getImage() {
        ImageDescriptor imageDescriptor = null;
        switch (this.getTypeCode()) {
            case 0: {
                imageDescriptor = JavaCompareUtilities.getImageDescriptor(5);
                break;
            }
            case 1: {
                imageDescriptor = JavaCompareUtilities.getImageDescriptor(11);
                break;
            }
            case 3: {
                imageDescriptor = JavaCompareUtilities.getImageDescriptor(13);
                break;
            }
            case 2: {
                imageDescriptor = JavaCompareUtilities.getImageDescriptor(12);
                break;
            }
            case 5: {
                imageDescriptor = JavaCompareUtilities.getTypeImageDescriptor(true);
                break;
            }
            case 4: {
                imageDescriptor = JavaCompareUtilities.getTypeImageDescriptor(false);
                break;
            }
            case 9: {
                imageDescriptor = JavaCompareUtilities.getImageDescriptor(10);
                break;
            }
            case 10: 
            case 11: {
                imageDescriptor = JavaCompareUtilities.getImageDescriptor(9);
                break;
            }
            case 8: {
                imageDescriptor = JavaCompareUtilities.getImageDescriptor(8);
                break;
            }
            case 6: {
                imageDescriptor = JavaCompareUtilities.getEnumImageDescriptor();
                break;
            }
            case 7: {
                imageDescriptor = JavaCompareUtilities.getAnnotationImageDescriptor();
            }
        }
        return JavaPlugin.getImageDescriptorRegistry().get(imageDescriptor);
    }

    public String toString() {
        return String.valueOf(this.getType()) + ": " + this.getName() + "[" + this.getRange().offset + "+" + this.getRange().length + "]";
    }
}

