/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.history.ElementLocalHistoryPageSource;
import org.eclipse.team.ui.history.HistoryPageCompareEditorInput;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaHistoryActionImpl;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

class JavaReplaceWithEditionActionImpl
extends JavaHistoryActionImpl {
    protected boolean fPrevious = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    JavaReplaceWithEditionActionImpl(boolean bl) {
        super(true);
        this.fPrevious = bl;
    }

    public void run(ISelection iSelection) {
        Shell shell = this.getShell();
        final IMember iMember = this.getEditionElement(iSelection);
        if (iMember == null) {
            MessageDialog.openInformation((Shell)shell, (String)CompareMessages.ReplaceFromHistory_title, (String)CompareMessages.ReplaceFromHistory_invalidSelectionMessage);
            return;
        }
        final IFile iFile = this.getFile(iMember);
        if (iFile == null) {
            this.showError();
            return;
        }
        IStatus iStatus = Resources.makeCommittable((IResource)iFile, (Object)shell);
        if (!iStatus.isOK()) {
            return;
        }
        if (this.fPrevious) {
            String string = CompareMessages.ReplaceFromHistory_title;
            String string2 = CompareMessages.ReplaceFromHistory_internalErrorMessage;
            try {
                ITypedElement iTypedElement = ElementLocalHistoryPageSource.getPreviousEdition((IFile)iFile, (Object)iMember);
                if (iTypedElement == null) {
                    MessageDialog.openInformation((Shell)shell, (String)string, (String)CompareMessages.ReplaceFromHistory_parsingErrorMessage);
                    return;
                }
                this.replace(iMember, iFile, iTypedElement);
            }
            catch (TeamException teamException) {
                ExceptionHandler.handle((CoreException)((Object)teamException), shell, string, string2);
            }
        } else {
            JavaElementHistoryPageSource javaElementHistoryPageSource = JavaElementHistoryPageSource.getInstance();
            CompareConfiguration compareConfiguration = new CompareConfiguration();
            compareConfiguration.setLeftEditable(false);
            compareConfiguration.setRightEditable(false);
            HistoryPageCompareEditorInput historyPageCompareEditorInput = new HistoryPageCompareEditorInput(compareConfiguration, (IHistoryPageSource)javaElementHistoryPageSource, iMember){

                protected void performReplace(Object object) {
                    if (object instanceof ITypedElement) {
                        JavaReplaceWithEditionActionImpl.this.replace(iMember, iFile, (ITypedElement)object);
                    }
                }
            };
            historyPageCompareEditorInput.setReplace(true);
            historyPageCompareEditorInput.setTitle(CompareMessages.JavaReplaceWithEditionActionImpl_0);
            historyPageCompareEditorInput.setHelpContextId("org.eclipse.wst.jsdt.ui.replace_element_with_history_dialog_context");
            CompareUI.openCompareDialog((CompareEditorInput)historyPageCompareEditorInput);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replace(IMember iMember, IFile iFile, ITypedElement iTypedElement) {
        Shell shell = this.getShell();
        String string = CompareMessages.ReplaceFromHistory_title;
        String string2 = CompareMessages.ReplaceFromHistory_internalErrorMessage;
        IPath iPath = iFile.getFullPath();
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer iTextFileBuffer = null;
        try {
            try {
                iTextFileBufferManager.connect(iPath, LocationKind.IFILE, null);
                iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(iPath, LocationKind.IFILE);
                IDocument iDocument = iTextFileBuffer.getDocument();
                this.performReplace(iMember, iFile, iTextFileBuffer, iDocument, iTypedElement);
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(invocationTargetException, shell, string, string2);
            }
            catch (InterruptedException interruptedException) {
                Assert.isTrue((boolean)false);
            }
            catch (CoreException coreException) {
                ExceptionHandler.handle(coreException, shell, string, string2);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (iTextFileBuffer == null) throw throwable;
                iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, null);
                throw throwable;
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        try {}
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            return;
        }
        if (iTextFileBuffer == null) return;
        iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, null);
    }

    private void performReplace(IMember iMember, IFile iFile, ITextFileBuffer iTextFileBuffer, IDocument iDocument, ITypedElement iTypedElement) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
        if (iTypedElement instanceof IStreamContentAccessor) {
            Object object;
            ASTNode aSTNode;
            boolean bl = this.beingEdited(iFile);
            String string = JavaCompareUtilities.readString((IStreamContentAccessor)iTypedElement);
            String string2 = JavaReplaceWithEditionActionImpl.trimTextBlock(string, TextUtilities.getDefaultLineDelimiter((IDocument)iDocument), iMember.getJavaProject());
            if (string2 == null) {
                this.showError();
                return;
            }
            ICompilationUnit iCompilationUnit = iMember.getCompilationUnit();
            CompilationUnit compilationUnit = JavaReplaceWithEditionActionImpl.parsePartialCompilationUnit(iCompilationUnit);
            ISourceRange iSourceRange = iMember.getNameRange();
            int n = iSourceRange.getLength();
            if (n < 0) {
                n = 1;
            }
            ASTNode aSTNode2 = NodeFinder.perform((ASTNode)compilationUnit, new SourceRange(iSourceRange.getOffset(), n));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((aSTNode = ASTNodes.getParent(aSTNode2, clazz)) == null) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                aSTNode = ASTNodes.getParent(aSTNode2, clazz2);
            }
            if (aSTNode == null) {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.EnumDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                aSTNode = ASTNodes.getParent(aSTNode2, clazz3);
            }
            if (aSTNode == null) {
                this.showError();
                return;
            }
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
            aSTRewrite.replace(aSTNode, aSTRewrite.createStringPlaceholder(string2, aSTNode.getNodeType()), null);
            if (bl && (object = this.getEditor(iFile)) != null) {
                object.setFocus();
            }
            object = null;
            IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
            if (iJavaProject != null) {
                object = iJavaProject.getOptions(true);
            }
            this.applyChanges(aSTRewrite, iDocument, iTextFileBuffer, this.getShell(), bl, (Map)object);
        }
    }

    private void showError() {
        MessageDialog.openError((Shell)this.getShell(), (String)CompareMessages.ReplaceFromHistory_title, (String)CompareMessages.ReplaceFromHistory_internalErrorMessage);
    }
}

