/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;

public class MultiElementListSelectionDialog
extends AbstractElementListSelectionDialog {
    private Page[] fPages;
    private int fCurrentPage;
    private int fNumberOfPages;
    private Button fFinishButton;
    private Button fBackButton;
    private Button fNextButton;
    private Label fPageInfoLabel;
    private String fPageInfoMessage = JavaUIMessages.MultiElementListSelectionDialog_pageInfoMessage;
    private Comparator fComparator;

    public MultiElementListSelectionDialog(Shell shell, ILabelProvider iLabelProvider) {
        super(shell, iLabelProvider);
    }

    public void setPageInfoMessage(String string) {
        this.fPageInfoMessage = string;
    }

    public void setElements(Object[][] objectArray) {
        this.fNumberOfPages = objectArray.length;
        this.fPages = new Page[this.fNumberOfPages];
        int n = 0;
        while (n != this.fNumberOfPages) {
            this.fPages[n] = new Page(objectArray[n]);
            ++n;
        }
        this.initializeResult(this.fNumberOfPages);
    }

    public int open() {
        List list = this.getInitialElementSelections();
        if (list == null || list.size() != this.fNumberOfPages) {
            this.setInitialSelections(new Object[this.fNumberOfPages]);
            list = this.getInitialElementSelections();
        }
        Assert.isTrue((list.size() == this.fNumberOfPages ? 1 : 0) != 0);
        return super.open();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.createFilterText(composite2);
        this.createFilteredList(composite2);
        this.fCurrentPage = 0;
        this.setPageData();
        MultiElementListSelectionDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.fBackButton = this.createButton(composite, 14, IDialogConstants.BACK_LABEL, false);
        this.fNextButton = this.createButton(composite, 15, IDialogConstants.NEXT_LABEL, true);
        this.fFinishButton = this.createButton(composite, 0, IDialogConstants.FINISH_LABEL, false);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Label createMessageArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        composite2.setLayoutData((Object)gridData);
        Label label = super.createMessageArea(composite2);
        this.fPageInfoLabel = new Label(composite2, 0);
        this.fPageInfoLabel.setText(this.getPageInfoMessage());
        gridData = new GridData(256);
        gridData.horizontalAlignment = 3;
        this.fPageInfoLabel.setLayoutData((Object)gridData);
        MultiElementListSelectionDialog.applyDialogFont((Control)label);
        return label;
    }

    protected void computeResult() {
        this.setResult(this.fCurrentPage, this.getSelectedElements());
    }

    protected void buttonPressed(int n) {
        if (n == 14) {
            this.turnPage(false);
        } else if (n == 15) {
            this.turnPage(true);
        } else {
            super.buttonPressed(n);
        }
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            if (this.fCurrentPage == this.fNumberOfPages - 1) {
                this.buttonPressed(0);
            } else {
                this.buttonPressed(15);
            }
        }
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        boolean bl;
        this.fPages[this.fCurrentPage].okState = bl = !iStatus.matches(4);
        boolean bl2 = bl;
        int n = 0;
        while (n != this.fNumberOfPages) {
            bl2 = bl2 && this.fPages[n].okState;
            n += 1;
        }
        this.fFinishButton.setEnabled(bl2);
        n = bl && this.fCurrentPage < this.fNumberOfPages - 1 ? 1 : 0;
        this.fNextButton.setEnabled(n != 0);
        this.fBackButton.setEnabled(this.fCurrentPage != 0);
        if (n) {
            this.getShell().setDefaultButton(this.fNextButton);
        } else if (bl2) {
            this.getShell().setDefaultButton(this.fFinishButton);
        }
    }

    private void turnPage(boolean bl) {
        Page page = this.fPages[this.fCurrentPage];
        String string = this.getFilter();
        if (string == null) {
            string = "";
        }
        page.filter = string;
        Object[] objectArray = this.getSelectedElements();
        List list = this.getInitialElementSelections();
        list.set(this.fCurrentPage, objectArray);
        this.setResult(this.fCurrentPage, this.getSelectedElements());
        if (bl) {
            if (this.fCurrentPage + 1 >= this.fNumberOfPages) {
                return;
            }
            ++this.fCurrentPage;
        } else {
            if (this.fCurrentPage - 1 < 0) {
                return;
            }
            --this.fCurrentPage;
        }
        if (this.fPageInfoLabel != null && !this.fPageInfoLabel.isDisposed()) {
            this.fPageInfoLabel.setText(this.getPageInfoMessage());
        }
        this.setPageData();
        this.validateCurrentSelection();
    }

    private void setPageData() {
        Page page = this.fPages[this.fCurrentPage];
        this.setListElements(page.elements);
        String string = page.filter;
        if (string == null) {
            string = "";
        }
        this.setFilter(string);
        Object[] objectArray = (Object[])this.getInitialElementSelections().get(this.fCurrentPage);
        this.setSelection(objectArray);
        this.fFilteredList.setFocus();
    }

    private String getPageInfoMessage() {
        if (this.fPageInfoMessage == null) {
            return "";
        }
        Object[] objectArray = new String[]{Integer.toString(this.fCurrentPage + 1), Integer.toString(this.fNumberOfPages)};
        return Messages.format(this.fPageInfoMessage, objectArray);
    }

    private void initializeResult(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 != n) {
            arrayList.add(null);
            ++n2;
        }
        this.setResult(arrayList);
    }

    public int getCurrentPage() {
        return this.fCurrentPage;
    }

    public void setComparator(Comparator comparator) {
        this.fComparator = comparator;
        if (this.fFilteredList != null) {
            this.fFilteredList.setComparator(this.fComparator);
        }
    }

    protected FilteredList createFilteredList(Composite composite) {
        FilteredList filteredList = super.createFilteredList(composite);
        if (this.fComparator != null) {
            filteredList.setComparator(this.fComparator);
        }
        return filteredList;
    }

    private static class Page {
        private Object[] elements;
        public String filter;
        public boolean okState = false;

        public Page(Object[] objectArray) {
            this.elements = objectArray;
        }
    }
}

