/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.wst.jsdt.ui.dialogs.TypeSelectionExtension;

public class OpenTypeSelectionDialog2
extends TypeSelectionDialog2 {
    private IDialogSettings fSettings;
    private Point fLocation;
    private Point fSize;
    private static final String DIALOG_SETTINGS = "org.eclipse.wst.jsdt.internal.ui.dialogs.OpenTypeSelectionDialog2";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";

    public OpenTypeSelectionDialog2(Shell shell, boolean bl, IRunnableContext iRunnableContext, IJavaSearchScope iJavaSearchScope, int n) {
        this(shell, bl, iRunnableContext, iJavaSearchScope, n, null);
    }

    public OpenTypeSelectionDialog2(Shell shell, boolean bl, IRunnableContext iRunnableContext, IJavaSearchScope iJavaSearchScope, int n, TypeSelectionExtension typeSelectionExtension) {
        super(shell, bl, iRunnableContext, iJavaSearchScope, n, typeSelectionExtension);
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        this.fSettings = iDialogSettings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            iDialogSettings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 480);
            this.fSettings.put(HEIGHT, 320);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.open_type_dialog_context");
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        if (this.fSize != null) {
            point.x = Math.max(point.x, this.fSize.x);
            point.y = Math.max(point.y, this.fSize.y);
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            point.x = Math.min(point.x, rectangle.width);
            point.y = Math.min(point.y, rectangle.height);
        }
        return point;
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = super.getInitialLocation(point);
        if (this.fLocation != null) {
            int n;
            point2.x = this.fLocation.x;
            point2.y = this.fLocation.y;
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            int n2 = point2.x + point.x;
            if (n2 > rectangle.width) {
                point2.x -= n2 - rectangle.width;
            }
            if ((n = point2.y + point.y) > rectangle.height) {
                point2.y -= n - rectangle.height;
            }
        }
        return point2;
    }

    protected Control createDialogArea(Composite composite) {
        this.readSettings();
        return super.createDialogArea(composite);
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    private void readSettings() {
        int n;
        int n2;
        try {
            n2 = this.fSettings.getInt("x");
            n = this.fSettings.getInt("y");
            this.fLocation = new Point(n2, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        try {
            n2 = this.fSettings.getInt(WIDTH);
            n = this.fSettings.getInt(HEIGHT);
            this.fSize = new Point(n2, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSize = null;
        }
    }

    private void writeSettings() {
        Point point = this.getShell().getLocation();
        this.fSettings.put("x", point.x);
        this.fSettings.put("y", point.y);
        Point point2 = this.getShell().getSize();
        this.fSettings.put(WIDTH, point2.x);
        this.fSettings.put(HEIGHT, point2.y);
    }
}

