/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ViewerPane;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;

public class OverrideMethodDialog
extends SourceActionDialog {
    private CompilationUnit fUnit = null;

    private static ITypeBinding getSuperType(ITypeBinding iTypeBinding, String string) {
        ITypeBinding iTypeBinding2;
        if (iTypeBinding.isArray() || iTypeBinding.isPrimitive()) {
            return null;
        }
        if (iTypeBinding.getQualifiedName().startsWith(string)) {
            return iTypeBinding;
        }
        ITypeBinding iTypeBinding3 = iTypeBinding.getSuperclass();
        if (iTypeBinding3 != null && (iTypeBinding2 = OverrideMethodDialog.getSuperType(iTypeBinding3, string)) != null) {
            return iTypeBinding2;
        }
        iTypeBinding2 = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < ((ITypeBinding)iTypeBinding2).length) {
            ITypeBinding iTypeBinding4 = OverrideMethodDialog.getSuperType(iTypeBinding2[n], string);
            if (iTypeBinding4 != null) {
                return iTypeBinding4;
            }
            ++n;
        }
        return null;
    }

    public OverrideMethodDialog(Shell shell, CompilationUnitEditor compilationUnitEditor, IType iType, boolean bl) throws JavaModelException {
        super(shell, (ILabelProvider)new BindingLabelProvider(), new OverrideMethodContentProvider(), compilationUnitEditor, iType, false);
        ITypeBinding iTypeBinding;
        Object object;
        Object object2;
        RefactoringASTParser refactoringASTParser = new RefactoringASTParser(3);
        this.fUnit = refactoringASTParser.parse((ITypeRoot)iType.getCompilationUnit(), true);
        ITypeBinding iTypeBinding2 = ASTNodes.getTypeBinding(this.fUnit, iType);
        ArrayList<IMethodBinding> arrayList = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = null;
        if (iTypeBinding2 != null) {
            IPackageBinding iPackageBinding = iTypeBinding2.getPackage();
            object2 = StubUtility2.getOverridableMethods(this.fUnit.getAST(), iTypeBinding2, false);
            ArrayList<IMethodBinding> arrayList2 = new ArrayList<IMethodBinding>(((IMethodBinding[])object2).length);
            int n = 0;
            while (n < ((IMethodBinding[])object2).length) {
                object = object2[n];
                if (Bindings.isVisibleInHierarchy(object, iPackageBinding)) {
                    arrayList2.add((IMethodBinding)object);
                }
                ++n;
            }
            iMethodBindingArray = arrayList2.toArray(new IMethodBinding[arrayList2.size()]);
        } else {
            iMethodBindingArray = new IMethodBinding[]{};
        }
        int n = 0;
        while (n < iMethodBindingArray.length) {
            if (Modifier.isAbstract((int)iMethodBindingArray[n].getModifiers())) {
                arrayList.add(iMethodBindingArray[n]);
            }
            ++n;
        }
        if (iTypeBinding2 != null && (iTypeBinding = OverrideMethodDialog.getSuperType(iTypeBinding2, "java.lang.Cloneable")) != null) {
            object2 = this.fUnit.getAST().resolveWellKnownType("java.lang.Object").getDeclaredMethods();
            int n2 = 0;
            while (n2 < ((IMethodBinding[])object2).length) {
                IMethodBinding iMethodBinding = object2[n2];
                if (iMethodBinding.getName().equals("clone") && iMethodBinding.getParameterTypes().length == 0) {
                    arrayList.add(iMethodBinding);
                }
                ++n2;
            }
        }
        Object[] objectArray = arrayList.toArray(new IMethodBinding[arrayList.size()]);
        this.setInitialSelections(objectArray);
        object2 = new HashSet(objectArray.length);
        int n3 = 0;
        while (n3 < objectArray.length) {
            ((HashSet)object2).add(objectArray[n3].getDeclaringClass());
            ++n3;
        }
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>(iMethodBindingArray.length);
        int n4 = 0;
        while (n4 < iMethodBindingArray.length) {
            hashSet.add(iMethodBindingArray[n4].getDeclaringClass());
            ++n4;
        }
        Object[] objectArray2 = hashSet.toArray(new ITypeBinding[hashSet.size()]);
        object = new OverrideMethodComparator(iTypeBinding2);
        if (((HashSet)object2).isEmpty() && objectArray2.length > 0) {
            object.sort(null, objectArray2);
            ((HashSet)object2).add(objectArray2[0]);
        }
        this.setExpandedElements(((HashSet)object2).toArray());
        ((OverrideMethodContentProvider)this.getContentProvider()).init(iMethodBindingArray, (ITypeBinding[])objectArray2);
        this.setTitle(JavaUIMessages.OverrideMethodDialog_dialog_title);
        this.setMessage(null);
        this.setValidator(new OverrideMethodValidator(iMethodBindingArray.length));
        this.setComparator((ViewerComparator)object);
        this.setContainerMode(true);
        this.setSize(60, 18);
        this.setInput(new Object());
    }

    public CompilationUnit getCompilationUnit() {
        return this.fUnit;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.override_tree_selection_dialog_context");
    }

    protected Control createLinkControl(Composite composite) {
        Link link = new Link(composite, 64);
        link.setText(JavaUIMessages.OverrideMethodDialog_link_message);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OverrideMethodDialog.this.openCodeTempatePage("org.eclipse.wst.jsdt.ui.text.codetemplates.overridecomment");
            }
        });
        link.setToolTipText(JavaUIMessages.OverrideMethodDialog_link_tooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        link.setLayoutData((Object)gridData);
        return link;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        ViewerPane viewerPane = new ViewerPane(composite, 0x800800);
        viewerPane.setText(JavaUIMessages.OverrideMethodDialog_dialog_description);
        CheckboxTreeViewer checkboxTreeViewer = super.createTreeViewer((Composite)viewerPane);
        viewerPane.setContent(checkboxTreeViewer.getControl());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        viewerPane.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(55);
        gridData.heightHint = this.convertHeightInCharsToPixels(15);
        viewerPane.setLayoutData(gridData);
        ToolBarManager toolBarManager = viewerPane.getToolBarManager();
        toolBarManager.add((IAction)new OverrideFlatTreeAction());
        toolBarManager.update(true);
        checkboxTreeViewer.getTree().setFocus();
        return checkboxTreeViewer;
    }

    public boolean hasMethodsToOverride() {
        return this.getContentProvider().getElements(null).length > 0;
    }

    private class OverrideFlatTreeAction
    extends Action {
        private boolean fToggle;

        public OverrideFlatTreeAction() {
            this.setToolTipText(JavaUIMessages.OverrideMethodDialog_groupMethodsByTypes);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "impl_co.gif");
            this.fToggle = this.getOverrideContentProvider().isShowTypes();
            this.setChecked(this.fToggle);
        }

        private OverrideMethodContentProvider getOverrideContentProvider() {
            return (OverrideMethodContentProvider)OverrideMethodDialog.this.getContentProvider();
        }

        public void run() {
            Object[] objectArray = this.getOverrideContentProvider().getViewer().getCheckedElements();
            this.fToggle = !this.fToggle;
            this.setChecked(this.fToggle);
            this.getOverrideContentProvider().setShowTypes(this.fToggle);
            this.getOverrideContentProvider().getViewer().setCheckedElements(objectArray);
        }
    }

    private static class OverrideMethodComparator
    extends ViewerComparator {
        private ITypeBinding[] fAllTypes = new ITypeBinding[0];

        public OverrideMethodComparator(ITypeBinding iTypeBinding) {
            if (iTypeBinding != null) {
                ITypeBinding[] iTypeBindingArray = Bindings.getAllSuperTypes(iTypeBinding);
                this.fAllTypes = new ITypeBinding[iTypeBindingArray.length + 1];
                this.fAllTypes[0] = iTypeBinding;
                System.arraycopy(iTypeBindingArray, 0, this.fAllTypes, 1, iTypeBindingArray.length);
            }
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            if (object instanceof ITypeBinding && object2 instanceof ITypeBinding) {
                ITypeBinding iTypeBinding = (ITypeBinding)object;
                ITypeBinding iTypeBinding2 = (ITypeBinding)object2;
                if (iTypeBinding2.getQualifiedName().equals("java.lang.Object")) {
                    return -1;
                }
                if (iTypeBinding.isEqualTo((IBinding)iTypeBinding2)) {
                    return 0;
                }
                if (Bindings.isSuperType(iTypeBinding, iTypeBinding2)) {
                    return 1;
                }
                if (Bindings.isSuperType(iTypeBinding2, iTypeBinding)) {
                    return -1;
                }
                return 0;
            }
            return super.compare(viewer, object, object2);
        }
    }

    private static class OverrideMethodContentProvider
    implements ITreeContentProvider {
        private final Object[] fEmpty = new Object[0];
        private IMethodBinding[] fMethods;
        private IDialogSettings fSettings;
        private boolean fShowTypes;
        private Object[] fTypes;
        private ContainerCheckedTreeViewer fViewer;
        private final String SETTINGS_SECTION = "OverrideMethodDialog";
        private final String SETTINGS_SHOWTYPES = "showtypes";

        public OverrideMethodContentProvider() {
            IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fSettings = iDialogSettings.getSection("OverrideMethodDialog");
            if (this.fSettings == null) {
                this.fSettings = iDialogSettings.addNewSection("OverrideMethodDialog");
                this.fSettings.put("showtypes", true);
            }
            this.fShowTypes = this.fSettings.getBoolean("showtypes");
        }

        public void dispose() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof ITypeBinding) {
                ArrayList<IMethodBinding> arrayList = new ArrayList<IMethodBinding>(this.fMethods.length);
                int n = 0;
                while (n < this.fMethods.length) {
                    if (this.fMethods[n].getDeclaringClass().isEqualTo((IBinding)object)) {
                        arrayList.add(this.fMethods[n]);
                    }
                    ++n;
                }
                return arrayList.toArray();
            }
            return this.fEmpty;
        }

        public Object[] getElements(Object object) {
            return this.fShowTypes ? this.fTypes : this.fMethods;
        }

        public Object getParent(Object object) {
            if (object instanceof IMethodBinding) {
                return ((IMethodBinding)object).getDeclaringClass();
            }
            return null;
        }

        public ContainerCheckedTreeViewer getViewer() {
            return this.fViewer;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public void init(IMethodBinding[] iMethodBindingArray, ITypeBinding[] iTypeBindingArray) {
            this.fMethods = iMethodBindingArray;
            this.fTypes = iTypeBindingArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.fViewer = (ContainerCheckedTreeViewer)viewer;
        }

        public boolean isShowTypes() {
            return this.fShowTypes;
        }

        public void setShowTypes(boolean bl) {
            if (this.fShowTypes != bl) {
                this.fShowTypes = bl;
                this.fSettings.put("showtypes", bl);
                if (this.fViewer != null) {
                    this.fViewer.refresh();
                }
            }
        }
    }

    private static class OverrideMethodValidator
    implements ISelectionStatusValidator {
        private static int fNumMethods;

        public OverrideMethodValidator(int n) {
            fNumMethods = n;
        }

        public IStatus validate(Object[] objectArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof IMethodBinding) {
                    ++n;
                }
                ++n2;
            }
            if (n == 0) {
                return new StatusInfo(4, "");
            }
            return new StatusInfo(1, Messages.format(JavaUIMessages.OverrideMethodDialog_selectioninfo_more, new String[]{String.valueOf(n), String.valueOf(fNumMethods)}));
        }
    }
}

