/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class TableTextCellEditor
extends CellEditor {
    private final TableViewer fTableViewer;
    private final int fColumn;
    private final String fProperty;
    String fOriginalValue;
    SubjectControlContentAssistant fContentAssistant;
    private IActivationListener fActivationListener;
    protected Text text;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private static final int defaultStyle = 4;
    private ModifyListener fModifyListener;

    public TableTextCellEditor(TableViewer tableViewer, int n) {
        super((Composite)tableViewer.getTable(), 4);
        this.fTableViewer = tableViewer;
        this.fColumn = n;
        this.fProperty = (String)tableViewer.getColumnProperties()[n];
    }

    public void activate() {
        super.activate();
        if (this.fActivationListener != null) {
            this.fActivationListener.activate();
        }
        this.fOriginalValue = this.text.getText();
    }

    private void fireModifyEvent(Object object) {
        this.fTableViewer.getCellModifier().modify(((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement(), this.fProperty, object);
    }

    protected void focusLost() {
        if (this.fContentAssistant == null || !this.fContentAssistant.hasProposalPopupFocus()) {
            super.focusLost();
        }
    }

    public void setContentAssistant(SubjectControlContentAssistant subjectControlContentAssistant) {
        this.fContentAssistant = subjectControlContentAssistant;
    }

    public void setActivationListener(IActivationListener iActivationListener) {
        this.fActivationListener = iActivationListener;
    }

    public Text getText() {
        return this.text;
    }

    protected void checkDeleteable() {
        boolean bl = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (bl != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    protected void checkSelectable() {
        boolean bl = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (bl != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    protected void checkSelection() {
        boolean bl = this.isSelection;
        boolean bl2 = this.isSelection = this.text.getSelectionCount() > 0;
        if (bl != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    private ModifyListener getModifyListener() {
        if (this.fModifyListener == null) {
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    TableTextCellEditor.this.editOccured(modifyEvent);
                }
            };
        }
        return this.fModifyListener;
    }

    protected Control createControl(Composite composite) {
        final Control[] controlArray = new Control[1];
        Composite composite2 = new Composite(composite, 0){

            public void addListener(int n, Listener listener) {
                if (n != 15 && n != 16) {
                    controlArray[0].addListener(n, listener);
                }
            }
        };
        composite2.setFont(composite.getFont());
        composite2.setBackground(composite.getBackground());
        composite2.setLayout((Layout)new FillLayout());
        this.text = new Text(composite2, this.getStyle());
        controlArray[0] = this.text;
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TableTextCellEditor.this.handleDefaultSelection(selectionEvent);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!(keyEvent.stateMask != SWT.MOD1 && keyEvent.stateMask != SWT.MOD2 || keyEvent.keyCode != 0x1000001 && keyEvent.keyCode != 0x1000002)) {
                    TableTextCellEditor.this.deactivate();
                    keyEvent.doit = false;
                    return;
                }
                if (keyEvent.stateMask != 0) {
                    return;
                }
                switch (keyEvent.keyCode) {
                    case 0x1000002: {
                        keyEvent.doit = false;
                        int n = TableTextCellEditor.this.fTableViewer.getTable().getSelectionIndex() + 1;
                        if (n >= TableTextCellEditor.this.fTableViewer.getTable().getItemCount()) break;
                        this.editRow(n);
                        break;
                    }
                    case 0x1000001: {
                        keyEvent.doit = false;
                        int n = TableTextCellEditor.this.fTableViewer.getTable().getSelectionIndex() - 1;
                        if (n < 0) break;
                        this.editRow(n);
                        break;
                    }
                    case 0x100000B: {
                        keyEvent.doit = false;
                        TableTextCellEditor.this.deactivate();
                    }
                }
            }

            private void editRow(int n) {
                TableTextCellEditor.this.fTableViewer.getTable().setSelection(n);
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TableTextCellEditor.this.fTableViewer.getSelection();
                if (iStructuredSelection.size() == 1) {
                    TableTextCellEditor.this.fTableViewer.editElement(iStructuredSelection.getFirstElement(), TableTextCellEditor.this.fColumn);
                }
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TableTextCellEditor.this.keyReleaseOccured(keyEvent);
                if (TableTextCellEditor.this.getControl() == null || TableTextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                TableTextCellEditor.this.checkSelection();
                TableTextCellEditor.this.checkDeleteable();
                TableTextCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TableTextCellEditor.this.checkSelection();
                TableTextCellEditor.this.checkDeleteable();
                TableTextCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TableTextCellEditor.this.focusLost();
            }
        });
        this.text.setFont(composite.getFont());
        this.text.setBackground(composite.getBackground());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        return composite2;
    }

    protected void fireCancelEditor() {
        this.text.setText(this.fOriginalValue);
        super.fireApplyEditorValue();
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object object) {
        Assert.isTrue((this.text != null && object instanceof String ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText((String)object);
        this.text.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent modifyEvent) {
        String string = this.text.getText();
        boolean bl = this.isValueValid();
        boolean bl2 = this.isCorrect(string);
        if (!bl2) {
            this.setErrorMessage(Messages.format(this.getErrorMessage(), new Object[]{string}));
        }
        this.valueChanged(bl, bl2);
        this.fireModifyEvent(this.text.getText());
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }

    protected void handleDefaultSelection(SelectionEvent selectionEvent) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.text != null && !this.text.isDisposed() && (this.text.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int n = this.text.getCaretPosition();
            if (n < this.text.getCharCount()) {
                this.text.setSelection(n, n + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    public static interface IActivationListener {
        public void activate();
    }
}

