/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingStrategy;

public class CommentFormatFix
implements IFix {
    private final ICompilationUnit fCompilationUnit;
    private final TextChange fChange;

    public static IFix createCleanUp(ICompilationUnit iCompilationUnit, boolean bl, boolean bl2, boolean bl3, HashMap hashMap) throws CoreException {
        if (!(bl || bl2 || bl3)) {
            return null;
        }
        String string = iCompilationUnit.getBuffer().getContents();
        Document document = new Document(string);
        List list = CommentFormatFix.format((IDocument)document, bl, bl2, bl3, hashMap);
        if (list.size() == 0) {
            return null;
        }
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChildren(list.toArray(new TextEdit[list.size()]));
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(MultiFixMessages.CommentFormatFix_description, iCompilationUnit);
        compilationUnitChange.setEdit((TextEdit)multiTextEdit);
        String string2 = MultiFixMessages.CommentFormatFix_description;
        CategorizedTextEditGroup categorizedTextEditGroup = new CategorizedTextEditGroup(string2, new GroupCategorySet(new GroupCategory(string2, string2, string2)));
        categorizedTextEditGroup.addTextEdit((TextEdit)multiTextEdit);
        compilationUnitChange.addTextEditGroup((TextEditGroup)categorizedTextEditGroup);
        return new CommentFormatFix((TextChange)compilationUnitChange, iCompilationUnit);
    }

    static String format(String string, boolean bl, boolean bl2, boolean bl3) {
        if (!(bl || bl2 || bl3)) {
            return string;
        }
        Document document = new Document(string);
        HashMap hashMap = new HashMap(JavaCore.getOptions());
        List list = CommentFormatFix.format((IDocument)document, bl, bl2, bl3, hashMap);
        if (list.size() == 0) {
            return string;
        }
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChildren(list.toArray(new TextEdit[list.size()]));
        try {
            multiTextEdit.apply((IDocument)document);
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return document.get();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List format(IDocument iDocument, boolean bl, boolean bl2, boolean bl3, HashMap hashMap) {
        ArrayList<TextEdit> arrayList = new ArrayList<TextEdit>();
        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner(iDocument, "___java_partitioning");
        String string = iDocument.get();
        CommentFormattingStrategy commentFormattingStrategy = new CommentFormattingStrategy();
        CommentFormattingContext commentFormattingContext = new CommentFormattingContext();
        commentFormattingContext.setProperty("formatting.context.preferences", hashMap);
        commentFormattingContext.setProperty("formatting.context.document", Boolean.TRUE);
        commentFormattingContext.setProperty("formatting.context.medium", iDocument);
        try {
            try {
                ITypedRegion[] iTypedRegionArray = TextUtilities.computePartitioning((IDocument)iDocument, (String)"___java_partitioning", (int)0, (int)iDocument.getLength(), (boolean)false);
                int n = 0;
                while (n < iTypedRegionArray.length) {
                    TextEdit textEdit;
                    ITypedRegion iTypedRegion = iTypedRegionArray[n];
                    if (bl && iTypedRegion.getType().equals("__java_singleline_comment")) {
                        textEdit = CommentFormatFix.format(iTypedRegion, (IFormattingContext)commentFormattingContext, commentFormattingStrategy, string);
                        if (textEdit != null) {
                            arrayList.add(textEdit);
                        }
                    } else if (bl2 && iTypedRegion.getType().equals("__java_multiline_comment")) {
                        textEdit = CommentFormatFix.format(iTypedRegion, (IFormattingContext)commentFormattingContext, commentFormattingStrategy, string);
                        if (textEdit != null) {
                            arrayList.add(textEdit);
                        }
                    } else if (bl3 && iTypedRegion.getType().equals("__java_javadoc") && (textEdit = CommentFormatFix.format(iTypedRegion, (IFormattingContext)commentFormattingContext, commentFormattingStrategy, string)) != null) {
                        arrayList.add(textEdit);
                    }
                    ++n;
                }
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            commentFormattingContext.dispose();
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        commentFormattingContext.dispose();
        return arrayList;
    }

    private static TextEdit format(ITypedRegion iTypedRegion, IFormattingContext iFormattingContext, CommentFormattingStrategy commentFormattingStrategy, String string) {
        TypedPosition typedPosition = new TypedPosition(iTypedRegion.getOffset(), iTypedRegion.getLength(), iTypedRegion.getType());
        iFormattingContext.setProperty((Object)"formatting.context.partition", (Object)typedPosition);
        commentFormattingStrategy.formatterStarts(iFormattingContext);
        TextEdit textEdit = commentFormattingStrategy.calculateTextEdit();
        commentFormattingStrategy.formatterStops();
        if (textEdit == null) {
            return null;
        }
        if (!textEdit.hasChildren()) {
            return null;
        }
        TextEdit[] textEditArray = textEdit.getChildren();
        int n = 0;
        while (n < textEditArray.length) {
            if (!(textEditArray[n] instanceof ReplaceEdit)) {
                return textEdit;
            }
            ++n;
        }
        Document document = new Document(string);
        try {
            textEdit.copy().apply((IDocument)document, 0);
            if (string.equals(document.get())) {
                return null;
            }
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {}
        return textEdit;
    }

    public CommentFormatFix(TextChange textChange, ICompilationUnit iCompilationUnit) {
        this.fChange = textChange;
        this.fCompilationUnit = iCompilationUnit;
    }

    public TextChange createChange() throws CoreException {
        return this.fChange;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getDescription() {
        return MultiFixMessages.CommentFormatFix_description;
    }

    public IStatus getStatus() {
        return StatusInfo.OK_STATUS;
    }
}

