/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JarPackageReader
implements IJarDescriptionReader {
    protected InputStream fInputStream;
    private MultiStatus fWarnings;

    public JarPackageReader(InputStream inputStream) {
        Assert.isNotNull((Object)inputStream);
        this.fInputStream = new BufferedInputStream(inputStream);
        this.fWarnings = new MultiStatus(JavaPlugin.getPluginId(), 0, JarPackagerMessages.JarPackageReader_jarPackageReaderWarnings, null);
    }

    public void read(JarPackageData jarPackageData) throws CoreException {
        try {
            this.readXML(jarPackageData);
        }
        catch (IOException iOException) {
            String string = iOException.getLocalizedMessage() != null ? iOException.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, (Throwable)iOException));
        }
        catch (SAXException sAXException) {
            String string = sAXException.getLocalizedMessage() != null ? sAXException.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, (Throwable)sAXException));
        }
    }

    public void close() throws CoreException {
        if (this.fInputStream != null) {
            try {
                this.fInputStream.close();
            }
            catch (IOException iOException) {
                String string = iOException.getLocalizedMessage() != null ? iOException.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, (Throwable)iOException));
            }
        }
    }

    public JarPackageData readXML(JarPackageData jarPackageData) throws IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getLocalizedMessage());
        }
        Element element = documentBuilder.parse(new InputSource(this.fInputStream)).getDocumentElement();
        if (!element.getNodeName().equals("jardesc")) {
            throw new IOException(JarPackagerMessages.JarPackageReader_error_badFormat);
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                this.xmlReadJarLocation(jarPackageData, element2);
                this.xmlReadOptions(jarPackageData, element2);
                this.xmlReadRefactoring(jarPackageData, element2);
                this.xmlReadSelectedProjects(jarPackageData, element2);
                if (jarPackageData.areGeneratedFilesExported()) {
                    this.xmlReadManifest(jarPackageData, element2);
                }
                this.xmlReadSelectedElements(jarPackageData, element2);
            }
            ++n;
        }
        return jarPackageData;
    }

    private void xmlReadJarLocation(JarPackageData jarPackageData, Element element) {
        if (element.getNodeName().equals("jar")) {
            jarPackageData.setJarLocation(Path.fromPortableString((String)element.getAttribute("path")));
        }
    }

    private void xmlReadOptions(JarPackageData jarPackageData, Element element) throws IOException {
        if (element.getNodeName().equals("options")) {
            jarPackageData.setOverwrite(this.getBooleanAttribute(element, "overwrite"));
            jarPackageData.setCompress(this.getBooleanAttribute(element, "compress"));
            jarPackageData.setExportErrors(this.getBooleanAttribute(element, "exportErrors"));
            jarPackageData.setExportWarnings(this.getBooleanAttribute(element, "exportWarnings"));
            jarPackageData.setSaveDescription(this.getBooleanAttribute(element, "saveDescription"));
            jarPackageData.setUseSourceFolderHierarchy(this.getBooleanAttribute(element, "useSourceFolders", false));
            jarPackageData.setDescriptionLocation(Path.fromPortableString((String)element.getAttribute("descriptionLocation")));
            jarPackageData.setBuildIfNeeded(this.getBooleanAttribute(element, "buildIfNeeded", jarPackageData.isBuildingIfNeeded()));
            jarPackageData.setIncludeDirectoryEntries(this.getBooleanAttribute(element, "includeDirectoryEntries", false));
            jarPackageData.setRefactoringAware(this.getBooleanAttribute(element, "storeRefactorings", false));
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void xmlReadRefactoring(JarPackageData jarPackageData, Element element) throws IOException {
        if (element.getNodeName().equals("storedRefactorings")) {
            IProject iProject;
            jarPackageData.setExportStructuralOnly(this.getBooleanAttribute(element, "structuralOnly", jarPackageData.isExportStructuralOnly()));
            jarPackageData.setDeprecationAware(this.getBooleanAttribute(element, "deprecationInfo", jarPackageData.isDeprecationAware()));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 1;
            String string = element.getAttribute("project" + n);
            while (string != null && !"".equals(string)) {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
                if (iProject.exists()) {
                    arrayList.add(iProject);
                }
                string = element.getAttribute("project" + ++n);
            }
            jarPackageData.setRefactoringProjects(arrayList.toArray(new IProject[arrayList.size()]));
            arrayList.clear();
            n = 1;
            iProject = RefactoringCore.getHistoryService();
            try {
                iProject.connect();
                string = element.getAttribute("refactoring" + n);
                boolean bl = true;
                do {
                    if (!bl || (bl = false) || !true) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                        try {
                            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray;
                            RefactoringHistory refactoringHistory = iProject.readRefactoringHistory((InputStream)byteArrayInputStream, 0);
                            if (refactoringHistory != null && (refactoringDescriptorProxyArray = refactoringHistory.getDescriptors()).length > 0) {
                                int n2 = 0;
                                while (n2 < refactoringDescriptorProxyArray.length) {
                                    arrayList.add(refactoringDescriptorProxyArray[n2]);
                                    ++n2;
                                }
                            }
                        }
                        catch (CoreException coreException) {
                            JavaPlugin.log(coreException);
                        }
                        string = element.getAttribute("refactoring" + ++n);
                    }
                    if (string == null) break;
                } while (!"".equals(string));
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                iProject.disconnect();
                throw throwable;
            }
            iProject.disconnect();
            jarPackageData.setRefactoringDescriptors(arrayList.toArray(new RefactoringDescriptorProxy[arrayList.size()]));
        }
    }

    private void xmlReadManifest(JarPackageData jarPackageData, Element element) throws IOException {
        if (element.getNodeName().equals("manifest")) {
            jarPackageData.setManifestVersion(element.getAttribute("manifestVersion"));
            jarPackageData.setUsesManifest(this.getBooleanAttribute(element, "usesManifest"));
            jarPackageData.setReuseManifest(this.getBooleanAttribute(element, "reuseManifest"));
            jarPackageData.setSaveManifest(this.getBooleanAttribute(element, "saveManifest"));
            jarPackageData.setGenerateManifest(this.getBooleanAttribute(element, "generateManifest"));
            jarPackageData.setManifestLocation(Path.fromPortableString((String)element.getAttribute("manifestLocation")));
            jarPackageData.setManifestMainClass(this.getMainClass(element));
            this.xmlReadSealingInfo(jarPackageData, element);
        }
    }

    private void xmlReadSealingInfo(JarPackageData jarPackageData, Element element) throws IOException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNodeName().equals("sealing")) {
                Element element2 = (Element)node;
                jarPackageData.setSealJar(this.getBooleanAttribute(element2, "sealJar"));
                jarPackageData.setPackagesToSeal(this.getPackages(element2.getElementsByTagName("packagesToSeal")));
                jarPackageData.setPackagesToUnseal(this.getPackages(element2.getElementsByTagName("packagesToUnSeal")));
            }
            ++n;
        }
    }

    private void xmlReadSelectedElements(JarPackageData jarPackageData, Element element) throws IOException {
        if (element.getNodeName().equals("selectedElements")) {
            jarPackageData.setExportClassFiles(this.getBooleanAttribute(element, "exportClassFiles"));
            jarPackageData.setExportOutputFolders(this.getBooleanAttribute(element, "exportOutputFolder", false));
            jarPackageData.setExportJavaFiles(this.getBooleanAttribute(element, "exportJavaFiles"));
            NodeList nodeList = element.getChildNodes();
            HashSet hashSet = new HashSet(nodeList.getLength());
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    if (element2.getNodeName().equals("file")) {
                        this.addFile(hashSet, element2);
                    } else if (element2.getNodeName().equals("folder")) {
                        this.addFolder(hashSet, element2);
                    } else if (element2.getNodeName().equals("project")) {
                        this.addProject(hashSet, element2);
                    } else if (element2.getNodeName().equals("javaElement")) {
                        this.addJavaElement(hashSet, element2);
                    }
                }
                ++n;
            }
            jarPackageData.setElements(hashSet.toArray());
        }
    }

    private void xmlReadSelectedProjects(JarPackageData jarPackageData, Element element) throws IOException {
        if (element.getNodeName().equals("selectedProjects")) {
            NodeList nodeList = element.getChildNodes();
            HashSet hashSet = new HashSet(nodeList.getLength());
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element2;
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1 && (element2 = (Element)node).getNodeName().equals("project")) {
                    this.addProject(hashSet, element2);
                }
                ++n;
            }
            jarPackageData.setRefactoringProjects(hashSet.toArray(new IProject[hashSet.size()]));
        }
    }

    protected boolean getBooleanAttribute(Element element, String string, boolean bl) throws IOException {
        if (element.hasAttribute(string)) {
            return this.getBooleanAttribute(element, string);
        }
        return bl;
    }

    protected boolean getBooleanAttribute(Element element, String string) throws IOException {
        String string2 = element.getAttribute(string);
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2 != null && string2.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IOException(JarPackagerMessages.JarPackageReader_error_illegalValueForBooleanAttribute);
    }

    private void addFile(Set set, Element element) throws IOException {
        IFile iFile;
        IPath iPath = this.getPath(element);
        if (iPath != null && (iFile = JavaPlugin.getWorkspace().getRoot().getFile(iPath)) != null) {
            set.add(iFile);
        }
    }

    private void addFolder(Set set, Element element) throws IOException {
        IFolder iFolder;
        IPath iPath = this.getPath(element);
        if (iPath != null && (iFolder = JavaPlugin.getWorkspace().getRoot().getFolder(iPath)) != null) {
            set.add(iFolder);
        }
    }

    private void addProject(Set set, Element element) throws IOException {
        String string = element.getAttribute("name");
        if (string.length() == 0) {
            throw new IOException(JarPackagerMessages.JarPackageReader_error_tagNameNotFound);
        }
        IProject iProject = JavaPlugin.getWorkspace().getRoot().getProject(string);
        if (iProject != null) {
            set.add(iProject);
        }
    }

    private IPath getPath(Element element) throws IOException {
        String string = element.getAttribute("path");
        if (string.length() == 0) {
            throw new IOException(JarPackagerMessages.JarPackageReader_error_tagPathNotFound);
        }
        return Path.fromPortableString((String)element.getAttribute("path"));
    }

    private void addJavaElement(Set set, Element element) throws IOException {
        String string = element.getAttribute("handleIdentifier");
        if (string.length() == 0) {
            throw new IOException(JarPackagerMessages.JarPackageReader_error_tagHandleIdentifierNotFoundOrEmpty);
        }
        IJavaElement iJavaElement = JavaCore.create((String)string);
        if (iJavaElement == null) {
            this.addWarning(JarPackagerMessages.JarPackageReader_warning_javaElementDoesNotExist, null);
        } else {
            set.add(iJavaElement);
        }
    }

    private IPackageFragment[] getPackages(NodeList nodeList) throws IOException {
        if (nodeList.getLength() > 1) {
            throw new IOException(Messages.format(JarPackagerMessages.JarPackageReader_error_duplicateTag, nodeList.item(0).getNodeName()));
        }
        if (nodeList.getLength() == 0) {
            return null;
        }
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(nodeList2.getLength());
        int n = 0;
        while (n < nodeList2.getLength()) {
            Node node = nodeList2.item(n);
            if (node.getNodeType() == 1 && node.getNodeName().equals("package")) {
                String string = ((Element)node).getAttribute("handleIdentifier");
                if (string.equals("")) {
                    throw new IOException(JarPackagerMessages.JarPackageReader_error_tagHandleIdentifierNotFoundOrEmpty);
                }
                IJavaElement iJavaElement = JavaCore.create((String)string);
                if (iJavaElement != null && iJavaElement.getElementType() == 4) {
                    arrayList.add(iJavaElement);
                } else {
                    this.addWarning(JarPackagerMessages.JarPackageReader_warning_javaElementDoesNotExist, null);
                }
            }
            ++n;
        }
        return arrayList.toArray(new IPackageFragment[arrayList.size()]);
    }

    private IType getMainClass(Element element) {
        String string = element.getAttribute("mainClassHandleIdentifier");
        if (string.equals("")) {
            return null;
        }
        IJavaElement iJavaElement = JavaCore.create((String)string);
        if (iJavaElement != null && iJavaElement.getElementType() == 7) {
            return (IType)iJavaElement;
        }
        this.addWarning(JarPackagerMessages.JarPackageReader_warning_mainClassDoesNotExist, null);
        return null;
    }

    public IStatus getStatus() {
        if (this.fWarnings.getChildren().length == 0) {
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }
        return this.fWarnings;
    }

    protected void addWarning(String string, Throwable throwable) {
        this.fWarnings.add((IStatus)new Status(2, JavaPlugin.getPluginId(), 0, string, throwable));
    }
}

