/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class JavadocConsoleLineTracker
implements IConsoleLineTracker {
    private IConsole fConsole;

    public void init(IConsole iConsole) {
        this.fConsole = iConsole;
    }

    public void lineAppended(IRegion iRegion) {
        try {
            Object object;
            int n = iRegion.getOffset();
            int n2 = iRegion.getLength();
            String string = this.fConsole.getDocument().get(n, n2);
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                return;
            }
            int n4 = -1;
            IPath iPath = null;
            int n5 = string.indexOf(58, n3 + 1);
            while (n5 != -1 && iPath == null) {
                if (n3 < n5) {
                    try {
                        object = string.substring(n3 + 1, n5);
                        n4 = Integer.parseInt((String)object);
                        iPath = Path.fromOSString((String)string.substring(0, n3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                n3 = n5;
                n5 = string.indexOf(58, n3 + 1);
            }
            if (n4 != -1) {
                object = new JavadocConsoleHyperLink(iPath, n4);
                this.fConsole.addLink((IHyperlink)object, iRegion.getOffset(), n3);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void dispose() {
        this.fConsole = null;
    }

    private static class JavadocConsoleHyperLink
    implements IHyperlink {
        private IPath fExternalPath;
        private int fLineNumber;

        public JavadocConsoleHyperLink(IPath iPath, int n) {
            this.fExternalPath = iPath;
            this.fLineNumber = n;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            try {
                IFile[] iFileArray = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(this.fExternalPath);
                if (iFileArray.length > 0) {
                    int n = 0;
                    while (n < iFileArray.length) {
                        IFile iFile = iFileArray[0];
                        IJavaElement iJavaElement = JavaCore.create((IFile)iFile);
                        if (iJavaElement != null && iJavaElement.exists()) {
                            IEditorPart iEditorPart = JavaUI.openInEditor(iJavaElement, true, false);
                            if (iEditorPart instanceof ITextEditor) {
                                this.revealLine((ITextEditor)iEditorPart, this.fLineNumber);
                            }
                            return;
                        }
                        ++n;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
            catch (PartInitException partInitException) {
                JavaPlugin.log(partInitException);
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }

        private void revealLine(ITextEditor iTextEditor, int n) throws BadLocationException {
            IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
            IRegion iRegion = iDocument.getLineInformation(n - 1);
            iTextEditor.selectAndReveal(iRegion.getOffset(), 0);
        }
    }
}

