/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocReader;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.RecentSettingsStore;
import org.eclipse.wst.jsdt.launching.ExecutionArguments;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavadocOptionsManager {
    private IFile fXmlfile;
    private StatusInfo fWizardStatus;
    private String[] fJavadocCommandHistory;
    private IJavaElement[] fSelectedElements;
    private IJavaElement[] fInitialElements;
    private String fAccess;
    private String fDocletpath;
    private String fDocletname;
    private boolean fFromStandard;
    private String fStylesheet;
    private String fAdditionalParams;
    private String fVMParams;
    private String fOverview;
    private String fTitle;
    private String[] fHRefs;
    private IPath[] fSourcepath;
    private IPath[] fClasspath;
    private boolean fNotree;
    private boolean fNoindex;
    private boolean fSplitindex;
    private boolean fNonavbar;
    private boolean fNodeprecated;
    private boolean fNoDeprecatedlist;
    private boolean fAuthor;
    private boolean fVersion;
    private boolean fUse;
    private String fSource;
    private boolean fOpenInBrowser;
    private RecentSettingsStore fRecentSettings;
    private String fDestination;
    private String fAntpath;
    public final String PRIVATE = "private";
    public final String PROTECTED = "protected";
    public final String PACKAGE = "package";
    public final String PUBLIC = "public";
    public final String USE = "use";
    public final String NOTREE = "notree";
    public final String NOINDEX = "noindex";
    public final String NONAVBAR = "nonavbar";
    public final String NODEPRECATED = "nodeprecated";
    public final String NODEPRECATEDLIST = "nodeprecatedlist";
    public final String VERSION = "version";
    public final String AUTHOR = "author";
    public final String SPLITINDEX = "splitindex";
    public final String STYLESHEETFILE = "stylesheetfile";
    public final String OVERVIEW = "overview";
    public final String DOCLETNAME = "docletname";
    public final String DOCLETPATH = "docletpath";
    public final String SOURCEPATH = "sourcepath";
    public final String CLASSPATH = "classpath";
    public final String DESTINATION = "destdir";
    public final String OPENINBROWSER = "openinbrowser";
    public final String VISIBILITY = "access";
    public final String PACKAGENAMES = "packagenames";
    public final String SOURCEFILES = "sourcefiles";
    public final String EXTRAOPTIONS = "additionalparam";
    public final String VMOPTIONS = "vmparam";
    public final String TITLE = "doctitle";
    public final String HREF = "href";
    public final String NAME = "name";
    public final String PATH = "path";
    public final String FROMSTANDARD = "fromStandard";
    public final String ANTPATH = "antpath";
    public final String SOURCE = "source";
    private final String SECTION_JAVADOC = "javadoc";
    private static final String JAVADOC_COMMAND_HISTORY = "javadoc_command_history";
    static /* synthetic */ Class class$0;

    public JavadocOptionsManager(IFile iFile, IDialogSettings iDialogSettings, List list) {
        this.fXmlfile = iFile;
        this.fWizardStatus = new StatusInfo();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("javadoc");
        String string = null;
        if (iDialogSettings2 != null) {
            string = iDialogSettings2.get(JAVADOC_COMMAND_HISTORY);
        }
        if (string == null || string.length() == 0) {
            string = JavadocOptionsManager.initJavadocCommandDefault();
        }
        this.fJavadocCommandHistory = this.arrayFromFlatString(string);
        this.fRecentSettings = new RecentSettingsStore(iDialogSettings2);
        if (iFile != null) {
            try {
                JavadocReader javadocReader = new JavadocReader(iFile.getContents());
                Element element = javadocReader.readXML();
                if (element != null) {
                    this.loadFromXML(element);
                    return;
                }
                this.fWizardStatus.setWarning(JavadocExportMessages.JavadocOptionsManager_antfileincorrectCE_warning);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
                this.fWizardStatus.setWarning(JavadocExportMessages.JavadocOptionsManager_antfileincorrectCE_warning);
            }
            catch (IOException iOException) {
                JavaPlugin.log(iOException);
                this.fWizardStatus.setWarning(JavadocExportMessages.JavadocOptionsManager_antfileincorrectIOE_warning);
            }
            catch (SAXException sAXException) {
                this.fWizardStatus.setWarning(JavadocExportMessages.JavadocOptionsManager_antfileincorrectSAXE_warning);
            }
        }
        if (iDialogSettings2 != null) {
            this.loadFromDialogStore(iDialogSettings2, list);
        } else {
            this.loadDefaults(list);
        }
    }

    private IJavaProject getSingleProjectFromInitialSelection() {
        IJavaProject iJavaProject = null;
        int n = 0;
        while (n < this.fInitialElements.length) {
            IJavaProject iJavaProject2 = this.fInitialElements[n].getJavaProject();
            if (iJavaProject == null) {
                iJavaProject = iJavaProject2;
            } else if (!iJavaProject.equals(iJavaProject2)) {
                return null;
            }
            ++n;
        }
        if (iJavaProject != null && iJavaProject.isOpen()) {
            return iJavaProject;
        }
        return null;
    }

    private void loadFromDialogStore(IDialogSettings iDialogSettings, List list) {
        this.fInitialElements = this.getInitialElementsFromSelection(list);
        IJavaProject iJavaProject = this.getSingleProjectFromInitialSelection();
        this.fAccess = iDialogSettings.get("access");
        if (this.fAccess == null) {
            this.fAccess = "protected";
        }
        this.fFromStandard = iDialogSettings.getBoolean("fromStandard");
        this.fDocletpath = iDialogSettings.get("docletpath");
        this.fDocletname = iDialogSettings.get("docletname");
        if (this.fDocletpath == null || this.fDocletname == null) {
            this.fFromStandard = true;
            this.fDocletpath = "";
            this.fDocletname = "";
        }
        if (iJavaProject != null) {
            this.fAntpath = this.getRecentSettings().getAntpath(iJavaProject);
        } else {
            this.fAntpath = iDialogSettings.get("antpath");
            if (this.fAntpath == null) {
                this.fAntpath = "";
            }
        }
        if (iJavaProject != null) {
            this.fDestination = this.getRecentSettings().getDestination(iJavaProject);
        } else {
            this.fDestination = iDialogSettings.get("destdir");
            if (this.fDestination == null) {
                this.fDestination = "";
            }
        }
        this.fTitle = iDialogSettings.get("doctitle");
        if (this.fTitle == null) {
            this.fTitle = "";
        }
        this.fStylesheet = iDialogSettings.get("stylesheetfile");
        if (this.fStylesheet == null) {
            this.fStylesheet = "";
        }
        this.fVMParams = iDialogSettings.get("vmparam");
        if (this.fVMParams == null) {
            this.fVMParams = "";
        }
        this.fAdditionalParams = iDialogSettings.get("additionalparam");
        if (this.fAdditionalParams == null) {
            this.fAdditionalParams = "";
        }
        this.fOverview = iDialogSettings.get("overview");
        if (this.fOverview == null) {
            this.fOverview = "";
        }
        this.fUse = this.loadBoolean(iDialogSettings.get("use"));
        this.fAuthor = this.loadBoolean(iDialogSettings.get("author"));
        this.fVersion = this.loadBoolean(iDialogSettings.get("version"));
        this.fNodeprecated = this.loadBoolean(iDialogSettings.get("nodeprecated"));
        this.fNoDeprecatedlist = this.loadBoolean(iDialogSettings.get("nodeprecatedlist"));
        this.fNonavbar = this.loadBoolean(iDialogSettings.get("nonavbar"));
        this.fNoindex = this.loadBoolean(iDialogSettings.get("noindex"));
        this.fNotree = this.loadBoolean(iDialogSettings.get("notree"));
        this.fSplitindex = this.loadBoolean(iDialogSettings.get("splitindex"));
        this.fOpenInBrowser = this.loadBoolean(iDialogSettings.get("openinbrowser"));
        this.fSource = iDialogSettings.get("source");
        if (iJavaProject != null) {
            this.fSource = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        }
        this.fHRefs = iJavaProject != null ? this.getRecentSettings().getHRefs(iJavaProject) : new String[0];
    }

    private void loadDefaults(List list) {
        this.fInitialElements = this.getInitialElementsFromSelection(list);
        IJavaProject iJavaProject = this.getSingleProjectFromInitialSelection();
        if (iJavaProject != null) {
            this.fAntpath = this.getRecentSettings().getAntpath(iJavaProject);
            this.fDestination = this.getRecentSettings().getDestination(iJavaProject);
            this.fHRefs = this.getRecentSettings().getHRefs(iJavaProject);
        } else {
            this.fAntpath = "";
            this.fDestination = "";
            this.fHRefs = new String[0];
        }
        this.fAccess = "public";
        this.fDocletname = "";
        this.fDocletpath = "";
        this.fTitle = "";
        this.fStylesheet = "";
        this.fVMParams = "";
        this.fAdditionalParams = "";
        this.fOverview = "";
        this.fUse = true;
        this.fAuthor = true;
        this.fVersion = true;
        this.fNodeprecated = false;
        this.fNoDeprecatedlist = false;
        this.fNonavbar = false;
        this.fNoindex = false;
        this.fNotree = false;
        this.fSplitindex = true;
        this.fOpenInBrowser = false;
        this.fSource = "1.3";
        if (iJavaProject != null) {
            this.fSource = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        }
        this.fFromStandard = true;
    }

    private void loadFromXML(Element element) {
        Object object;
        int n;
        NodeList nodeList;
        this.fAccess = element.getAttribute("access");
        if (this.fAccess.length() == 0) {
            this.fAccess = "protected";
        }
        String string = element.getAttribute("destdir");
        this.fDestination = this.makeAbsolutePathFromRelative((IPath)new Path(string)).toOSString();
        this.fFromStandard = true;
        this.fDocletname = "";
        this.fDocletpath = "";
        if (string.length() == 0) {
            nodeList = element.getChildNodes();
            n = 0;
            while (n < nodeList.getLength()) {
                object = nodeList.item(n);
                if (object.getNodeName().equals("doclet")) {
                    this.fDocletpath = ((Element)object).getAttribute("path");
                    this.fDocletname = ((Element)object).getAttribute("name");
                    if (this.fDocletpath.length() != 0 || this.fDocletname.length() != 0) {
                        this.fFromStandard = false;
                        break;
                    }
                    this.fDocletname = "";
                    this.fDocletpath = "";
                    break;
                }
                ++n;
            }
        }
        this.fInitialElements = this.getSelectedElementsFromAnt(element);
        nodeList = element.getChildNodes();
        this.fHRefs = new String[nodeList.getLength()];
        n = 0;
        while (n < this.fHRefs.length) {
            object = nodeList.item(n);
            if (object.getNodeName().equals("link")) {
                this.fHRefs[n] = ((Element)object).getAttribute("href");
            }
            ++n;
        }
        IPath iPath = this.fXmlfile.getLocation();
        this.fAntpath = iPath != null ? iPath.toOSString() : "";
        this.fStylesheet = element.getAttribute("stylesheetfile");
        this.fTitle = element.getAttribute("doctitle");
        object = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = element.getAttribute("additionalparam");
        if (string2.length() > 0) {
            ExecutionArguments executionArguments = new ExecutionArguments("", string2);
            String[] stringArray = executionArguments.getProgramArgumentsArray();
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                if (string3.length() > 0 && string3.charAt(0) == '-') {
                    boolean bl2 = bl = string3.length() > 1 && string3.charAt(1) == 'J';
                }
                if (bl) {
                    stringBuffer.append(string3).append(' ');
                } else {
                    ((StringBuffer)object).append(string3).append(' ');
                }
                ++n2;
            }
        }
        this.fAdditionalParams = ((StringBuffer)object).toString();
        this.fVMParams = stringBuffer.toString();
        this.fOverview = element.getAttribute("overview");
        this.fUse = this.loadBoolean(element.getAttribute("use"));
        this.fAuthor = this.loadBoolean(element.getAttribute("author"));
        this.fVersion = this.loadBoolean(element.getAttribute("version"));
        this.fNodeprecated = this.loadBoolean(element.getAttribute("nodeprecated"));
        this.fNoDeprecatedlist = this.loadBoolean(element.getAttribute("nodeprecatedlist"));
        this.fNonavbar = this.loadBoolean(element.getAttribute("nonavbar"));
        this.fNoindex = this.loadBoolean(element.getAttribute("noindex"));
        this.fNotree = this.loadBoolean(element.getAttribute("notree"));
        this.fSplitindex = this.loadBoolean(element.getAttribute("splitindex"));
        this.fSource = element.getAttribute("source");
    }

    private IPath makeAbsolutePathFromRelative(IPath iPath) {
        if (!iPath.isAbsolute()) {
            if (this.fXmlfile == null) {
                return null;
            }
            IPath iPath2 = this.fXmlfile.getParent().getLocation();
            if (iPath2 == null) {
                return null;
            }
            return iPath2.append(iPath);
        }
        return iPath;
    }

    private IContainer[] getSourceContainers(Element element) {
        String string = element.getAttribute("sourcepath");
        if (string.endsWith(File.pathSeparator)) {
            string = String.valueOf(string) + '.';
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
        String[] stringArray = string.split(File.pathSeparator);
        int n = 0;
        while (n < stringArray.length) {
            IPath iPath = this.makeAbsolutePathFromRelative((IPath)new Path(stringArray[n].trim()));
            if (iPath != null) {
                IContainer[] iContainerArray = iWorkspaceRoot.findContainersForLocation(iPath);
                int n2 = 0;
                while (n2 < iContainerArray.length) {
                    arrayList.add(iContainerArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new IContainer[arrayList.size()]);
    }

    private IJavaElement[] getSelectedElementsFromAnt(Element element) {
        IFile[] iFileArray;
        IPath iPath;
        StringTokenizer stringTokenizer;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = element.getAttribute("packagenames");
        if (string != null) {
            object2 = this.getSourceContainers(element);
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringTokenizer = new Path(((StringTokenizer)object).nextToken().trim().replace('.', '/'));
                int n = 0;
                while (n < ((IContainer[])object2).length) {
                    IJavaElement iJavaElement;
                    iPath = object2[n];
                    iFileArray = iPath.findMember((IPath)stringTokenizer);
                    if (iFileArray != null && (iJavaElement = JavaCore.create((IResource)iFileArray)) instanceof IPackageFragment) {
                        arrayList.add(iJavaElement);
                    }
                    ++n;
                }
            }
        }
        if ((object2 = element.getAttribute("sourcefiles")) != null) {
            object = ResourcesPlugin.getWorkspace().getRoot();
            stringTokenizer = new StringTokenizer((String)object2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!JavaCore.isJavaLikeFileName((String)string2) || (iPath = this.makeAbsolutePathFromRelative((IPath)new Path(string2))) == null) continue;
                iFileArray = object.findFilesForLocation(iPath);
                int n = 0;
                while (n < iFileArray.length) {
                    ICompilationUnit iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)iFileArray[n]);
                    if (iCompilationUnit != null) {
                        arrayList.add(iCompilationUnit);
                    }
                    ++n;
                }
            }
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    public String[] getJavadocCommandHistory() {
        return this.fJavadocCommandHistory;
    }

    public StatusInfo getWizardStatus() {
        return this.fWizardStatus;
    }

    public IJavaElement[] getInitialElements() {
        return this.fInitialElements;
    }

    public IJavaElement[] getSourceElements() {
        return this.fSelectedElements;
    }

    public String getAccess() {
        return this.fAccess;
    }

    public String getAntpath() {
        return this.fAntpath;
    }

    public boolean isFromStandard() {
        return this.fFromStandard;
    }

    public String getDestination() {
        return this.fDestination;
    }

    public String getDocletPath() {
        return this.fDocletpath;
    }

    public String getDocletName() {
        return this.fDocletname;
    }

    public String getStyleSheet() {
        return this.fStylesheet;
    }

    public String getOverview() {
        return this.fOverview;
    }

    public String getAdditionalParams() {
        return this.fAdditionalParams;
    }

    public String getVMParams() {
        return this.fVMParams;
    }

    public IPath[] getClasspath() {
        return this.fClasspath;
    }

    public IPath[] getSourcepath() {
        return this.fSourcepath;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public boolean doOpenInBrowser() {
        return this.fOpenInBrowser;
    }

    public String[] getHRefs() {
        return this.fHRefs;
    }

    public boolean getBoolean(String string) {
        if (string.equals("author")) {
            return this.fAuthor;
        }
        if (string.equals("version")) {
            return this.fVersion;
        }
        if (string.equals("use")) {
            return this.fUse;
        }
        if (string.equals("nodeprecated")) {
            return this.fNodeprecated;
        }
        if (string.equals("nodeprecatedlist")) {
            return this.fNoDeprecatedlist;
        }
        if (string.equals("noindex")) {
            return this.fNoindex;
        }
        if (string.equals("notree")) {
            return this.fNotree;
        }
        if (string.equals("splitindex")) {
            return this.fSplitindex;
        }
        if (string.equals("nonavbar")) {
            return this.fNonavbar;
        }
        return false;
    }

    private boolean loadBoolean(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("true");
    }

    private String flatPathList(IPath[] iPathArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < iPathArray.length) {
            if (n > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(iPathArray[n].toOSString());
            ++n;
        }
        return stringBuffer.toString();
    }

    private String flatStringList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String[] arrayFromFlatString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public IStatus getArgumentArray(List list, List list2) {
        IPath iPath;
        IJavaElement iJavaElement;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, JavadocExportMessages.JavadocOptionsManager_status_title, null);
        list.add(this.getJavadocCommandHistory()[0]);
        if (this.fFromStandard) {
            list2.add("-d");
            list2.add(this.fDestination);
        } else {
            list2.add("-doclet");
            list2.add(this.fDocletname);
            list2.add("-docletpath");
            list2.add(this.fDocletpath);
        }
        if (this.fSourcepath.length > 0) {
            list2.add("-sourcepath");
            list2.add(this.flatPathList(this.fSourcepath));
        }
        if (this.fClasspath.length > 0) {
            list2.add("-classpath");
            list2.add(this.flatPathList(this.fClasspath));
        }
        list2.add("-" + this.fAccess);
        if (this.fFromStandard) {
            if (this.fSource.length() > 0 && !this.fSource.equals("-")) {
                list2.add("-source");
                list2.add(this.fSource);
            }
            if (this.fUse) {
                list2.add("-use");
            }
            if (this.fVersion) {
                list2.add("-version");
            }
            if (this.fAuthor) {
                list2.add("-author");
            }
            if (this.fNonavbar) {
                list2.add("-nonavbar");
            }
            if (this.fNoindex) {
                list2.add("-noindex");
            }
            if (this.fNotree) {
                list2.add("-notree");
            }
            if (this.fNodeprecated) {
                list2.add("-nodeprecated");
            }
            if (this.fNoDeprecatedlist) {
                list2.add("-nodeprecatedlist");
            }
            if (this.fSplitindex) {
                list2.add("-splitindex");
            }
            if (this.fTitle.length() != 0) {
                list2.add("-doctitle");
                list2.add(this.fTitle);
            }
            if (this.fStylesheet.length() != 0) {
                list2.add("-stylesheetfile");
                list2.add(this.fStylesheet);
            }
            int n = 0;
            while (n < this.fHRefs.length) {
                list2.add("-link");
                list2.add(this.fHRefs[n]);
                ++n;
            }
        }
        if (this.fAdditionalParams.length() + this.fVMParams.length() != 0) {
            ExecutionArguments executionArguments = new ExecutionArguments(this.fVMParams, this.fAdditionalParams);
            iJavaElement = executionArguments.getVMArgumentsArray();
            int n = 0;
            while (n < ((String[])iJavaElement).length) {
                list.add(iJavaElement[n]);
                ++n;
            }
            iPath = executionArguments.getProgramArgumentsArray();
            int n2 = 0;
            while (n2 < ((String[])iPath).length) {
                list2.add(iPath[n2]);
                ++n2;
            }
        }
        this.addProxyOptions(list);
        if (this.fOverview.length() != 0) {
            list2.add("-overview");
            list2.add(this.fOverview);
        }
        int n = 0;
        while (n < this.fSelectedElements.length) {
            iJavaElement = this.fSelectedElements[n];
            if (iJavaElement instanceof IPackageFragment) {
                list2.add(iJavaElement.getElementName());
            } else if (iJavaElement instanceof ICompilationUnit) {
                iPath = iJavaElement.getResource().getLocation();
                if (iPath != null) {
                    list2.add(iPath.toOSString());
                } else {
                    String string = JavadocExportMessages.JavadocOptionsManager_status_non_local;
                    multiStatus.add((IStatus)new StatusInfo(2, Messages.format(string, iJavaElement.getPath().makeRelative().toString())));
                }
            }
            ++n;
        }
        return multiStatus;
    }

    private void addProxyOptions(List list) {
        String string;
        String string2 = "-J-Dhttp.proxyHost=";
        String string3 = "-J-Dhttp.proxyPort=";
        int n = 0;
        while (n < list.size()) {
            string = (String)list.get(n);
            if (string.startsWith(string2) || string.startsWith(string3)) {
                return;
            }
            ++n;
        }
        String string4 = System.getProperty("http.proxyHost");
        if (string4 != null) {
            list.add(String.valueOf(string2) + string4);
        }
        if ((string = System.getProperty("http.proxyPort")) != null) {
            list.add(String.valueOf(string3) + string);
        }
    }

    /*
     * Exception decompiling
     */
    public File createXML(IJavaProject[] var1_1) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 242->245)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateDialogSettings(IDialogSettings iDialogSettings, IJavaProject[] iJavaProjectArray) {
        IDialogSettings iDialogSettings2 = iDialogSettings.addNewSection("javadoc");
        iDialogSettings2.put(JAVADOC_COMMAND_HISTORY, this.flatStringList(this.fJavadocCommandHistory));
        if (this.fJavadocCommandHistory.length > 0) {
            IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
            iPreferenceStore.setValue("command", this.fJavadocCommandHistory[0]);
        }
        iDialogSettings2.put("fromStandard", this.fFromStandard);
        iDialogSettings2.put("docletname", this.fDocletname);
        iDialogSettings2.put("docletpath", this.fDocletpath);
        iDialogSettings2.put("access", this.fAccess);
        iDialogSettings2.put("use", this.fUse);
        iDialogSettings2.put("author", this.fAuthor);
        iDialogSettings2.put("version", this.fVersion);
        iDialogSettings2.put("nodeprecated", this.fNodeprecated);
        iDialogSettings2.put("nodeprecatedlist", this.fNoDeprecatedlist);
        iDialogSettings2.put("splitindex", this.fSplitindex);
        iDialogSettings2.put("noindex", this.fNoindex);
        iDialogSettings2.put("notree", this.fNotree);
        iDialogSettings2.put("nonavbar", this.fNonavbar);
        iDialogSettings2.put("openinbrowser", this.fOpenInBrowser);
        iDialogSettings2.put("source", this.fSource);
        if (this.fAntpath.length() != 0) {
            iDialogSettings2.put("antpath", this.fAntpath);
        }
        if (this.fDestination.length() != 0) {
            iDialogSettings2.put("destdir", this.fDestination);
        }
        if (this.fAdditionalParams.length() != 0) {
            iDialogSettings2.put("additionalparam", this.fAdditionalParams);
        }
        if (this.fVMParams.length() != 0) {
            iDialogSettings2.put("vmparam", this.fVMParams);
        }
        if (this.fOverview.length() != 0) {
            iDialogSettings2.put("overview", this.fOverview);
        }
        if (this.fStylesheet.length() != 0) {
            iDialogSettings2.put("stylesheetfile", this.fStylesheet);
        }
        if (this.fTitle.length() != 0) {
            iDialogSettings2.put("doctitle", this.fTitle);
        }
        if (iJavaProjectArray.length == 1) {
            this.updateRecentSettings(iJavaProjectArray[0]);
        }
        this.getRecentSettings().store(iDialogSettings2);
    }

    public void setJavadocCommandHistory(String[] stringArray) {
        this.fJavadocCommandHistory = stringArray;
    }

    public void setAccess(String string) {
        this.fAccess = string;
    }

    public void setDestination(String string) {
        this.fDestination = string;
    }

    public void setDocletPath(String string) {
        this.fDocletpath = string;
    }

    public void setDocletName(String string) {
        this.fDocletname = string;
    }

    public void setStyleSheet(String string) {
        this.fStylesheet = string;
    }

    public void setOverview(String string) {
        this.fOverview = string;
    }

    public void setAdditionalParams(String string) {
        this.fAdditionalParams = string;
    }

    public void setVMParams(String string) {
        this.fVMParams = string;
    }

    public void setGeneralAntpath(String string) {
        this.fAntpath = string;
    }

    public void setClasspath(IPath[] iPathArray) {
        this.fClasspath = iPathArray;
    }

    public void setSourcepath(IPath[] iPathArray) {
        this.fSourcepath = iPathArray;
    }

    public void setSelectedElements(IJavaElement[] iJavaElementArray) {
        this.fSelectedElements = iJavaElementArray;
    }

    public void setFromStandard(boolean bl) {
        this.fFromStandard = bl;
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    public void setOpenInBrowser(boolean bl) {
        this.fOpenInBrowser = bl;
    }

    public void setHRefs(String[] stringArray) {
        this.fHRefs = stringArray;
    }

    public void setBoolean(String string, boolean bl) {
        if (string.equals("author")) {
            this.fAuthor = bl;
        } else if (string.equals("use")) {
            this.fUse = bl;
        } else if (string.equals("version")) {
            this.fVersion = bl;
        } else if (string.equals("nodeprecated")) {
            this.fNodeprecated = bl;
        } else if (string.equals("nodeprecatedlist")) {
            this.fNoDeprecatedlist = bl;
        } else if (string.equals("noindex")) {
            this.fNoindex = bl;
        } else if (string.equals("notree")) {
            this.fNotree = bl;
        } else if (string.equals("splitindex")) {
            this.fSplitindex = bl;
        } else if (string.equals("nonavbar")) {
            this.fNonavbar = bl;
        }
    }

    public void setSource(String string) {
        this.fSource = string;
    }

    public String getSource() {
        return this.fSource;
    }

    private IJavaElement[] getInitialElementsFromSelection(List list) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        int n = 0;
        while (n < list.size()) {
            try {
                IJavaElement iJavaElement = this.getSelectableJavaElement(list.get(n));
                if (iJavaElement != null) {
                    arrayList.add(iJavaElement);
                }
            }
            catch (JavaModelException javaModelException) {}
            ++n;
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    private IJavaElement getSelectableJavaElement(Object object) throws JavaModelException {
        IJavaElement iJavaElement = null;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz);
        }
        if (iJavaElement != null) {
            IJavaProject iJavaProject;
            switch (iJavaElement.getElementType()) {
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    if (!this.containsCompilationUnits((IPackageFragmentRoot)iJavaElement)) break;
                    return iJavaElement;
                }
                case 4: {
                    if (!this.containsCompilationUnits((IPackageFragment)iJavaElement)) break;
                    return iJavaElement;
                }
                default: {
                    iJavaProject = (ICompilationUnit)iJavaElement.getAncestor(5);
                    if (iJavaProject == null) break;
                    return iJavaProject;
                }
            }
            iJavaProject = iJavaElement.getJavaProject();
            if (this.isValidProject(iJavaProject)) {
                return iJavaProject;
            }
        }
        return null;
    }

    private boolean isValidProject(IJavaProject iJavaProject) throws JavaModelException {
        return iJavaProject != null && iJavaProject.exists() && iJavaProject.isOpen();
    }

    private boolean containsCompilationUnits(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        if (iPackageFragmentRoot.getKind() != 1) {
            return false;
        }
        IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IPackageFragment iPackageFragment;
            if (iJavaElementArray[n] instanceof IPackageFragment && this.containsCompilationUnits(iPackageFragment = (IPackageFragment)iJavaElementArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean containsCompilationUnits(IPackageFragment iPackageFragment) throws JavaModelException {
        return iPackageFragment.getCompilationUnits().length > 0;
    }

    public RecentSettingsStore getRecentSettings() {
        return this.fRecentSettings;
    }

    public void updateRecentSettings(IJavaProject iJavaProject) {
        this.fRecentSettings.setProjectSettings(iJavaProject, this.fDestination, this.fAntpath, this.fHRefs);
    }

    private static String initJavadocCommandDefault() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("command");
        if (string != null && string.length() > 0) {
            iPreferenceStore.setToDefault("command");
            return string;
        }
        File file = JavadocOptionsManager.findJavaDocCommand();
        if (file != null) {
            return file.getPath();
        }
        return "";
    }

    private static File findJavaDocCommand() {
        Object object;
        IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
        if (iVMInstall != null && (object = JavadocOptionsManager.getCommand(iVMInstall)) != null) {
            return object;
        }
        object = JavaRuntime.getVMInstallTypes();
        int n = 0;
        while (n < ((IVMInstallType[])object).length) {
            IVMInstallType iVMInstallType = object[n];
            IVMInstall[] iVMInstallArray = iVMInstallType.getVMInstalls();
            int n2 = 0;
            while (n2 < iVMInstallArray.length) {
                File file = JavadocOptionsManager.getCommand(iVMInstallArray[n2]);
                if (file != null) {
                    return file;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private static File getCommand(IVMInstall iVMInstall) {
        File file = iVMInstall.getInstallLocation();
        if (file != null) {
            File file2 = new File(file, "bin/javadoc");
            if (file2.isFile()) {
                return file2;
            }
            file2 = new File(file, "bin/javadoc.exe");
            if (file2.isFile()) {
                return file2;
            }
        }
        return null;
    }
}

