/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;

class OverrideIndicatorManager
implements IJavaReconcilingListener {
    static final String ANNOTATION_TYPE = "org.eclipse.wst.jsdt.ui.overrideIndicator";
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Annotation[] fOverrideAnnotations;
    private IJavaElement fJavaElement;

    public OverrideIndicatorManager(IAnnotationModel iAnnotationModel, IJavaElement iJavaElement, CompilationUnit compilationUnit) {
        Assert.isNotNull((Object)iAnnotationModel);
        Assert.isNotNull((Object)iJavaElement);
        this.fJavaElement = iJavaElement;
        this.fAnnotationModel = iAnnotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
        this.updateAnnotations(compilationUnit, (IProgressMonitor)new NullProgressMonitor());
    }

    private Object getLockObject(IAnnotationModel iAnnotationModel) {
        Object object;
        if (iAnnotationModel instanceof ISynchronizable && (object = ((ISynchronizable)iAnnotationModel).getLockObject()) != null) {
            return object;
        }
        return iAnnotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(CompilationUnit compilationUnit, IProgressMonitor iProgressMonitor) {
        if (compilationUnit == null || iProgressMonitor.isCanceled()) {
            return;
        }
        final HashMap hashMap = new HashMap(50);
        compilationUnit.accept(new ASTVisitor(false){

            public boolean visit(MethodDeclaration methodDeclaration) {
                IMethodBinding iMethodBinding;
                IMethodBinding iMethodBinding2 = methodDeclaration.resolveBinding();
                if (iMethodBinding2 != null && (iMethodBinding = Bindings.findOverriddenMethod(iMethodBinding2, true)) != null) {
                    ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
                    String string = String.valueOf(iTypeBinding.getQualifiedName()) + "." + iMethodBinding2.getName();
                    boolean bl = JdtFlags.isAbstract(iMethodBinding);
                    String string2 = bl ? Messages.format(JavaEditorMessages.OverrideIndicatorManager_implements, string) : Messages.format(JavaEditorMessages.OverrideIndicatorManager_overrides, string);
                    SimpleName simpleName = methodDeclaration.getName();
                    Position position = new Position(simpleName.getStartPosition(), simpleName.getLength());
                    hashMap.put(new OverrideIndicator(bl, string2, iMethodBinding2.getKey()), position);
                }
                return true;
            }
        });
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, hashMap);
            } else {
                this.removeAnnotations();
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.fAnnotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
            this.fOverrideAnnotations = hashMap.keySet().toArray(new Annotation[hashMap.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int n = 0;
                int n2 = this.fOverrideAnnotations.length;
                while (n < n2) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[n]);
                    ++n;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(CompilationUnit compilationUnit, boolean bl, IProgressMonitor iProgressMonitor) {
        this.updateAnnotations(compilationUnit, iProgressMonitor);
    }

    class OverrideIndicator
    extends Annotation {
        private boolean fIsOverwriteIndicator;
        private String fAstNodeKey;

        OverrideIndicator(boolean bl, String string, String string2) {
            super(OverrideIndicatorManager.ANNOTATION_TYPE, false, string);
            this.fIsOverwriteIndicator = bl;
            this.fAstNodeKey = string2;
        }

        public boolean isOverwriteIndicator() {
            return this.fIsOverwriteIndicator;
        }

        public void open() {
            String string;
            String string2;
            CompilationUnit compilationUnit = ASTProvider.getASTProvider().getAST(OverrideIndicatorManager.this.fJavaElement, ASTProvider.WAIT_ACTIVE_ONLY, null);
            if (compilationUnit != null && (string2 = compilationUnit.findDeclaringNode(this.fAstNodeKey)) instanceof MethodDeclaration) {
                try {
                    IJavaElement iJavaElement;
                    string = ((MethodDeclaration)string2).resolveBinding();
                    IMethodBinding iMethodBinding = Bindings.findOverriddenMethod((IMethodBinding)string, true);
                    if (iMethodBinding != null && (iJavaElement = iMethodBinding.getJavaElement()) != null) {
                        JavaUI.openInEditor(iJavaElement, true, true);
                        return;
                    }
                }
                catch (CoreException coreException) {
                    ExceptionHandler.handle(coreException, JavaEditorMessages.OverrideIndicatorManager_open_error_title, JavaEditorMessages.OverrideIndicatorManager_open_error_messageHasLogEntry);
                    return;
                }
            }
            string2 = JavaEditorMessages.OverrideIndicatorManager_open_error_title;
            string = JavaEditorMessages.OverrideIndicatorManager_open_error_message;
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)string2, (String)string);
        }
    }
}

