/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingPresenter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingReconciler;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightings;
import org.eclipse.wst.jsdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.wst.jsdt.ui.text.IColorManager;
import org.eclipse.wst.jsdt.ui.text.IColorManagerExtension;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;

public class SemanticHighlightingManager
implements IPropertyChangeListener {
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;
    private SemanticHighlighting[] fSemanticHighlightings;
    private Highlighting[] fHighlightings;
    private JavaEditor fEditor;
    private JavaSourceViewer fSourceViewer;
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private JavaSourceViewerConfiguration fConfiguration;
    private JavaPresentationReconciler fPresentationReconciler;
    private HighlightedRange[][] fHardcodedRanges;

    public void install(JavaEditor javaEditor, JavaSourceViewer javaSourceViewer, IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        this.fEditor = javaEditor;
        this.fSourceViewer = javaSourceViewer;
        this.fColorManager = iColorManager;
        this.fPreferenceStore = iPreferenceStore;
        if (this.fEditor != null) {
            this.fConfiguration = javaEditor.createJavaSourceViewerConfiguration();
            this.fPresentationReconciler = (JavaPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)javaSourceViewer);
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void install(JavaSourceViewer javaSourceViewer, IColorManager iColorManager, IPreferenceStore iPreferenceStore, HighlightedRange[][] highlightedRangeArray) {
        this.fHardcodedRanges = highlightedRangeArray;
        this.install(null, javaSourceViewer, iColorManager, iPreferenceStore);
    }

    private void enable() {
        this.initializeHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = new SemanticHighlightingReconciler();
            this.fReconciler.install(this.fEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings, this.fHighlightings);
        } else {
            this.fPresenter.updatePresentation(null, this.createHardcodedPositions(), new HighlightedPosition[0]);
        }
    }

    private HighlightedPosition[] createHardcodedPositions() {
        ArrayList<HighlightedPosition> arrayList = new ArrayList<HighlightedPosition>();
        int n = 0;
        while (n < this.fHardcodedRanges.length) {
            HighlightedRange highlightedRange = null;
            Highlighting highlighting = null;
            int n2 = 0;
            while (n2 < this.fHardcodedRanges[n].length) {
                highlighting = this.getHighlighting(this.fHardcodedRanges[n][n2].getKey());
                if (highlighting.isEnabled()) {
                    highlightedRange = this.fHardcodedRanges[n][n2];
                    break;
                }
                ++n2;
            }
            if (highlightedRange != null) {
                arrayList.add(this.fPresenter.createHighlightedPosition(highlightedRange.getOffset(), highlightedRange.getLength(), highlighting));
            }
            ++n;
        }
        return arrayList.toArray(new HighlightedPosition[arrayList.size()]);
    }

    private Highlighting getHighlighting(String string) {
        int n = 0;
        while (n < this.fSemanticHighlightings.length) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[n];
            if (string.equals(semanticHighlighting.getPreferenceKey())) {
                return this.fHighlightings[n];
            }
            ++n;
        }
        return null;
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fColorManager = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
        this.fHardcodedRanges = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fSemanticHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    private boolean isEnabled() {
        return SemanticHighlightings.isEnabled(this.fPreferenceStore);
    }

    private void initializeHighlightings() {
        this.fSemanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        this.fHighlightings = new Highlighting[this.fSemanticHighlightings.length];
        int n = 0;
        int n2 = this.fSemanticHighlightings.length;
        while (n < n2) {
            String string;
            String string2;
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[n];
            String string3 = SemanticHighlightings.getColorPreferenceKey(semanticHighlighting);
            this.addColor(string3);
            String string4 = SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting);
            int n3 = this.fPreferenceStore.getBoolean(string4) ? 1 : 0;
            String string5 = SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting);
            if (this.fPreferenceStore.getBoolean(string5)) {
                n3 |= 2;
            }
            if (this.fPreferenceStore.getBoolean(string2 = SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting))) {
                n3 |= 0x20000000;
            }
            if (this.fPreferenceStore.getBoolean(string = SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting))) {
                n3 |= 0x40000000;
            }
            boolean bl = this.fPreferenceStore.getBoolean(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting));
            this.fHighlightings[n] = new Highlighting(new TextAttribute(this.fColorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)string3)), null, n3), bl);
            ++n;
        }
    }

    private void disposeHighlightings() {
        int n = 0;
        int n2 = this.fSemanticHighlightings.length;
        while (n < n2) {
            this.removeColor(SemanticHighlightings.getColorPreferenceKey(this.fSemanticHighlightings[n]));
            ++n;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.handlePropertyChangeEvent(propertyChangeEvent);
    }

    private void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        if (this.fPreferenceStore == null) {
            return;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration.handlePropertyChangeEvent(propertyChangeEvent);
        }
        if (SemanticHighlightings.affectsEnablement(this.fPreferenceStore, propertyChangeEvent)) {
            if (this.isEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
        }
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = false;
        int n = 0;
        int n2 = this.fSemanticHighlightings.length;
        while (n < n2) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[n];
            String string = SemanticHighlightings.getColorPreferenceKey(semanticHighlighting);
            if (string.equals(propertyChangeEvent.getProperty())) {
                this.adaptToTextForegroundChange(this.fHighlightings[n], propertyChangeEvent);
                this.fPresenter.highlightingStyleChanged(this.fHighlightings[n]);
                bl = true;
            } else {
                String string2 = SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting);
                if (string2.equals(propertyChangeEvent.getProperty())) {
                    this.adaptToTextStyleChange(this.fHighlightings[n], propertyChangeEvent, 1);
                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[n]);
                    bl = true;
                } else {
                    String string3 = SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting);
                    if (string3.equals(propertyChangeEvent.getProperty())) {
                        this.adaptToTextStyleChange(this.fHighlightings[n], propertyChangeEvent, 2);
                        this.fPresenter.highlightingStyleChanged(this.fHighlightings[n]);
                        bl = true;
                    } else {
                        String string4 = SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting);
                        if (string4.equals(propertyChangeEvent.getProperty())) {
                            this.adaptToTextStyleChange(this.fHighlightings[n], propertyChangeEvent, 0x20000000);
                            this.fPresenter.highlightingStyleChanged(this.fHighlightings[n]);
                            bl = true;
                        } else {
                            String string5 = SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting);
                            if (string5.equals(propertyChangeEvent.getProperty())) {
                                this.adaptToTextStyleChange(this.fHighlightings[n], propertyChangeEvent, 0x40000000);
                                this.fPresenter.highlightingStyleChanged(this.fHighlightings[n]);
                                bl = true;
                            } else {
                                String string6 = SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting);
                                if (string6.equals(propertyChangeEvent.getProperty())) {
                                    this.adaptToEnablementChange(this.fHighlightings[n], propertyChangeEvent);
                                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[n]);
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
            ++n;
        }
        if (bl && this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    private void adaptToEnablementChange(Highlighting highlighting, PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        boolean bl = object instanceof Boolean ? (Boolean)object : "true".equals(object);
        highlighting.setEnabled(bl);
    }

    private void adaptToTextForegroundChange(Highlighting highlighting, PropertyChangeEvent propertyChangeEvent) {
        RGB rGB = null;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof RGB) {
            rGB = (RGB)object;
        } else if (object instanceof String) {
            rGB = StringConverter.asRGB((String)((String)object));
        }
        if (rGB != null) {
            Object object2;
            String string = propertyChangeEvent.getProperty();
            Color color = this.fColorManager.getColor(string);
            if ((color == null || !rGB.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                object2 = (IColorManagerExtension)((Object)this.fColorManager);
                object2.unbindColor(string);
                object2.bindColor(string, rGB);
                color = this.fColorManager.getColor(string);
            }
            object2 = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(color, object2.getBackground(), object2.getStyle()));
        }
    }

    private void adaptToTextStyleChange(Highlighting highlighting, PropertyChangeEvent propertyChangeEvent, int n) {
        boolean bl;
        boolean bl2 = false;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        } else if ("true".equals(object)) {
            bl2 = true;
        }
        TextAttribute textAttribute = highlighting.getTextAttribute();
        boolean bl3 = bl = (textAttribute.getStyle() & n) == n;
        if (bl != bl2) {
            highlighting.setTextAttribute(new TextAttribute(textAttribute.getForeground(), textAttribute.getBackground(), bl2 ? textAttribute.getStyle() | n : textAttribute.getStyle() & ~n));
        }
    }

    private void addColor(String string) {
        if (this.fColorManager != null && string != null && this.fColorManager.getColor(string) == null) {
            RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)string);
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension iColorManagerExtension = (IColorManagerExtension)((Object)this.fColorManager);
                iColorManagerExtension.unbindColor(string);
                iColorManagerExtension.bindColor(string, rGB);
            }
        }
    }

    private void removeColor(String string) {
        if (this.fColorManager instanceof IColorManagerExtension) {
            ((IColorManagerExtension)((Object)this.fColorManager)).unbindColor(string);
        }
    }

    public SemanticHighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    static class HighlightedPosition
    extends Position {
        private Highlighting fStyle;
        private Object fLock;

        public HighlightedPosition(int n, int n2, Highlighting highlighting, Object object) {
            super(n, n2);
            this.fStyle = highlighting;
            this.fLock = object;
        }

        public StyleRange createStyleRange() {
            int n = 0;
            if (this.fStyle.isEnabled()) {
                n = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int n2 = textAttribute.getStyle();
            int n3 = n2 & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), n, textAttribute.getForeground(), textAttribute.getBackground(), n3);
            styleRange.strikeout = (n2 & 0x20000000) != 0;
            styleRange.underline = (n2 & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int n, int n2, Highlighting highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == n && this.getLength() == n2 && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int n, int n2) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && n <= this.getOffset() && n + n2 >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int n, int n2) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(n);
                super.setLength(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int n) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int n) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public Highlighting getHighlighting() {
            return this.fStyle;
        }
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int n, int n2, String string) {
            super(n, n2);
            this.fKey = string;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object object) {
            return super.equals(object) && object instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)object)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }

    static class Highlighting {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public Highlighting(TextAttribute textAttribute, boolean bl) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(bl);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean bl) {
            this.fIsEnabled = bl;
        }
    }
}

