/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class JavaDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private List fElements;
    private JavaMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private JavaCopyProcessor fCopyProcessor;
    private int fCanCopyElements;

    public IStatus handleDrop(CommonDropAdapter commonDropAdapter, DropTargetEvent dropTargetEvent, Object object) {
        if (LocalSelectionTransfer.getInstance().isSupportedType(commonDropAdapter.getCurrentTransfer())) {
            try {
                switch (commonDropAdapter.getCurrentOperation()) {
                    case 2: {
                        this.handleDropMove(object);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(object);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(invocationTargetException, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
            }
            catch (InterruptedException interruptedException) {}
            this.clear();
            return Status.OK_STATUS;
        }
        if (FileTransfer.getInstance().isSupportedType(commonDropAdapter.getCurrentTransfer())) {
            try {
                Object object2 = FileTransfer.getInstance().nativeToJava(commonDropAdapter.getCurrentTransfer());
                if (!(object2 instanceof String[])) {
                    return Status.CANCEL_STATUS;
                }
                IContainer iContainer = this.getActualTarget(object);
                if (iContainer == null) {
                    return Status.CANCEL_STATUS;
                }
                this.getShell().forceActive();
                new CopyFilesAndFoldersOperation(this.getShell()).copyFiles((String[])object2, iContainer);
            }
            catch (JavaModelException javaModelException) {
                String string = PackagesMessages.DropAdapter_errorTitle;
                String string2 = PackagesMessages.DropAdapter_errorMessage;
                ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), string, string2);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus validateDrop(Object object, int n, TransferData transferData) {
        IStatus iStatus = Status.OK_STATUS;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            this.initializeSelection();
            try {
                switch (n) {
                    case 16: {
                        if (this.handleValidateDefault(object) != 0) {
                            iStatus = Status.OK_STATUS;
                            break;
                        }
                        iStatus = Status.CANCEL_STATUS;
                        break;
                    }
                    case 1: {
                        if (this.handleValidateCopy(object) != 0) {
                            iStatus = Status.OK_STATUS;
                            break;
                        }
                        iStatus = Status.CANCEL_STATUS;
                        break;
                    }
                    case 2: {
                        if (this.handleValidateMove(object) != 0) {
                            iStatus = Status.OK_STATUS;
                            break;
                        }
                        iStatus = Status.CANCEL_STATUS;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
                iStatus = Status.CANCEL_STATUS;
            }
        }
        return iStatus;
    }

    public boolean isSupportedType(TransferData transferData) {
        return super.isSupportedType(transferData) || FileTransfer.getInstance().isSupportedType(transferData);
    }

    private IContainer getActualTarget(Object object) throws JavaModelException {
        if (object instanceof IContainer) {
            return (IContainer)object;
        }
        if (object instanceof IJavaElement) {
            return this.getActualTarget(((IJavaElement)object).getCorrespondingResource());
        }
        return null;
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        this.fElements = ((IStructuredSelection)iSelection).toList();
    }

    private void handleDropMove(Object object) throws JavaModelException, InvocationTargetException, InterruptedException {
        IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(this.fElements);
        IResource[] iResourceArray = ReorgUtils.getResources(this.fElements);
        ReorgMoveStarter reorgMoveStarter = null;
        if (object instanceof IResource) {
            reorgMoveStarter = ReorgMoveStarter.create(iJavaElementArray, iResourceArray, (IResource)object);
        } else if (object instanceof IJavaElement) {
            reorgMoveStarter = ReorgMoveStarter.create(iJavaElementArray, iResourceArray, (IJavaElement)object);
        }
        if (reorgMoveStarter != null) {
            reorgMoveStarter.run(this.getShell());
        }
    }

    private void handleDropCopy(Object object) throws JavaModelException, InvocationTargetException, InterruptedException {
        IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(this.fElements);
        IResource[] iResourceArray = ReorgUtils.getResources(this.fElements);
        ReorgCopyStarter reorgCopyStarter = null;
        if (object instanceof IResource) {
            reorgCopyStarter = ReorgCopyStarter.create(iJavaElementArray, iResourceArray, (IResource)object);
        } else if (object instanceof IJavaElement) {
            reorgCopyStarter = ReorgCopyStarter.create(iJavaElementArray, iResourceArray, (IJavaElement)object);
        }
        if (reorgCopyStarter != null) {
            reorgCopyStarter.run(this.getShell());
        }
    }

    private int handleValidateCopy(Object object) throws JavaModelException {
        IReorgPolicy.ICopyPolicy iCopyPolicy = ReorgPolicyFactory.createCopyPolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements));
        JavaCopyProcessor javaCopyProcessor = this.fCopyProcessor = iCopyPolicy.canEnable() ? new JavaCopyProcessor(iCopyPolicy) : null;
        if (!this.canCopyElements()) {
            return 0;
        }
        if (object instanceof IResource && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IResource)object).isOK()) {
            return 1;
        }
        if (object instanceof IJavaElement && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IJavaElement)object).isOK()) {
            return 1;
        }
        return 0;
    }

    private int handleValidateDefault(Object object) throws JavaModelException {
        if (object == null) {
            return 0;
        }
        return this.handleValidateMove(object);
    }

    private int handleValidateMove(Object object) throws JavaModelException {
        if (object == null) {
            return 0;
        }
        IReorgPolicy.IMovePolicy iMovePolicy = ReorgPolicyFactory.createMovePolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements));
        JavaMoveProcessor javaMoveProcessor = this.fMoveProcessor = iMovePolicy.canEnable() ? new JavaMoveProcessor(iMovePolicy) : null;
        if (!this.canMoveElements()) {
            return 0;
        }
        if (object instanceof IResource && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IResource)object).isOK()) {
            return 2;
        }
        if (object instanceof IJavaElement && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IJavaElement)object).isOK()) {
            return 2;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void clear() {
        this.fElements = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }
}

