/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JSDScopeUtil;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.IClasspathContainerInitialzerExtension;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;

public class ClassPathContainer
extends PackageFragmentRootContainer {
    private IClasspathEntry fClassPathEntry;
    private IClasspathContainer fContainer;
    static /* synthetic */ Class class$0;

    public ClassPathContainer(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry) {
        super(iJavaProject);
        this.fClassPathEntry = iClasspathEntry;
        try {
            this.fContainer = JavaCore.getClasspathContainer((IPath)iClasspathEntry.getPath(), (IJavaProject)iJavaProject);
        }
        catch (JavaModelException javaModelException) {
            this.fContainer = null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ClassPathContainer) {
            ClassPathContainer classPathContainer = (ClassPathContainer)object;
            if (this.getJavaProject().equals(classPathContainer.getJavaProject()) && this.fClassPathEntry.equals(classPathContainer.fClassPathEntry)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getJavaProject().hashCode() * 17 + this.fClassPathEntry.hashCode();
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots() {
        return this.getJavaProject().findPackageFragmentRoots(this.fClassPathEntry);
    }

    public IAdaptable[] getChildren() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            arrayList.add(iPackageFragmentRootArray[n]);
            ++n;
        }
        if (this.fContainer != null) {
            IClasspathEntry[] iClasspathEntryArray = this.fContainer.getClasspathEntries();
            if (iClasspathEntryArray == null) {
                JavaPlugin.log(new IllegalArgumentException("Invalid classpath container implementation: getClasspathEntries() returns null. " + this.fContainer.getPath()));
            } else {
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                int n2 = 0;
                while (n2 < iClasspathEntryArray.length) {
                    IResource iResource;
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                    if (iClasspathEntry.getEntryKind() == 2 && (iResource = iWorkspaceRoot.findMember(iClasspathEntry.getPath())) instanceof IProject) {
                        arrayList.add(new RequiredProjectWrapper(this, JavaCore.create((IProject)((IProject)iResource))));
                    }
                    ++n2;
                }
            }
        }
        return arrayList.toArray(new IAdaptable[arrayList.size()]);
    }

    public ImageDescriptor getImageDescriptor() {
        IPath iPath;
        ImageDescriptor imageDescriptor;
        ClasspathContainerInitializer classpathContainerInitializer = JSDScopeUtil.getContainerInitializer((IPath)this.fClassPathEntry.getPath());
        if (classpathContainerInitializer != null && classpathContainerInitializer instanceof IClasspathContainerInitialzerExtension && (imageDescriptor = ((IClasspathContainerInitialzerExtension)classpathContainerInitializer).getImage(iPath = this.fClassPathEntry.getPath(), this.fClassPathEntry.toString(), super.getJavaProject())) != null) {
            return imageDescriptor;
        }
        return JavaPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel() {
        if (this.fContainer != null) {
            return this.fContainer.getDescription();
        }
        IPath iPath = this.fClassPathEntry.getPath();
        String string = iPath.segment(0);
        ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)string);
        if (classpathContainerInitializer != null) {
            String string2 = classpathContainerInitializer.getDescription(iPath, this.getJavaProject());
            return Messages.format(PackagesMessages.ClassPathContainer_unbound_label, string2);
        }
        return Messages.format(PackagesMessages.ClassPathContainer_unknown_label, iPath.toString());
    }

    public IClasspathEntry getClasspathEntry() {
        return this.fClassPathEntry;
    }

    static boolean contains(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, IPackageFragmentRoot iPackageFragmentRoot) {
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.findPackageFragmentRoots(iClasspathEntry);
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            if (iPackageFragmentRootArray[n].equals(iPackageFragmentRoot)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static class RequiredProjectWrapper
    implements IAdaptable,
    IWorkbenchAdapter {
        private final ClassPathContainer fParent;
        private final IJavaProject fProject;

        public RequiredProjectWrapper(ClassPathContainer classPathContainer, IJavaProject iJavaProject) {
            this.fParent = classPathContainer;
            this.fProject = iJavaProject;
        }

        public IJavaProject getProject() {
            return this.fProject;
        }

        public ClassPathContainer getParentClassPathContainer() {
            return this.fParent;
        }

        public Object getAdapter(Class clazz) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        }

        public String getLabel(Object object) {
            return this.fProject.getElementName();
        }

        public Object getParent(Object object) {
            return this.fParent;
        }
    }
}

