/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.navigator.ContainerFolder;
import org.eclipse.wst.jsdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.LibraryContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

public class PackageExplorerContentProvider
extends StandardJavaElementContentProvider
implements ITreeContentProvider,
IElementChangedListener,
IPropertyChangeListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    private TreeViewer fViewer;
    private Object fInput;
    private boolean fIsFlatLayout = false;
    private boolean fShowLibrariesNode = false;
    private boolean fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
    private Collection fPendingUpdates = null;

    public PackageExplorerContentProvider(boolean bl) {
        super(bl);
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.flatPackagesInPackageExplorer");
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        ArrayList arrayList = new ArrayList();
        try {
            try {
                if (this.inputDeleted(arrayList)) {
                    Object var4_3 = null;
                    this.executeRunnables(arrayList);
                    return;
                }
                this.processDelta(elementChangedEvent.getDelta(), arrayList);
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.executeRunnables(arrayList);
            throw throwable;
        }
        {
            Object var4_5 = null;
            this.executeRunnables(arrayList);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeRunnables(Collection collection) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            if (control.getDisplay().getThread() == Thread.currentThread()) {
                this.runUpdates(collection);
            } else {
                PackageExplorerContentProvider packageExplorerContentProvider = this;
                synchronized (packageExplorerContentProvider) {
                    if (this.fPendingUpdates == null) {
                        this.fPendingUpdates = collection;
                    } else {
                        this.fPendingUpdates.addAll(collection);
                    }
                }
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PackageExplorerContentProvider.this.runPendingUpdates();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPendingUpdates() {
        Collection collection;
        PackageExplorerContentProvider packageExplorerContentProvider = this;
        synchronized (packageExplorerContentProvider) {
            collection = this.fPendingUpdates;
            this.fPendingUpdates = null;
        }
        if (collection != null && this.fViewer != null && (packageExplorerContentProvider = this.fViewer.getControl()) != null && !packageExplorerContentProvider.isDisposed()) {
            this.runUpdates(collection);
        }
    }

    private void runUpdates(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((Runnable)iterator.next()).run();
        }
    }

    private boolean inputDeleted(Collection collection) {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IJavaElement && ((IJavaElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        if (this.fInput instanceof IWorkingSet) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput, collection);
        return true;
    }

    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        if (this.fIsFlatLayout) {
            return super.getPackageFragmentRootContent(iPackageFragmentRoot);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getHierarchicalPackageChildren(iPackageFragmentRoot, null, arrayList);
        if (!this.isProjectPackageFragmentRoot(iPackageFragmentRoot)) {
            Object[] objectArray = iPackageFragmentRoot.getNonJavaResources();
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(objectArray[n]);
                ++n;
            }
        }
        return arrayList.toArray();
    }

    protected Object[] getPackageContent(IPackageFragment iPackageFragment) throws JavaModelException {
        if (this.fIsFlatLayout) {
            return super.getPackageContent(iPackageFragment);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getHierarchicalPackageChildren((IPackageFragmentRoot)iPackageFragment.getParent(), iPackageFragment, arrayList);
        Object[] objectArray = super.getPackageContent(iPackageFragment);
        if (arrayList.isEmpty()) {
            return objectArray;
        }
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n]);
            ++n;
        }
        return arrayList.toArray();
    }

    protected Object[] getFolderContent(IFolder iFolder) throws CoreException {
        if (this.fIsFlatLayout) {
            return super.getFolderContent(iFolder);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getHierarchicalPackagesInFolder(iFolder, arrayList);
        Object[] objectArray = super.getFolderContent(iFolder);
        if (arrayList.isEmpty()) {
            return objectArray;
        }
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n]);
            ++n;
        }
        return arrayList.toArray();
    }

    public Object[] getChildren(Object object) {
        try {
            if (object instanceof IJavaModel) {
                return PackageExplorerContentProvider.concatenate(this.getJavaProjects((IJavaModel)object), this.getNonJavaProjects((IJavaModel)object));
            }
            if (object instanceof ContainerFolder) {
                return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)((ContainerFolder)object).getParentObject());
            }
            if (object instanceof PackageFragmentRootContainer) {
                return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)object, true);
            }
            if (object instanceof IProject) {
                return ((IProject)object).members();
            }
            if (object instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)object).isVirtual()) {
                return this.getLibraryChildren((IPackageFragmentRoot)object);
            }
            return super.getChildren(object);
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private Object[] getLibraryChildren(IPackageFragmentRoot iPackageFragmentRoot) {
        Object[] objectArray = null;
        try {
            objectArray = iPackageFragmentRoot.getChildren();
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        if (objectArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        try {
            while (!bl && objectArray != null && objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    String string;
                    String string2 = ((IJavaElement)objectArray[0]).getDisplayName();
                    if (string2 != (string = ((IJavaElement)objectArray[n]).getDisplayName()) && (string2 == null || string2.compareTo(string) != 0)) {
                        arrayList.addAll(Arrays.asList(objectArray));
                        bl = true;
                        break;
                    }
                    ++n;
                }
                ArrayList<IJavaElement> arrayList2 = new ArrayList<IJavaElement>();
                int n2 = 0;
                while (!bl && n2 < objectArray.length) {
                    if (objectArray[n2] instanceof IPackageFragment) {
                        arrayList2.addAll(Arrays.asList(((IPackageFragment)objectArray[n2]).getChildren()));
                    } else if (objectArray[n2] instanceof IPackageFragmentRoot) {
                        arrayList2.addAll(Arrays.asList(((IPackageFragmentRoot)objectArray[n2]).getChildren()));
                    } else if (objectArray[n2] instanceof IClassFile) {
                        arrayList2.addAll(Arrays.asList(this.filter(((IClassFile)objectArray[n2]).getChildren())));
                    } else if (objectArray[n2] instanceof ICompilationUnit) {
                        arrayList2.addAll(Arrays.asList(this.filter(((ICompilationUnit)objectArray[n2]).getChildren())));
                    } else {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) continue;
                objectArray = arrayList2.toArray();
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return arrayList.toArray();
    }

    protected Object[] getPackageFragmentRoots(IJavaProject iJavaProject) throws JavaModelException {
        IClasspathEntry iClasspathEntry;
        if (!iJavaProject.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
            int n2 = iClasspathEntry.getEntryKind();
            if (n2 != 5) {
                if (this.fShowLibrariesNode && (n2 == 1 || n2 == 4)) {
                    bl = true;
                } else if (this.isProjectPackageFragmentRoot(iPackageFragmentRoot)) {
                    Object[] objectArray = this.getPackageFragmentRootContent(iPackageFragmentRoot);
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        arrayList.add(objectArray[n3]);
                        ++n3;
                    }
                } else {
                    arrayList.add(iPackageFragmentRoot);
                }
            }
            ++n;
        }
        if (bl) {
            arrayList.add(new LibraryContainer(iJavaProject));
        }
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n4 = 0;
        while (n4 < iClasspathEntryArray.length) {
            iClasspathEntry = iClasspathEntryArray[n4];
            if (iClasspathEntry.getEntryKind() == 5) {
                arrayList.add(new ClassPathContainer(iJavaProject, iClasspathEntry));
            }
            ++n4;
        }
        Object[] objectArray = iJavaProject.getNonJavaResources();
        int n5 = 0;
        while (n5 < objectArray.length) {
            arrayList.add(objectArray[n5]);
            ++n5;
        }
        return arrayList.toArray();
    }

    private Object[] getContainerPackageFragmentRoots3(PackageFragmentRootContainer packageFragmentRootContainer) {
        IAdaptable[] iAdaptableArray = packageFragmentRootContainer.getChildren();
        if (iAdaptableArray == null) {
            return null;
        }
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        int n = 0;
        while (n < iAdaptableArray.length) {
            try {
                arrayList.addAll(Arrays.asList(((IPackageFragmentRoot)iAdaptableArray[n]).getChildren()));
            }
            catch (JavaModelException javaModelException) {}
            ++n;
        }
        return arrayList.toArray();
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer packageFragmentRootContainer) {
        return this.getContainerPackageFragmentRoots(packageFragmentRootContainer, false);
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer packageFragmentRootContainer, boolean bl) {
        if (packageFragmentRootContainer != null) {
            Object[] objectArray = packageFragmentRootContainer.getChildren();
            if (objectArray == null) {
                return null;
            }
            ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>();
            boolean bl2 = false;
            while (!bl2 && objectArray != null && objectArray.length > 0) {
                String string = null;
                int n = 0;
                while (n < objectArray.length) {
                    String string2;
                    string = ((IJavaElement)objectArray[0]).getDisplayName();
                    if (string != (string2 = ((IJavaElement)objectArray[n]).getDisplayName()) && (string == null || string.compareTo(string2) != 0)) {
                        arrayList.addAll(Arrays.asList(objectArray));
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
                if (!bl2 && bl) {
                    ContainerFolder containerFolder = new ContainerFolder(string, packageFragmentRootContainer);
                    return new Object[]{containerFolder};
                }
                ArrayList<IJavaElement> arrayList2 = new ArrayList<IJavaElement>();
                int n2 = 0;
                while (!bl2 && n2 < objectArray.length) {
                    block17: {
                        try {
                            if (objectArray[n2] instanceof IPackageFragment) {
                                arrayList2.addAll(Arrays.asList(((IPackageFragment)objectArray[n2]).getChildren()));
                                break block17;
                            }
                            if (objectArray[n2] instanceof IPackageFragmentRoot) {
                                arrayList2.addAll(Arrays.asList(((IPackageFragmentRoot)objectArray[n2]).getChildren()));
                                break block17;
                            }
                            if (objectArray[n2] instanceof IClassFile) {
                                arrayList2.addAll(Arrays.asList(this.filter(((IClassFile)objectArray[n2]).getChildren())));
                                break block17;
                            }
                            if (objectArray[n2] instanceof ICompilationUnit) {
                                arrayList2.addAll(Arrays.asList(this.filter(((ICompilationUnit)objectArray[n2]).getChildren())));
                                break block17;
                            }
                            bl2 = true;
                            break;
                        }
                        catch (JavaModelException javaModelException) {
                            javaModelException.printStackTrace();
                        }
                    }
                    ++n2;
                }
                if (bl2) continue;
                objectArray = arrayList2.toArray();
            }
            return arrayList.toArray();
        }
        IAdaptable[] iAdaptableArray = packageFragmentRootContainer.getChildren();
        if (iAdaptableArray == null) {
            return null;
        }
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        int n = 0;
        while (n < iAdaptableArray.length) {
            try {
                arrayList.addAll(Arrays.asList(((IPackageFragmentRoot)iAdaptableArray[n]).getChildren()));
            }
            catch (JavaModelException javaModelException) {}
            ++n;
        }
        return arrayList.toArray();
    }

    private Object[] getNonJavaProjects(IJavaModel iJavaModel) throws JavaModelException {
        return iJavaModel.getNonJavaResources();
    }

    protected Object internalGetParent(Object object) {
        if (!this.fIsFlatLayout && object instanceof IPackageFragment) {
            return this.getHierarchicalPackageParent((IPackageFragment)object);
        }
        if (object instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object;
            try {
                IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
                int n = iClasspathEntry.getEntryKind();
                if (n == 5) {
                    return new ClassPathContainer(iPackageFragmentRoot.getJavaProject(), iClasspathEntry);
                }
                if (this.fShowLibrariesNode && (n == 1 || n == 4)) {
                    return new LibraryContainer(iPackageFragmentRoot.getJavaProject());
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (object instanceof PackageFragmentRootContainer) {
            return ((PackageFragmentRootContainer)object).getJavaProject();
        }
        return super.internalGetParent(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        this.fViewer = (TreeViewer)viewer;
        if (object == null && object2 != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else if (object != null && object2 == null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = object2;
    }

    private void getHierarchicalPackageChildren(IPackageFragmentRoot iPackageFragmentRoot, IPackageFragment iPackageFragment, Collection collection) throws JavaModelException {
        String string;
        IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
        String string2 = string = iPackageFragment != null ? String.valueOf(iPackageFragment.getElementName()) + '/' : "";
        if (string.length() == 1) {
            string = "";
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            IPackageFragment iPackageFragment2 = (IPackageFragment)iJavaElementArray[n2];
            if (iPackageFragment == null) {
                if (iPackageFragment2.isDefaultPackage()) {
                    collection.add(iPackageFragment2);
                }
            } else {
                String string3 = iPackageFragment2.getElementName();
                if (string3.startsWith(string) && string3.length() > n && string3.indexOf(47, n) == -1) {
                    if (this.fFoldPackages) {
                        iPackageFragment2 = PackageExplorerContentProvider.getFolded(iJavaElementArray, iPackageFragment2);
                    }
                    collection.add(iPackageFragment2);
                }
            }
            ++n2;
        }
    }

    private void getHierarchicalPackagesInFolder(IFolder iFolder, Collection collection) throws CoreException {
        IResource[] iResourceArray = iFolder.members();
        int n = 0;
        while (n < iResourceArray.length) {
            IFolder iFolder2;
            IJavaElement iJavaElement;
            IResource iResource = iResourceArray[n];
            if (iResource instanceof IFolder && (iJavaElement = JavaCore.create((IFolder)(iFolder2 = (IFolder)iResource))) instanceof IPackageFragment) {
                if (this.fFoldPackages) {
                    IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
                    iJavaElement = PackageExplorerContentProvider.getFolded(iPackageFragmentRoot.getChildren(), iPackageFragment);
                }
                collection.add(iJavaElement);
            }
            ++n;
        }
    }

    public Object getHierarchicalPackageParent(IPackageFragment iPackageFragment) {
        String string = iPackageFragment.getElementName();
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
        int n = string.lastIndexOf(47);
        if (n != -1) {
            String string2 = string.substring(0, n);
            IPackageFragment iPackageFragment2 = iPackageFragmentRoot.getPackageFragment(string2);
            if (iPackageFragment2.exists()) {
                try {
                    if (this.fFoldPackages && PackageExplorerContentProvider.isEmpty(iPackageFragment2) && PackageExplorerContentProvider.findSinglePackageChild(iPackageFragment2, iPackageFragmentRoot.getChildren()) != null) {
                        return this.getHierarchicalPackageParent(iPackageFragment2);
                    }
                }
                catch (JavaModelException javaModelException) {}
                return iPackageFragment2;
            }
            IResource iResource = iPackageFragment2.getResource();
            if (iResource != null) {
                return iResource;
            }
        }
        if (iPackageFragmentRoot.getResource() instanceof IProject) {
            return iPackageFragmentRoot.getJavaProject();
        }
        return iPackageFragmentRoot;
    }

    private static IPackageFragment getFolded(IJavaElement[] iJavaElementArray, IPackageFragment iPackageFragment) throws JavaModelException {
        while (PackageExplorerContentProvider.isEmpty(iPackageFragment)) {
            IPackageFragment iPackageFragment2 = PackageExplorerContentProvider.findSinglePackageChild(iPackageFragment, iJavaElementArray);
            if (iPackageFragment2 == null) {
                return iPackageFragment;
            }
            iPackageFragment = iPackageFragment2;
        }
        return iPackageFragment;
    }

    private static boolean isEmpty(IPackageFragment iPackageFragment) throws JavaModelException {
        return !iPackageFragment.containsJavaResources() && iPackageFragment.getNonJavaResources().length == 0;
    }

    private static IPackageFragment findSinglePackageChild(IPackageFragment iPackageFragment, IJavaElement[] iJavaElementArray) {
        String string = String.valueOf(iPackageFragment.getElementName()) + '/';
        int n = string.length();
        IPackageFragment iPackageFragment2 = null;
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            String string2 = iJavaElement.getElementName();
            if (string2.startsWith(string) && string2.length() > n && string2.indexOf(47, n) == -1) {
                if (iPackageFragment2 == null) {
                    iPackageFragment2 = (IPackageFragment)iJavaElement;
                } else {
                    return null;
                }
            }
            ++n2;
        }
        return iPackageFragment2;
    }

    private boolean processDelta(IJavaElementDelta iJavaElementDelta, Collection collection) throws JavaModelException {
        Object object;
        int n = iJavaElementDelta.getKind();
        int n2 = iJavaElementDelta.getFlags();
        IJavaElement iJavaElement = iJavaElementDelta.getElement();
        int n3 = iJavaElement.getElementType();
        if (!(n3 == 1 || n3 == 2 || (object = iJavaElement.getJavaProject()) != null && object.getProject().isOpen())) {
            return false;
        }
        if (!this.fIsFlatLayout && n3 == 4) {
            if (n == 2) {
                object = this.getHierarchicalPackageParent((IPackageFragment)iJavaElement);
                if (object instanceof IPackageFragmentRoot) {
                    this.postRemove(iJavaElement, collection);
                    return false;
                }
                this.postRefresh(this.internalGetParent(object), 2, iJavaElement, collection);
                return true;
            }
            if (n == 1) {
                object = this.getHierarchicalPackageParent((IPackageFragment)iJavaElement);
                if (object instanceof IPackageFragmentRoot) {
                    this.postAdd(object, iJavaElement, collection);
                    return false;
                }
                this.postRefresh(this.internalGetParent(object), 2, iJavaElement, collection);
                return true;
            }
            this.handleAffectedChildren(iJavaElementDelta, iJavaElement, collection);
            return false;
        }
        if (n3 == 5) {
            object = (ICompilationUnit)iJavaElement;
            if (!JavaModelUtil.isPrimary((ICompilationUnit)object)) {
                return false;
            }
            if (!this.getProvideMembers() && object.isWorkingCopy() && n == 4) {
                return false;
            }
            if (n == 4 && !PackageExplorerContentProvider.isStructuralCUChange(n2)) {
                return false;
            }
            if (!this.isOnClassPath((ICompilationUnit)object)) {
                return false;
            }
        }
        if (n3 == 2) {
            if ((n2 & 0x600) != 0) {
                this.postRefresh(iJavaElement, 0, iJavaElement, collection);
                return false;
            }
            if ((n2 & 0x20000) != 0) {
                this.postRefresh(iJavaElement, 0, iJavaElement, collection);
                return false;
            }
            if (n == 1) {
                this.postRemove(iJavaElement.getResource(), collection);
                this.postAdd(iJavaElement.getParent(), iJavaElement, collection);
                return false;
            }
        }
        if (n == 2) {
            object = this.internalGetParent(iJavaElement);
            if (iJavaElement instanceof IPackageFragment) {
                if (this.fViewer.testFindItem(object) != null) {
                    this.postRefresh(object, 1, iJavaElement, collection);
                }
                return true;
            }
            this.postRemove(iJavaElement, collection);
            if (object instanceof IPackageFragment) {
                this.postUpdateIcon((IJavaElement)((IPackageFragment)object), collection);
            }
            if (this.isPackageFragmentEmpty(iJavaElement.getParent())) {
                if (this.fViewer.testFindItem(object) != null) {
                    this.postRefresh(this.internalGetParent(object), 2, iJavaElement, collection);
                }
                return true;
            }
            return false;
        }
        if (n == 1) {
            object = this.internalGetParent(iJavaElement);
            if (object instanceof IPackageFragment) {
                Object object2 = this.internalGetParent(object);
                if (object.equals(this.fInput)) {
                    this.postRefresh(object, 1, iJavaElement, collection);
                } else if (this.fViewer.testFindItem(object) == null) {
                    this.postRefresh(object2, 2, iJavaElement, collection);
                } else {
                    this.postRefresh(object, 1, iJavaElement, collection);
                }
                return true;
            }
            this.postAdd(object, iJavaElement, collection);
        }
        if (n3 == 5) {
            if (n == 4) {
                this.postRefresh(iJavaElement, 0, iJavaElement, collection);
                this.updateSelection(iJavaElementDelta, collection);
            }
            return false;
        }
        if (n3 == 6) {
            return false;
        }
        if (n3 == 3) {
            if ((n2 & 0x8000) != 0) {
                this.postRefresh(iJavaElement, 0, iJavaElement, collection);
                return false;
            }
            if ((n2 & 0x3000) != 0) {
                this.postUpdateIcon(iJavaElement, collection);
            }
            if (this.isClassPathChange(iJavaElementDelta)) {
                this.postRefresh(iJavaElement.getJavaProject(), 4, iJavaElement, collection);
                return true;
            }
        }
        this.handleAffectedChildren(iJavaElementDelta, iJavaElement, collection);
        return false;
    }

    private static boolean isStructuralCUChange(int n) {
        return (n & 8) != 0 || (n & 0x4001) == 1;
    }

    void handleAffectedChildren(IJavaElementDelta iJavaElementDelta, IJavaElement iJavaElement, Collection collection) throws JavaModelException {
        int n;
        int n2 = 0;
        IResourceDelta[] iResourceDeltaArray = iJavaElementDelta.getResourceDeltas();
        if (iResourceDeltaArray != null) {
            int n3 = 0;
            while (n3 < iResourceDeltaArray.length) {
                n = iResourceDeltaArray[n3].getKind();
                if (n == 1 || n == 2) {
                    ++n2;
                }
                ++n3;
            }
        }
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        n = 0;
        while (n < iJavaElementDeltaArray.length) {
            int n4 = iJavaElementDeltaArray[n].getKind();
            if (n4 == 1 || n4 == 2) {
                ++n2;
            }
            ++n;
        }
        if (n2 > 1) {
            if (iJavaElement instanceof IPackageFragment) {
                IJavaElement iJavaElement2 = (IJavaElement)this.internalGetParent(iJavaElement);
                if (iJavaElement.equals(this.fInput)) {
                    this.postRefresh(iJavaElement, 0, iJavaElement, collection);
                } else {
                    this.postRefresh(iJavaElement2, 1, iJavaElement, collection);
                }
            } else if (iJavaElement instanceof IPackageFragmentRoot) {
                Object object = this.internalGetParent(iJavaElement);
                this.postRefresh(object, 0, object, collection);
            } else {
                this.postRefresh(iJavaElement, 0, iJavaElement, collection);
            }
            return;
        }
        if (iResourceDeltaArray != null) {
            n = 0;
            while (n < iResourceDeltaArray.length) {
                if (this.processResourceDelta(iResourceDeltaArray[n], iJavaElement, collection)) {
                    return;
                }
                ++n;
            }
        }
        n = 0;
        while (n < iJavaElementDeltaArray.length) {
            if (this.processDelta(iJavaElementDeltaArray[n], collection)) {
                return;
            }
            ++n;
        }
    }

    protected void processAffectedChildren(IJavaElementDelta[] iJavaElementDeltaArray, Collection collection) throws JavaModelException {
        int n = 0;
        while (n < iJavaElementDeltaArray.length) {
            this.processDelta(iJavaElementDeltaArray[n], collection);
            ++n;
        }
    }

    private boolean isOnClassPath(ICompilationUnit iCompilationUnit) {
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        if (iJavaProject == null || !iJavaProject.exists()) {
            return false;
        }
        return iJavaProject.isOnClasspath((IJavaElement)iCompilationUnit);
    }

    private void updateSelection(IJavaElementDelta iJavaElementDelta, Collection collection) {
        final IJavaElement iJavaElement = this.findAddedElement(iJavaElementDelta);
        if (iJavaElement != null) {
            final StructuredSelection structuredSelection = new StructuredSelection((Object)iJavaElement);
            collection.add(new Runnable(){

                public void run() {
                    if (PackageExplorerContentProvider.this.fViewer.testFindItem((Object)iJavaElement) != null) {
                        PackageExplorerContentProvider.this.fViewer.setSelection((ISelection)structuredSelection);
                    }
                }
            });
        }
    }

    private IJavaElement findAddedElement(IJavaElementDelta iJavaElementDelta) {
        if (iJavaElementDelta.getKind() == 1) {
            return iJavaElementDelta.getElement();
        }
        int n = 0;
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        if (n < iJavaElementDeltaArray.length) {
            return this.findAddedElement(iJavaElementDeltaArray[n]);
        }
        return null;
    }

    private void postUpdateIcon(final IJavaElement iJavaElement, Collection collection) {
        collection.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.update((Object)iJavaElement, new String[]{"org.eclipse.jface.image"});
            }
        });
    }

    private boolean processResourceDelta(IResourceDelta iResourceDelta, Object object, Collection collection) {
        int n = iResourceDelta.getKind();
        int n2 = iResourceDelta.getFlags();
        IResource iResource = iResourceDelta.getResource();
        if (iResource == null) {
            return false;
        }
        if ((n & 2) != 0) {
            if (object instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(object), 1, object, collection);
                return true;
            }
            this.postRemove(iResource, collection);
        }
        if ((n & 1) != 0) {
            if (object instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(object), 1, object, collection);
                return true;
            }
            this.postAdd(object, iResource, collection);
        }
        if ((n2 & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(object), collection);
            return true;
        }
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        int n3 = 0;
        while (n3 < iResourceDeltaArray.length) {
            if (this.processResourceDelta(iResourceDeltaArray[n3], iResource, collection)) {
                return false;
            }
            ++n3;
        }
        return false;
    }

    public void setIsFlatLayout(boolean bl) {
        this.fIsFlatLayout = bl;
    }

    public void setShowLibrariesNode(boolean bl) {
        this.fShowLibrariesNode = bl;
    }

    private void postRefresh(Object object, int n, Object object2, Collection collection) {
        if (this.isParent(object, this.fInput)) {
            object = this.fInput;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        this.augmentElementToRefresh(arrayList, n, object2);
        this.postRefresh(arrayList, true, collection);
    }

    protected void augmentElementToRefresh(List list, int n, Object object) {
    }

    private boolean isParent(Object object, Object object2) {
        Object object3 = this.getParent(object2);
        if (object3 == null) {
            return false;
        }
        if (object3.equals(object)) {
            return true;
        }
        return this.isParent(object, object3);
    }

    protected void postRefresh(final List list, final boolean bl, Collection collection) {
        collection.add(new Runnable(){

            public void run() {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PackageExplorerContentProvider.this.fViewer.refresh(iterator.next(), bl);
                }
            }
        });
    }

    protected void postAdd(final Object object, final Object object2, Collection collection) {
        collection.add(new Runnable(){

            public void run() {
                if (PackageExplorerContentProvider.this.fViewer.testFindItem(object2) == null) {
                    PackageExplorerContentProvider.this.fViewer.add(object, object2);
                }
            }
        });
    }

    protected void postRemove(final Object object, Collection collection) {
        collection.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.remove(object);
            }
        });
    }

    protected void postProjectStateChanged(final Object object, Collection collection) {
        collection.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.refresh(object, true);
                PackageExplorerContentProvider.this.fViewer.setSelection(PackageExplorerContentProvider.this.fViewer.getSelection());
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.getControl().setRedraw(false);
                Object[] objectArray = this.fViewer.getExpandedElements();
                this.fViewer.refresh();
                this.fViewer.setExpandedElements(objectArray);
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }
}

